/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagrisInvalidArnException extends FirehoseException implements
        ToCopyableBuilder<TagrisInvalidArnException.Builder, TagrisInvalidArnException> {
    private static final SdkField<TagrisSweepListItem> SWEEP_LIST_ITEM_FIELD = SdkField
            .<TagrisSweepListItem> builder(MarshallingType.SDK_POJO).memberName("sweepListItem")
            .getter(getter(TagrisInvalidArnException::sweepListItem)).setter(setter(Builder::sweepListItem))
            .constructor(TagrisSweepListItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sweepListItem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SWEEP_LIST_ITEM_FIELD));

    private static final long serialVersionUID = 1L;

    private final TagrisSweepListItem sweepListItem;

    private TagrisInvalidArnException(BuilderImpl builder) {
        super(builder);
        this.sweepListItem = builder.sweepListItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the SweepListItem property for this object.
     * 
     * @return The value of the SweepListItem property for this object.
     */
    public TagrisSweepListItem sweepListItem() {
        return sweepListItem;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagrisInvalidArnException, T> g) {
        return obj -> g.apply((TagrisInvalidArnException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagrisInvalidArnException>, FirehoseException.Builder {
        /**
         * Sets the value of the SweepListItem property for this object.
         *
         * @param sweepListItem
         *        The new value for the SweepListItem property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sweepListItem(TagrisSweepListItem sweepListItem);

        /**
         * Sets the value of the SweepListItem property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TagrisSweepListItem.Builder} avoiding the
         * need to create one manually via {@link TagrisSweepListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagrisSweepListItem.Builder#build()} is called immediately and
         * its result is passed to {@link #sweepListItem(TagrisSweepListItem)}.
         * 
         * @param sweepListItem
         *        a consumer that will call methods on {@link TagrisSweepListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sweepListItem(TagrisSweepListItem)
         */
        default Builder sweepListItem(Consumer<TagrisSweepListItem.Builder> sweepListItem) {
            return sweepListItem(TagrisSweepListItem.builder().applyMutation(sweepListItem).build());
        }

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends FirehoseException.BuilderImpl implements Builder {
        private TagrisSweepListItem sweepListItem;

        private BuilderImpl() {
        }

        private BuilderImpl(TagrisInvalidArnException model) {
            super(model);
            sweepListItem(model.sweepListItem);
        }

        public final TagrisSweepListItem.Builder getSweepListItem() {
            return sweepListItem != null ? sweepListItem.toBuilder() : null;
        }

        public final void setSweepListItem(TagrisSweepListItem.BuilderImpl sweepListItem) {
            this.sweepListItem = sweepListItem != null ? sweepListItem.build() : null;
        }

        @Override
        public final Builder sweepListItem(TagrisSweepListItem sweepListItem) {
            this.sweepListItem = sweepListItem;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public TagrisInvalidArnException build() {
            return new TagrisInvalidArnException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
