/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKinesisStreamResponse extends FirehoseResponse implements
        ToCopyableBuilder<GetKinesisStreamResponse.Builder, GetKinesisStreamResponse> {
    private static final SdkField<String> KINESIS_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KinesisStreamARN").getter(getter(GetKinesisStreamResponse::kinesisStreamARN))
            .setter(setter(Builder::kinesisStreamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamARN").build()).build();

    private static final SdkField<SessionCredentials> CREDENTIALS_FOR_READING_KINESIS_STREAM_FIELD = SdkField
            .<SessionCredentials> builder(MarshallingType.SDK_POJO)
            .memberName("CredentialsForReadingKinesisStream")
            .getter(getter(GetKinesisStreamResponse::credentialsForReadingKinesisStream))
            .setter(setter(Builder::credentialsForReadingKinesisStream))
            .constructor(SessionCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialsForReadingKinesisStream")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KINESIS_STREAM_ARN_FIELD,
            CREDENTIALS_FOR_READING_KINESIS_STREAM_FIELD));

    private final String kinesisStreamARN;

    private final SessionCredentials credentialsForReadingKinesisStream;

    private GetKinesisStreamResponse(BuilderImpl builder) {
        super(builder);
        this.kinesisStreamARN = builder.kinesisStreamARN;
        this.credentialsForReadingKinesisStream = builder.credentialsForReadingKinesisStream;
    }

    /**
     * Returns the value of the KinesisStreamARN property for this object.
     * 
     * @return The value of the KinesisStreamARN property for this object.
     */
    public final String kinesisStreamARN() {
        return kinesisStreamARN;
    }

    /**
     * Returns the value of the CredentialsForReadingKinesisStream property for this object.
     * 
     * @return The value of the CredentialsForReadingKinesisStream property for this object.
     */
    public final SessionCredentials credentialsForReadingKinesisStream() {
        return credentialsForReadingKinesisStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsForReadingKinesisStream());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKinesisStreamResponse)) {
            return false;
        }
        GetKinesisStreamResponse other = (GetKinesisStreamResponse) obj;
        return Objects.equals(kinesisStreamARN(), other.kinesisStreamARN())
                && Objects.equals(credentialsForReadingKinesisStream(), other.credentialsForReadingKinesisStream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetKinesisStreamResponse")
                .add("KinesisStreamARN", kinesisStreamARN())
                .add("CredentialsForReadingKinesisStream",
                        credentialsForReadingKinesisStream() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KinesisStreamARN":
            return Optional.ofNullable(clazz.cast(kinesisStreamARN()));
        case "CredentialsForReadingKinesisStream":
            return Optional.ofNullable(clazz.cast(credentialsForReadingKinesisStream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetKinesisStreamResponse, T> g) {
        return obj -> g.apply((GetKinesisStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FirehoseResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetKinesisStreamResponse> {
        /**
         * Sets the value of the KinesisStreamARN property for this object.
         *
         * @param kinesisStreamARN
         *        The new value for the KinesisStreamARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamARN(String kinesisStreamARN);

        /**
         * Sets the value of the CredentialsForReadingKinesisStream property for this object.
         *
         * @param credentialsForReadingKinesisStream
         *        The new value for the CredentialsForReadingKinesisStream property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsForReadingKinesisStream(SessionCredentials credentialsForReadingKinesisStream);

        /**
         * Sets the value of the CredentialsForReadingKinesisStream property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SessionCredentials.Builder} avoiding the
         * need to create one manually via {@link SessionCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionCredentials.Builder#build()} is called immediately and its
         * result is passed to {@link #credentialsForReadingKinesisStream(SessionCredentials)}.
         * 
         * @param credentialsForReadingKinesisStream
         *        a consumer that will call methods on {@link SessionCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentialsForReadingKinesisStream(SessionCredentials)
         */
        default Builder credentialsForReadingKinesisStream(Consumer<SessionCredentials.Builder> credentialsForReadingKinesisStream) {
            return credentialsForReadingKinesisStream(SessionCredentials.builder()
                    .applyMutation(credentialsForReadingKinesisStream).build());
        }
    }

    static final class BuilderImpl extends FirehoseResponse.BuilderImpl implements Builder {
        private String kinesisStreamARN;

        private SessionCredentials credentialsForReadingKinesisStream;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKinesisStreamResponse model) {
            super(model);
            kinesisStreamARN(model.kinesisStreamARN);
            credentialsForReadingKinesisStream(model.credentialsForReadingKinesisStream);
        }

        public final String getKinesisStreamARN() {
            return kinesisStreamARN;
        }

        public final void setKinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
        }

        @Override
        public final Builder kinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
            return this;
        }

        public final SessionCredentials.Builder getCredentialsForReadingKinesisStream() {
            return credentialsForReadingKinesisStream != null ? credentialsForReadingKinesisStream.toBuilder() : null;
        }

        public final void setCredentialsForReadingKinesisStream(SessionCredentials.BuilderImpl credentialsForReadingKinesisStream) {
            this.credentialsForReadingKinesisStream = credentialsForReadingKinesisStream != null ? credentialsForReadingKinesisStream
                    .build() : null;
        }

        @Override
        public final Builder credentialsForReadingKinesisStream(SessionCredentials credentialsForReadingKinesisStream) {
            this.credentialsForReadingKinesisStream = credentialsForReadingKinesisStream;
            return this;
        }

        @Override
        public GetKinesisStreamResponse build() {
            return new GetKinesisStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
