/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a destination in the Serverless offering for Amazon OpenSearch Service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmazonOpenSearchServerlessDestinationConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AmazonOpenSearchServerlessDestinationConfiguration.Builder, AmazonOpenSearchServerlessDestinationConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(AmazonOpenSearchServerlessDestinationConfiguration::roleARN))
            .setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> COLLECTION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionEndpoint")
            .getter(getter(AmazonOpenSearchServerlessDestinationConfiguration::collectionEndpoint))
            .setter(setter(Builder::collectionEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionEndpoint").build())
            .build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(AmazonOpenSearchServerlessDestinationConfiguration::indexName))
            .setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<AmazonOpenSearchServerlessBufferingHints> BUFFERING_HINTS_FIELD = SdkField
            .<AmazonOpenSearchServerlessBufferingHints> builder(MarshallingType.SDK_POJO).memberName("BufferingHints")
            .getter(getter(AmazonOpenSearchServerlessDestinationConfiguration::bufferingHints))
            .setter(setter(Builder::bufferingHints)).constructor(AmazonOpenSearchServerlessBufferingHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()).build();

    private static final SdkField<AmazonOpenSearchServerlessRetryOptions> RETRY_OPTIONS_FIELD = SdkField
            .<AmazonOpenSearchServerlessRetryOptions> builder(MarshallingType.SDK_POJO).memberName("RetryOptions")
            .getter(getter(AmazonOpenSearchServerlessDestinationConfiguration::retryOptions))
            .setter(setter(Builder::retryOptions)).constructor(AmazonOpenSearchServerlessRetryOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()).build();

    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BackupMode").getter(getter(AmazonOpenSearchServerlessDestinationConfiguration::s3BackupModeAsString))
            .setter(setter(Builder::s3BackupMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()).build();

    private static final SdkField<S3DestinationConfiguration> S3_CONFIGURATION_FIELD = SdkField
            .<S3DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3Configuration")
            .getter(getter(AmazonOpenSearchServerlessDestinationConfiguration::s3Configuration))
            .setter(setter(Builder::s3Configuration)).constructor(S3DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()).build();

    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField
            .<ProcessingConfiguration> builder(MarshallingType.SDK_POJO).memberName("ProcessingConfiguration")
            .getter(getter(AmazonOpenSearchServerlessDestinationConfiguration::processingConfiguration))
            .setter(setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build())
            .build();

    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField
            .<CloudWatchLoggingOptions> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions")
            .getter(getter(AmazonOpenSearchServerlessDestinationConfiguration::cloudWatchLoggingOptions))
            .setter(setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build())
            .build();

    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(AmazonOpenSearchServerlessDestinationConfiguration::vpcConfiguration))
            .setter(setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            COLLECTION_ENDPOINT_FIELD, INDEX_NAME_FIELD, BUFFERING_HINTS_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD,
            S3_CONFIGURATION_FIELD, PROCESSING_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, VPC_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleARN;

    private final String collectionEndpoint;

    private final String indexName;

    private final AmazonOpenSearchServerlessBufferingHints bufferingHints;

    private final AmazonOpenSearchServerlessRetryOptions retryOptions;

    private final String s3BackupMode;

    private final S3DestinationConfiguration s3Configuration;

    private final ProcessingConfiguration processingConfiguration;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private final VpcConfiguration vpcConfiguration;

    private AmazonOpenSearchServerlessDestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.collectionEndpoint = builder.collectionEndpoint;
        this.indexName = builder.indexName;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Configuration = builder.s3Configuration;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Serverless offering for
     * Amazon OpenSearch Service Configuration API and for indexing documents.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Serverless
     *         offering for Amazon OpenSearch Service Configuration API and for indexing documents.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The endpoint to use when communicating with the collection in the Serverless offering for Amazon OpenSearch
     * Service.
     * </p>
     * 
     * @return The endpoint to use when communicating with the collection in the Serverless offering for Amazon
     *         OpenSearch Service.
     */
    public final String collectionEndpoint() {
        return collectionEndpoint;
    }

    /**
     * <p>
     * The Serverless offering for Amazon OpenSearch Service index name.
     * </p>
     * 
     * @return The Serverless offering for Amazon OpenSearch Service index name.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The buffering options. If no value is specified, the default values for AmazonopensearchserviceBufferingHints are
     * used.
     * </p>
     * 
     * @return The buffering options. If no value is specified, the default values for
     *         AmazonopensearchserviceBufferingHints are used.
     */
    public final AmazonOpenSearchServerlessBufferingHints bufferingHints() {
        return bufferingHints;
    }

    /**
     * <p>
     * The retry behavior in case Firehose is unable to deliver documents to the Serverless offering for Amazon
     * OpenSearch Service. The default value is 300 (5 minutes).
     * </p>
     * 
     * @return The retry behavior in case Firehose is unable to deliver documents to the Serverless offering for Amazon
     *         OpenSearch Service. The default value is 300 (5 minutes).
     */
    public final AmazonOpenSearchServerlessRetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly, Firehose writes
     * any documents that could not be indexed to the configured Amazon S3 destination, with
     * AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all
     * incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/ appended to
     * the prefix.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link AmazonOpenSearchServerlessS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly, Firehose
     *         writes any documents that could not be indexed to the configured Amazon S3 destination, with
     *         AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers
     *         all incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/
     *         appended to the prefix.
     * @see AmazonOpenSearchServerlessS3BackupMode
     */
    public final AmazonOpenSearchServerlessS3BackupMode s3BackupMode() {
        return AmazonOpenSearchServerlessS3BackupMode.fromValue(s3BackupMode);
    }

    /**
     * <p>
     * Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly, Firehose writes
     * any documents that could not be indexed to the configured Amazon S3 destination, with
     * AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all
     * incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/ appended to
     * the prefix.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link AmazonOpenSearchServerlessS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly, Firehose
     *         writes any documents that could not be indexed to the configured Amazon S3 destination, with
     *         AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers
     *         all incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/
     *         appended to the prefix.
     * @see AmazonOpenSearchServerlessS3BackupMode
     */
    public final String s3BackupModeAsString() {
        return s3BackupMode;
    }

    /**
     * Returns the value of the S3Configuration property for this object.
     * 
     * @return The value of the S3Configuration property for this object.
     */
    public final S3DestinationConfiguration s3Configuration() {
        return s3Configuration;
    }

    /**
     * Returns the value of the ProcessingConfiguration property for this object.
     * 
     * @return The value of the ProcessingConfiguration property for this object.
     */
    public final ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * Returns the value of the CloudWatchLoggingOptions property for this object.
     * 
     * @return The value of the CloudWatchLoggingOptions property for this object.
     */
    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    /**
     * Returns the value of the VpcConfiguration property for this object.
     * 
     * @return The value of the VpcConfiguration property for this object.
     */
    public final VpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(collectionEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonOpenSearchServerlessDestinationConfiguration)) {
            return false;
        }
        AmazonOpenSearchServerlessDestinationConfiguration other = (AmazonOpenSearchServerlessDestinationConfiguration) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(collectionEndpoint(), other.collectionEndpoint())
                && Objects.equals(indexName(), other.indexName()) && Objects.equals(bufferingHints(), other.bufferingHints())
                && Objects.equals(retryOptions(), other.retryOptions())
                && Objects.equals(s3BackupModeAsString(), other.s3BackupModeAsString())
                && Objects.equals(s3Configuration(), other.s3Configuration())
                && Objects.equals(processingConfiguration(), other.processingConfiguration())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmazonOpenSearchServerlessDestinationConfiguration").add("RoleARN", roleARN())
                .add("CollectionEndpoint", collectionEndpoint()).add("IndexName", indexName())
                .add("BufferingHints", bufferingHints()).add("RetryOptions", retryOptions())
                .add("S3BackupMode", s3BackupModeAsString()).add("S3Configuration", s3Configuration())
                .add("ProcessingConfiguration", processingConfiguration())
                .add("CloudWatchLoggingOptions", cloudWatchLoggingOptions()).add("VpcConfiguration", vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "CollectionEndpoint":
            return Optional.ofNullable(clazz.cast(collectionEndpoint()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "BufferingHints":
            return Optional.ofNullable(clazz.cast(bufferingHints()));
        case "RetryOptions":
            return Optional.ofNullable(clazz.cast(retryOptions()));
        case "S3BackupMode":
            return Optional.ofNullable(clazz.cast(s3BackupModeAsString()));
        case "S3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        case "ProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(processingConfiguration()));
        case "CloudWatchLoggingOptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptions()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmazonOpenSearchServerlessDestinationConfiguration, T> g) {
        return obj -> g.apply((AmazonOpenSearchServerlessDestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmazonOpenSearchServerlessDestinationConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Serverless offering
         * for Amazon OpenSearch Service Configuration API and for indexing documents.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Serverless
         *        offering for Amazon OpenSearch Service Configuration API and for indexing documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The endpoint to use when communicating with the collection in the Serverless offering for Amazon OpenSearch
         * Service.
         * </p>
         * 
         * @param collectionEndpoint
         *        The endpoint to use when communicating with the collection in the Serverless offering for Amazon
         *        OpenSearch Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionEndpoint(String collectionEndpoint);

        /**
         * <p>
         * The Serverless offering for Amazon OpenSearch Service index name.
         * </p>
         * 
         * @param indexName
         *        The Serverless offering for Amazon OpenSearch Service index name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The buffering options. If no value is specified, the default values for AmazonopensearchserviceBufferingHints
         * are used.
         * </p>
         * 
         * @param bufferingHints
         *        The buffering options. If no value is specified, the default values for
         *        AmazonopensearchserviceBufferingHints are used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(AmazonOpenSearchServerlessBufferingHints bufferingHints);

        /**
         * <p>
         * The buffering options. If no value is specified, the default values for AmazonopensearchserviceBufferingHints
         * are used.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AmazonOpenSearchServerlessBufferingHints.Builder} avoiding the need to create one manually via
         * {@link AmazonOpenSearchServerlessBufferingHints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonOpenSearchServerlessBufferingHints.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #bufferingHints(AmazonOpenSearchServerlessBufferingHints)}.
         * 
         * @param bufferingHints
         *        a consumer that will call methods on {@link AmazonOpenSearchServerlessBufferingHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bufferingHints(AmazonOpenSearchServerlessBufferingHints)
         */
        default Builder bufferingHints(Consumer<AmazonOpenSearchServerlessBufferingHints.Builder> bufferingHints) {
            return bufferingHints(AmazonOpenSearchServerlessBufferingHints.builder().applyMutation(bufferingHints).build());
        }

        /**
         * <p>
         * The retry behavior in case Firehose is unable to deliver documents to the Serverless offering for Amazon
         * OpenSearch Service. The default value is 300 (5 minutes).
         * </p>
         * 
         * @param retryOptions
         *        The retry behavior in case Firehose is unable to deliver documents to the Serverless offering for
         *        Amazon OpenSearch Service. The default value is 300 (5 minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(AmazonOpenSearchServerlessRetryOptions retryOptions);

        /**
         * <p>
         * The retry behavior in case Firehose is unable to deliver documents to the Serverless offering for Amazon
         * OpenSearch Service. The default value is 300 (5 minutes).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AmazonOpenSearchServerlessRetryOptions.Builder} avoiding the need to create one manually via
         * {@link AmazonOpenSearchServerlessRetryOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonOpenSearchServerlessRetryOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #retryOptions(AmazonOpenSearchServerlessRetryOptions)}.
         * 
         * @param retryOptions
         *        a consumer that will call methods on {@link AmazonOpenSearchServerlessRetryOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryOptions(AmazonOpenSearchServerlessRetryOptions)
         */
        default Builder retryOptions(Consumer<AmazonOpenSearchServerlessRetryOptions.Builder> retryOptions) {
            return retryOptions(AmazonOpenSearchServerlessRetryOptions.builder().applyMutation(retryOptions).build());
        }

        /**
         * <p>
         * Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly, Firehose
         * writes any documents that could not be indexed to the configured Amazon S3 destination, with
         * AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all
         * incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/ appended
         * to the prefix.
         * </p>
         * 
         * @param s3BackupMode
         *        Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly,
         *        Firehose writes any documents that could not be indexed to the configured Amazon S3 destination, with
         *        AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose
         *        delivers all incoming records to Amazon S3, and also writes failed documents with
         *        AmazonOpenSearchService-failed/ appended to the prefix.
         * @see AmazonOpenSearchServerlessS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmazonOpenSearchServerlessS3BackupMode
         */
        Builder s3BackupMode(String s3BackupMode);

        /**
         * <p>
         * Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly, Firehose
         * writes any documents that could not be indexed to the configured Amazon S3 destination, with
         * AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all
         * incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/ appended
         * to the prefix.
         * </p>
         * 
         * @param s3BackupMode
         *        Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly,
         *        Firehose writes any documents that could not be indexed to the configured Amazon S3 destination, with
         *        AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose
         *        delivers all incoming records to Amazon S3, and also writes failed documents with
         *        AmazonOpenSearchService-failed/ appended to the prefix.
         * @see AmazonOpenSearchServerlessS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmazonOpenSearchServerlessS3BackupMode
         */
        Builder s3BackupMode(AmazonOpenSearchServerlessS3BackupMode s3BackupMode);

        /**
         * Sets the value of the S3Configuration property for this object.
         *
         * @param s3Configuration
         *        The new value for the S3Configuration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3DestinationConfiguration s3Configuration);

        /**
         * Sets the value of the S3Configuration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Configuration(S3DestinationConfiguration)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3DestinationConfiguration)
         */
        default Builder s3Configuration(Consumer<S3DestinationConfiguration.Builder> s3Configuration) {
            return s3Configuration(S3DestinationConfiguration.builder().applyMutation(s3Configuration).build());
        }

        /**
         * Sets the value of the ProcessingConfiguration property for this object.
         *
         * @param processingConfiguration
         *        The new value for the ProcessingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * Sets the value of the ProcessingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProcessingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ProcessingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcessingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #processingConfiguration(ProcessingConfiguration)}.
         * 
         * @param processingConfiguration
         *        a consumer that will call methods on {@link ProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfiguration(ProcessingConfiguration)
         */
        default Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return processingConfiguration(ProcessingConfiguration.builder().applyMutation(processingConfiguration).build());
        }

        /**
         * Sets the value of the CloudWatchLoggingOptions property for this object.
         *
         * @param cloudWatchLoggingOptions
         *        The new value for the CloudWatchLoggingOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * Sets the value of the CloudWatchLoggingOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CloudWatchLoggingOptions.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions).build());
        }

        /**
         * Sets the value of the VpcConfiguration property for this object.
         *
         * @param vpcConfiguration
         *        The new value for the VpcConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcConfiguration vpcConfiguration);

        /**
         * Sets the value of the VpcConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConfiguration.Builder} avoiding the
         * need to create one manually via {@link VpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfiguration(VpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String collectionEndpoint;

        private String indexName;

        private AmazonOpenSearchServerlessBufferingHints bufferingHints;

        private AmazonOpenSearchServerlessRetryOptions retryOptions;

        private String s3BackupMode;

        private S3DestinationConfiguration s3Configuration;

        private ProcessingConfiguration processingConfiguration;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private VpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonOpenSearchServerlessDestinationConfiguration model) {
            roleARN(model.roleARN);
            collectionEndpoint(model.collectionEndpoint);
            indexName(model.indexName);
            bufferingHints(model.bufferingHints);
            retryOptions(model.retryOptions);
            s3BackupMode(model.s3BackupMode);
            s3Configuration(model.s3Configuration);
            processingConfiguration(model.processingConfiguration);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            vpcConfiguration(model.vpcConfiguration);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getCollectionEndpoint() {
            return collectionEndpoint;
        }

        public final void setCollectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
        }

        @Override
        public final Builder collectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final AmazonOpenSearchServerlessBufferingHints.Builder getBufferingHints() {
            return bufferingHints != null ? bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(AmazonOpenSearchServerlessBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(AmazonOpenSearchServerlessBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final AmazonOpenSearchServerlessRetryOptions.Builder getRetryOptions() {
            return retryOptions != null ? retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(AmazonOpenSearchServerlessRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(AmazonOpenSearchServerlessRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(AmazonOpenSearchServerlessS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        @Override
        public AmazonOpenSearchServerlessDestinationConfiguration build() {
            return new AmazonOpenSearchServerlessDestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
