/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resize specification for On-Demand Instances in the instance fleet, which contains the resize timeout period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnDemandResizingSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<OnDemandResizingSpecification.Builder, OnDemandResizingSpecification> {
    private static final SdkField<Integer> TIMEOUT_DURATION_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeoutDurationMinutes").getter(getter(OnDemandResizingSpecification::timeoutDurationMinutes))
            .setter(setter(Builder::timeoutDurationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutDurationMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TIMEOUT_DURATION_MINUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer timeoutDurationMinutes;

    private OnDemandResizingSpecification(BuilderImpl builder) {
        this.timeoutDurationMinutes = builder.timeoutDurationMinutes;
    }

    /**
     * <p>
     * On-Demand resize timeout in minutes. If On-Demand Instances are not provisioned within this time, the resize
     * workflow stops. The minimum value is 5 minutes, and the maximum value is 10,080 minutes (7 days). The timeout
     * applies to all resize workflows on the Instance Fleet. The resize could be triggered by Amazon EMR Managed
     * Scaling or by the customer (via Amazon EMR Console, Amazon EMR CLI modify-instance-fleet or Amazon EMR SDK
     * ModifyInstanceFleet API) or by Amazon EMR due to Amazon EC2 Spot Reclamation.
     * </p>
     * 
     * @return On-Demand resize timeout in minutes. If On-Demand Instances are not provisioned within this time, the
     *         resize workflow stops. The minimum value is 5 minutes, and the maximum value is 10,080 minutes (7 days).
     *         The timeout applies to all resize workflows on the Instance Fleet. The resize could be triggered by
     *         Amazon EMR Managed Scaling or by the customer (via Amazon EMR Console, Amazon EMR CLI
     *         modify-instance-fleet or Amazon EMR SDK ModifyInstanceFleet API) or by Amazon EMR due to Amazon EC2 Spot
     *         Reclamation.
     */
    public final Integer timeoutDurationMinutes() {
        return timeoutDurationMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutDurationMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDemandResizingSpecification)) {
            return false;
        }
        OnDemandResizingSpecification other = (OnDemandResizingSpecification) obj;
        return Objects.equals(timeoutDurationMinutes(), other.timeoutDurationMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnDemandResizingSpecification").add("TimeoutDurationMinutes", timeoutDurationMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeoutDurationMinutes":
            return Optional.ofNullable(clazz.cast(timeoutDurationMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnDemandResizingSpecification, T> g) {
        return obj -> g.apply((OnDemandResizingSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnDemandResizingSpecification> {
        /**
         * <p>
         * On-Demand resize timeout in minutes. If On-Demand Instances are not provisioned within this time, the resize
         * workflow stops. The minimum value is 5 minutes, and the maximum value is 10,080 minutes (7 days). The timeout
         * applies to all resize workflows on the Instance Fleet. The resize could be triggered by Amazon EMR Managed
         * Scaling or by the customer (via Amazon EMR Console, Amazon EMR CLI modify-instance-fleet or Amazon EMR SDK
         * ModifyInstanceFleet API) or by Amazon EMR due to Amazon EC2 Spot Reclamation.
         * </p>
         * 
         * @param timeoutDurationMinutes
         *        On-Demand resize timeout in minutes. If On-Demand Instances are not provisioned within this time, the
         *        resize workflow stops. The minimum value is 5 minutes, and the maximum value is 10,080 minutes (7
         *        days). The timeout applies to all resize workflows on the Instance Fleet. The resize could be
         *        triggered by Amazon EMR Managed Scaling or by the customer (via Amazon EMR Console, Amazon EMR CLI
         *        modify-instance-fleet or Amazon EMR SDK ModifyInstanceFleet API) or by Amazon EMR due to Amazon EC2
         *        Spot Reclamation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutDurationMinutes(Integer timeoutDurationMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutDurationMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDemandResizingSpecification model) {
            timeoutDurationMinutes(model.timeoutDurationMinutes);
        }

        public final Integer getTimeoutDurationMinutes() {
            return timeoutDurationMinutes;
        }

        public final void setTimeoutDurationMinutes(Integer timeoutDurationMinutes) {
            this.timeoutDurationMinutes = timeoutDurationMinutes;
        }

        @Override
        public final Builder timeoutDurationMinutes(Integer timeoutDurationMinutes) {
            this.timeoutDurationMinutes = timeoutDurationMinutes;
            return this;
        }

        @Override
        public OnDemandResizingSpecification build() {
            return new OnDemandResizingSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
