/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies change details of the domain configuration change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeProgressDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ChangeProgressDetails.Builder, ChangeProgressDetails> {
    private static final SdkField<String> CHANGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeId").getter(getter(ChangeProgressDetails::changeId)).setter(setter(Builder::changeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeId").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ChangeProgressDetails::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> CONFIG_CHANGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigChangeStatus").getter(getter(ChangeProgressDetails::configChangeStatusAsString))
            .setter(setter(Builder::configChangeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigChangeStatus").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ChangeProgressDetails::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(ChangeProgressDetails::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> INITIATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitiatedBy").getter(getter(ChangeProgressDetails::initiatedByAsString))
            .setter(setter(Builder::initiatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_ID_FIELD,
            MESSAGE_FIELD, CONFIG_CHANGE_STATUS_FIELD, START_TIME_FIELD, LAST_UPDATED_TIME_FIELD, INITIATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String changeId;

    private final String message;

    private final String configChangeStatus;

    private final Instant startTime;

    private final Instant lastUpdatedTime;

    private final String initiatedBy;

    private ChangeProgressDetails(BuilderImpl builder) {
        this.changeId = builder.changeId;
        this.message = builder.message;
        this.configChangeStatus = builder.configChangeStatus;
        this.startTime = builder.startTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.initiatedBy = builder.initiatedBy;
    }

    /**
     * <p>
     * The unique change identifier associated with a specific domain configuration change.
     * </p>
     * 
     * @return The unique change identifier associated with a specific domain configuration change.
     */
    public final String changeId() {
        return changeId;
    }

    /**
     * <p>
     * Contains an optional message associated with the domain configuration change.
     * </p>
     * 
     * @return Contains an optional message associated with the domain configuration change.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The current status of the configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configChangeStatus} will return {@link ConfigChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #configChangeStatusAsString}.
     * </p>
     * 
     * @return The current status of the configuration change.
     * @see ConfigChangeStatus
     */
    public final ConfigChangeStatus configChangeStatus() {
        return ConfigChangeStatus.fromValue(configChangeStatus);
    }

    /**
     * <p>
     * The current status of the configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configChangeStatus} will return {@link ConfigChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #configChangeStatusAsString}.
     * </p>
     * 
     * @return The current status of the configuration change.
     * @see ConfigChangeStatus
     */
    public final String configChangeStatusAsString() {
        return configChangeStatus;
    }

    /**
     * <p>
     * The time that the configuration change was initiated, in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return The time that the configuration change was initiated, in Universal Coordinated Time (UTC).
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The last time that the configuration change was updated.
     * </p>
     * 
     * @return The last time that the configuration change was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The IAM principal who initiated the configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiatedBy} will
     * return {@link InitiatedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #initiatedByAsString}.
     * </p>
     * 
     * @return The IAM principal who initiated the configuration change.
     * @see InitiatedBy
     */
    public final InitiatedBy initiatedBy() {
        return InitiatedBy.fromValue(initiatedBy);
    }

    /**
     * <p>
     * The IAM principal who initiated the configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiatedBy} will
     * return {@link InitiatedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #initiatedByAsString}.
     * </p>
     * 
     * @return The IAM principal who initiated the configuration change.
     * @see InitiatedBy
     */
    public final String initiatedByAsString() {
        return initiatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(changeId());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(configChangeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(initiatedByAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeProgressDetails)) {
            return false;
        }
        ChangeProgressDetails other = (ChangeProgressDetails) obj;
        return Objects.equals(changeId(), other.changeId()) && Objects.equals(message(), other.message())
                && Objects.equals(configChangeStatusAsString(), other.configChangeStatusAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(initiatedByAsString(), other.initiatedByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeProgressDetails").add("ChangeId", changeId()).add("Message", message())
                .add("ConfigChangeStatus", configChangeStatusAsString()).add("StartTime", startTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("InitiatedBy", initiatedByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeId":
            return Optional.ofNullable(clazz.cast(changeId()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ConfigChangeStatus":
            return Optional.ofNullable(clazz.cast(configChangeStatusAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "InitiatedBy":
            return Optional.ofNullable(clazz.cast(initiatedByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeProgressDetails, T> g) {
        return obj -> g.apply((ChangeProgressDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeProgressDetails> {
        /**
         * <p>
         * The unique change identifier associated with a specific domain configuration change.
         * </p>
         * 
         * @param changeId
         *        The unique change identifier associated with a specific domain configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeId(String changeId);

        /**
         * <p>
         * Contains an optional message associated with the domain configuration change.
         * </p>
         * 
         * @param message
         *        Contains an optional message associated with the domain configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The current status of the configuration change.
         * </p>
         * 
         * @param configChangeStatus
         *        The current status of the configuration change.
         * @see ConfigChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigChangeStatus
         */
        Builder configChangeStatus(String configChangeStatus);

        /**
         * <p>
         * The current status of the configuration change.
         * </p>
         * 
         * @param configChangeStatus
         *        The current status of the configuration change.
         * @see ConfigChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigChangeStatus
         */
        Builder configChangeStatus(ConfigChangeStatus configChangeStatus);

        /**
         * <p>
         * The time that the configuration change was initiated, in Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param startTime
         *        The time that the configuration change was initiated, in Universal Coordinated Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The last time that the configuration change was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last time that the configuration change was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The IAM principal who initiated the configuration change.
         * </p>
         * 
         * @param initiatedBy
         *        The IAM principal who initiated the configuration change.
         * @see InitiatedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InitiatedBy
         */
        Builder initiatedBy(String initiatedBy);

        /**
         * <p>
         * The IAM principal who initiated the configuration change.
         * </p>
         * 
         * @param initiatedBy
         *        The IAM principal who initiated the configuration change.
         * @see InitiatedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InitiatedBy
         */
        Builder initiatedBy(InitiatedBy initiatedBy);
    }

    static final class BuilderImpl implements Builder {
        private String changeId;

        private String message;

        private String configChangeStatus;

        private Instant startTime;

        private Instant lastUpdatedTime;

        private String initiatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeProgressDetails model) {
            changeId(model.changeId);
            message(model.message);
            configChangeStatus(model.configChangeStatus);
            startTime(model.startTime);
            lastUpdatedTime(model.lastUpdatedTime);
            initiatedBy(model.initiatedBy);
        }

        public final String getChangeId() {
            return changeId;
        }

        public final void setChangeId(String changeId) {
            this.changeId = changeId;
        }

        @Override
        public final Builder changeId(String changeId) {
            this.changeId = changeId;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getConfigChangeStatus() {
            return configChangeStatus;
        }

        public final void setConfigChangeStatus(String configChangeStatus) {
            this.configChangeStatus = configChangeStatus;
        }

        @Override
        public final Builder configChangeStatus(String configChangeStatus) {
            this.configChangeStatus = configChangeStatus;
            return this;
        }

        @Override
        public final Builder configChangeStatus(ConfigChangeStatus configChangeStatus) {
            this.configChangeStatus(configChangeStatus == null ? null : configChangeStatus.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getInitiatedBy() {
            return initiatedBy;
        }

        public final void setInitiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
        }

        @Override
        public final Builder initiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
            return this;
        }

        @Override
        public final Builder initiatedBy(InitiatedBy initiatedBy) {
            this.initiatedBy(initiatedBy == null ? null : initiatedBy.toString());
            return this;
        }

        @Override
        public ChangeProgressDetails build() {
            return new ChangeProgressDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
