/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFargateProfilesResponse extends EksResponse implements
        ToCopyableBuilder<ListFargateProfilesResponse.Builder, ListFargateProfilesResponse> {
    private static final SdkField<List<String>> FARGATE_PROFILE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("fargateProfileNames")
            .getter(getter(ListFargateProfilesResponse::fargateProfileNames))
            .setter(setter(Builder::fargateProfileNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateProfileNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFargateProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARGATE_PROFILE_NAMES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> fargateProfileNames;

    private final String nextToken;

    private ListFargateProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.fargateProfileNames = builder.fargateProfileNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FargateProfileNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFargateProfileNames() {
        return fargateProfileNames != null && !(fargateProfileNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all of the Fargate profiles associated with the specified cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFargateProfileNames} method.
     * </p>
     * 
     * @return A list of all of the Fargate profiles associated with the specified cluster.
     */
    public final List<String> fargateProfileNames() {
        return fargateProfileNames;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was
     * used and the results exceeded the value of that parameter. Pagination continues from the end of the previous
     * results that returned the <code>nextToken</code> value. This value is null when there are no more results to
     * return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated request, where
     *         <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value. This value
     *         is null when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is used only to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFargateProfileNames() ? fargateProfileNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFargateProfilesResponse)) {
            return false;
        }
        ListFargateProfilesResponse other = (ListFargateProfilesResponse) obj;
        return hasFargateProfileNames() == other.hasFargateProfileNames()
                && Objects.equals(fargateProfileNames(), other.fargateProfileNames())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFargateProfilesResponse")
                .add("FargateProfileNames", hasFargateProfileNames() ? fargateProfileNames() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fargateProfileNames":
            return Optional.ofNullable(clazz.cast(fargateProfileNames()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFargateProfilesResponse, T> g) {
        return obj -> g.apply((ListFargateProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFargateProfilesResponse> {
        /**
         * <p>
         * A list of all of the Fargate profiles associated with the specified cluster.
         * </p>
         * 
         * @param fargateProfileNames
         *        A list of all of the Fargate profiles associated with the specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fargateProfileNames(Collection<String> fargateProfileNames);

        /**
         * <p>
         * A list of all of the Fargate profiles associated with the specified cluster.
         * </p>
         * 
         * @param fargateProfileNames
         *        A list of all of the Fargate profiles associated with the specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fargateProfileNames(String... fargateProfileNames);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code>
         * was used and the results exceeded the value of that parameter. Pagination continues from the end of the
         * previous results that returned the <code>nextToken</code> value. This value is null when there are no more
         * results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated request, where
         *        <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
         *        continues from the end of the previous results that returned the <code>nextToken</code> value. This
         *        value is null when there are no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is used only to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private List<String> fargateProfileNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFargateProfilesResponse model) {
            super(model);
            fargateProfileNames(model.fargateProfileNames);
            nextToken(model.nextToken);
        }

        public final Collection<String> getFargateProfileNames() {
            if (fargateProfileNames instanceof SdkAutoConstructList) {
                return null;
            }
            return fargateProfileNames;
        }

        public final void setFargateProfileNames(Collection<String> fargateProfileNames) {
            this.fargateProfileNames = StringListCopier.copy(fargateProfileNames);
        }

        @Override
        public final Builder fargateProfileNames(Collection<String> fargateProfileNames) {
            this.fargateProfileNames = StringListCopier.copy(fargateProfileNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fargateProfileNames(String... fargateProfileNames) {
            fargateProfileNames(Arrays.asList(fargateProfileNames));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFargateProfilesResponse build() {
            return new ListFargateProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
