/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyReservedInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyReservedInstancesRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyReservedInstancesRequest.Builder, ModifyReservedInstancesRequest> {
    private static final SdkField<List<String>> RESERVED_INSTANCES_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReservedInstancesIds")
            .getter(getter(ModifyReservedInstancesRequest::reservedInstancesIds))
            .setter(setter(Builder::reservedInstancesIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId")
                    .unmarshallLocationName("ReservedInstancesId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReservedInstancesId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReservedInstancesId")
                                                    .unmarshallLocationName("ReservedInstancesId").build()).build()).build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ModifyReservedInstancesRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<List<ReservedInstancesConfiguration>> TARGET_CONFIGURATIONS_FIELD = SdkField
            .<List<ReservedInstancesConfiguration>> builder(MarshallingType.LIST)
            .memberName("TargetConfigurations")
            .getter(getter(ModifyReservedInstancesRequest::targetConfigurations))
            .setter(setter(Builder::targetConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReservedInstancesConfigurationSetItemType")
                    .unmarshallLocationName("ReservedInstancesConfigurationSetItemType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ReservedInstancesConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedInstancesConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCES_IDS_FIELD,
            CLIENT_TOKEN_FIELD, TARGET_CONFIGURATIONS_FIELD));

    private final List<String> reservedInstancesIds;

    private final String clientToken;

    private final List<ReservedInstancesConfiguration> targetConfigurations;

    private ModifyReservedInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.clientToken = builder.clientToken;
        this.targetConfigurations = builder.targetConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservedInstancesIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReservedInstancesIds() {
        return reservedInstancesIds != null && !(reservedInstancesIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Reserved Instances to modify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservedInstancesIds} method.
     * </p>
     * 
     * @return The IDs of the Reserved Instances to modify.
     */
    public final List<String> reservedInstancesIds() {
        return reservedInstancesIds;
    }

    /**
     * <p>
     * A unique, case-sensitive token you provide to ensure idempotency of your modification request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive token you provide to ensure idempotency of your modification request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetConfigurations() {
        return targetConfigurations != null && !(targetConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration settings for the Reserved Instances to modify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetConfigurations} method.
     * </p>
     * 
     * @return The configuration settings for the Reserved Instances to modify.
     */
    public final List<ReservedInstancesConfiguration> targetConfigurations() {
        return targetConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReservedInstancesIds() ? reservedInstancesIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetConfigurations() ? targetConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReservedInstancesRequest)) {
            return false;
        }
        ModifyReservedInstancesRequest other = (ModifyReservedInstancesRequest) obj;
        return hasReservedInstancesIds() == other.hasReservedInstancesIds()
                && Objects.equals(reservedInstancesIds(), other.reservedInstancesIds())
                && Objects.equals(clientToken(), other.clientToken())
                && hasTargetConfigurations() == other.hasTargetConfigurations()
                && Objects.equals(targetConfigurations(), other.targetConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyReservedInstancesRequest")
                .add("ReservedInstancesIds", hasReservedInstancesIds() ? reservedInstancesIds() : null)
                .add("ClientToken", clientToken())
                .add("TargetConfigurations", hasTargetConfigurations() ? targetConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesIds":
            return Optional.ofNullable(clazz.cast(reservedInstancesIds()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "TargetConfigurations":
            return Optional.ofNullable(clazz.cast(targetConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyReservedInstancesRequest, T> g) {
        return obj -> g.apply((ModifyReservedInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyReservedInstancesRequest> {
        /**
         * <p>
         * The IDs of the Reserved Instances to modify.
         * </p>
         * 
         * @param reservedInstancesIds
         *        The IDs of the Reserved Instances to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesIds(Collection<String> reservedInstancesIds);

        /**
         * <p>
         * The IDs of the Reserved Instances to modify.
         * </p>
         * 
         * @param reservedInstancesIds
         *        The IDs of the Reserved Instances to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesIds(String... reservedInstancesIds);

        /**
         * <p>
         * A unique, case-sensitive token you provide to ensure idempotency of your modification request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token you provide to ensure idempotency of your modification request. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration settings for the Reserved Instances to modify.
         * </p>
         * 
         * @param targetConfigurations
         *        The configuration settings for the Reserved Instances to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations);

        /**
         * <p>
         * The configuration settings for the Reserved Instances to modify.
         * </p>
         * 
         * @param targetConfigurations
         *        The configuration settings for the Reserved Instances to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurations(ReservedInstancesConfiguration... targetConfigurations);

        /**
         * <p>
         * The configuration settings for the Reserved Instances to modify.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #targetConfigurations(List<ReservedInstancesConfiguration>)}.
         * 
         * @param targetConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfigurations(java.util.Collection<ReservedInstancesConfiguration>)
         */
        Builder targetConfigurations(Consumer<ReservedInstancesConfiguration.Builder>... targetConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> reservedInstancesIds = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private List<ReservedInstancesConfiguration> targetConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReservedInstancesRequest model) {
            super(model);
            reservedInstancesIds(model.reservedInstancesIds);
            clientToken(model.clientToken);
            targetConfigurations(model.targetConfigurations);
        }

        public final Collection<String> getReservedInstancesIds() {
            if (reservedInstancesIds instanceof SdkAutoConstructList) {
                return null;
            }
            return reservedInstancesIds;
        }

        public final void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
        }

        @Override
        public final Builder reservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(String... reservedInstancesIds) {
            reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<ReservedInstancesConfiguration.Builder> getTargetConfigurations() {
            List<ReservedInstancesConfiguration.Builder> result = ReservedInstancesConfigurationListCopier
                    .copyToBuilder(this.targetConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetConfigurations(Collection<ReservedInstancesConfiguration.BuilderImpl> targetConfigurations) {
            this.targetConfigurations = ReservedInstancesConfigurationListCopier.copyFromBuilder(targetConfigurations);
        }

        @Override
        public final Builder targetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations) {
            this.targetConfigurations = ReservedInstancesConfigurationListCopier.copy(targetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(ReservedInstancesConfiguration... targetConfigurations) {
            targetConfigurations(Arrays.asList(targetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(Consumer<ReservedInstancesConfiguration.Builder>... targetConfigurations) {
            targetConfigurations(Stream.of(targetConfigurations)
                    .map(c -> ReservedInstancesConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReservedInstancesRequest build() {
            return new ModifyReservedInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
