/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a locked snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LockedSnapshotsInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<LockedSnapshotsInfo.Builder, LockedSnapshotsInfo> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(LockedSnapshotsInfo::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(LockedSnapshotsInfo::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<String> LOCK_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LockState")
            .getter(getter(LockedSnapshotsInfo::lockStateAsString))
            .setter(setter(Builder::lockState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockState")
                    .unmarshallLocationName("lockState").build()).build();

    private static final SdkField<Integer> LOCK_DURATION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("LockDuration")
            .getter(getter(LockedSnapshotsInfo::lockDuration))
            .setter(setter(Builder::lockDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockDuration")
                    .unmarshallLocationName("lockDuration").build()).build();

    private static final SdkField<Integer> COOL_OFF_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CoolOffPeriod")
            .getter(getter(LockedSnapshotsInfo::coolOffPeriod))
            .setter(setter(Builder::coolOffPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoolOffPeriod")
                    .unmarshallLocationName("coolOffPeriod").build()).build();

    private static final SdkField<Instant> COOL_OFF_PERIOD_EXPIRES_ON_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CoolOffPeriodExpiresOn")
            .getter(getter(LockedSnapshotsInfo::coolOffPeriodExpiresOn))
            .setter(setter(Builder::coolOffPeriodExpiresOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoolOffPeriodExpiresOn")
                    .unmarshallLocationName("coolOffPeriodExpiresOn").build()).build();

    private static final SdkField<Instant> LOCK_CREATED_ON_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LockCreatedOn")
            .getter(getter(LockedSnapshotsInfo::lockCreatedOn))
            .setter(setter(Builder::lockCreatedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockCreatedOn")
                    .unmarshallLocationName("lockCreatedOn").build()).build();

    private static final SdkField<Instant> LOCK_DURATION_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LockDurationStartTime")
            .getter(getter(LockedSnapshotsInfo::lockDurationStartTime))
            .setter(setter(Builder::lockDurationStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockDurationStartTime")
                    .unmarshallLocationName("lockDurationStartTime").build()).build();

    private static final SdkField<Instant> LOCK_EXPIRES_ON_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LockExpiresOn")
            .getter(getter(LockedSnapshotsInfo::lockExpiresOn))
            .setter(setter(Builder::lockExpiresOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockExpiresOn")
                    .unmarshallLocationName("lockExpiresOn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD,
            SNAPSHOT_ID_FIELD, LOCK_STATE_FIELD, LOCK_DURATION_FIELD, COOL_OFF_PERIOD_FIELD, COOL_OFF_PERIOD_EXPIRES_ON_FIELD,
            LOCK_CREATED_ON_FIELD, LOCK_DURATION_START_TIME_FIELD, LOCK_EXPIRES_ON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ownerId;

    private final String snapshotId;

    private final String lockState;

    private final Integer lockDuration;

    private final Integer coolOffPeriod;

    private final Instant coolOffPeriodExpiresOn;

    private final Instant lockCreatedOn;

    private final Instant lockDurationStartTime;

    private final Instant lockExpiresOn;

    private LockedSnapshotsInfo(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.snapshotId = builder.snapshotId;
        this.lockState = builder.lockState;
        this.lockDuration = builder.lockDuration;
        this.coolOffPeriod = builder.coolOffPeriod;
        this.coolOffPeriodExpiresOn = builder.coolOffPeriodExpiresOn;
        this.lockCreatedOn = builder.lockCreatedOn;
        this.lockDurationStartTime = builder.lockDurationStartTime;
        this.lockExpiresOn = builder.lockExpiresOn;
    }

    /**
     * <p>
     * The account ID of the Amazon Web Services account that owns the snapshot.
     * </p>
     * 
     * @return The account ID of the Amazon Web Services account that owns the snapshot.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The state of the snapshot lock. Valid states include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still within the
     * cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock settings can be modified
     * by users with appropriate permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted, but it can be
     * unlocked and the lock settings can be modified by users with appropriate permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has expired. The
     * snapshot can't be unlocked or deleted. The lock duration can only be increased by users with appropriate
     * permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration has
     * expired. The snapshot is not locked and can be deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockState} will
     * return {@link LockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockStateAsString}.
     * </p>
     * 
     * @return The state of the snapshot lock. Valid states include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still within
     *         the cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock settings can
     *         be modified by users with appropriate permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted, but
     *         it can be unlocked and the lock settings can be modified by users with appropriate permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has
     *         expired. The snapshot can't be unlocked or deleted. The lock duration can only be increased by users with
     *         appropriate permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration has
     *         expired. The snapshot is not locked and can be deleted.
     *         </p>
     *         </li>
     * @see LockState
     */
    public final LockState lockState() {
        return LockState.fromValue(lockState);
    }

    /**
     * <p>
     * The state of the snapshot lock. Valid states include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still within the
     * cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock settings can be modified
     * by users with appropriate permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted, but it can be
     * unlocked and the lock settings can be modified by users with appropriate permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has expired. The
     * snapshot can't be unlocked or deleted. The lock duration can only be increased by users with appropriate
     * permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration has
     * expired. The snapshot is not locked and can be deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockState} will
     * return {@link LockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockStateAsString}.
     * </p>
     * 
     * @return The state of the snapshot lock. Valid states include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still within
     *         the cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock settings can
     *         be modified by users with appropriate permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted, but
     *         it can be unlocked and the lock settings can be modified by users with appropriate permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has
     *         expired. The snapshot can't be unlocked or deleted. The lock duration can only be increased by users with
     *         appropriate permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration has
     *         expired. The snapshot is not locked and can be deleted.
     *         </p>
     *         </li>
     * @see LockState
     */
    public final String lockStateAsString() {
        return lockState;
    }

    /**
     * <p>
     * The period of time for which the snapshot is locked, in days.
     * </p>
     * 
     * @return The period of time for which the snapshot is locked, in days.
     */
    public final Integer lockDuration() {
        return lockDuration;
    }

    /**
     * <p>
     * The compliance mode cooling-off period, in hours.
     * </p>
     * 
     * @return The compliance mode cooling-off period, in hours.
     */
    public final Integer coolOffPeriod() {
        return coolOffPeriod;
    }

    /**
     * <p>
     * The date and time at which the compliance mode cooling-off period expires, in the UTC time zone (
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     * </p>
     * 
     * @return The date and time at which the compliance mode cooling-off period expires, in the UTC time zone (
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     */
    public final Instant coolOffPeriodExpiresOn() {
        return coolOffPeriodExpiresOn;
    }

    /**
     * <p>
     * The date and time at which the snapshot was locked, in the UTC time zone (<code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     * </p>
     * 
     * @return The date and time at which the snapshot was locked, in the UTC time zone (
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     */
    public final Instant lockCreatedOn() {
        return lockCreatedOn;
    }

    /**
     * <p>
     * The date and time at which the lock duration started, in the UTC time zone (<code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     * ).
     * </p>
     * <p>
     * If you lock a snapshot that is in the <code>pending</code> state, the lock duration starts only once the snapshot
     * enters the <code>completed</code> state.
     * </p>
     * 
     * @return The date and time at which the lock duration started, in the UTC time zone (
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).</p>
     *         <p>
     *         If you lock a snapshot that is in the <code>pending</code> state, the lock duration starts only once the
     *         snapshot enters the <code>completed</code> state.
     */
    public final Instant lockDurationStartTime() {
        return lockDurationStartTime;
    }

    /**
     * <p>
     * The date and time at which the lock will expire, in the UTC time zone (<code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     * </p>
     * 
     * @return The date and time at which the lock will expire, in the UTC time zone (
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     */
    public final Instant lockExpiresOn() {
        return lockExpiresOn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(lockStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lockDuration());
        hashCode = 31 * hashCode + Objects.hashCode(coolOffPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(coolOffPeriodExpiresOn());
        hashCode = 31 * hashCode + Objects.hashCode(lockCreatedOn());
        hashCode = 31 * hashCode + Objects.hashCode(lockDurationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(lockExpiresOn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LockedSnapshotsInfo)) {
            return false;
        }
        LockedSnapshotsInfo other = (LockedSnapshotsInfo) obj;
        return Objects.equals(ownerId(), other.ownerId()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(lockStateAsString(), other.lockStateAsString())
                && Objects.equals(lockDuration(), other.lockDuration()) && Objects.equals(coolOffPeriod(), other.coolOffPeriod())
                && Objects.equals(coolOffPeriodExpiresOn(), other.coolOffPeriodExpiresOn())
                && Objects.equals(lockCreatedOn(), other.lockCreatedOn())
                && Objects.equals(lockDurationStartTime(), other.lockDurationStartTime())
                && Objects.equals(lockExpiresOn(), other.lockExpiresOn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LockedSnapshotsInfo").add("OwnerId", ownerId()).add("SnapshotId", snapshotId())
                .add("LockState", lockStateAsString()).add("LockDuration", lockDuration()).add("CoolOffPeriod", coolOffPeriod())
                .add("CoolOffPeriodExpiresOn", coolOffPeriodExpiresOn()).add("LockCreatedOn", lockCreatedOn())
                .add("LockDurationStartTime", lockDurationStartTime()).add("LockExpiresOn", lockExpiresOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "LockState":
            return Optional.ofNullable(clazz.cast(lockStateAsString()));
        case "LockDuration":
            return Optional.ofNullable(clazz.cast(lockDuration()));
        case "CoolOffPeriod":
            return Optional.ofNullable(clazz.cast(coolOffPeriod()));
        case "CoolOffPeriodExpiresOn":
            return Optional.ofNullable(clazz.cast(coolOffPeriodExpiresOn()));
        case "LockCreatedOn":
            return Optional.ofNullable(clazz.cast(lockCreatedOn()));
        case "LockDurationStartTime":
            return Optional.ofNullable(clazz.cast(lockDurationStartTime()));
        case "LockExpiresOn":
            return Optional.ofNullable(clazz.cast(lockExpiresOn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LockedSnapshotsInfo, T> g) {
        return obj -> g.apply((LockedSnapshotsInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LockedSnapshotsInfo> {
        /**
         * <p>
         * The account ID of the Amazon Web Services account that owns the snapshot.
         * </p>
         * 
         * @param ownerId
         *        The account ID of the Amazon Web Services account that owns the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The state of the snapshot lock. Valid states include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still within the
         * cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock settings can be
         * modified by users with appropriate permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted, but it
         * can be unlocked and the lock settings can be modified by users with appropriate permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has expired.
         * The snapshot can't be unlocked or deleted. The lock duration can only be increased by users with appropriate
         * permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration has
         * expired. The snapshot is not locked and can be deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lockState
         *        The state of the snapshot lock. Valid states include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still
         *        within the cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock
         *        settings can be modified by users with appropriate permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted,
         *        but it can be unlocked and the lock settings can be modified by users with appropriate permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has
         *        expired. The snapshot can't be unlocked or deleted. The lock duration can only be increased by users
         *        with appropriate permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration
         *        has expired. The snapshot is not locked and can be deleted.
         *        </p>
         *        </li>
         * @see LockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockState
         */
        Builder lockState(String lockState);

        /**
         * <p>
         * The state of the snapshot lock. Valid states include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still within the
         * cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock settings can be
         * modified by users with appropriate permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted, but it
         * can be unlocked and the lock settings can be modified by users with appropriate permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has expired.
         * The snapshot can't be unlocked or deleted. The lock duration can only be increased by users with appropriate
         * permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration has
         * expired. The snapshot is not locked and can be deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lockState
         *        The state of the snapshot lock. Valid states include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still
         *        within the cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock
         *        settings can be modified by users with appropriate permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted,
         *        but it can be unlocked and the lock settings can be modified by users with appropriate permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has
         *        expired. The snapshot can't be unlocked or deleted. The lock duration can only be increased by users
         *        with appropriate permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration
         *        has expired. The snapshot is not locked and can be deleted.
         *        </p>
         *        </li>
         * @see LockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockState
         */
        Builder lockState(LockState lockState);

        /**
         * <p>
         * The period of time for which the snapshot is locked, in days.
         * </p>
         * 
         * @param lockDuration
         *        The period of time for which the snapshot is locked, in days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockDuration(Integer lockDuration);

        /**
         * <p>
         * The compliance mode cooling-off period, in hours.
         * </p>
         * 
         * @param coolOffPeriod
         *        The compliance mode cooling-off period, in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coolOffPeriod(Integer coolOffPeriod);

        /**
         * <p>
         * The date and time at which the compliance mode cooling-off period expires, in the UTC time zone (
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * </p>
         * 
         * @param coolOffPeriodExpiresOn
         *        The date and time at which the compliance mode cooling-off period expires, in the UTC time zone (
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coolOffPeriodExpiresOn(Instant coolOffPeriodExpiresOn);

        /**
         * <p>
         * The date and time at which the snapshot was locked, in the UTC time zone (
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * </p>
         * 
         * @param lockCreatedOn
         *        The date and time at which the snapshot was locked, in the UTC time zone (
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockCreatedOn(Instant lockCreatedOn);

        /**
         * <p>
         * The date and time at which the lock duration started, in the UTC time zone (
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * </p>
         * <p>
         * If you lock a snapshot that is in the <code>pending</code> state, the lock duration starts only once the
         * snapshot enters the <code>completed</code> state.
         * </p>
         * 
         * @param lockDurationStartTime
         *        The date and time at which the lock duration started, in the UTC time zone (
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).</p>
         *        <p>
         *        If you lock a snapshot that is in the <code>pending</code> state, the lock duration starts only once
         *        the snapshot enters the <code>completed</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockDurationStartTime(Instant lockDurationStartTime);

        /**
         * <p>
         * The date and time at which the lock will expire, in the UTC time zone (<code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * ).
         * </p>
         * 
         * @param lockExpiresOn
         *        The date and time at which the lock will expire, in the UTC time zone (
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockExpiresOn(Instant lockExpiresOn);
    }

    static final class BuilderImpl implements Builder {
        private String ownerId;

        private String snapshotId;

        private String lockState;

        private Integer lockDuration;

        private Integer coolOffPeriod;

        private Instant coolOffPeriodExpiresOn;

        private Instant lockCreatedOn;

        private Instant lockDurationStartTime;

        private Instant lockExpiresOn;

        private BuilderImpl() {
        }

        private BuilderImpl(LockedSnapshotsInfo model) {
            ownerId(model.ownerId);
            snapshotId(model.snapshotId);
            lockState(model.lockState);
            lockDuration(model.lockDuration);
            coolOffPeriod(model.coolOffPeriod);
            coolOffPeriodExpiresOn(model.coolOffPeriodExpiresOn);
            lockCreatedOn(model.lockCreatedOn);
            lockDurationStartTime(model.lockDurationStartTime);
            lockExpiresOn(model.lockExpiresOn);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getLockState() {
            return lockState;
        }

        public final void setLockState(String lockState) {
            this.lockState = lockState;
        }

        @Override
        public final Builder lockState(String lockState) {
            this.lockState = lockState;
            return this;
        }

        @Override
        public final Builder lockState(LockState lockState) {
            this.lockState(lockState == null ? null : lockState.toString());
            return this;
        }

        public final Integer getLockDuration() {
            return lockDuration;
        }

        public final void setLockDuration(Integer lockDuration) {
            this.lockDuration = lockDuration;
        }

        @Override
        public final Builder lockDuration(Integer lockDuration) {
            this.lockDuration = lockDuration;
            return this;
        }

        public final Integer getCoolOffPeriod() {
            return coolOffPeriod;
        }

        public final void setCoolOffPeriod(Integer coolOffPeriod) {
            this.coolOffPeriod = coolOffPeriod;
        }

        @Override
        public final Builder coolOffPeriod(Integer coolOffPeriod) {
            this.coolOffPeriod = coolOffPeriod;
            return this;
        }

        public final Instant getCoolOffPeriodExpiresOn() {
            return coolOffPeriodExpiresOn;
        }

        public final void setCoolOffPeriodExpiresOn(Instant coolOffPeriodExpiresOn) {
            this.coolOffPeriodExpiresOn = coolOffPeriodExpiresOn;
        }

        @Override
        public final Builder coolOffPeriodExpiresOn(Instant coolOffPeriodExpiresOn) {
            this.coolOffPeriodExpiresOn = coolOffPeriodExpiresOn;
            return this;
        }

        public final Instant getLockCreatedOn() {
            return lockCreatedOn;
        }

        public final void setLockCreatedOn(Instant lockCreatedOn) {
            this.lockCreatedOn = lockCreatedOn;
        }

        @Override
        public final Builder lockCreatedOn(Instant lockCreatedOn) {
            this.lockCreatedOn = lockCreatedOn;
            return this;
        }

        public final Instant getLockDurationStartTime() {
            return lockDurationStartTime;
        }

        public final void setLockDurationStartTime(Instant lockDurationStartTime) {
            this.lockDurationStartTime = lockDurationStartTime;
        }

        @Override
        public final Builder lockDurationStartTime(Instant lockDurationStartTime) {
            this.lockDurationStartTime = lockDurationStartTime;
            return this;
        }

        public final Instant getLockExpiresOn() {
            return lockExpiresOn;
        }

        public final void setLockExpiresOn(Instant lockExpiresOn) {
            this.lockExpiresOn = lockExpiresOn;
        }

        @Override
        public final Builder lockExpiresOn(Instant lockExpiresOn) {
            this.lockExpiresOn = lockExpiresOn;
            return this;
        }

        @Override
        public LockedSnapshotsInfo build() {
            return new LockedSnapshotsInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
