/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients when a
 * VPN session is established.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientLoginBannerOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientLoginBannerOptions.Builder, ClientLoginBannerOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(ClientLoginBannerOptions::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<String> BANNER_TEXT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BannerText")
            .getter(getter(ClientLoginBannerOptions::bannerText))
            .setter(setter(Builder::bannerText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BannerText")
                    .unmarshallLocationName("BannerText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            BANNER_TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String bannerText;

    private ClientLoginBannerOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.bannerText = builder.bannerText;
    }

    /**
     * <p>
     * Enable or disable a customizable text banner that will be displayed on Amazon Web Services provided clients when
     * a VPN session is established.
     * </p>
     * <p>
     * Valid values: <code>true | false</code>
     * </p>
     * <p>
     * Default value: <code>false</code>
     * </p>
     * 
     * @return Enable or disable a customizable text banner that will be displayed on Amazon Web Services provided
     *         clients when a VPN session is established.</p>
     *         <p>
     *         Valid values: <code>true | false</code>
     *         </p>
     *         <p>
     *         Default value: <code>false</code>
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Customizable text that will be displayed in a banner on Amazon Web Services provided clients when a VPN session
     * is established. UTF-8 encoded characters only. Maximum of 1400 characters.
     * </p>
     * 
     * @return Customizable text that will be displayed in a banner on Amazon Web Services provided clients when a VPN
     *         session is established. UTF-8 encoded characters only. Maximum of 1400 characters.
     */
    public final String bannerText() {
        return bannerText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(bannerText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientLoginBannerOptions)) {
            return false;
        }
        ClientLoginBannerOptions other = (ClientLoginBannerOptions) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(bannerText(), other.bannerText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientLoginBannerOptions").add("Enabled", enabled()).add("BannerText", bannerText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "BannerText":
            return Optional.ofNullable(clazz.cast(bannerText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientLoginBannerOptions, T> g) {
        return obj -> g.apply((ClientLoginBannerOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientLoginBannerOptions> {
        /**
         * <p>
         * Enable or disable a customizable text banner that will be displayed on Amazon Web Services provided clients
         * when a VPN session is established.
         * </p>
         * <p>
         * Valid values: <code>true | false</code>
         * </p>
         * <p>
         * Default value: <code>false</code>
         * </p>
         * 
         * @param enabled
         *        Enable or disable a customizable text banner that will be displayed on Amazon Web Services provided
         *        clients when a VPN session is established.</p>
         *        <p>
         *        Valid values: <code>true | false</code>
         *        </p>
         *        <p>
         *        Default value: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Customizable text that will be displayed in a banner on Amazon Web Services provided clients when a VPN
         * session is established. UTF-8 encoded characters only. Maximum of 1400 characters.
         * </p>
         * 
         * @param bannerText
         *        Customizable text that will be displayed in a banner on Amazon Web Services provided clients when a
         *        VPN session is established. UTF-8 encoded characters only. Maximum of 1400 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bannerText(String bannerText);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String bannerText;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientLoginBannerOptions model) {
            enabled(model.enabled);
            bannerText(model.bannerText);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getBannerText() {
            return bannerText;
        }

        public final void setBannerText(String bannerText) {
            this.bannerText = bannerText;
        }

        @Override
        public final Builder bannerText(String bannerText) {
            this.bannerText = bannerText;
            return this;
        }

        @Override
        public ClientLoginBannerOptions build() {
            return new ClientLoginBannerOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
