/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents test settings. This data structure is passed in as the test parameter to ScheduleRun. For an example of
 * the JSON request syntax, see <a>ScheduleRun</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleRunTest implements SdkPojo, Serializable, ToCopyableBuilder<ScheduleRunTest.Builder, ScheduleRunTest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ScheduleRunTest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> TEST_PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testPackageArn").getter(getter(ScheduleRunTest::testPackageArn)).setter(setter(Builder::testPackageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testPackageArn").build()).build();

    private static final SdkField<String> TEST_SPEC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSpecArn").getter(getter(ScheduleRunTest::testSpecArn)).setter(setter(Builder::testSpecArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSpecArn").build()).build();

    private static final SdkField<String> FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("filter")
            .getter(getter(ScheduleRunTest::filter)).setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(ScheduleRunTest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            TEST_PACKAGE_ARN_FIELD, TEST_SPEC_ARN_FIELD, FILTER_FIELD, PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String testPackageArn;

    private final String testSpecArn;

    private final String filter;

    private final Map<String, String> parameters;

    private ScheduleRunTest(BuilderImpl builder) {
        this.type = builder.type;
        this.testPackageArn = builder.testPackageArn;
        this.testSpecArn = builder.testSpecArn;
        this.filter = builder.filter;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The test's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing
     * screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The test's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_NODE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_RUBY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_NODE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_RUBY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI
     *         </p>
     *         </li>
     * @see TestType
     */
    public final TestType type() {
        return TestType.fromValue(type);
    }

    /**
     * <p>
     * The test's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing
     * screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The test's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_NODE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_RUBY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_NODE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_RUBY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI
     *         </p>
     *         </li>
     * @see TestType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The ARN of the uploaded test to be run.
     * </p>
     * 
     * @return The ARN of the uploaded test to be run.
     */
    public final String testPackageArn() {
        return testPackageArn;
    }

    /**
     * <p>
     * The ARN of the YAML-formatted test specification.
     * </p>
     * 
     * @return The ARN of the YAML-formatted test specification.
     */
    public final String testSpecArn() {
        return testSpecArn;
    }

    /**
     * <p>
     * The test's filter.
     * </p>
     * 
     * @return The test's filter.
     */
    public final String filter() {
        return filter;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The test's parameters, such as test framework parameters and fixture settings. Parameters are represented by
     * name-value pairs of strings.
     * </p>
     * <p>
     * For all tests:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>app_performance_monitoring</code>: Performance monitoring is enabled by default. Set this parameter to
     * false to disable it.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For Calabash tests:
     * </p>
     * <ul>
     * <li>
     * <p>
     * profile: A cucumber profile (for example, <code>my_profile_name</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * tags: You can limit execution to features or scenarios that have (or don't have) certain tags (for example, @smoke
     * or @smoke,~@wip).
     * </p>
     * </li>
     * </ul>
     * <p>
     * For Appium tests (all types):
     * </p>
     * <ul>
     * <li>
     * <p>
     * appium_version: The Appium version. Currently supported values are 1.6.5 (and later), latest, and default.
     * </p>
     * <ul>
     * <li>
     * <p>
     * latest runs the latest Appium version supported by Device Farm (1.9.1).
     * </p>
     * </li>
     * <li>
     * <p>
     * For default, Device Farm selects a compatible version of Appium for the device. The current behavior is to run
     * 1.7.2 on Android devices and iOS 9 and earlier and 1.7.2 for iOS 10 and later.
     * </p>
     * </li>
     * <li>
     * <p>
     * This behavior is subject to change.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For fuzz tests (Android only):
     * </p>
     * <ul>
     * <li>
     * <p>
     * event_count: The number of events, between 1 and 10000, that the UI fuzz test should perform.
     * </p>
     * </li>
     * <li>
     * <p>
     * throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should wait between events.
     * </p>
     * </li>
     * <li>
     * <p>
     * seed: A seed to use for randomizing the UI fuzz test. Using the same seed value between tests ensures identical
     * event sequences.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For Explorer tests:
     * </p>
     * <ul>
     * <li>
     * <p>
     * username: A user name to use if the Explorer encounters a login form. If not supplied, no user name is inserted.
     * </p>
     * </li>
     * <li>
     * <p>
     * password: A password to use if the Explorer encounters a login form. If not supplied, no password is inserted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For Instrumentation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * filter: A test filter string. Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Running a single test case: <code>com.android.abc.Test1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Running a single test: <code>com.android.abc.Test1#smoke</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Running multiple tests: <code>com.android.abc.Test1,com.android.abc.Test2</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For XCTest and XCTestUI:
     * </p>
     * <ul>
     * <li>
     * <p>
     * filter: A test filter string. Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Running a single test class: <code>LoginTests</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Running a multiple test classes: <code>LoginTests,SmokeTests</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Running a single test: <code>LoginTests/testValid</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Running multiple tests: <code>LoginTests/testValid,LoginTests/testInvalid</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For UIAutomator:
     * </p>
     * <ul>
     * <li>
     * <p>
     * filter: A test filter string. Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Running a single test case: <code>com.android.abc.Test1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Running a single test: <code>com.android.abc.Test1#smoke</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Running multiple tests: <code>com.android.abc.Test1,com.android.abc.Test2</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The test's parameters, such as test framework parameters and fixture settings. Parameters are represented
     *         by name-value pairs of strings.</p>
     *         <p>
     *         For all tests:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>app_performance_monitoring</code>: Performance monitoring is enabled by default. Set this parameter
     *         to false to disable it.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For Calabash tests:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         profile: A cucumber profile (for example, <code>my_profile_name</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         tags: You can limit execution to features or scenarios that have (or don't have) certain tags (for
     *         example, @smoke or @smoke,~@wip).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For Appium tests (all types):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         appium_version: The Appium version. Currently supported values are 1.6.5 (and later), latest, and
     *         default.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         latest runs the latest Appium version supported by Device Farm (1.9.1).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For default, Device Farm selects a compatible version of Appium for the device. The current behavior is
     *         to run 1.7.2 on Android devices and iOS 9 and earlier and 1.7.2 for iOS 10 and later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         This behavior is subject to change.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         For fuzz tests (Android only):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         event_count: The number of events, between 1 and 10000, that the UI fuzz test should perform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should wait between events.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         seed: A seed to use for randomizing the UI fuzz test. Using the same seed value between tests ensures
     *         identical event sequences.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For Explorer tests:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         username: A user name to use if the Explorer encounters a login form. If not supplied, no user name is
     *         inserted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         password: A password to use if the Explorer encounters a login form. If not supplied, no password is
     *         inserted.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For Instrumentation:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         filter: A test filter string. Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Running a single test case: <code>com.android.abc.Test1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running a single test: <code>com.android.abc.Test1#smoke</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running multiple tests: <code>com.android.abc.Test1,com.android.abc.Test2</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         For XCTest and XCTestUI:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         filter: A test filter string. Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Running a single test class: <code>LoginTests</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running a multiple test classes: <code>LoginTests,SmokeTests</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running a single test: <code>LoginTests/testValid</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running multiple tests: <code>LoginTests/testValid,LoginTests/testInvalid</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         For UIAutomator:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         filter: A test filter string. Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Running a single test case: <code>com.android.abc.Test1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running a single test: <code>com.android.abc.Test1#smoke</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running multiple tests: <code>com.android.abc.Test1,com.android.abc.Test2</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(testPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(testSpecArn());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunTest)) {
            return false;
        }
        ScheduleRunTest other = (ScheduleRunTest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(testPackageArn(), other.testPackageArn())
                && Objects.equals(testSpecArn(), other.testSpecArn()) && Objects.equals(filter(), other.filter())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleRunTest").add("Type", typeAsString()).add("TestPackageArn", testPackageArn())
                .add("TestSpecArn", testSpecArn()).add("Filter", filter())
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "testPackageArn":
            return Optional.ofNullable(clazz.cast(testPackageArn()));
        case "testSpecArn":
            return Optional.ofNullable(clazz.cast(testSpecArn()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleRunTest, T> g) {
        return obj -> g.apply((ScheduleRunTest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleRunTest> {
        /**
         * <p>
         * The test's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_NODE
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_RUBY
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_NODE
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_RUBY
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The test's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
         *        capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_NODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_RUBY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_NODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_RUBY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(String type);

        /**
         * <p>
         * The test's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_NODE
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_RUBY
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_NODE
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_RUBY
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The test's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
         *        capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_NODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_RUBY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_NODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_RUBY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(TestType type);

        /**
         * <p>
         * The ARN of the uploaded test to be run.
         * </p>
         * 
         * @param testPackageArn
         *        The ARN of the uploaded test to be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testPackageArn(String testPackageArn);

        /**
         * <p>
         * The ARN of the YAML-formatted test specification.
         * </p>
         * 
         * @param testSpecArn
         *        The ARN of the YAML-formatted test specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSpecArn(String testSpecArn);

        /**
         * <p>
         * The test's filter.
         * </p>
         * 
         * @param filter
         *        The test's filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(String filter);

        /**
         * <p>
         * The test's parameters, such as test framework parameters and fixture settings. Parameters are represented by
         * name-value pairs of strings.
         * </p>
         * <p>
         * For all tests:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>app_performance_monitoring</code>: Performance monitoring is enabled by default. Set this parameter to
         * false to disable it.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For Calabash tests:
         * </p>
         * <ul>
         * <li>
         * <p>
         * profile: A cucumber profile (for example, <code>my_profile_name</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * tags: You can limit execution to features or scenarios that have (or don't have) certain tags (for example, @smoke
         * or @smoke,~@wip).
         * </p>
         * </li>
         * </ul>
         * <p>
         * For Appium tests (all types):
         * </p>
         * <ul>
         * <li>
         * <p>
         * appium_version: The Appium version. Currently supported values are 1.6.5 (and later), latest, and default.
         * </p>
         * <ul>
         * <li>
         * <p>
         * latest runs the latest Appium version supported by Device Farm (1.9.1).
         * </p>
         * </li>
         * <li>
         * <p>
         * For default, Device Farm selects a compatible version of Appium for the device. The current behavior is to
         * run 1.7.2 on Android devices and iOS 9 and earlier and 1.7.2 for iOS 10 and later.
         * </p>
         * </li>
         * <li>
         * <p>
         * This behavior is subject to change.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * For fuzz tests (Android only):
         * </p>
         * <ul>
         * <li>
         * <p>
         * event_count: The number of events, between 1 and 10000, that the UI fuzz test should perform.
         * </p>
         * </li>
         * <li>
         * <p>
         * throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should wait between events.
         * </p>
         * </li>
         * <li>
         * <p>
         * seed: A seed to use for randomizing the UI fuzz test. Using the same seed value between tests ensures
         * identical event sequences.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For Explorer tests:
         * </p>
         * <ul>
         * <li>
         * <p>
         * username: A user name to use if the Explorer encounters a login form. If not supplied, no user name is
         * inserted.
         * </p>
         * </li>
         * <li>
         * <p>
         * password: A password to use if the Explorer encounters a login form. If not supplied, no password is
         * inserted.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For Instrumentation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * filter: A test filter string. Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Running a single test case: <code>com.android.abc.Test1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Running a single test: <code>com.android.abc.Test1#smoke</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Running multiple tests: <code>com.android.abc.Test1,com.android.abc.Test2</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * For XCTest and XCTestUI:
         * </p>
         * <ul>
         * <li>
         * <p>
         * filter: A test filter string. Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Running a single test class: <code>LoginTests</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Running a multiple test classes: <code>LoginTests,SmokeTests</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Running a single test: <code>LoginTests/testValid</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Running multiple tests: <code>LoginTests/testValid,LoginTests/testInvalid</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * For UIAutomator:
         * </p>
         * <ul>
         * <li>
         * <p>
         * filter: A test filter string. Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Running a single test case: <code>com.android.abc.Test1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Running a single test: <code>com.android.abc.Test1#smoke</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Running multiple tests: <code>com.android.abc.Test1,com.android.abc.Test2</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param parameters
         *        The test's parameters, such as test framework parameters and fixture settings. Parameters are
         *        represented by name-value pairs of strings.</p>
         *        <p>
         *        For all tests:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>app_performance_monitoring</code>: Performance monitoring is enabled by default. Set this
         *        parameter to false to disable it.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For Calabash tests:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        profile: A cucumber profile (for example, <code>my_profile_name</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        tags: You can limit execution to features or scenarios that have (or don't have) certain tags (for
         *        example, @smoke or @smoke,~@wip).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For Appium tests (all types):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        appium_version: The Appium version. Currently supported values are 1.6.5 (and later), latest, and
         *        default.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        latest runs the latest Appium version supported by Device Farm (1.9.1).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For default, Device Farm selects a compatible version of Appium for the device. The current behavior
         *        is to run 1.7.2 on Android devices and iOS 9 and earlier and 1.7.2 for iOS 10 and later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This behavior is subject to change.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        For fuzz tests (Android only):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        event_count: The number of events, between 1 and 10000, that the UI fuzz test should perform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should wait between events.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        seed: A seed to use for randomizing the UI fuzz test. Using the same seed value between tests ensures
         *        identical event sequences.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For Explorer tests:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        username: A user name to use if the Explorer encounters a login form. If not supplied, no user name is
         *        inserted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        password: A password to use if the Explorer encounters a login form. If not supplied, no password is
         *        inserted.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For Instrumentation:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        filter: A test filter string. Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Running a single test case: <code>com.android.abc.Test1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running a single test: <code>com.android.abc.Test1#smoke</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running multiple tests: <code>com.android.abc.Test1,com.android.abc.Test2</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        For XCTest and XCTestUI:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        filter: A test filter string. Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Running a single test class: <code>LoginTests</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running a multiple test classes: <code>LoginTests,SmokeTests</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running a single test: <code>LoginTests/testValid</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running multiple tests: <code>LoginTests/testValid,LoginTests/testInvalid</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        For UIAutomator:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        filter: A test filter string. Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Running a single test case: <code>com.android.abc.Test1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running a single test: <code>com.android.abc.Test1#smoke</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running multiple tests: <code>com.android.abc.Test1,com.android.abc.Test2</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String testPackageArn;

        private String testSpecArn;

        private String filter;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunTest model) {
            type(model.type);
            testPackageArn(model.testPackageArn);
            testSpecArn(model.testSpecArn);
            filter(model.filter);
            parameters(model.parameters);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTestPackageArn() {
            return testPackageArn;
        }

        public final void setTestPackageArn(String testPackageArn) {
            this.testPackageArn = testPackageArn;
        }

        @Override
        public final Builder testPackageArn(String testPackageArn) {
            this.testPackageArn = testPackageArn;
            return this;
        }

        public final String getTestSpecArn() {
            return testSpecArn;
        }

        public final void setTestSpecArn(String testSpecArn) {
            this.testSpecArn = testSpecArn;
        }

        @Override
        public final Builder testSpecArn(String testSpecArn) {
            this.testSpecArn = testSpecArn;
            return this;
        }

        public final String getFilter() {
            return filter;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = TestParametersCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = TestParametersCopier.copy(parameters);
            return this;
        }

        @Override
        public ScheduleRunTest build() {
            return new ScheduleRunTest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
