/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ActivatePipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivatePipelineRequest extends DataPipelineRequest implements
        ToCopyableBuilder<ActivatePipelineRequest.Builder, ActivatePipelineRequest> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineId").getter(getter(ActivatePipelineRequest::pipelineId)).setter(setter(Builder::pipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()).build();

    private static final SdkField<List<ParameterValue>> PARAMETER_VALUES_FIELD = SdkField
            .<List<ParameterValue>> builder(MarshallingType.LIST)
            .memberName("parameterValues")
            .getter(getter(ActivatePipelineRequest::parameterValues))
            .setter(setter(Builder::parameterValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTimestamp").getter(getter(ActivatePipelineRequest::startTimestamp))
            .setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD,
            PARAMETER_VALUES_FIELD, START_TIMESTAMP_FIELD));

    private final String pipelineId;

    private final List<ParameterValue> parameterValues;

    private final Instant startTimestamp;

    private ActivatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.parameterValues = builder.parameterValues;
        this.startTimestamp = builder.startTimestamp;
    }

    /**
     * <p>
     * The ID of the pipeline.
     * </p>
     * 
     * @return The ID of the pipeline.
     */
    public final String pipelineId() {
        return pipelineId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterValues() {
        return parameterValues != null && !(parameterValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameter values to pass to the pipeline at activation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterValues} method.
     * </p>
     * 
     * @return A list of parameter values to pass to the pipeline at activation.
     */
    public final List<ParameterValue> parameterValues() {
        return parameterValues;
    }

    /**
     * <p>
     * The date and time to resume the pipeline. By default, the pipeline resumes from the last completed execution.
     * </p>
     * 
     * @return The date and time to resume the pipeline. By default, the pipeline resumes from the last completed
     *         execution.
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterValues() ? parameterValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivatePipelineRequest)) {
            return false;
        }
        ActivatePipelineRequest other = (ActivatePipelineRequest) obj;
        return Objects.equals(pipelineId(), other.pipelineId()) && hasParameterValues() == other.hasParameterValues()
                && Objects.equals(parameterValues(), other.parameterValues())
                && Objects.equals(startTimestamp(), other.startTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActivatePipelineRequest").add("PipelineId", pipelineId())
                .add("ParameterValues", hasParameterValues() ? parameterValues() : null).add("StartTimestamp", startTimestamp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineId":
            return Optional.ofNullable(clazz.cast(pipelineId()));
        case "parameterValues":
            return Optional.ofNullable(clazz.cast(parameterValues()));
        case "startTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivatePipelineRequest, T> g) {
        return obj -> g.apply((ActivatePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, ActivatePipelineRequest> {
        /**
         * <p>
         * The ID of the pipeline.
         * </p>
         * 
         * @param pipelineId
         *        The ID of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineId(String pipelineId);

        /**
         * <p>
         * A list of parameter values to pass to the pipeline at activation.
         * </p>
         * 
         * @param parameterValues
         *        A list of parameter values to pass to the pipeline at activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValues(Collection<ParameterValue> parameterValues);

        /**
         * <p>
         * A list of parameter values to pass to the pipeline at activation.
         * </p>
         * 
         * @param parameterValues
         *        A list of parameter values to pass to the pipeline at activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValues(ParameterValue... parameterValues);

        /**
         * <p>
         * A list of parameter values to pass to the pipeline at activation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datapipeline.model.ParameterValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datapipeline.model.ParameterValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datapipeline.model.ParameterValue.Builder#build()} is called
         * immediately and its result is passed to {@link #parameterValues(List<ParameterValue>)}.
         * 
         * @param parameterValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datapipeline.model.ParameterValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterValues(java.util.Collection<ParameterValue>)
         */
        Builder parameterValues(Consumer<ParameterValue.Builder>... parameterValues);

        /**
         * <p>
         * The date and time to resume the pipeline. By default, the pipeline resumes from the last completed execution.
         * </p>
         * 
         * @param startTimestamp
         *        The date and time to resume the pipeline. By default, the pipeline resumes from the last completed
         *        execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataPipelineRequest.BuilderImpl implements Builder {
        private String pipelineId;

        private List<ParameterValue> parameterValues = DefaultSdkAutoConstructList.getInstance();

        private Instant startTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivatePipelineRequest model) {
            super(model);
            pipelineId(model.pipelineId);
            parameterValues(model.parameterValues);
            startTimestamp(model.startTimestamp);
        }

        public final String getPipelineId() {
            return pipelineId;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final List<ParameterValue.Builder> getParameterValues() {
            List<ParameterValue.Builder> result = ParameterValueListCopier.copyToBuilder(this.parameterValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterValues(Collection<ParameterValue.BuilderImpl> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copyFromBuilder(parameterValues);
        }

        @Override
        public final Builder parameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(ParameterValue... parameterValues) {
            parameterValues(Arrays.asList(parameterValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(Consumer<ParameterValue.Builder>... parameterValues) {
            parameterValues(Stream.of(parameterValues).map(c -> ParameterValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ActivatePipelineRequest build() {
            return new ActivatePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
