/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMetadataModelExportAsScriptRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<StartMetadataModelExportAsScriptRequest.Builder, StartMetadataModelExportAsScriptRequest> {
    private static final SdkField<String> MIGRATION_PROJECT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MigrationProjectIdentifier")
            .getter(getter(StartMetadataModelExportAsScriptRequest::migrationProjectIdentifier))
            .setter(setter(Builder::migrationProjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectIdentifier").build())
            .build();

    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectionRules").getter(getter(StartMetadataModelExportAsScriptRequest::selectionRules))
            .setter(setter(Builder::selectionRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()).build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Origin")
            .getter(getter(StartMetadataModelExportAsScriptRequest::originAsString)).setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()).build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileName").getter(getter(StartMetadataModelExportAsScriptRequest::fileName))
            .setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MIGRATION_PROJECT_IDENTIFIER_FIELD, SELECTION_RULES_FIELD, ORIGIN_FIELD, FILE_NAME_FIELD));

    private final String migrationProjectIdentifier;

    private final String selectionRules;

    private final String origin;

    private final String fileName;

    private StartMetadataModelExportAsScriptRequest(BuilderImpl builder) {
        super(builder);
        this.migrationProjectIdentifier = builder.migrationProjectIdentifier;
        this.selectionRules = builder.selectionRules;
        this.origin = builder.origin;
        this.fileName = builder.fileName;
    }

    /**
     * <p>
     * The migration project name or Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The migration project name or Amazon Resource Name (ARN).
     */
    public final String migrationProjectIdentifier() {
        return migrationProjectIdentifier;
    }

    /**
     * <p>
     * A value that specifies the database objects to export.
     * </p>
     * 
     * @return A value that specifies the database objects to export.
     */
    public final String selectionRules() {
        return selectionRules;
    }

    /**
     * <p>
     * Whether to export the metadata model from the source or the target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link OriginTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return Whether to export the metadata model from the source or the target.
     * @see OriginTypeValue
     */
    public final OriginTypeValue origin() {
        return OriginTypeValue.fromValue(origin);
    }

    /**
     * <p>
     * Whether to export the metadata model from the source or the target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link OriginTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return Whether to export the metadata model from the source or the target.
     * @see OriginTypeValue
     */
    public final String originAsString() {
        return origin;
    }

    /**
     * <p>
     * The name of the model file to create in the Amazon S3 bucket.
     * </p>
     * 
     * @return The name of the model file to create in the Amazon S3 bucket.
     */
    public final String fileName() {
        return fileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(migrationProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(selectionRules());
        hashCode = 31 * hashCode + Objects.hashCode(originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMetadataModelExportAsScriptRequest)) {
            return false;
        }
        StartMetadataModelExportAsScriptRequest other = (StartMetadataModelExportAsScriptRequest) obj;
        return Objects.equals(migrationProjectIdentifier(), other.migrationProjectIdentifier())
                && Objects.equals(selectionRules(), other.selectionRules())
                && Objects.equals(originAsString(), other.originAsString()) && Objects.equals(fileName(), other.fileName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMetadataModelExportAsScriptRequest")
                .add("MigrationProjectIdentifier", migrationProjectIdentifier()).add("SelectionRules", selectionRules())
                .add("Origin", originAsString()).add("FileName", fileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MigrationProjectIdentifier":
            return Optional.ofNullable(clazz.cast(migrationProjectIdentifier()));
        case "SelectionRules":
            return Optional.ofNullable(clazz.cast(selectionRules()));
        case "Origin":
            return Optional.ofNullable(clazz.cast(originAsString()));
        case "FileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMetadataModelExportAsScriptRequest, T> g) {
        return obj -> g.apply((StartMetadataModelExportAsScriptRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMetadataModelExportAsScriptRequest> {
        /**
         * <p>
         * The migration project name or Amazon Resource Name (ARN).
         * </p>
         * 
         * @param migrationProjectIdentifier
         *        The migration project name or Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationProjectIdentifier(String migrationProjectIdentifier);

        /**
         * <p>
         * A value that specifies the database objects to export.
         * </p>
         * 
         * @param selectionRules
         *        A value that specifies the database objects to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionRules(String selectionRules);

        /**
         * <p>
         * Whether to export the metadata model from the source or the target.
         * </p>
         * 
         * @param origin
         *        Whether to export the metadata model from the source or the target.
         * @see OriginTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginTypeValue
         */
        Builder origin(String origin);

        /**
         * <p>
         * Whether to export the metadata model from the source or the target.
         * </p>
         * 
         * @param origin
         *        Whether to export the metadata model from the source or the target.
         * @see OriginTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginTypeValue
         */
        Builder origin(OriginTypeValue origin);

        /**
         * <p>
         * The name of the model file to create in the Amazon S3 bucket.
         * </p>
         * 
         * @param fileName
         *        The name of the model file to create in the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String migrationProjectIdentifier;

        private String selectionRules;

        private String origin;

        private String fileName;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMetadataModelExportAsScriptRequest model) {
            super(model);
            migrationProjectIdentifier(model.migrationProjectIdentifier);
            selectionRules(model.selectionRules);
            origin(model.origin);
            fileName(model.fileName);
        }

        public final String getMigrationProjectIdentifier() {
            return migrationProjectIdentifier;
        }

        public final void setMigrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
        }

        @Override
        public final Builder migrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        public final String getSelectionRules() {
            return selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        public final String getOrigin() {
            return origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OriginTypeValue origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMetadataModelExportAsScriptRequest build() {
            return new StartMetadataModelExportAsScriptRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
