/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMigrationProjectResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<CreateMigrationProjectResponse.Builder, CreateMigrationProjectResponse> {
    private static final SdkField<MigrationProject> MIGRATION_PROJECT_FIELD = SdkField
            .<MigrationProject> builder(MarshallingType.SDK_POJO).memberName("MigrationProject")
            .getter(getter(CreateMigrationProjectResponse::migrationProject)).setter(setter(Builder::migrationProject))
            .constructor(MigrationProject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_PROJECT_FIELD));

    private final MigrationProject migrationProject;

    private CreateMigrationProjectResponse(BuilderImpl builder) {
        super(builder);
        this.migrationProject = builder.migrationProject;
    }

    /**
     * <p>
     * The migration project that was created.
     * </p>
     * 
     * @return The migration project that was created.
     */
    public final MigrationProject migrationProject() {
        return migrationProject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(migrationProject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMigrationProjectResponse)) {
            return false;
        }
        CreateMigrationProjectResponse other = (CreateMigrationProjectResponse) obj;
        return Objects.equals(migrationProject(), other.migrationProject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMigrationProjectResponse").add("MigrationProject", migrationProject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MigrationProject":
            return Optional.ofNullable(clazz.cast(migrationProject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMigrationProjectResponse, T> g) {
        return obj -> g.apply((CreateMigrationProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMigrationProjectResponse> {
        /**
         * <p>
         * The migration project that was created.
         * </p>
         * 
         * @param migrationProject
         *        The migration project that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationProject(MigrationProject migrationProject);

        /**
         * <p>
         * The migration project that was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link MigrationProject.Builder} avoiding the
         * need to create one manually via {@link MigrationProject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MigrationProject.Builder#build()} is called immediately and its
         * result is passed to {@link #migrationProject(MigrationProject)}.
         * 
         * @param migrationProject
         *        a consumer that will call methods on {@link MigrationProject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #migrationProject(MigrationProject)
         */
        default Builder migrationProject(Consumer<MigrationProject.Builder> migrationProject) {
            return migrationProject(MigrationProject.builder().applyMutation(migrationProject).build());
        }
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private MigrationProject migrationProject;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMigrationProjectResponse model) {
            super(model);
            migrationProject(model.migrationProject);
        }

        public final MigrationProject.Builder getMigrationProject() {
            return migrationProject != null ? migrationProject.toBuilder() : null;
        }

        public final void setMigrationProject(MigrationProject.BuilderImpl migrationProject) {
            this.migrationProject = migrationProject != null ? migrationProject.build() : null;
        }

        @Override
        public final Builder migrationProject(MigrationProject migrationProject) {
            this.migrationProject = migrationProject;
            return this;
        }

        @Override
        public CreateMigrationProjectResponse build() {
            return new CreateMigrationProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
