/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time period for an anomaly.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyDateInterval implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalyDateInterval.Builder, AnomalyDateInterval> {
    private static final SdkField<String> START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartDate").getter(getter(AnomalyDateInterval::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<String> END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndDate").getter(getter(AnomalyDateInterval::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_DATE_FIELD,
            END_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String startDate;

    private final String endDate;

    private AnomalyDateInterval(BuilderImpl builder) {
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
    }

    /**
     * <p>
     * The first date an anomaly was observed.
     * </p>
     * 
     * @return The first date an anomaly was observed.
     */
    public final String startDate() {
        return startDate;
    }

    /**
     * <p>
     * The last date an anomaly was observed.
     * </p>
     * 
     * @return The last date an anomaly was observed.
     */
    public final String endDate() {
        return endDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDateInterval)) {
            return false;
        }
        AnomalyDateInterval other = (AnomalyDateInterval) obj;
        return Objects.equals(startDate(), other.startDate()) && Objects.equals(endDate(), other.endDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyDateInterval").add("StartDate", startDate()).add("EndDate", endDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyDateInterval, T> g) {
        return obj -> g.apply((AnomalyDateInterval) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyDateInterval> {
        /**
         * <p>
         * The first date an anomaly was observed.
         * </p>
         * 
         * @param startDate
         *        The first date an anomaly was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(String startDate);

        /**
         * <p>
         * The last date an anomaly was observed.
         * </p>
         * 
         * @param endDate
         *        The last date an anomaly was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(String endDate);
    }

    static final class BuilderImpl implements Builder {
        private String startDate;

        private String endDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyDateInterval model) {
            startDate(model.startDate);
            endDate(model.endDate);
        }

        public final String getStartDate() {
            return startDate;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getEndDate() {
            return endDate;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        @Override
        public AnomalyDateInterval build() {
            return new AnomalyDateInterval(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
