/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.costexplorer.model.BillExpirationException;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerException;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.DataUnavailableException;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.GenerationExistsException;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostForecastRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostForecastResponse;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlanPurchaseRecommendationDetailsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlanPurchaseRecommendationDetailsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetTagsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetTagsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetUsageForecastRequest;
import software.amazon.awssdk.services.costexplorer.model.GetUsageForecastResponse;
import software.amazon.awssdk.services.costexplorer.model.InvalidNextTokenException;
import software.amazon.awssdk.services.costexplorer.model.LimitExceededException;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsResponse;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse;
import software.amazon.awssdk.services.costexplorer.model.ListSavingsPlansPurchaseRecommendationGenerationRequest;
import software.amazon.awssdk.services.costexplorer.model.ListSavingsPlansPurchaseRecommendationGenerationResponse;
import software.amazon.awssdk.services.costexplorer.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.costexplorer.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest;
import software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse;
import software.amazon.awssdk.services.costexplorer.model.RequestChangedException;
import software.amazon.awssdk.services.costexplorer.model.ResourceNotFoundException;
import software.amazon.awssdk.services.costexplorer.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.costexplorer.model.StartSavingsPlansPurchaseRecommendationGenerationRequest;
import software.amazon.awssdk.services.costexplorer.model.StartSavingsPlansPurchaseRecommendationGenerationResponse;
import software.amazon.awssdk.services.costexplorer.model.TagResourceRequest;
import software.amazon.awssdk.services.costexplorer.model.TagResourceResponse;
import software.amazon.awssdk.services.costexplorer.model.TooManyTagsException;
import software.amazon.awssdk.services.costexplorer.model.UnknownMonitorException;
import software.amazon.awssdk.services.costexplorer.model.UnknownSubscriptionException;
import software.amazon.awssdk.services.costexplorer.model.UnresolvableUsageUnitException;
import software.amazon.awssdk.services.costexplorer.model.UntagResourceRequest;
import software.amazon.awssdk.services.costexplorer.model.UntagResourceResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostAllocationTagsStatusRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostAllocationTagsStatusResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoverageIterable;
import software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsIterable;
import software.amazon.awssdk.services.costexplorer.paginators.ListCostAllocationTagsIterable;
import software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsIterable;

/**
 * Service client for accessing AWS Cost Explorer. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * You can use the Cost Explorer API to programmatically query your cost and usage data. You can query for aggregated
 * data such as total monthly costs or total daily usage. You can also query for granular data. This might include the
 * number of daily write operations for Amazon DynamoDB database tables in your production environment.
 * </p>
 * <p>
 * Service Endpoint
 * </p>
 * <p>
 * The Cost Explorer API provides the following endpoint:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>https://ce.us-east-1.amazonaws.com</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * For information about the costs that are associated with the Cost Explorer API, see <a
 * href="http://aws.amazon.com/aws-cost-management/pricing/">Amazon Web Services Cost Management Pricing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CostExplorerClient extends AwsClient {
    String SERVICE_NAME = "ce";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ce";

    /**
     * <p>
     * Creates a new cost anomaly detection monitor with the requested type and monitor specification.
     * </p>
     *
     * @param createAnomalyMonitorRequest
     * @return Result of the CreateAnomalyMonitor operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.CreateAnomalyMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalyMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAnomalyMonitorResponse createAnomalyMonitor(CreateAnomalyMonitorRequest createAnomalyMonitorRequest)
            throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new cost anomaly detection monitor with the requested type and monitor specification.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAnomalyMonitorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAnomalyMonitorRequest#builder()}
     * </p>
     *
     * @param createAnomalyMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAnomalyMonitor operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.CreateAnomalyMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalyMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAnomalyMonitorResponse createAnomalyMonitor(
            Consumer<CreateAnomalyMonitorRequest.Builder> createAnomalyMonitorRequest) throws LimitExceededException,
            AwsServiceException, SdkClientException, CostExplorerException {
        return createAnomalyMonitor(CreateAnomalyMonitorRequest.builder().applyMutation(createAnomalyMonitorRequest).build());
    }

    /**
     * <p>
     * Adds an alert subscription to a cost anomaly detection monitor. You can use each subscription to define
     * subscribers with email or SNS notifications. Email subscribers can set an absolute or percentage threshold and a
     * time frequency for receiving notifications.
     * </p>
     *
     * @param createAnomalySubscriptionRequest
     * @return Result of the CreateAnomalySubscription operation returned by the service.
     * @throws UnknownMonitorException
     *         The cost anomaly monitor does not exist for the account.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.CreateAnomalySubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalySubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAnomalySubscriptionResponse createAnomalySubscription(
            CreateAnomalySubscriptionRequest createAnomalySubscriptionRequest) throws UnknownMonitorException,
            LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an alert subscription to a cost anomaly detection monitor. You can use each subscription to define
     * subscribers with email or SNS notifications. Email subscribers can set an absolute or percentage threshold and a
     * time frequency for receiving notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAnomalySubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAnomalySubscriptionRequest#builder()}
     * </p>
     *
     * @param createAnomalySubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateAnomalySubscription operation returned by the service.
     * @throws UnknownMonitorException
     *         The cost anomaly monitor does not exist for the account.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.CreateAnomalySubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateAnomalySubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAnomalySubscriptionResponse createAnomalySubscription(
            Consumer<CreateAnomalySubscriptionRequest.Builder> createAnomalySubscriptionRequest) throws UnknownMonitorException,
            LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        return createAnomalySubscription(CreateAnomalySubscriptionRequest.builder()
                .applyMutation(createAnomalySubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a new Cost Category with the requested name and rules.
     * </p>
     *
     * @param createCostCategoryDefinitionRequest
     * @return Result of the CreateCostCategoryDefinition operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You've reached the limit on the number of resources you can create, or exceeded the size of an individual
     *         resource.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.CreateCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCostCategoryDefinitionResponse createCostCategoryDefinition(
            CreateCostCategoryDefinitionRequest createCostCategoryDefinitionRequest) throws ServiceQuotaExceededException,
            LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Cost Category with the requested name and rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCostCategoryDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCostCategoryDefinitionRequest#builder()}
     * </p>
     *
     * @param createCostCategoryDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateCostCategoryDefinition operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You've reached the limit on the number of resources you can create, or exceeded the size of an individual
     *         resource.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.CreateCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/CreateCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCostCategoryDefinitionResponse createCostCategoryDefinition(
            Consumer<CreateCostCategoryDefinitionRequest.Builder> createCostCategoryDefinitionRequest)
            throws ServiceQuotaExceededException, LimitExceededException, AwsServiceException, SdkClientException,
            CostExplorerException {
        return createCostCategoryDefinition(CreateCostCategoryDefinitionRequest.builder()
                .applyMutation(createCostCategoryDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a cost anomaly monitor.
     * </p>
     *
     * @param deleteAnomalyMonitorRequest
     * @return Result of the DeleteAnomalyMonitor operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws UnknownMonitorException
     *         The cost anomaly monitor does not exist for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.DeleteAnomalyMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalyMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAnomalyMonitorResponse deleteAnomalyMonitor(DeleteAnomalyMonitorRequest deleteAnomalyMonitorRequest)
            throws LimitExceededException, UnknownMonitorException, AwsServiceException, SdkClientException,
            CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a cost anomaly monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnomalyMonitorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAnomalyMonitorRequest#builder()}
     * </p>
     *
     * @param deleteAnomalyMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAnomalyMonitor operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws UnknownMonitorException
     *         The cost anomaly monitor does not exist for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.DeleteAnomalyMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalyMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAnomalyMonitorResponse deleteAnomalyMonitor(
            Consumer<DeleteAnomalyMonitorRequest.Builder> deleteAnomalyMonitorRequest) throws LimitExceededException,
            UnknownMonitorException, AwsServiceException, SdkClientException, CostExplorerException {
        return deleteAnomalyMonitor(DeleteAnomalyMonitorRequest.builder().applyMutation(deleteAnomalyMonitorRequest).build());
    }

    /**
     * <p>
     * Deletes a cost anomaly subscription.
     * </p>
     *
     * @param deleteAnomalySubscriptionRequest
     * @return Result of the DeleteAnomalySubscription operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws UnknownSubscriptionException
     *         The cost anomaly subscription does not exist for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.DeleteAnomalySubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalySubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAnomalySubscriptionResponse deleteAnomalySubscription(
            DeleteAnomalySubscriptionRequest deleteAnomalySubscriptionRequest) throws LimitExceededException,
            UnknownSubscriptionException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a cost anomaly subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnomalySubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAnomalySubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteAnomalySubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAnomalySubscription operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws UnknownSubscriptionException
     *         The cost anomaly subscription does not exist for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.DeleteAnomalySubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteAnomalySubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAnomalySubscriptionResponse deleteAnomalySubscription(
            Consumer<DeleteAnomalySubscriptionRequest.Builder> deleteAnomalySubscriptionRequest) throws LimitExceededException,
            UnknownSubscriptionException, AwsServiceException, SdkClientException, CostExplorerException {
        return deleteAnomalySubscription(DeleteAnomalySubscriptionRequest.builder()
                .applyMutation(deleteAnomalySubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes a Cost Category. Expenses from this month going forward will no longer be categorized with this Cost
     * Category.
     * </p>
     *
     * @param deleteCostCategoryDefinitionRequest
     * @return Result of the DeleteCostCategoryDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.DeleteCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCostCategoryDefinitionResponse deleteCostCategoryDefinition(
            DeleteCostCategoryDefinitionRequest deleteCostCategoryDefinitionRequest) throws ResourceNotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Cost Category. Expenses from this month going forward will no longer be categorized with this Cost
     * Category.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCostCategoryDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCostCategoryDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteCostCategoryDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteCostCategoryDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.DeleteCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DeleteCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCostCategoryDefinitionResponse deleteCostCategoryDefinition(
            Consumer<DeleteCostCategoryDefinitionRequest.Builder> deleteCostCategoryDefinitionRequest)
            throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            CostExplorerException {
        return deleteCostCategoryDefinition(DeleteCostCategoryDefinitionRequest.builder()
                .applyMutation(deleteCostCategoryDefinitionRequest).build());
    }

    /**
     * <p>
     * Returns the name, Amazon Resource Name (ARN), rules, definition, and effective dates of a Cost Category that's
     * defined in the account.
     * </p>
     * <p>
     * You have the option to use <code>EffectiveOn</code> to return a Cost Category that's active on a specific date.
     * If there's no <code>EffectiveOn</code> specified, you see a Cost Category that's effective on the current date.
     * If Cost Category is still effective, <code>EffectiveEnd</code> is omitted in the response.
     * </p>
     *
     * @param describeCostCategoryDefinitionRequest
     * @return Result of the DescribeCostCategoryDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.DescribeCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DescribeCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCostCategoryDefinitionResponse describeCostCategoryDefinition(
            DescribeCostCategoryDefinitionRequest describeCostCategoryDefinitionRequest) throws ResourceNotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the name, Amazon Resource Name (ARN), rules, definition, and effective dates of a Cost Category that's
     * defined in the account.
     * </p>
     * <p>
     * You have the option to use <code>EffectiveOn</code> to return a Cost Category that's active on a specific date.
     * If there's no <code>EffectiveOn</code> specified, you see a Cost Category that's effective on the current date.
     * If Cost Category is still effective, <code>EffectiveEnd</code> is omitted in the response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCostCategoryDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCostCategoryDefinitionRequest#builder()}
     * </p>
     *
     * @param describeCostCategoryDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeCostCategoryDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.DescribeCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/DescribeCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCostCategoryDefinitionResponse describeCostCategoryDefinition(
            Consumer<DescribeCostCategoryDefinitionRequest.Builder> describeCostCategoryDefinitionRequest)
            throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            CostExplorerException {
        return describeCostCategoryDefinition(DescribeCostCategoryDefinitionRequest.builder()
                .applyMutation(describeCostCategoryDefinitionRequest).build());
    }

    /**
     * <p>
     * Retrieves all of the cost anomalies detected on your account during the time period that's specified by the
     * <code>DateInterval</code> object. Anomalies are available for up to 90 days.
     * </p>
     *
     * @param getAnomaliesRequest
     * @return Result of the GetAnomalies operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetAnomalies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAnomaliesResponse getAnomalies(GetAnomaliesRequest getAnomaliesRequest) throws LimitExceededException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all of the cost anomalies detected on your account during the time period that's specified by the
     * <code>DateInterval</code> object. Anomalies are available for up to 90 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnomaliesRequest.Builder} avoiding the need to
     * create one manually via {@link GetAnomaliesRequest#builder()}
     * </p>
     *
     * @param getAnomaliesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest.Builder} to create a
     *        request.
     * @return Result of the GetAnomalies operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetAnomalies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAnomaliesResponse getAnomalies(Consumer<GetAnomaliesRequest.Builder> getAnomaliesRequest)
            throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            CostExplorerException {
        return getAnomalies(GetAnomaliesRequest.builder().applyMutation(getAnomaliesRequest).build());
    }

    /**
     * <p>
     * Retrieves the cost anomaly monitor definitions for your account. You can filter using a list of cost anomaly
     * monitor Amazon Resource Names (ARNs).
     * </p>
     *
     * @param getAnomalyMonitorsRequest
     * @return Result of the GetAnomalyMonitors operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws UnknownMonitorException
     *         The cost anomaly monitor does not exist for the account.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetAnomalyMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalyMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAnomalyMonitorsResponse getAnomalyMonitors(GetAnomalyMonitorsRequest getAnomalyMonitorsRequest)
            throws LimitExceededException, UnknownMonitorException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the cost anomaly monitor definitions for your account. You can filter using a list of cost anomaly
     * monitor Amazon Resource Names (ARNs).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnomalyMonitorsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAnomalyMonitorsRequest#builder()}
     * </p>
     *
     * @param getAnomalyMonitorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest.Builder} to create a
     *        request.
     * @return Result of the GetAnomalyMonitors operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws UnknownMonitorException
     *         The cost anomaly monitor does not exist for the account.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetAnomalyMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalyMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAnomalyMonitorsResponse getAnomalyMonitors(Consumer<GetAnomalyMonitorsRequest.Builder> getAnomalyMonitorsRequest)
            throws LimitExceededException, UnknownMonitorException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, CostExplorerException {
        return getAnomalyMonitors(GetAnomalyMonitorsRequest.builder().applyMutation(getAnomalyMonitorsRequest).build());
    }

    /**
     * <p>
     * Retrieves the cost anomaly subscription objects for your account. You can filter using a list of cost anomaly
     * monitor Amazon Resource Names (ARNs).
     * </p>
     *
     * @param getAnomalySubscriptionsRequest
     * @return Result of the GetAnomalySubscriptions operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws UnknownSubscriptionException
     *         The cost anomaly subscription does not exist for the account.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetAnomalySubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalySubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAnomalySubscriptionsResponse getAnomalySubscriptions(GetAnomalySubscriptionsRequest getAnomalySubscriptionsRequest)
            throws LimitExceededException, UnknownSubscriptionException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the cost anomaly subscription objects for your account. You can filter using a list of cost anomaly
     * monitor Amazon Resource Names (ARNs).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnomalySubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetAnomalySubscriptionsRequest#builder()}
     * </p>
     *
     * @param getAnomalySubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest.Builder} to
     *        create a request.
     * @return Result of the GetAnomalySubscriptions operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws UnknownSubscriptionException
     *         The cost anomaly subscription does not exist for the account.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetAnomalySubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetAnomalySubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAnomalySubscriptionsResponse getAnomalySubscriptions(
            Consumer<GetAnomalySubscriptionsRequest.Builder> getAnomalySubscriptionsRequest) throws LimitExceededException,
            UnknownSubscriptionException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            CostExplorerException {
        return getAnomalySubscriptions(GetAnomalySubscriptionsRequest.builder().applyMutation(getAnomalySubscriptionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves cost and usage metrics for your account. You can specify which cost and usage-related metric that you
     * want the request to return. For example, you can specify <code>BlendedCosts</code> or <code>UsageQuantity</code>.
     * You can also filter and group your data by various dimensions, such as <code>SERVICE</code> or <code>AZ</code>,
     * in a specific time range. For a complete list of valid dimensions, see the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html"
     * >GetDimensionValues</a> operation. Management account in an organization in Organizations have access to all
     * member accounts.
     * </p>
     * <p>
     * For information about filter limitations, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-limits.html">Quotas and
     * restrictions</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param getCostAndUsageRequest
     * @return Result of the GetCostAndUsage operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws BillExpirationException
     *         The requested report expired. Update the date interval and try again.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws RequestChangedException
     *         Your request parameters changed between pages. Try again with the old parameters or without a pagination
     *         token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetCostAndUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCostAndUsageResponse getCostAndUsage(GetCostAndUsageRequest getCostAndUsageRequest) throws LimitExceededException,
            BillExpirationException, DataUnavailableException, InvalidNextTokenException, RequestChangedException,
            AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves cost and usage metrics for your account. You can specify which cost and usage-related metric that you
     * want the request to return. For example, you can specify <code>BlendedCosts</code> or <code>UsageQuantity</code>.
     * You can also filter and group your data by various dimensions, such as <code>SERVICE</code> or <code>AZ</code>,
     * in a specific time range. For a complete list of valid dimensions, see the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html"
     * >GetDimensionValues</a> operation. Management account in an organization in Organizations have access to all
     * member accounts.
     * </p>
     * <p>
     * For information about filter limitations, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-limits.html">Quotas and
     * restrictions</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCostAndUsageRequest.Builder} avoiding the need
     * to create one manually via {@link GetCostAndUsageRequest#builder()}
     * </p>
     *
     * @param getCostAndUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest.Builder} to create a
     *        request.
     * @return Result of the GetCostAndUsage operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws BillExpirationException
     *         The requested report expired. Update the date interval and try again.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws RequestChangedException
     *         Your request parameters changed between pages. Try again with the old parameters or without a pagination
     *         token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetCostAndUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCostAndUsageResponse getCostAndUsage(Consumer<GetCostAndUsageRequest.Builder> getCostAndUsageRequest)
            throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException,
            RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        return getCostAndUsage(GetCostAndUsageRequest.builder().applyMutation(getCostAndUsageRequest).build());
    }

    /**
     * <p>
     * Retrieves cost and usage metrics with resources for your account. You can specify which cost and usage-related
     * metric, such as <code>BlendedCosts</code> or <code>UsageQuantity</code>, that you want the request to return. You
     * can also filter and group your data by various dimensions, such as <code>SERVICE</code> or <code>AZ</code>, in a
     * specific time range. For a complete list of valid dimensions, see the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html"
     * >GetDimensionValues</a> operation. Management account in an organization in Organizations have access to all
     * member accounts. This API is currently available for the Amazon Elastic Compute Cloud – Compute service only.
     * </p>
     * <note>
     * <p>
     * This is an opt-in only feature. You can enable this feature from the Cost Explorer Settings page. For information
     * about how to access the Settings page, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-access.html">Controlling Access for Cost
     * Explorer</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * </note>
     *
     * @param getCostAndUsageWithResourcesRequest
     * @return Result of the GetCostAndUsageWithResources operation returned by the service.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws BillExpirationException
     *         The requested report expired. Update the date interval and try again.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws RequestChangedException
     *         Your request parameters changed between pages. Try again with the old parameters or without a pagination
     *         token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetCostAndUsageWithResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsageWithResources"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCostAndUsageWithResourcesResponse getCostAndUsageWithResources(
            GetCostAndUsageWithResourcesRequest getCostAndUsageWithResourcesRequest) throws DataUnavailableException,
            LimitExceededException, BillExpirationException, InvalidNextTokenException, RequestChangedException,
            AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves cost and usage metrics with resources for your account. You can specify which cost and usage-related
     * metric, such as <code>BlendedCosts</code> or <code>UsageQuantity</code>, that you want the request to return. You
     * can also filter and group your data by various dimensions, such as <code>SERVICE</code> or <code>AZ</code>, in a
     * specific time range. For a complete list of valid dimensions, see the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html"
     * >GetDimensionValues</a> operation. Management account in an organization in Organizations have access to all
     * member accounts. This API is currently available for the Amazon Elastic Compute Cloud – Compute service only.
     * </p>
     * <note>
     * <p>
     * This is an opt-in only feature. You can enable this feature from the Cost Explorer Settings page. For information
     * about how to access the Settings page, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-access.html">Controlling Access for Cost
     * Explorer</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCostAndUsageWithResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link GetCostAndUsageWithResourcesRequest#builder()}
     * </p>
     *
     * @param getCostAndUsageWithResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest.Builder} to
     *        create a request.
     * @return Result of the GetCostAndUsageWithResources operation returned by the service.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws BillExpirationException
     *         The requested report expired. Update the date interval and try again.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws RequestChangedException
     *         Your request parameters changed between pages. Try again with the old parameters or without a pagination
     *         token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetCostAndUsageWithResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsageWithResources"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCostAndUsageWithResourcesResponse getCostAndUsageWithResources(
            Consumer<GetCostAndUsageWithResourcesRequest.Builder> getCostAndUsageWithResourcesRequest)
            throws DataUnavailableException, LimitExceededException, BillExpirationException, InvalidNextTokenException,
            RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        return getCostAndUsageWithResources(GetCostAndUsageWithResourcesRequest.builder()
                .applyMutation(getCostAndUsageWithResourcesRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of Cost Category names and values incurred cost.
     * </p>
     * <note>
     * <p>
     * If some Cost Category names and values are not associated with any cost, they will not be returned by this API.
     * </p>
     * </note>
     *
     * @param getCostCategoriesRequest
     * @return Result of the GetCostCategories operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws BillExpirationException
     *         The requested report expired. Update the date interval and try again.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws RequestChangedException
     *         Your request parameters changed between pages. Try again with the old parameters or without a pagination
     *         token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetCostCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostCategories" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCostCategoriesResponse getCostCategories(GetCostCategoriesRequest getCostCategoriesRequest)
            throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException,
            RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of Cost Category names and values incurred cost.
     * </p>
     * <note>
     * <p>
     * If some Cost Category names and values are not associated with any cost, they will not be returned by this API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCostCategoriesRequest.Builder} avoiding the need
     * to create one manually via {@link GetCostCategoriesRequest#builder()}
     * </p>
     *
     * @param getCostCategoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesRequest.Builder} to create a
     *        request.
     * @return Result of the GetCostCategories operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws BillExpirationException
     *         The requested report expired. Update the date interval and try again.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws RequestChangedException
     *         Your request parameters changed between pages. Try again with the old parameters or without a pagination
     *         token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetCostCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostCategories" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCostCategoriesResponse getCostCategories(Consumer<GetCostCategoriesRequest.Builder> getCostCategoriesRequest)
            throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException,
            RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        return getCostCategories(GetCostCategoriesRequest.builder().applyMutation(getCostCategoriesRequest).build());
    }

    /**
     * <p>
     * Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period
     * that you select, based on your past costs.
     * </p>
     *
     * @param getCostForecastRequest
     * @return Result of the GetCostForecast operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetCostForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCostForecastResponse getCostForecast(GetCostForecastRequest getCostForecastRequest) throws LimitExceededException,
            DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period
     * that you select, based on your past costs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCostForecastRequest.Builder} avoiding the need
     * to create one manually via {@link GetCostForecastRequest#builder()}
     * </p>
     *
     * @param getCostForecastRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetCostForecastRequest.Builder} to create a
     *        request.
     * @return Result of the GetCostForecast operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetCostForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCostForecastResponse getCostForecast(Consumer<GetCostForecastRequest.Builder> getCostForecastRequest)
            throws LimitExceededException, DataUnavailableException, AwsServiceException, SdkClientException,
            CostExplorerException {
        return getCostForecast(GetCostForecastRequest.builder().applyMutation(getCostForecastRequest).build());
    }

    /**
     * <p>
     * Retrieves all available filter values for a specified filter over a period of time. You can search the dimension
     * values for an arbitrary string.
     * </p>
     *
     * @param getDimensionValuesRequest
     * @return Result of the GetDimensionValues operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws BillExpirationException
     *         The requested report expired. Update the date interval and try again.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws RequestChangedException
     *         Your request parameters changed between pages. Try again with the old parameters or without a pagination
     *         token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetDimensionValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetDimensionValues" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDimensionValuesResponse getDimensionValues(GetDimensionValuesRequest getDimensionValuesRequest)
            throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException,
            RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all available filter values for a specified filter over a period of time. You can search the dimension
     * values for an arbitrary string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDimensionValuesRequest.Builder} avoiding the
     * need to create one manually via {@link GetDimensionValuesRequest#builder()}
     * </p>
     *
     * @param getDimensionValuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest.Builder} to create a
     *        request.
     * @return Result of the GetDimensionValues operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws BillExpirationException
     *         The requested report expired. Update the date interval and try again.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws RequestChangedException
     *         Your request parameters changed between pages. Try again with the old parameters or without a pagination
     *         token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetDimensionValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetDimensionValues" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDimensionValuesResponse getDimensionValues(Consumer<GetDimensionValuesRequest.Builder> getDimensionValuesRequest)
            throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException,
            RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        return getDimensionValues(GetDimensionValuesRequest.builder().applyMutation(getDimensionValuesRequest).build());
    }

    /**
     * <p>
     * Retrieves the reservation coverage for your account, which you can use to see how much of your Amazon Elastic
     * Compute Cloud, Amazon ElastiCache, Amazon Relational Database Service, or Amazon Redshift usage is covered by a
     * reservation. An organization's management account can see the coverage of the associated member accounts. This
     * supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data about
     * reservation usage by the following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_ENGINE
     * </p>
     * </li>
     * <li>
     * <p>
     * DATABASE_ENGINE
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_OPTION
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATING_SYSTEM
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE
     * </p>
     * </li>
     * <li>
     * <p>
     * TAG
     * </p>
     * </li>
     * <li>
     * <p>
     * TENANCY
     * </p>
     * </li>
     * </ul>
     * <p>
     * To determine valid values for a dimension, use the <code>GetDimensionValues</code> operation.
     * </p>
     *
     * @param getReservationCoverageRequest
     *        You can use the following request parameters to query for how much of your instance usage a reservation
     *        covered.
     * @return Result of the GetReservationCoverage operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetReservationCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetReservationCoverageResponse getReservationCoverage(GetReservationCoverageRequest getReservationCoverageRequest)
            throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the reservation coverage for your account, which you can use to see how much of your Amazon Elastic
     * Compute Cloud, Amazon ElastiCache, Amazon Relational Database Service, or Amazon Redshift usage is covered by a
     * reservation. An organization's management account can see the coverage of the associated member accounts. This
     * supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data about
     * reservation usage by the following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_ENGINE
     * </p>
     * </li>
     * <li>
     * <p>
     * DATABASE_ENGINE
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_OPTION
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATING_SYSTEM
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE
     * </p>
     * </li>
     * <li>
     * <p>
     * TAG
     * </p>
     * </li>
     * <li>
     * <p>
     * TENANCY
     * </p>
     * </li>
     * </ul>
     * <p>
     * To determine valid values for a dimension, use the <code>GetDimensionValues</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReservationCoverageRequest.Builder} avoiding the
     * need to create one manually via {@link GetReservationCoverageRequest#builder()}
     * </p>
     *
     * @param getReservationCoverageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest.Builder} to create
     *        a request. You can use the following request parameters to query for how much of your instance usage a
     *        reservation covered.
     * @return Result of the GetReservationCoverage operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetReservationCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetReservationCoverageResponse getReservationCoverage(
            Consumer<GetReservationCoverageRequest.Builder> getReservationCoverageRequest) throws LimitExceededException,
            DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        return getReservationCoverage(GetReservationCoverageRequest.builder().applyMutation(getReservationCoverageRequest)
                .build());
    }

    /**
     * <p>
     * Gets recommendations for reservation purchases. These recommendations might help you to reduce your costs.
     * Reservations provide a discounted hourly rate (up to 75%) compared to On-Demand pricing.
     * </p>
     * <p>
     * Amazon Web Services generates your recommendations by identifying your On-Demand usage during a specific time
     * period and collecting your usage into categories that are eligible for a reservation. After Amazon Web Services
     * has these categories, it simulates every combination of reservations in each category of usage to identify the
     * best number of each type of Reserved Instance (RI) to purchase to maximize your estimated savings.
     * </p>
     * <p>
     * For example, Amazon Web Services automatically aggregates your Amazon EC2 Linux, shared tenancy, and c4 family
     * usage in the US West (Oregon) Region and recommends that you buy size-flexible regional reservations to apply to
     * the c4 family usage. Amazon Web Services recommends the smallest size instance in an instance family. This makes
     * it easier to purchase a size-flexible Reserved Instance (RI). Amazon Web Services also shows the equal number of
     * normalized units. This way, you can purchase any instance size that you want. For this example, your RI
     * recommendation is for <code>c4.large</code> because that is the smallest size instance in the c4 instance family.
     * </p>
     *
     * @param getReservationPurchaseRecommendationRequest
     * @return Result of the GetReservationPurchaseRecommendation operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetReservationPurchaseRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationPurchaseRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReservationPurchaseRecommendationResponse getReservationPurchaseRecommendation(
            GetReservationPurchaseRecommendationRequest getReservationPurchaseRecommendationRequest)
            throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets recommendations for reservation purchases. These recommendations might help you to reduce your costs.
     * Reservations provide a discounted hourly rate (up to 75%) compared to On-Demand pricing.
     * </p>
     * <p>
     * Amazon Web Services generates your recommendations by identifying your On-Demand usage during a specific time
     * period and collecting your usage into categories that are eligible for a reservation. After Amazon Web Services
     * has these categories, it simulates every combination of reservations in each category of usage to identify the
     * best number of each type of Reserved Instance (RI) to purchase to maximize your estimated savings.
     * </p>
     * <p>
     * For example, Amazon Web Services automatically aggregates your Amazon EC2 Linux, shared tenancy, and c4 family
     * usage in the US West (Oregon) Region and recommends that you buy size-flexible regional reservations to apply to
     * the c4 family usage. Amazon Web Services recommends the smallest size instance in an instance family. This makes
     * it easier to purchase a size-flexible Reserved Instance (RI). Amazon Web Services also shows the equal number of
     * normalized units. This way, you can purchase any instance size that you want. For this example, your RI
     * recommendation is for <code>c4.large</code> because that is the smallest size instance in the c4 instance family.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetReservationPurchaseRecommendationRequest.Builder} avoiding the need to create one manually via
     * {@link GetReservationPurchaseRecommendationRequest#builder()}
     * </p>
     *
     * @param getReservationPurchaseRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest.Builder}
     *        to create a request.
     * @return Result of the GetReservationPurchaseRecommendation operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetReservationPurchaseRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationPurchaseRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReservationPurchaseRecommendationResponse getReservationPurchaseRecommendation(
            Consumer<GetReservationPurchaseRecommendationRequest.Builder> getReservationPurchaseRecommendationRequest)
            throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, CostExplorerException {
        return getReservationPurchaseRecommendation(GetReservationPurchaseRecommendationRequest.builder()
                .applyMutation(getReservationPurchaseRecommendationRequest).build());
    }

    /**
     * <p>
     * Retrieves the reservation utilization for your account. Management account in an organization have access to
     * member accounts. You can filter data by dimensions in a time period. You can use <code>GetDimensionValues</code>
     * to determine the possible dimension values. Currently, you can group only by <code>SUBSCRIPTION_ID</code>.
     * </p>
     *
     * @param getReservationUtilizationRequest
     * @return Result of the GetReservationUtilization operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetReservationUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationUtilization" target="_top">AWS
     *      API Documentation</a>
     */
    default GetReservationUtilizationResponse getReservationUtilization(
            GetReservationUtilizationRequest getReservationUtilizationRequest) throws LimitExceededException,
            DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the reservation utilization for your account. Management account in an organization have access to
     * member accounts. You can filter data by dimensions in a time period. You can use <code>GetDimensionValues</code>
     * to determine the possible dimension values. Currently, you can group only by <code>SUBSCRIPTION_ID</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReservationUtilizationRequest.Builder} avoiding
     * the need to create one manually via {@link GetReservationUtilizationRequest#builder()}
     * </p>
     *
     * @param getReservationUtilizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest.Builder} to
     *        create a request.
     * @return Result of the GetReservationUtilization operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetReservationUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetReservationUtilization" target="_top">AWS
     *      API Documentation</a>
     */
    default GetReservationUtilizationResponse getReservationUtilization(
            Consumer<GetReservationUtilizationRequest.Builder> getReservationUtilizationRequest) throws LimitExceededException,
            DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        return getReservationUtilization(GetReservationUtilizationRequest.builder()
                .applyMutation(getReservationUtilizationRequest).build());
    }

    /**
     * <p>
     * Creates recommendations that help you save cost by identifying idle and underutilized Amazon EC2 instances.
     * </p>
     * <p>
     * Recommendations are generated to either downsize or terminate instances, along with providing savings detail and
     * metrics. For more information about calculation and function, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-rightsizing.html">Optimizing Your Cost with
     * Rightsizing Recommendations</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param getRightsizingRecommendationRequest
     * @return Result of the GetRightsizingRecommendation operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetRightsizingRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetRightsizingRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRightsizingRecommendationResponse getRightsizingRecommendation(
            GetRightsizingRecommendationRequest getRightsizingRecommendationRequest) throws LimitExceededException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates recommendations that help you save cost by identifying idle and underutilized Amazon EC2 instances.
     * </p>
     * <p>
     * Recommendations are generated to either downsize or terminate instances, along with providing savings detail and
     * metrics. For more information about calculation and function, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-rightsizing.html">Optimizing Your Cost with
     * Rightsizing Recommendations</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRightsizingRecommendationRequest.Builder}
     * avoiding the need to create one manually via {@link GetRightsizingRecommendationRequest#builder()}
     * </p>
     *
     * @param getRightsizingRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest.Builder} to
     *        create a request.
     * @return Result of the GetRightsizingRecommendation operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetRightsizingRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetRightsizingRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRightsizingRecommendationResponse getRightsizingRecommendation(
            Consumer<GetRightsizingRecommendationRequest.Builder> getRightsizingRecommendationRequest)
            throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            CostExplorerException {
        return getRightsizingRecommendation(GetRightsizingRecommendationRequest.builder()
                .applyMutation(getRightsizingRecommendationRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for a Savings Plan recommendation. These details include the hourly data-points that
     * construct the cost, coverage, and utilization charts.
     * </p>
     *
     * @param getSavingsPlanPurchaseRecommendationDetailsRequest
     * @return Result of the GetSavingsPlanPurchaseRecommendationDetails operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlanPurchaseRecommendationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlanPurchaseRecommendationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSavingsPlanPurchaseRecommendationDetailsResponse getSavingsPlanPurchaseRecommendationDetails(
            GetSavingsPlanPurchaseRecommendationDetailsRequest getSavingsPlanPurchaseRecommendationDetailsRequest)
            throws LimitExceededException, DataUnavailableException, AwsServiceException, SdkClientException,
            CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for a Savings Plan recommendation. These details include the hourly data-points that
     * construct the cost, coverage, and utilization charts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetSavingsPlanPurchaseRecommendationDetailsRequest.Builder} avoiding the need to create one manually via
     * {@link GetSavingsPlanPurchaseRecommendationDetailsRequest#builder()}
     * </p>
     *
     * @param getSavingsPlanPurchaseRecommendationDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetSavingsPlanPurchaseRecommendationDetailsRequest.Builder}
     *        to create a request.
     * @return Result of the GetSavingsPlanPurchaseRecommendationDetails operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlanPurchaseRecommendationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlanPurchaseRecommendationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSavingsPlanPurchaseRecommendationDetailsResponse getSavingsPlanPurchaseRecommendationDetails(
            Consumer<GetSavingsPlanPurchaseRecommendationDetailsRequest.Builder> getSavingsPlanPurchaseRecommendationDetailsRequest)
            throws LimitExceededException, DataUnavailableException, AwsServiceException, SdkClientException,
            CostExplorerException {
        return getSavingsPlanPurchaseRecommendationDetails(GetSavingsPlanPurchaseRecommendationDetailsRequest.builder()
                .applyMutation(getSavingsPlanPurchaseRecommendationDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves the Savings Plans covered for your account. This enables you to see how much of your cost is covered by
     * a Savings Plan. An organization’s management account can see the coverage of the associated member accounts. This
     * supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data for
     * Savings Plans usage with the following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINKED_ACCOUNT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_FAMILY</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To determine valid values for a dimension, use the <code>GetDimensionValues</code> operation.
     * </p>
     *
     * @param getSavingsPlansCoverageRequest
     * @return Result of the GetSavingsPlansCoverage operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlansCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansCoverage" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSavingsPlansCoverageResponse getSavingsPlansCoverage(GetSavingsPlansCoverageRequest getSavingsPlansCoverageRequest)
            throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Savings Plans covered for your account. This enables you to see how much of your cost is covered by
     * a Savings Plan. An organization’s management account can see the coverage of the associated member accounts. This
     * supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data for
     * Savings Plans usage with the following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINKED_ACCOUNT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_FAMILY</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To determine valid values for a dimension, use the <code>GetDimensionValues</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSavingsPlansCoverageRequest.Builder} avoiding
     * the need to create one manually via {@link GetSavingsPlansCoverageRequest#builder()}
     * </p>
     *
     * @param getSavingsPlansCoverageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest.Builder} to
     *        create a request.
     * @return Result of the GetSavingsPlansCoverage operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlansCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansCoverage" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSavingsPlansCoverageResponse getSavingsPlansCoverage(
            Consumer<GetSavingsPlansCoverageRequest.Builder> getSavingsPlansCoverageRequest) throws LimitExceededException,
            DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        return getSavingsPlansCoverage(GetSavingsPlansCoverageRequest.builder().applyMutation(getSavingsPlansCoverageRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getSavingsPlansCoverage(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoverageIterable responses = client.getSavingsPlansCoveragePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoverageIterable responses = client
     *             .getSavingsPlansCoveragePaginator(request);
     *     for (software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoverageIterable responses = client.getSavingsPlansCoveragePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSavingsPlansCoverage(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSavingsPlansCoverageRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlansCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansCoverage" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSavingsPlansCoverageIterable getSavingsPlansCoveragePaginator(
            GetSavingsPlansCoverageRequest getSavingsPlansCoverageRequest) throws LimitExceededException,
            DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        return new GetSavingsPlansCoverageIterable(this, getSavingsPlansCoverageRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getSavingsPlansCoverage(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoverageIterable responses = client.getSavingsPlansCoveragePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoverageIterable responses = client
     *             .getSavingsPlansCoveragePaginator(request);
     *     for (software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoverageIterable responses = client.getSavingsPlansCoveragePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSavingsPlansCoverage(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSavingsPlansCoverageRequest.Builder} avoiding
     * the need to create one manually via {@link GetSavingsPlansCoverageRequest#builder()}
     * </p>
     *
     * @param getSavingsPlansCoverageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlansCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansCoverage" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSavingsPlansCoverageIterable getSavingsPlansCoveragePaginator(
            Consumer<GetSavingsPlansCoverageRequest.Builder> getSavingsPlansCoverageRequest) throws LimitExceededException,
            DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        return getSavingsPlansCoveragePaginator(GetSavingsPlansCoverageRequest.builder()
                .applyMutation(getSavingsPlansCoverageRequest).build());
    }

    /**
     * <p>
     * Retrieves the Savings Plans recommendations for your account. First use
     * <code>StartSavingsPlansPurchaseRecommendationGeneration</code> to generate a new set of recommendations, and then
     * use <code>GetSavingsPlansPurchaseRecommendation</code> to retrieve them.
     * </p>
     *
     * @param getSavingsPlansPurchaseRecommendationRequest
     * @return Result of the GetSavingsPlansPurchaseRecommendation operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlansPurchaseRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansPurchaseRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSavingsPlansPurchaseRecommendationResponse getSavingsPlansPurchaseRecommendation(
            GetSavingsPlansPurchaseRecommendationRequest getSavingsPlansPurchaseRecommendationRequest)
            throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Savings Plans recommendations for your account. First use
     * <code>StartSavingsPlansPurchaseRecommendationGeneration</code> to generate a new set of recommendations, and then
     * use <code>GetSavingsPlansPurchaseRecommendation</code> to retrieve them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetSavingsPlansPurchaseRecommendationRequest.Builder} avoiding the need to create one manually via
     * {@link GetSavingsPlansPurchaseRecommendationRequest#builder()}
     * </p>
     *
     * @param getSavingsPlansPurchaseRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest.Builder}
     *        to create a request.
     * @return Result of the GetSavingsPlansPurchaseRecommendation operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlansPurchaseRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansPurchaseRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSavingsPlansPurchaseRecommendationResponse getSavingsPlansPurchaseRecommendation(
            Consumer<GetSavingsPlansPurchaseRecommendationRequest.Builder> getSavingsPlansPurchaseRecommendationRequest)
            throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            CostExplorerException {
        return getSavingsPlansPurchaseRecommendation(GetSavingsPlansPurchaseRecommendationRequest.builder()
                .applyMutation(getSavingsPlansPurchaseRecommendationRequest).build());
    }

    /**
     * <p>
     * Retrieves the Savings Plans utilization for your account across date ranges with daily or monthly granularity.
     * Management account in an organization have access to member accounts. You can use <code>GetDimensionValues</code>
     * in <code>SAVINGS_PLANS</code> to determine the possible dimension values.
     * </p>
     * <note>
     * <p>
     * You can't group by any dimension values for <code>GetSavingsPlansUtilization</code>.
     * </p>
     * </note>
     *
     * @param getSavingsPlansUtilizationRequest
     * @return Result of the GetSavingsPlansUtilization operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlansUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilization" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSavingsPlansUtilizationResponse getSavingsPlansUtilization(
            GetSavingsPlansUtilizationRequest getSavingsPlansUtilizationRequest) throws LimitExceededException,
            DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Savings Plans utilization for your account across date ranges with daily or monthly granularity.
     * Management account in an organization have access to member accounts. You can use <code>GetDimensionValues</code>
     * in <code>SAVINGS_PLANS</code> to determine the possible dimension values.
     * </p>
     * <note>
     * <p>
     * You can't group by any dimension values for <code>GetSavingsPlansUtilization</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSavingsPlansUtilizationRequest.Builder} avoiding
     * the need to create one manually via {@link GetSavingsPlansUtilizationRequest#builder()}
     * </p>
     *
     * @param getSavingsPlansUtilizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest.Builder} to
     *        create a request.
     * @return Result of the GetSavingsPlansUtilization operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlansUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilization" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSavingsPlansUtilizationResponse getSavingsPlansUtilization(
            Consumer<GetSavingsPlansUtilizationRequest.Builder> getSavingsPlansUtilizationRequest) throws LimitExceededException,
            DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        return getSavingsPlansUtilization(GetSavingsPlansUtilizationRequest.builder()
                .applyMutation(getSavingsPlansUtilizationRequest).build());
    }

    /**
     * <p>
     * Retrieves attribute data along with aggregate utilization and savings data for a given time period. This doesn't
     * support granular or grouped data (daily/monthly) in response. You can't retrieve data by dates in a single
     * response similar to <code>GetSavingsPlanUtilization</code>, but you have the option to make multiple calls to
     * <code>GetSavingsPlanUtilizationDetails</code> by providing individual dates. You can use
     * <code>GetDimensionValues</code> in <code>SAVINGS_PLANS</code> to determine the possible dimension values.
     * </p>
     * <note>
     * <p>
     * <code>GetSavingsPlanUtilizationDetails</code> internally groups data by <code>SavingsPlansArn</code>.
     * </p>
     * </note>
     *
     * @param getSavingsPlansUtilizationDetailsRequest
     * @return Result of the GetSavingsPlansUtilizationDetails operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlansUtilizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSavingsPlansUtilizationDetailsResponse getSavingsPlansUtilizationDetails(
            GetSavingsPlansUtilizationDetailsRequest getSavingsPlansUtilizationDetailsRequest) throws LimitExceededException,
            DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves attribute data along with aggregate utilization and savings data for a given time period. This doesn't
     * support granular or grouped data (daily/monthly) in response. You can't retrieve data by dates in a single
     * response similar to <code>GetSavingsPlanUtilization</code>, but you have the option to make multiple calls to
     * <code>GetSavingsPlanUtilizationDetails</code> by providing individual dates. You can use
     * <code>GetDimensionValues</code> in <code>SAVINGS_PLANS</code> to determine the possible dimension values.
     * </p>
     * <note>
     * <p>
     * <code>GetSavingsPlanUtilizationDetails</code> internally groups data by <code>SavingsPlansArn</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSavingsPlansUtilizationDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetSavingsPlansUtilizationDetailsRequest#builder()}
     * </p>
     *
     * @param getSavingsPlansUtilizationDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest.Builder}
     *        to create a request.
     * @return Result of the GetSavingsPlansUtilizationDetails operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlansUtilizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSavingsPlansUtilizationDetailsResponse getSavingsPlansUtilizationDetails(
            Consumer<GetSavingsPlansUtilizationDetailsRequest.Builder> getSavingsPlansUtilizationDetailsRequest)
            throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, CostExplorerException {
        return getSavingsPlansUtilizationDetails(GetSavingsPlansUtilizationDetailsRequest.builder()
                .applyMutation(getSavingsPlansUtilizationDetailsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getSavingsPlansUtilizationDetails(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsIterable responses = client.getSavingsPlansUtilizationDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsIterable responses = client
     *             .getSavingsPlansUtilizationDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsIterable responses = client.getSavingsPlansUtilizationDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSavingsPlansUtilizationDetails(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSavingsPlansUtilizationDetailsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlansUtilizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSavingsPlansUtilizationDetailsIterable getSavingsPlansUtilizationDetailsPaginator(
            GetSavingsPlansUtilizationDetailsRequest getSavingsPlansUtilizationDetailsRequest) throws LimitExceededException,
            DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        return new GetSavingsPlansUtilizationDetailsIterable(this, getSavingsPlansUtilizationDetailsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getSavingsPlansUtilizationDetails(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsIterable responses = client.getSavingsPlansUtilizationDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsIterable responses = client
     *             .getSavingsPlansUtilizationDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsIterable responses = client.getSavingsPlansUtilizationDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSavingsPlansUtilizationDetails(software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSavingsPlansUtilizationDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetSavingsPlansUtilizationDetailsRequest#builder()}
     * </p>
     *
     * @param getSavingsPlansUtilizationDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetSavingsPlansUtilizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSavingsPlansUtilizationDetailsIterable getSavingsPlansUtilizationDetailsPaginator(
            Consumer<GetSavingsPlansUtilizationDetailsRequest.Builder> getSavingsPlansUtilizationDetailsRequest)
            throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, CostExplorerException {
        return getSavingsPlansUtilizationDetailsPaginator(GetSavingsPlansUtilizationDetailsRequest.builder()
                .applyMutation(getSavingsPlansUtilizationDetailsRequest).build());
    }

    /**
     * <p>
     * Queries for available tag keys and tag values for a specified period. You can search the tag values for an
     * arbitrary string.
     * </p>
     *
     * @param getTagsRequest
     * @return Result of the GetTags operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws BillExpirationException
     *         The requested report expired. Update the date interval and try again.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws RequestChangedException
     *         Your request parameters changed between pages. Try again with the old parameters or without a pagination
     *         token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetTags" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTagsResponse getTags(GetTagsRequest getTagsRequest) throws LimitExceededException, BillExpirationException,
            DataUnavailableException, InvalidNextTokenException, RequestChangedException, AwsServiceException,
            SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries for available tag keys and tag values for a specified period. You can search the tag values for an
     * arbitrary string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTagsRequest.Builder} avoiding the need to create
     * one manually via {@link GetTagsRequest#builder()}
     * </p>
     *
     * @param getTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetTagsRequest.Builder} to create a request.
     * @return Result of the GetTags operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws BillExpirationException
     *         The requested report expired. Update the date interval and try again.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws RequestChangedException
     *         Your request parameters changed between pages. Try again with the old parameters or without a pagination
     *         token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetTags" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTagsResponse getTags(Consumer<GetTagsRequest.Builder> getTagsRequest) throws LimitExceededException,
            BillExpirationException, DataUnavailableException, InvalidNextTokenException, RequestChangedException,
            AwsServiceException, SdkClientException, CostExplorerException {
        return getTags(GetTagsRequest.builder().applyMutation(getTagsRequest).build());
    }

    /**
     * <p>
     * Retrieves a forecast for how much Amazon Web Services predicts that you will use over the forecast time period
     * that you select, based on your past usage.
     * </p>
     *
     * @param getUsageForecastRequest
     * @return Result of the GetUsageForecast operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws UnresolvableUsageUnitException
     *         Cost Explorer was unable to identify the usage unit. Provide <code>UsageType/UsageTypeGroup</code> filter
     *         selections that contain matching units, for example: <code>hours</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetUsageForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetUsageForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUsageForecastResponse getUsageForecast(GetUsageForecastRequest getUsageForecastRequest)
            throws LimitExceededException, DataUnavailableException, UnresolvableUsageUnitException, AwsServiceException,
            SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a forecast for how much Amazon Web Services predicts that you will use over the forecast time period
     * that you select, based on your past usage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageForecastRequest.Builder} avoiding the need
     * to create one manually via {@link GetUsageForecastRequest#builder()}
     * </p>
     *
     * @param getUsageForecastRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.GetUsageForecastRequest.Builder} to create a
     *        request.
     * @return Result of the GetUsageForecast operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws UnresolvableUsageUnitException
     *         Cost Explorer was unable to identify the usage unit. Provide <code>UsageType/UsageTypeGroup</code> filter
     *         selections that contain matching units, for example: <code>hours</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.GetUsageForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetUsageForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUsageForecastResponse getUsageForecast(Consumer<GetUsageForecastRequest.Builder> getUsageForecastRequest)
            throws LimitExceededException, DataUnavailableException, UnresolvableUsageUnitException, AwsServiceException,
            SdkClientException, CostExplorerException {
        return getUsageForecast(GetUsageForecastRequest.builder().applyMutation(getUsageForecastRequest).build());
    }

    /**
     * <p>
     * Get a list of cost allocation tags. All inputs in the API are optional and serve as filters. By default, all cost
     * allocation tags are returned.
     * </p>
     *
     * @param listCostAllocationTagsRequest
     * @return Result of the ListCostAllocationTags operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ListCostAllocationTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostAllocationTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCostAllocationTagsResponse listCostAllocationTags(ListCostAllocationTagsRequest listCostAllocationTagsRequest)
            throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of cost allocation tags. All inputs in the API are optional and serve as filters. By default, all cost
     * allocation tags are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCostAllocationTagsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCostAllocationTagsRequest#builder()}
     * </p>
     *
     * @param listCostAllocationTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsRequest.Builder} to create
     *        a request.
     * @return Result of the ListCostAllocationTags operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ListCostAllocationTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostAllocationTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCostAllocationTagsResponse listCostAllocationTags(
            Consumer<ListCostAllocationTagsRequest.Builder> listCostAllocationTagsRequest) throws LimitExceededException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        return listCostAllocationTags(ListCostAllocationTagsRequest.builder().applyMutation(listCostAllocationTagsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCostAllocationTags(software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.ListCostAllocationTagsIterable responses = client.listCostAllocationTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.costexplorer.paginators.ListCostAllocationTagsIterable responses = client
     *             .listCostAllocationTagsPaginator(request);
     *     for (software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.ListCostAllocationTagsIterable responses = client.listCostAllocationTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCostAllocationTags(software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCostAllocationTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ListCostAllocationTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostAllocationTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCostAllocationTagsIterable listCostAllocationTagsPaginator(
            ListCostAllocationTagsRequest listCostAllocationTagsRequest) throws LimitExceededException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        return new ListCostAllocationTagsIterable(this, listCostAllocationTagsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCostAllocationTags(software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.ListCostAllocationTagsIterable responses = client.listCostAllocationTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.costexplorer.paginators.ListCostAllocationTagsIterable responses = client
     *             .listCostAllocationTagsPaginator(request);
     *     for (software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.ListCostAllocationTagsIterable responses = client.listCostAllocationTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCostAllocationTags(software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCostAllocationTagsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCostAllocationTagsRequest#builder()}
     * </p>
     *
     * @param listCostAllocationTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ListCostAllocationTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostAllocationTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCostAllocationTagsIterable listCostAllocationTagsPaginator(
            Consumer<ListCostAllocationTagsRequest.Builder> listCostAllocationTagsRequest) throws LimitExceededException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        return listCostAllocationTagsPaginator(ListCostAllocationTagsRequest.builder()
                .applyMutation(listCostAllocationTagsRequest).build());
    }

    /**
     * <p>
     * Returns the name, Amazon Resource Name (ARN), <code>NumberOfRules</code> and effective dates of all Cost
     * Categories defined in the account. You have the option to use <code>EffectiveOn</code> to return a list of Cost
     * Categories that were active on a specific date. If there is no <code>EffectiveOn</code> specified, you’ll see
     * Cost Categories that are effective on the current date. If Cost Category is still effective,
     * <code>EffectiveEnd</code> is omitted in the response. <code>ListCostCategoryDefinitions</code> supports
     * pagination. The request can have a <code>MaxResults</code> range up to 100.
     * </p>
     *
     * @param listCostCategoryDefinitionsRequest
     * @return Result of the ListCostCategoryDefinitions operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ListCostCategoryDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostCategoryDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCostCategoryDefinitionsResponse listCostCategoryDefinitions(
            ListCostCategoryDefinitionsRequest listCostCategoryDefinitionsRequest) throws LimitExceededException,
            AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the name, Amazon Resource Name (ARN), <code>NumberOfRules</code> and effective dates of all Cost
     * Categories defined in the account. You have the option to use <code>EffectiveOn</code> to return a list of Cost
     * Categories that were active on a specific date. If there is no <code>EffectiveOn</code> specified, you’ll see
     * Cost Categories that are effective on the current date. If Cost Category is still effective,
     * <code>EffectiveEnd</code> is omitted in the response. <code>ListCostCategoryDefinitions</code> supports
     * pagination. The request can have a <code>MaxResults</code> range up to 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCostCategoryDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCostCategoryDefinitionsRequest#builder()}
     * </p>
     *
     * @param listCostCategoryDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListCostCategoryDefinitions operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ListCostCategoryDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostCategoryDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCostCategoryDefinitionsResponse listCostCategoryDefinitions(
            Consumer<ListCostCategoryDefinitionsRequest.Builder> listCostCategoryDefinitionsRequest)
            throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        return listCostCategoryDefinitions(ListCostCategoryDefinitionsRequest.builder()
                .applyMutation(listCostCategoryDefinitionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCostCategoryDefinitions(software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsIterable responses = client.listCostCategoryDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsIterable responses = client
     *             .listCostCategoryDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsIterable responses = client.listCostCategoryDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCostCategoryDefinitions(software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCostCategoryDefinitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ListCostCategoryDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostCategoryDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCostCategoryDefinitionsIterable listCostCategoryDefinitionsPaginator(
            ListCostCategoryDefinitionsRequest listCostCategoryDefinitionsRequest) throws LimitExceededException,
            AwsServiceException, SdkClientException, CostExplorerException {
        return new ListCostCategoryDefinitionsIterable(this, listCostCategoryDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCostCategoryDefinitions(software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsIterable responses = client.listCostCategoryDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsIterable responses = client
     *             .listCostCategoryDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsIterable responses = client.listCostCategoryDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCostCategoryDefinitions(software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCostCategoryDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCostCategoryDefinitionsRequest#builder()}
     * </p>
     *
     * @param listCostCategoryDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ListCostCategoryDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListCostCategoryDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCostCategoryDefinitionsIterable listCostCategoryDefinitionsPaginator(
            Consumer<ListCostCategoryDefinitionsRequest.Builder> listCostCategoryDefinitionsRequest)
            throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        return listCostCategoryDefinitionsPaginator(ListCostCategoryDefinitionsRequest.builder()
                .applyMutation(listCostCategoryDefinitionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of your historical recommendation generations within the past 30 days.
     * </p>
     *
     * @param listSavingsPlansPurchaseRecommendationGenerationRequest
     * @return Result of the ListSavingsPlansPurchaseRecommendationGeneration operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ListSavingsPlansPurchaseRecommendationGeneration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListSavingsPlansPurchaseRecommendationGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSavingsPlansPurchaseRecommendationGenerationResponse listSavingsPlansPurchaseRecommendationGeneration(
            ListSavingsPlansPurchaseRecommendationGenerationRequest listSavingsPlansPurchaseRecommendationGenerationRequest)
            throws LimitExceededException, InvalidNextTokenException, DataUnavailableException, AwsServiceException,
            SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of your historical recommendation generations within the past 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListSavingsPlansPurchaseRecommendationGenerationRequest.Builder} avoiding the need to create one manually
     * via {@link ListSavingsPlansPurchaseRecommendationGenerationRequest#builder()}
     * </p>
     *
     * @param listSavingsPlansPurchaseRecommendationGenerationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.ListSavingsPlansPurchaseRecommendationGenerationRequest.Builder}
     *        to create a request.
     * @return Result of the ListSavingsPlansPurchaseRecommendationGeneration operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws InvalidNextTokenException
     *         The pagination token is invalid. Try again without a pagination token.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ListSavingsPlansPurchaseRecommendationGeneration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListSavingsPlansPurchaseRecommendationGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSavingsPlansPurchaseRecommendationGenerationResponse listSavingsPlansPurchaseRecommendationGeneration(
            Consumer<ListSavingsPlansPurchaseRecommendationGenerationRequest.Builder> listSavingsPlansPurchaseRecommendationGenerationRequest)
            throws LimitExceededException, InvalidNextTokenException, DataUnavailableException, AwsServiceException,
            SdkClientException, CostExplorerException {
        return listSavingsPlansPurchaseRecommendationGeneration(ListSavingsPlansPurchaseRecommendationGenerationRequest.builder()
                .applyMutation(listSavingsPlansPurchaseRecommendationGenerationRequest).build());
    }

    /**
     * <p>
     * Returns a list of resource tags associated with the resource specified by the Amazon Resource Name (ARN).
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resource tags associated with the resource specified by the Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the feedback property of a given cost anomaly.
     * </p>
     *
     * @param provideAnomalyFeedbackRequest
     * @return Result of the ProvideAnomalyFeedback operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ProvideAnomalyFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ProvideAnomalyFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default ProvideAnomalyFeedbackResponse provideAnomalyFeedback(ProvideAnomalyFeedbackRequest provideAnomalyFeedbackRequest)
            throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the feedback property of a given cost anomaly.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ProvideAnomalyFeedbackRequest.Builder} avoiding the
     * need to create one manually via {@link ProvideAnomalyFeedbackRequest#builder()}
     * </p>
     *
     * @param provideAnomalyFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest.Builder} to create
     *        a request.
     * @return Result of the ProvideAnomalyFeedback operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.ProvideAnomalyFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/ProvideAnomalyFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default ProvideAnomalyFeedbackResponse provideAnomalyFeedback(
            Consumer<ProvideAnomalyFeedbackRequest.Builder> provideAnomalyFeedbackRequest) throws LimitExceededException,
            AwsServiceException, SdkClientException, CostExplorerException {
        return provideAnomalyFeedback(ProvideAnomalyFeedbackRequest.builder().applyMutation(provideAnomalyFeedbackRequest)
                .build());
    }

    /**
     * <p>
     * Requests a Savings Plans recommendation generation. This enables you to calculate a fresh set of Savings Plans
     * recommendations that takes your latest usage data and current Savings Plans inventory into account. You can
     * refresh Savings Plans recommendations up to three times daily for a consolidated billing family.
     * </p>
     * <note>
     * <p>
     * <code>StartSavingsPlansPurchaseRecommendationGeneration</code> has no request syntax because no input parameters
     * are needed to support this operation.
     * </p>
     * </note>
     *
     * @param startSavingsPlansPurchaseRecommendationGenerationRequest
     * @return Result of the StartSavingsPlansPurchaseRecommendationGeneration operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws ServiceQuotaExceededException
     *         You've reached the limit on the number of resources you can create, or exceeded the size of an individual
     *         resource.
     * @throws GenerationExistsException
     *         A request to generate a recommendation is already in progress.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.StartSavingsPlansPurchaseRecommendationGeneration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/StartSavingsPlansPurchaseRecommendationGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSavingsPlansPurchaseRecommendationGenerationResponse startSavingsPlansPurchaseRecommendationGeneration(
            StartSavingsPlansPurchaseRecommendationGenerationRequest startSavingsPlansPurchaseRecommendationGenerationRequest)
            throws LimitExceededException, ServiceQuotaExceededException, GenerationExistsException, DataUnavailableException,
            AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests a Savings Plans recommendation generation. This enables you to calculate a fresh set of Savings Plans
     * recommendations that takes your latest usage data and current Savings Plans inventory into account. You can
     * refresh Savings Plans recommendations up to three times daily for a consolidated billing family.
     * </p>
     * <note>
     * <p>
     * <code>StartSavingsPlansPurchaseRecommendationGeneration</code> has no request syntax because no input parameters
     * are needed to support this operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartSavingsPlansPurchaseRecommendationGenerationRequest.Builder} avoiding the need to create one manually
     * via {@link StartSavingsPlansPurchaseRecommendationGenerationRequest#builder()}
     * </p>
     *
     * @param startSavingsPlansPurchaseRecommendationGenerationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.StartSavingsPlansPurchaseRecommendationGenerationRequest.Builder}
     *        to create a request.
     * @return Result of the StartSavingsPlansPurchaseRecommendationGeneration operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws ServiceQuotaExceededException
     *         You've reached the limit on the number of resources you can create, or exceeded the size of an individual
     *         resource.
     * @throws GenerationExistsException
     *         A request to generate a recommendation is already in progress.
     * @throws DataUnavailableException
     *         The requested data is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.StartSavingsPlansPurchaseRecommendationGeneration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/StartSavingsPlansPurchaseRecommendationGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSavingsPlansPurchaseRecommendationGenerationResponse startSavingsPlansPurchaseRecommendationGeneration(
            Consumer<StartSavingsPlansPurchaseRecommendationGenerationRequest.Builder> startSavingsPlansPurchaseRecommendationGenerationRequest)
            throws LimitExceededException, ServiceQuotaExceededException, GenerationExistsException, DataUnavailableException,
            AwsServiceException, SdkClientException, CostExplorerException {
        return startSavingsPlansPurchaseRecommendationGeneration(StartSavingsPlansPurchaseRecommendationGenerationRequest
                .builder().applyMutation(startSavingsPlansPurchaseRecommendationGenerationRequest).build());
    }

    /**
     * <p>
     * An API operation for adding one or more tags (key-value pairs) to a resource.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> operation with a resource that already has tags. If you specify a new
     * tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a
     * tag key that is already associated with the resource, the new tag value you specify replaces the previous value
     * for that tag.
     * </p>
     * <p>
     * Although the maximum number of array members is 200, user-tag maximum is 50. The remaining are reserved for
     * Amazon Web Services use.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws TooManyTagsException
     *         Can occur if you specify a number of tags for a resource greater than the maximum 50 user tags per
     *         resource.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            TooManyTagsException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An API operation for adding one or more tags (key-value pairs) to a resource.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> operation with a resource that already has tags. If you specify a new
     * tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a
     * tag key that is already associated with the resource, the new tag value you specify replaces the previous value
     * for that tag.
     * </p>
     * <p>
     * Although the maximum number of array members is 200, user-tag maximum is 50. The remaining are reserved for
     * Amazon Web Services use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws TooManyTagsException
     *         Can occur if you specify a number of tags for a resource greater than the maximum 50 user tags per
     *         resource.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, TooManyTagsException, LimitExceededException, AwsServiceException,
            SdkClientException, CostExplorerException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a resource. Specify only tag keys in your request. Don't specify the value.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a resource. Specify only tag keys in your request. Don't specify the value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            CostExplorerException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing cost anomaly monitor. The changes made are applied going forward, and doesn't change
     * anomalies detected in the past.
     * </p>
     *
     * @param updateAnomalyMonitorRequest
     * @return Result of the UpdateAnomalyMonitor operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws UnknownMonitorException
     *         The cost anomaly monitor does not exist for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.UpdateAnomalyMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalyMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAnomalyMonitorResponse updateAnomalyMonitor(UpdateAnomalyMonitorRequest updateAnomalyMonitorRequest)
            throws LimitExceededException, UnknownMonitorException, AwsServiceException, SdkClientException,
            CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing cost anomaly monitor. The changes made are applied going forward, and doesn't change
     * anomalies detected in the past.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnomalyMonitorRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAnomalyMonitorRequest#builder()}
     * </p>
     *
     * @param updateAnomalyMonitorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAnomalyMonitor operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws UnknownMonitorException
     *         The cost anomaly monitor does not exist for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.UpdateAnomalyMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalyMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAnomalyMonitorResponse updateAnomalyMonitor(
            Consumer<UpdateAnomalyMonitorRequest.Builder> updateAnomalyMonitorRequest) throws LimitExceededException,
            UnknownMonitorException, AwsServiceException, SdkClientException, CostExplorerException {
        return updateAnomalyMonitor(UpdateAnomalyMonitorRequest.builder().applyMutation(updateAnomalyMonitorRequest).build());
    }

    /**
     * <p>
     * Updates an existing cost anomaly subscription. Specify the fields that you want to update. Omitted fields are
     * unchanged.
     * </p>
     * <note>
     * <p>
     * The JSON below describes the generic construct for each type. See <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_UpdateAnomalySubscription.html#API_UpdateAnomalySubscription_RequestParameters"
     * >Request Parameters</a> for possible values as they apply to <code>AnomalySubscription</code>.
     * </p>
     * </note>
     *
     * @param updateAnomalySubscriptionRequest
     * @return Result of the UpdateAnomalySubscription operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws UnknownMonitorException
     *         The cost anomaly monitor does not exist for the account.
     * @throws UnknownSubscriptionException
     *         The cost anomaly subscription does not exist for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.UpdateAnomalySubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalySubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateAnomalySubscriptionResponse updateAnomalySubscription(
            UpdateAnomalySubscriptionRequest updateAnomalySubscriptionRequest) throws LimitExceededException,
            UnknownMonitorException, UnknownSubscriptionException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing cost anomaly subscription. Specify the fields that you want to update. Omitted fields are
     * unchanged.
     * </p>
     * <note>
     * <p>
     * The JSON below describes the generic construct for each type. See <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_UpdateAnomalySubscription.html#API_UpdateAnomalySubscription_RequestParameters"
     * >Request Parameters</a> for possible values as they apply to <code>AnomalySubscription</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnomalySubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAnomalySubscriptionRequest#builder()}
     * </p>
     *
     * @param updateAnomalySubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateAnomalySubscription operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws UnknownMonitorException
     *         The cost anomaly monitor does not exist for the account.
     * @throws UnknownSubscriptionException
     *         The cost anomaly subscription does not exist for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.UpdateAnomalySubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateAnomalySubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateAnomalySubscriptionResponse updateAnomalySubscription(
            Consumer<UpdateAnomalySubscriptionRequest.Builder> updateAnomalySubscriptionRequest) throws LimitExceededException,
            UnknownMonitorException, UnknownSubscriptionException, AwsServiceException, SdkClientException, CostExplorerException {
        return updateAnomalySubscription(UpdateAnomalySubscriptionRequest.builder()
                .applyMutation(updateAnomalySubscriptionRequest).build());
    }

    /**
     * <p>
     * Updates status for cost allocation tags in bulk, with maximum batch size of 20. If the tag status that's updated
     * is the same as the existing tag status, the request doesn't fail. Instead, it doesn't have any effect on the tag
     * status (for example, activating the active tag).
     * </p>
     *
     * @param updateCostAllocationTagsStatusRequest
     * @return Result of the UpdateCostAllocationTagsStatus operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.UpdateCostAllocationTagsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateCostAllocationTagsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCostAllocationTagsStatusResponse updateCostAllocationTagsStatus(
            UpdateCostAllocationTagsStatusRequest updateCostAllocationTagsStatusRequest) throws LimitExceededException,
            AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates status for cost allocation tags in bulk, with maximum batch size of 20. If the tag status that's updated
     * is the same as the existing tag status, the request doesn't fail. Instead, it doesn't have any effect on the tag
     * status (for example, activating the active tag).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCostAllocationTagsStatusRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCostAllocationTagsStatusRequest#builder()}
     * </p>
     *
     * @param updateCostAllocationTagsStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.UpdateCostAllocationTagsStatusRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateCostAllocationTagsStatus operation returned by the service.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.UpdateCostAllocationTagsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateCostAllocationTagsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCostAllocationTagsStatusResponse updateCostAllocationTagsStatus(
            Consumer<UpdateCostAllocationTagsStatusRequest.Builder> updateCostAllocationTagsStatusRequest)
            throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        return updateCostAllocationTagsStatus(UpdateCostAllocationTagsStatusRequest.builder()
                .applyMutation(updateCostAllocationTagsStatusRequest).build());
    }

    /**
     * <p>
     * Updates an existing Cost Category. Changes made to the Cost Category rules will be used to categorize the current
     * month’s expenses and future expenses. This won’t change categorization for the previous months.
     * </p>
     *
     * @param updateCostCategoryDefinitionRequest
     * @return Result of the UpdateCostCategoryDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws ServiceQuotaExceededException
     *         You've reached the limit on the number of resources you can create, or exceeded the size of an individual
     *         resource.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.UpdateCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCostCategoryDefinitionResponse updateCostCategoryDefinition(
            UpdateCostCategoryDefinitionRequest updateCostCategoryDefinitionRequest) throws ResourceNotFoundException,
            ServiceQuotaExceededException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Cost Category. Changes made to the Cost Category rules will be used to categorize the current
     * month’s expenses and future expenses. This won’t change categorization for the previous months.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCostCategoryDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCostCategoryDefinitionRequest#builder()}
     * </p>
     *
     * @param updateCostCategoryDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateCostCategoryDefinition operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws ServiceQuotaExceededException
     *         You've reached the limit on the number of resources you can create, or exceeded the size of an individual
     *         resource.
     * @throws LimitExceededException
     *         You made too many calls in a short period of time. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostExplorerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostExplorerClient.UpdateCostCategoryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/UpdateCostCategoryDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCostCategoryDefinitionResponse updateCostCategoryDefinition(
            Consumer<UpdateCostCategoryDefinitionRequest.Builder> updateCostCategoryDefinitionRequest)
            throws ResourceNotFoundException, ServiceQuotaExceededException, LimitExceededException, AwsServiceException,
            SdkClientException, CostExplorerException {
        return updateCostCategoryDefinition(UpdateCostCategoryDefinitionRequest.builder()
                .applyMutation(updateCostCategoryDefinitionRequest).build());
    }

    /**
     * Create a {@link CostExplorerClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CostExplorerClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CostExplorerClient}.
     */
    static CostExplorerClientBuilder builder() {
        return new DefaultCostExplorerClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CostExplorerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
