/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An entity type within a labeled training dataset that Amazon Comprehend uses to train a custom entity recognizer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityTypesListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityTypesListItem.Builder, EntityTypesListItem> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(EntityTypesListItem::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private EntityTypesListItem(BuilderImpl builder) {
        this.type = builder.type;
    }

    /**
     * <p>
     * An entity type within a labeled training dataset that Amazon Comprehend uses to train a custom entity recognizer.
     * </p>
     * <p>
     * Entity types must not contain the following invalid characters: \n (line break), \\n (escaped line break, \r
     * (carriage return), \\r (escaped carriage return), \t (tab), \\t (escaped tab), and , (comma).
     * </p>
     * 
     * @return An entity type within a labeled training dataset that Amazon Comprehend uses to train a custom entity
     *         recognizer.</p>
     *         <p>
     *         Entity types must not contain the following invalid characters: \n (line break), \\n (escaped line break,
     *         \r (carriage return), \\r (escaped carriage return), \t (tab), \\t (escaped tab), and , (comma).
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityTypesListItem)) {
            return false;
        }
        EntityTypesListItem other = (EntityTypesListItem) obj;
        return Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityTypesListItem").add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityTypesListItem, T> g) {
        return obj -> g.apply((EntityTypesListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityTypesListItem> {
        /**
         * <p>
         * An entity type within a labeled training dataset that Amazon Comprehend uses to train a custom entity
         * recognizer.
         * </p>
         * <p>
         * Entity types must not contain the following invalid characters: \n (line break), \\n (escaped line break, \r
         * (carriage return), \\r (escaped carriage return), \t (tab), \\t (escaped tab), and , (comma).
         * </p>
         * 
         * @param type
         *        An entity type within a labeled training dataset that Amazon Comprehend uses to train a custom entity
         *        recognizer.</p>
         *        <p>
         *        Entity types must not contain the following invalid characters: \n (line break), \\n (escaped line
         *        break, \r (carriage return), \\r (escaped carriage return), \t (tab), \\t (escaped tab), and ,
         *        (comma).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityTypesListItem model) {
            type(model.type);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public EntityTypesListItem build() {
            return new EntityTypesListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
