/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration required for a document classification model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentClassificationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentClassificationConfig.Builder, DocumentClassificationConfig> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(DocumentClassificationConfig::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<List<String>> LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Labels")
            .getter(getter(DocumentClassificationConfig::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, LABELS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final List<String> labels;

    private DocumentClassificationConfig(BuilderImpl builder) {
        this.mode = builder.mode;
        this.labels = builder.labels;
    }

    /**
     * <p>
     * Classification mode indicates whether the documents are <code>MULTI_CLASS</code> or <code>MULTI_LABEL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link DocumentClassifierMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Classification mode indicates whether the documents are <code>MULTI_CLASS</code> or
     *         <code>MULTI_LABEL</code>.
     * @see DocumentClassifierMode
     */
    public final DocumentClassifierMode mode() {
        return DocumentClassifierMode.fromValue(mode);
    }

    /**
     * <p>
     * Classification mode indicates whether the documents are <code>MULTI_CLASS</code> or <code>MULTI_LABEL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link DocumentClassifierMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Classification mode indicates whether the documents are <code>MULTI_CLASS</code> or
     *         <code>MULTI_LABEL</code>.
     * @see DocumentClassifierMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more labels to associate with the custom classifier.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return One or more labels to associate with the custom classifier.
     */
    public final List<String> labels() {
        return labels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentClassificationConfig)) {
            return false;
        }
        DocumentClassificationConfig other = (DocumentClassificationConfig) obj;
        return Objects.equals(modeAsString(), other.modeAsString()) && hasLabels() == other.hasLabels()
                && Objects.equals(labels(), other.labels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentClassificationConfig").add("Mode", modeAsString())
                .add("Labels", hasLabels() ? labels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentClassificationConfig, T> g) {
        return obj -> g.apply((DocumentClassificationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentClassificationConfig> {
        /**
         * <p>
         * Classification mode indicates whether the documents are <code>MULTI_CLASS</code> or <code>MULTI_LABEL</code>.
         * </p>
         * 
         * @param mode
         *        Classification mode indicates whether the documents are <code>MULTI_CLASS</code> or
         *        <code>MULTI_LABEL</code>.
         * @see DocumentClassifierMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentClassifierMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Classification mode indicates whether the documents are <code>MULTI_CLASS</code> or <code>MULTI_LABEL</code>.
         * </p>
         * 
         * @param mode
         *        Classification mode indicates whether the documents are <code>MULTI_CLASS</code> or
         *        <code>MULTI_LABEL</code>.
         * @see DocumentClassifierMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentClassifierMode
         */
        Builder mode(DocumentClassifierMode mode);

        /**
         * <p>
         * One or more labels to associate with the custom classifier.
         * </p>
         * 
         * @param labels
         *        One or more labels to associate with the custom classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<String> labels);

        /**
         * <p>
         * One or more labels to associate with the custom classifier.
         * </p>
         * 
         * @param labels
         *        One or more labels to associate with the custom classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(String... labels);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentClassificationConfig model) {
            mode(model.mode);
            labels(model.labels);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(DocumentClassifierMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Collection<String> getLabels() {
            if (labels instanceof SdkAutoConstructList) {
                return null;
            }
            return labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = LabelsListCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = LabelsListCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        @Override
        public DocumentClassificationConfig build() {
            return new DocumentClassificationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
