/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event criteria for the pull request trigger configuration, such as the lists of branches or file paths to include
 * and exclude.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GitPullRequestFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<GitPullRequestFilter.Builder, GitPullRequestFilter> {
    private static final SdkField<List<String>> EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("events")
            .getter(getter(GitPullRequestFilter::eventsAsStrings))
            .setter(setter(Builder::eventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<GitBranchFilterCriteria> BRANCHES_FIELD = SdkField
            .<GitBranchFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("branches")
            .getter(getter(GitPullRequestFilter::branches)).setter(setter(Builder::branches))
            .constructor(GitBranchFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branches").build()).build();

    private static final SdkField<GitFilePathFilterCriteria> FILE_PATHS_FIELD = SdkField
            .<GitFilePathFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("filePaths")
            .getter(getter(GitPullRequestFilter::filePaths)).setter(setter(Builder::filePaths))
            .constructor(GitFilePathFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePaths").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD, BRANCHES_FIELD,
            FILE_PATHS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> events;

    private final GitBranchFilterCriteria branches;

    private final GitFilePathFilterCriteria filePaths;

    private GitPullRequestFilter(BuilderImpl builder) {
        this.events = builder.events;
        this.branches = builder.branches;
        this.filePaths = builder.filePaths;
    }

    /**
     * <p>
     * The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger
     * configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger
     *         configuration.
     */
    public final List<GitPullRequestEventType> events() {
        return GitPullRequestEventTypeListCopier.copyStringToEnum(events);
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger
     * configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger
     *         configuration.
     */
    public final List<String> eventsAsStrings() {
        return events;
    }

    /**
     * <p>
     * The field that specifies to filter on branches for the pull request trigger configuration.
     * </p>
     * 
     * @return The field that specifies to filter on branches for the pull request trigger configuration.
     */
    public final GitBranchFilterCriteria branches() {
        return branches;
    }

    /**
     * <p>
     * The field that specifies to filter on file paths for the pull request trigger configuration.
     * </p>
     * 
     * @return The field that specifies to filter on file paths for the pull request trigger configuration.
     */
    public final GitFilePathFilterCriteria filePaths() {
        return filePaths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? eventsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(branches());
        hashCode = 31 * hashCode + Objects.hashCode(filePaths());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitPullRequestFilter)) {
            return false;
        }
        GitPullRequestFilter other = (GitPullRequestFilter) obj;
        return hasEvents() == other.hasEvents() && Objects.equals(eventsAsStrings(), other.eventsAsStrings())
                && Objects.equals(branches(), other.branches()) && Objects.equals(filePaths(), other.filePaths());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GitPullRequestFilter").add("Events", hasEvents() ? eventsAsStrings() : null)
                .add("Branches", branches()).add("FilePaths", filePaths()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "events":
            return Optional.ofNullable(clazz.cast(eventsAsStrings()));
        case "branches":
            return Optional.ofNullable(clazz.cast(branches()));
        case "filePaths":
            return Optional.ofNullable(clazz.cast(filePaths()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GitPullRequestFilter, T> g) {
        return obj -> g.apply((GitPullRequestFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GitPullRequestFilter> {
        /**
         * <p>
         * The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger
         * configuration.
         * </p>
         * 
         * @param events
         *        The field that specifies which pull request events to filter on (opened, updated, closed) for the
         *        trigger configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsWithStrings(Collection<String> events);

        /**
         * <p>
         * The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger
         * configuration.
         * </p>
         * 
         * @param events
         *        The field that specifies which pull request events to filter on (opened, updated, closed) for the
         *        trigger configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsWithStrings(String... events);

        /**
         * <p>
         * The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger
         * configuration.
         * </p>
         * 
         * @param events
         *        The field that specifies which pull request events to filter on (opened, updated, closed) for the
         *        trigger configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<GitPullRequestEventType> events);

        /**
         * <p>
         * The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger
         * configuration.
         * </p>
         * 
         * @param events
         *        The field that specifies which pull request events to filter on (opened, updated, closed) for the
         *        trigger configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(GitPullRequestEventType... events);

        /**
         * <p>
         * The field that specifies to filter on branches for the pull request trigger configuration.
         * </p>
         * 
         * @param branches
         *        The field that specifies to filter on branches for the pull request trigger configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branches(GitBranchFilterCriteria branches);

        /**
         * <p>
         * The field that specifies to filter on branches for the pull request trigger configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link GitBranchFilterCriteria.Builder} avoiding
         * the need to create one manually via {@link GitBranchFilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GitBranchFilterCriteria.Builder#build()} is called immediately
         * and its result is passed to {@link #branches(GitBranchFilterCriteria)}.
         * 
         * @param branches
         *        a consumer that will call methods on {@link GitBranchFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #branches(GitBranchFilterCriteria)
         */
        default Builder branches(Consumer<GitBranchFilterCriteria.Builder> branches) {
            return branches(GitBranchFilterCriteria.builder().applyMutation(branches).build());
        }

        /**
         * <p>
         * The field that specifies to filter on file paths for the pull request trigger configuration.
         * </p>
         * 
         * @param filePaths
         *        The field that specifies to filter on file paths for the pull request trigger configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePaths(GitFilePathFilterCriteria filePaths);

        /**
         * <p>
         * The field that specifies to filter on file paths for the pull request trigger configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link GitFilePathFilterCriteria.Builder}
         * avoiding the need to create one manually via {@link GitFilePathFilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GitFilePathFilterCriteria.Builder#build()} is called immediately
         * and its result is passed to {@link #filePaths(GitFilePathFilterCriteria)}.
         * 
         * @param filePaths
         *        a consumer that will call methods on {@link GitFilePathFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filePaths(GitFilePathFilterCriteria)
         */
        default Builder filePaths(Consumer<GitFilePathFilterCriteria.Builder> filePaths) {
            return filePaths(GitFilePathFilterCriteria.builder().applyMutation(filePaths).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> events = DefaultSdkAutoConstructList.getInstance();

        private GitBranchFilterCriteria branches;

        private GitFilePathFilterCriteria filePaths;

        private BuilderImpl() {
        }

        private BuilderImpl(GitPullRequestFilter model) {
            eventsWithStrings(model.events);
            branches(model.branches);
            filePaths(model.filePaths);
        }

        public final Collection<String> getEvents() {
            if (events instanceof SdkAutoConstructList) {
                return null;
            }
            return events;
        }

        public final void setEvents(Collection<String> events) {
            this.events = GitPullRequestEventTypeListCopier.copy(events);
        }

        @Override
        public final Builder eventsWithStrings(Collection<String> events) {
            this.events = GitPullRequestEventTypeListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventsWithStrings(String... events) {
            eventsWithStrings(Arrays.asList(events));
            return this;
        }

        @Override
        public final Builder events(Collection<GitPullRequestEventType> events) {
            this.events = GitPullRequestEventTypeListCopier.copyEnumToString(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(GitPullRequestEventType... events) {
            events(Arrays.asList(events));
            return this;
        }

        public final GitBranchFilterCriteria.Builder getBranches() {
            return branches != null ? branches.toBuilder() : null;
        }

        public final void setBranches(GitBranchFilterCriteria.BuilderImpl branches) {
            this.branches = branches != null ? branches.build() : null;
        }

        @Override
        public final Builder branches(GitBranchFilterCriteria branches) {
            this.branches = branches;
            return this;
        }

        public final GitFilePathFilterCriteria.Builder getFilePaths() {
            return filePaths != null ? filePaths.toBuilder() : null;
        }

        public final void setFilePaths(GitFilePathFilterCriteria.BuilderImpl filePaths) {
            this.filePaths = filePaths != null ? filePaths.build() : null;
        }

        @Override
        public final Builder filePaths(GitFilePathFilterCriteria filePaths) {
            this.filePaths = filePaths;
            return this;
        }

        @Override
        public GitPullRequestFilter build() {
            return new GitPullRequestFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
