/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePartnerEventSourceResponse extends CloudWatchEventsResponse implements
        ToCopyableBuilder<CreatePartnerEventSourceResponse.Builder, CreatePartnerEventSourceResponse> {
    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSourceArn").getter(getter(CreatePartnerEventSourceResponse::eventSourceArn))
            .setter(setter(Builder::eventSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCE_ARN_FIELD));

    private final String eventSourceArn;

    private CreatePartnerEventSourceResponse(BuilderImpl builder) {
        super(builder);
        this.eventSourceArn = builder.eventSourceArn;
    }

    /**
     * <p>
     * The ARN of the partner event source.
     * </p>
     * 
     * @return The ARN of the partner event source.
     */
    public final String eventSourceArn() {
        return eventSourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePartnerEventSourceResponse)) {
            return false;
        }
        CreatePartnerEventSourceResponse other = (CreatePartnerEventSourceResponse) obj;
        return Objects.equals(eventSourceArn(), other.eventSourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePartnerEventSourceResponse").add("EventSourceArn", eventSourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventSourceArn":
            return Optional.ofNullable(clazz.cast(eventSourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePartnerEventSourceResponse, T> g) {
        return obj -> g.apply((CreatePartnerEventSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePartnerEventSourceResponse> {
        /**
         * <p>
         * The ARN of the partner event source.
         * </p>
         * 
         * @param eventSourceArn
         *        The ARN of the partner event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceArn(String eventSourceArn);
    }

    static final class BuilderImpl extends CloudWatchEventsResponse.BuilderImpl implements Builder {
        private String eventSourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePartnerEventSourceResponse model) {
            super(model);
            eventSourceArn(model.eventSourceArn);
        }

        public final String getEventSourceArn() {
            return eventSourceArn;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        @Override
        public CreatePartnerEventSourceResponse build() {
            return new CreatePartnerEventSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
