/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Key Value Store associations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyValueStoreAssociations implements SdkPojo, Serializable,
        ToCopyableBuilder<KeyValueStoreAssociations.Builder, KeyValueStoreAssociations> {
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity")
            .getter(getter(KeyValueStoreAssociations::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity")
                    .unmarshallLocationName("Quantity").build()).build();

    private static final SdkField<List<KeyValueStoreAssociation>> ITEMS_FIELD = SdkField
            .<List<KeyValueStoreAssociation>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(KeyValueStoreAssociations::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items")
                    .unmarshallLocationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("KeyValueStoreAssociation")
                            .memberFieldInfo(
                                    SdkField.<KeyValueStoreAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValueStoreAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("KeyValueStoreAssociation")
                                                    .unmarshallLocationName("KeyValueStoreAssociation").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTITY_FIELD, ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer quantity;

    private final List<KeyValueStoreAssociation> items;

    private KeyValueStoreAssociations(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The quantity of Key Value Store associations.
     * </p>
     * 
     * @return The quantity of Key Value Store associations.
     */
    public final Integer quantity() {
        return quantity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The items of the Key Value Store association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The items of the Key Value Store association.
     */
    public final List<KeyValueStoreAssociation> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyValueStoreAssociations)) {
            return false;
        }
        KeyValueStoreAssociations other = (KeyValueStoreAssociations) obj;
        return Objects.equals(quantity(), other.quantity()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyValueStoreAssociations").add("Quantity", quantity())
                .add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyValueStoreAssociations, T> g) {
        return obj -> g.apply((KeyValueStoreAssociations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyValueStoreAssociations> {
        /**
         * <p>
         * The quantity of Key Value Store associations.
         * </p>
         * 
         * @param quantity
         *        The quantity of Key Value Store associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * The items of the Key Value Store association.
         * </p>
         * 
         * @param items
         *        The items of the Key Value Store association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<KeyValueStoreAssociation> items);

        /**
         * <p>
         * The items of the Key Value Store association.
         * </p>
         * 
         * @param items
         *        The items of the Key Value Store association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(KeyValueStoreAssociation... items);

        /**
         * <p>
         * The items of the Key Value Store association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociation.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<KeyValueStoreAssociation>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<KeyValueStoreAssociation>)
         */
        Builder items(Consumer<KeyValueStoreAssociation.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<KeyValueStoreAssociation> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KeyValueStoreAssociations model) {
            quantity(model.quantity);
            items(model.items);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final List<KeyValueStoreAssociation.Builder> getItems() {
            List<KeyValueStoreAssociation.Builder> result = KeyValueStoreAssociationListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<KeyValueStoreAssociation.BuilderImpl> items) {
            this.items = KeyValueStoreAssociationListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<KeyValueStoreAssociation> items) {
            this.items = KeyValueStoreAssociationListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(KeyValueStoreAssociation... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<KeyValueStoreAssociation.Builder>... items) {
            items(Stream.of(items).map(c -> KeyValueStoreAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public KeyValueStoreAssociations build() {
            return new KeyValueStoreAssociations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
