/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKeyValueStoreResponse extends CloudFrontResponse implements
        ToCopyableBuilder<CreateKeyValueStoreResponse.Builder, CreateKeyValueStoreResponse> {
    private static final SdkField<KeyValueStore> KEY_VALUE_STORE_FIELD = SdkField
            .<KeyValueStore> builder(MarshallingType.SDK_POJO)
            .memberName("KeyValueStore")
            .getter(getter(CreateKeyValueStoreResponse::keyValueStore))
            .setter(setter(Builder::keyValueStore))
            .constructor(KeyValueStore::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyValueStore")
                    .unmarshallLocationName("KeyValueStore").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(CreateKeyValueStoreResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Location")
            .getter(getter(CreateKeyValueStoreResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_VALUE_STORE_FIELD,
            E_TAG_FIELD, LOCATION_FIELD));

    private final KeyValueStore keyValueStore;

    private final String eTag;

    private final String location;

    private CreateKeyValueStoreResponse(BuilderImpl builder) {
        super(builder);
        this.keyValueStore = builder.keyValueStore;
        this.eTag = builder.eTag;
        this.location = builder.location;
    }

    /**
     * <p>
     * The resulting Key Value Store.
     * </p>
     * 
     * @return The resulting Key Value Store.
     */
    public final KeyValueStore keyValueStore() {
        return keyValueStore;
    }

    /**
     * <p>
     * The ETag in the resulting Key Value Store.
     * </p>
     * 
     * @return The ETag in the resulting Key Value Store.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * <p>
     * The location of the resulting Key Value Store.
     * </p>
     * 
     * @return The location of the resulting Key Value Store.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyValueStore());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyValueStoreResponse)) {
            return false;
        }
        CreateKeyValueStoreResponse other = (CreateKeyValueStoreResponse) obj;
        return Objects.equals(keyValueStore(), other.keyValueStore()) && Objects.equals(eTag(), other.eTag())
                && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKeyValueStoreResponse").add("KeyValueStore", keyValueStore()).add("ETag", eTag())
                .add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyValueStore":
            return Optional.ofNullable(clazz.cast(keyValueStore()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKeyValueStoreResponse, T> g) {
        return obj -> g.apply((CreateKeyValueStoreResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateKeyValueStoreResponse> {
        /**
         * <p>
         * The resulting Key Value Store.
         * </p>
         * 
         * @param keyValueStore
         *        The resulting Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValueStore(KeyValueStore keyValueStore);

        /**
         * <p>
         * The resulting Key Value Store.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyValueStore.Builder} avoiding the need
         * to create one manually via {@link KeyValueStore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyValueStore.Builder#build()} is called immediately and its
         * result is passed to {@link #keyValueStore(KeyValueStore)}.
         * 
         * @param keyValueStore
         *        a consumer that will call methods on {@link KeyValueStore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyValueStore(KeyValueStore)
         */
        default Builder keyValueStore(Consumer<KeyValueStore.Builder> keyValueStore) {
            return keyValueStore(KeyValueStore.builder().applyMutation(keyValueStore).build());
        }

        /**
         * <p>
         * The ETag in the resulting Key Value Store.
         * </p>
         * 
         * @param eTag
         *        The ETag in the resulting Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * The location of the resulting Key Value Store.
         * </p>
         * 
         * @param location
         *        The location of the resulting Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private KeyValueStore keyValueStore;

        private String eTag;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyValueStoreResponse model) {
            super(model);
            keyValueStore(model.keyValueStore);
            eTag(model.eTag);
            location(model.location);
        }

        public final KeyValueStore.Builder getKeyValueStore() {
            return keyValueStore != null ? keyValueStore.toBuilder() : null;
        }

        public final void setKeyValueStore(KeyValueStore.BuilderImpl keyValueStore) {
            this.keyValueStore = keyValueStore != null ? keyValueStore.build() : null;
        }

        @Override
        public final Builder keyValueStore(KeyValueStore keyValueStore) {
            this.keyValueStore = keyValueStore;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public CreateKeyValueStoreResponse build() {
            return new CreateKeyValueStoreResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
