/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum BatchWriteExceptionType {
    INTERNAL_SERVICE_EXCEPTION("InternalServiceException"),

    VALIDATION_EXCEPTION("ValidationException"),

    INVALID_ARN_EXCEPTION("InvalidArnException"),

    LINK_NAME_ALREADY_IN_USE_EXCEPTION("LinkNameAlreadyInUseException"),

    STILL_CONTAINS_LINKS_EXCEPTION("StillContainsLinksException"),

    FACET_VALIDATION_EXCEPTION("FacetValidationException"),

    OBJECT_NOT_DETACHED_EXCEPTION("ObjectNotDetachedException"),

    RESOURCE_NOT_FOUND_EXCEPTION("ResourceNotFoundException"),

    ACCESS_DENIED_EXCEPTION("AccessDeniedException"),

    INVALID_ATTACHMENT_EXCEPTION("InvalidAttachmentException"),

    NOT_INDEX_EXCEPTION("NotIndexException"),

    NOT_NODE_EXCEPTION("NotNodeException"),

    INDEXED_ATTRIBUTE_MISSING_EXCEPTION("IndexedAttributeMissingException"),

    OBJECT_ALREADY_DETACHED_EXCEPTION("ObjectAlreadyDetachedException"),

    NOT_POLICY_EXCEPTION("NotPolicyException"),

    DIRECTORY_NOT_ENABLED_EXCEPTION("DirectoryNotEnabledException"),

    LIMIT_EXCEEDED_EXCEPTION("LimitExceededException"),

    UNSUPPORTED_INDEX_TYPE_EXCEPTION("UnsupportedIndexTypeException"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BatchWriteExceptionType> VALUE_MAP = EnumUtils.uniqueIndex(BatchWriteExceptionType.class,
            BatchWriteExceptionType::toString);

    private final String value;

    private BatchWriteExceptionType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return BatchWriteExceptionType corresponding to the value
     */
    public static BatchWriteExceptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link BatchWriteExceptionType}s
     */
    public static Set<BatchWriteExceptionType> knownValues() {
        Set<BatchWriteExceptionType> knownValues = EnumSet.allOf(BatchWriteExceptionType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
