/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings associated with an Amazon Chime user, including inbound and outbound calling and text messaging.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserSettings implements SdkPojo, Serializable, ToCopyableBuilder<UserSettings.Builder, UserSettings> {
    private static final SdkField<TelephonySettings> TELEPHONY_FIELD = SdkField
            .<TelephonySettings> builder(MarshallingType.SDK_POJO).memberName("Telephony")
            .getter(getter(UserSettings::telephony)).setter(setter(Builder::telephony)).constructor(TelephonySettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Telephony").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEPHONY_FIELD));

    private static final long serialVersionUID = 1L;

    private final TelephonySettings telephony;

    private UserSettings(BuilderImpl builder) {
        this.telephony = builder.telephony;
    }

    /**
     * <p>
     * The telephony settings associated with the user.
     * </p>
     * 
     * @return The telephony settings associated with the user.
     */
    public final TelephonySettings telephony() {
        return telephony;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(telephony());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSettings)) {
            return false;
        }
        UserSettings other = (UserSettings) obj;
        return Objects.equals(telephony(), other.telephony());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserSettings").add("Telephony", telephony()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Telephony":
            return Optional.ofNullable(clazz.cast(telephony()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserSettings, T> g) {
        return obj -> g.apply((UserSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserSettings> {
        /**
         * <p>
         * The telephony settings associated with the user.
         * </p>
         * 
         * @param telephony
         *        The telephony settings associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telephony(TelephonySettings telephony);

        /**
         * <p>
         * The telephony settings associated with the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link TelephonySettings.Builder} avoiding the
         * need to create one manually via {@link TelephonySettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelephonySettings.Builder#build()} is called immediately and its
         * result is passed to {@link #telephony(TelephonySettings)}.
         * 
         * @param telephony
         *        a consumer that will call methods on {@link TelephonySettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telephony(TelephonySettings)
         */
        default Builder telephony(Consumer<TelephonySettings.Builder> telephony) {
            return telephony(TelephonySettings.builder().applyMutation(telephony).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TelephonySettings telephony;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSettings model) {
            telephony(model.telephony);
        }

        public final TelephonySettings.Builder getTelephony() {
            return telephony != null ? telephony.toBuilder() : null;
        }

        public final void setTelephony(TelephonySettings.BuilderImpl telephony) {
            this.telephony = telephony != null ? telephony.build() : null;
        }

        @Override
        public final Builder telephony(TelephonySettings telephony) {
            this.telephony = telephony;
            return this;
        }

        @Override
        public UserSettings build() {
            return new UserSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
