/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegenerateSecurityTokenResponse extends ChimeResponse implements
        ToCopyableBuilder<RegenerateSecurityTokenResponse.Builder, RegenerateSecurityTokenResponse> {
    private static final SdkField<Bot> BOT_FIELD = SdkField.<Bot> builder(MarshallingType.SDK_POJO).memberName("Bot")
            .getter(getter(RegenerateSecurityTokenResponse::bot)).setter(setter(Builder::bot)).constructor(Bot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_FIELD));

    private final Bot bot;

    private RegenerateSecurityTokenResponse(BuilderImpl builder) {
        super(builder);
        this.bot = builder.bot;
    }

    /**
     * <p>
     * A resource that allows Enterprise account administrators to configure an interface that receives events from
     * Amazon Chime.
     * </p>
     * 
     * @return A resource that allows Enterprise account administrators to configure an interface that receives events
     *         from Amazon Chime.
     */
    public final Bot bot() {
        return bot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegenerateSecurityTokenResponse)) {
            return false;
        }
        RegenerateSecurityTokenResponse other = (RegenerateSecurityTokenResponse) obj;
        return Objects.equals(bot(), other.bot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegenerateSecurityTokenResponse").add("Bot", bot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bot":
            return Optional.ofNullable(clazz.cast(bot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegenerateSecurityTokenResponse, T> g) {
        return obj -> g.apply((RegenerateSecurityTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, RegenerateSecurityTokenResponse> {
        /**
         * <p>
         * A resource that allows Enterprise account administrators to configure an interface that receives events from
         * Amazon Chime.
         * </p>
         * 
         * @param bot
         *        A resource that allows Enterprise account administrators to configure an interface that receives
         *        events from Amazon Chime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bot(Bot bot);

        /**
         * <p>
         * A resource that allows Enterprise account administrators to configure an interface that receives events from
         * Amazon Chime.
         * </p>
         * This is a convenience method that creates an instance of the {@link Bot.Builder} avoiding the need to create
         * one manually via {@link Bot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Bot.Builder#build()} is called immediately and its result is
         * passed to {@link #bot(Bot)}.
         * 
         * @param bot
         *        a consumer that will call methods on {@link Bot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bot(Bot)
         */
        default Builder bot(Consumer<Bot.Builder> bot) {
            return bot(Bot.builder().applyMutation(bot).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private Bot bot;

        private BuilderImpl() {
        }

        private BuilderImpl(RegenerateSecurityTokenResponse model) {
            super(model);
            bot(model.bot);
        }

        public final Bot.Builder getBot() {
            return bot != null ? bot.toBuilder() : null;
        }

        public final void setBot(Bot.BuilderImpl bot) {
            this.bot = bot != null ? bot.build() : null;
        }

        @Override
        public final Builder bot(Bot bot) {
            this.bot = bot;
            return this;
        }

        @Override
        public RegenerateSecurityTokenResponse build() {
            return new RegenerateSecurityTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
