/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRetentionSettingsResponse extends ChimeResponse implements
        ToCopyableBuilder<GetRetentionSettingsResponse.Builder, GetRetentionSettingsResponse> {
    private static final SdkField<RetentionSettings> RETENTION_SETTINGS_FIELD = SdkField
            .<RetentionSettings> builder(MarshallingType.SDK_POJO).memberName("RetentionSettings")
            .getter(getter(GetRetentionSettingsResponse::retentionSettings)).setter(setter(Builder::retentionSettings))
            .constructor(RetentionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionSettings").build()).build();

    private static final SdkField<Instant> INITIATE_DELETION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("InitiateDeletionTimestamp")
            .getter(getter(GetRetentionSettingsResponse::initiateDeletionTimestamp))
            .setter(setter(Builder::initiateDeletionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiateDeletionTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_SETTINGS_FIELD,
            INITIATE_DELETION_TIMESTAMP_FIELD));

    private final RetentionSettings retentionSettings;

    private final Instant initiateDeletionTimestamp;

    private GetRetentionSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.retentionSettings = builder.retentionSettings;
        this.initiateDeletionTimestamp = builder.initiateDeletionTimestamp;
    }

    /**
     * <p>
     * The retention settings.
     * </p>
     * 
     * @return The retention settings.
     */
    public final RetentionSettings retentionSettings() {
        return retentionSettings;
    }

    /**
     * <p>
     * The timestamp representing the time at which the specified items are permanently deleted, in ISO 8601 format.
     * </p>
     * 
     * @return The timestamp representing the time at which the specified items are permanently deleted, in ISO 8601
     *         format.
     */
    public final Instant initiateDeletionTimestamp() {
        return initiateDeletionTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(retentionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(initiateDeletionTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRetentionSettingsResponse)) {
            return false;
        }
        GetRetentionSettingsResponse other = (GetRetentionSettingsResponse) obj;
        return Objects.equals(retentionSettings(), other.retentionSettings())
                && Objects.equals(initiateDeletionTimestamp(), other.initiateDeletionTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRetentionSettingsResponse").add("RetentionSettings", retentionSettings())
                .add("InitiateDeletionTimestamp", initiateDeletionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionSettings":
            return Optional.ofNullable(clazz.cast(retentionSettings()));
        case "InitiateDeletionTimestamp":
            return Optional.ofNullable(clazz.cast(initiateDeletionTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRetentionSettingsResponse, T> g) {
        return obj -> g.apply((GetRetentionSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRetentionSettingsResponse> {
        /**
         * <p>
         * The retention settings.
         * </p>
         * 
         * @param retentionSettings
         *        The retention settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionSettings(RetentionSettings retentionSettings);

        /**
         * <p>
         * The retention settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionSettings.Builder} avoiding the
         * need to create one manually via {@link RetentionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionSettings(RetentionSettings)}.
         * 
         * @param retentionSettings
         *        a consumer that will call methods on {@link RetentionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionSettings(RetentionSettings)
         */
        default Builder retentionSettings(Consumer<RetentionSettings.Builder> retentionSettings) {
            return retentionSettings(RetentionSettings.builder().applyMutation(retentionSettings).build());
        }

        /**
         * <p>
         * The timestamp representing the time at which the specified items are permanently deleted, in ISO 8601 format.
         * </p>
         * 
         * @param initiateDeletionTimestamp
         *        The timestamp representing the time at which the specified items are permanently deleted, in ISO 8601
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiateDeletionTimestamp(Instant initiateDeletionTimestamp);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private RetentionSettings retentionSettings;

        private Instant initiateDeletionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRetentionSettingsResponse model) {
            super(model);
            retentionSettings(model.retentionSettings);
            initiateDeletionTimestamp(model.initiateDeletionTimestamp);
        }

        public final RetentionSettings.Builder getRetentionSettings() {
            return retentionSettings != null ? retentionSettings.toBuilder() : null;
        }

        public final void setRetentionSettings(RetentionSettings.BuilderImpl retentionSettings) {
            this.retentionSettings = retentionSettings != null ? retentionSettings.build() : null;
        }

        @Override
        public final Builder retentionSettings(RetentionSettings retentionSettings) {
            this.retentionSettings = retentionSettings;
            return this;
        }

        public final Instant getInitiateDeletionTimestamp() {
            return initiateDeletionTimestamp;
        }

        public final void setInitiateDeletionTimestamp(Instant initiateDeletionTimestamp) {
            this.initiateDeletionTimestamp = initiateDeletionTimestamp;
        }

        @Override
        public final Builder initiateDeletionTimestamp(Instant initiateDeletionTimestamp) {
            this.initiateDeletionTimestamp = initiateDeletionTimestamp;
            return this;
        }

        @Override
        public GetRetentionSettingsResponse build() {
            return new GetRetentionSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
