/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for the pod.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksPodPropertiesDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<EksPodPropertiesDetail.Builder, EksPodPropertiesDetail> {
    private static final SdkField<String> SERVICE_ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceAccountName").getter(getter(EksPodPropertiesDetail::serviceAccountName))
            .setter(setter(Builder::serviceAccountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountName").build())
            .build();

    private static final SdkField<Boolean> HOST_NETWORK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hostNetwork").getter(getter(EksPodPropertiesDetail::hostNetwork)).setter(setter(Builder::hostNetwork))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostNetwork").build()).build();

    private static final SdkField<String> DNS_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnsPolicy").getter(getter(EksPodPropertiesDetail::dnsPolicy)).setter(setter(Builder::dnsPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsPolicy").build()).build();

    private static final SdkField<List<EksContainerDetail>> CONTAINERS_FIELD = SdkField
            .<List<EksContainerDetail>> builder(MarshallingType.LIST)
            .memberName("containers")
            .getter(getter(EksPodPropertiesDetail::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EksContainerDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(EksContainerDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EksVolume>> VOLUMES_FIELD = SdkField
            .<List<EksVolume>> builder(MarshallingType.LIST)
            .memberName("volumes")
            .getter(getter(EksPodPropertiesDetail::volumes))
            .setter(setter(Builder::volumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EksVolume> builder(MarshallingType.SDK_POJO)
                                            .constructor(EksVolume::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> POD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("podName").getter(getter(EksPodPropertiesDetail::podName)).setter(setter(Builder::podName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podName").build()).build();

    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(EksPodPropertiesDetail::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final SdkField<EksMetadata> METADATA_FIELD = SdkField.<EksMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("metadata").getter(getter(EksPodPropertiesDetail::metadata)).setter(setter(Builder::metadata))
            .constructor(EksMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCOUNT_NAME_FIELD,
            HOST_NETWORK_FIELD, DNS_POLICY_FIELD, CONTAINERS_FIELD, VOLUMES_FIELD, POD_NAME_FIELD, NODE_NAME_FIELD,
            METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceAccountName;

    private final Boolean hostNetwork;

    private final String dnsPolicy;

    private final List<EksContainerDetail> containers;

    private final List<EksVolume> volumes;

    private final String podName;

    private final String nodeName;

    private final EksMetadata metadata;

    private EksPodPropertiesDetail(BuilderImpl builder) {
        this.serviceAccountName = builder.serviceAccountName;
        this.hostNetwork = builder.hostNetwork;
        this.dnsPolicy = builder.dnsPolicy;
        this.containers = builder.containers;
        this.volumes = builder.volumes;
        this.podName = builder.podName;
        this.nodeName = builder.nodeName;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The name of the service account that's used to run the pod. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html">Kubernetes service accounts</a> and
     * <a href="https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html">Configure a
     * Kubernetes service account to assume an IAM role</a> in the <i>Amazon EKS User Guide</i> and <a
     * href="https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/">Configure service
     * accounts for pods</a> in the <i>Kubernetes documentation</i>.
     * </p>
     * 
     * @return The name of the service account that's used to run the pod. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html">Kubernetes service
     *         accounts</a> and <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html">Configure a
     *         Kubernetes service account to assume an IAM role</a> in the <i>Amazon EKS User Guide</i> and <a
     *         href="https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/">Configure
     *         service accounts for pods</a> in the <i>Kubernetes documentation</i>.
     */
    public final String serviceAccountName() {
        return serviceAccountName;
    }

    /**
     * <p>
     * Indicates if the pod uses the hosts' network IP address. The default value is <code>true</code>. Setting this to
     * <code>false</code> enables the Kubernetes pod networking model. Most Batch workloads are egress-only and don't
     * require the overhead of IP allocation for each pod for incoming connections. For more information, see <a
     * href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces">Host namespaces</a> and
     * <a href="https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking">Pod networking</a> in the
     * <i>Kubernetes documentation</i>.
     * </p>
     * 
     * @return Indicates if the pod uses the hosts' network IP address. The default value is <code>true</code>. Setting
     *         this to <code>false</code> enables the Kubernetes pod networking model. Most Batch workloads are
     *         egress-only and don't require the overhead of IP allocation for each pod for incoming connections. For
     *         more information, see <a
     *         href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces">Host
     *         namespaces</a> and <a href="https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking">Pod
     *         networking</a> in the <i>Kubernetes documentation</i>.
     */
    public final Boolean hostNetwork() {
        return hostNetwork;
    }

    /**
     * <p>
     * The DNS policy for the pod. The default value is <code>ClusterFirst</code>. If the <code>hostNetwork</code>
     * parameter is not specified, the default is <code>ClusterFirstWithHostNet</code>. <code>ClusterFirst</code>
     * indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the
     * upstream nameserver inherited from the node. If no value was specified for <code>dnsPolicy</code> in the <a
     * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html"
     * >RegisterJobDefinition</a> API operation, then no value will be returned for <code>dnsPolicy</code> by either of
     * <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobDefinitions.html">
     * DescribeJobDefinitions</a> or <a
     * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobs.html">DescribeJobs</a> API
     * operations. The pod spec setting will contain either <code>ClusterFirst</code> or
     * <code>ClusterFirstWithHostNet</code>, depending on the value of the <code>hostNetwork</code> parameter. For more
     * information, see <a
     * href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy">Pod's DNS
     * policy</a> in the <i>Kubernetes documentation</i>.
     * </p>
     * <p>
     * Valid values: <code>Default</code> | <code>ClusterFirst</code> | <code>ClusterFirstWithHostNet</code>
     * </p>
     * 
     * @return The DNS policy for the pod. The default value is <code>ClusterFirst</code>. If the
     *         <code>hostNetwork</code> parameter is not specified, the default is <code>ClusterFirstWithHostNet</code>.
     *         <code>ClusterFirst</code> indicates that any DNS query that does not match the configured cluster domain
     *         suffix is forwarded to the upstream nameserver inherited from the node. If no value was specified for
     *         <code>dnsPolicy</code> in the <a
     *         href="https://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html"
     *         >RegisterJobDefinition</a> API operation, then no value will be returned for <code>dnsPolicy</code> by
     *         either of <a
     *         href="https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobDefinitions.html">
     *         DescribeJobDefinitions</a> or <a
     *         href="https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobs.html">DescribeJobs</a> API
     *         operations. The pod spec setting will contain either <code>ClusterFirst</code> or
     *         <code>ClusterFirstWithHostNet</code>, depending on the value of the <code>hostNetwork</code> parameter.
     *         For more information, see <a
     *         href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy">Pod's
     *         DNS policy</a> in the <i>Kubernetes documentation</i>.</p>
     *         <p>
     *         Valid values: <code>Default</code> | <code>ClusterFirst</code> | <code>ClusterFirstWithHostNet</code>
     */
    public final String dnsPolicy() {
        return dnsPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties of the container that's used on the Amazon EKS pod.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return The properties of the container that's used on the Amazon EKS pod.
     */
    public final List<EksContainerDetail> containers() {
        return containers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Volumes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVolumes() {
        return volumes != null && !(volumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the volumes for a job definition using Amazon EKS resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumes} method.
     * </p>
     * 
     * @return Specifies the volumes for a job definition using Amazon EKS resources.
     */
    public final List<EksVolume> volumes() {
        return volumes;
    }

    /**
     * <p>
     * The name of the pod for this job.
     * </p>
     * 
     * @return The name of the pod for this job.
     */
    public final String podName() {
        return podName;
    }

    /**
     * <p>
     * The name of the node for this job.
     * </p>
     * 
     * @return The name of the node for this job.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * Describes and uniquely identifies Kubernetes resources. For example, the compute environment that a pod runs in
     * or the <code>jobID</code> for a job running in the pod. For more information, see <a
     * href="https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/">Understanding
     * Kubernetes Objects</a> in the <i>Kubernetes documentation</i>.
     * </p>
     * 
     * @return Describes and uniquely identifies Kubernetes resources. For example, the compute environment that a pod
     *         runs in or the <code>jobID</code> for a job running in the pod. For more information, see <a
     *         href="https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/"
     *         >Understanding Kubernetes Objects</a> in the <i>Kubernetes documentation</i>.
     */
    public final EksMetadata metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(hostNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(dnsPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumes() ? volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(podName());
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksPodPropertiesDetail)) {
            return false;
        }
        EksPodPropertiesDetail other = (EksPodPropertiesDetail) obj;
        return Objects.equals(serviceAccountName(), other.serviceAccountName())
                && Objects.equals(hostNetwork(), other.hostNetwork()) && Objects.equals(dnsPolicy(), other.dnsPolicy())
                && hasContainers() == other.hasContainers() && Objects.equals(containers(), other.containers())
                && hasVolumes() == other.hasVolumes() && Objects.equals(volumes(), other.volumes())
                && Objects.equals(podName(), other.podName()) && Objects.equals(nodeName(), other.nodeName())
                && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksPodPropertiesDetail").add("ServiceAccountName", serviceAccountName())
                .add("HostNetwork", hostNetwork()).add("DnsPolicy", dnsPolicy())
                .add("Containers", hasContainers() ? containers() : null).add("Volumes", hasVolumes() ? volumes() : null)
                .add("PodName", podName()).add("NodeName", nodeName()).add("Metadata", metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceAccountName":
            return Optional.ofNullable(clazz.cast(serviceAccountName()));
        case "hostNetwork":
            return Optional.ofNullable(clazz.cast(hostNetwork()));
        case "dnsPolicy":
            return Optional.ofNullable(clazz.cast(dnsPolicy()));
        case "containers":
            return Optional.ofNullable(clazz.cast(containers()));
        case "volumes":
            return Optional.ofNullable(clazz.cast(volumes()));
        case "podName":
            return Optional.ofNullable(clazz.cast(podName()));
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EksPodPropertiesDetail, T> g) {
        return obj -> g.apply((EksPodPropertiesDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksPodPropertiesDetail> {
        /**
         * <p>
         * The name of the service account that's used to run the pod. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html">Kubernetes service accounts</a>
         * and <a href="https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html">Configure
         * a Kubernetes service account to assume an IAM role</a> in the <i>Amazon EKS User Guide</i> and <a
         * href="https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/">Configure service
         * accounts for pods</a> in the <i>Kubernetes documentation</i>.
         * </p>
         * 
         * @param serviceAccountName
         *        The name of the service account that's used to run the pod. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html">Kubernetes service
         *        accounts</a> and <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html">Configure
         *        a Kubernetes service account to assume an IAM role</a> in the <i>Amazon EKS User Guide</i> and <a
         *        href="https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/">Configure
         *        service accounts for pods</a> in the <i>Kubernetes documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountName(String serviceAccountName);

        /**
         * <p>
         * Indicates if the pod uses the hosts' network IP address. The default value is <code>true</code>. Setting this
         * to <code>false</code> enables the Kubernetes pod networking model. Most Batch workloads are egress-only and
         * don't require the overhead of IP allocation for each pod for incoming connections. For more information, see
         * <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces">Host
         * namespaces</a> and <a href="https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking">Pod
         * networking</a> in the <i>Kubernetes documentation</i>.
         * </p>
         * 
         * @param hostNetwork
         *        Indicates if the pod uses the hosts' network IP address. The default value is <code>true</code>.
         *        Setting this to <code>false</code> enables the Kubernetes pod networking model. Most Batch workloads
         *        are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
         *        For more information, see <a
         *        href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces">Host
         *        namespaces</a> and <a href="https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking">Pod
         *        networking</a> in the <i>Kubernetes documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostNetwork(Boolean hostNetwork);

        /**
         * <p>
         * The DNS policy for the pod. The default value is <code>ClusterFirst</code>. If the <code>hostNetwork</code>
         * parameter is not specified, the default is <code>ClusterFirstWithHostNet</code>. <code>ClusterFirst</code>
         * indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the
         * upstream nameserver inherited from the node. If no value was specified for <code>dnsPolicy</code> in the <a
         * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html">
         * RegisterJobDefinition</a> API operation, then no value will be returned for <code>dnsPolicy</code> by either
         * of <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobDefinitions.html">
         * DescribeJobDefinitions</a> or <a
         * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobs.html">DescribeJobs</a> API
         * operations. The pod spec setting will contain either <code>ClusterFirst</code> or
         * <code>ClusterFirstWithHostNet</code>, depending on the value of the <code>hostNetwork</code> parameter. For
         * more information, see <a
         * href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy">Pod's DNS
         * policy</a> in the <i>Kubernetes documentation</i>.
         * </p>
         * <p>
         * Valid values: <code>Default</code> | <code>ClusterFirst</code> | <code>ClusterFirstWithHostNet</code>
         * </p>
         * 
         * @param dnsPolicy
         *        The DNS policy for the pod. The default value is <code>ClusterFirst</code>. If the
         *        <code>hostNetwork</code> parameter is not specified, the default is
         *        <code>ClusterFirstWithHostNet</code>. <code>ClusterFirst</code> indicates that any DNS query that does
         *        not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from
         *        the node. If no value was specified for <code>dnsPolicy</code> in the <a
         *        href="https://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html"
         *        >RegisterJobDefinition</a> API operation, then no value will be returned for <code>dnsPolicy</code> by
         *        either of <a
         *        href="https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobDefinitions.html"
         *        >DescribeJobDefinitions</a> or <a
         *        href="https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobs.html">DescribeJobs</a>
         *        API operations. The pod spec setting will contain either <code>ClusterFirst</code> or
         *        <code>ClusterFirstWithHostNet</code>, depending on the value of the <code>hostNetwork</code>
         *        parameter. For more information, see <a
         *        href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy">Pod's
         *        DNS policy</a> in the <i>Kubernetes documentation</i>.</p>
         *        <p>
         *        Valid values: <code>Default</code> | <code>ClusterFirst</code> | <code>ClusterFirstWithHostNet</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsPolicy(String dnsPolicy);

        /**
         * <p>
         * The properties of the container that's used on the Amazon EKS pod.
         * </p>
         * 
         * @param containers
         *        The properties of the container that's used on the Amazon EKS pod.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<EksContainerDetail> containers);

        /**
         * <p>
         * The properties of the container that's used on the Amazon EKS pod.
         * </p>
         * 
         * @param containers
         *        The properties of the container that's used on the Amazon EKS pod.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(EksContainerDetail... containers);

        /**
         * <p>
         * The properties of the container that's used on the Amazon EKS pod.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.EksContainerDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.batch.model.EksContainerDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.EksContainerDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #containers(List<EksContainerDetail>)}.
         * 
         * @param containers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.EksContainerDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(java.util.Collection<EksContainerDetail>)
         */
        Builder containers(Consumer<EksContainerDetail.Builder>... containers);

        /**
         * <p>
         * Specifies the volumes for a job definition using Amazon EKS resources.
         * </p>
         * 
         * @param volumes
         *        Specifies the volumes for a job definition using Amazon EKS resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<EksVolume> volumes);

        /**
         * <p>
         * Specifies the volumes for a job definition using Amazon EKS resources.
         * </p>
         * 
         * @param volumes
         *        Specifies the volumes for a job definition using Amazon EKS resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(EksVolume... volumes);

        /**
         * <p>
         * Specifies the volumes for a job definition using Amazon EKS resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.EksVolume.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.batch.model.EksVolume#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.EksVolume.Builder#build()} is called immediately and its
         * result is passed to {@link #volumes(List<EksVolume>)}.
         * 
         * @param volumes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.EksVolume.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumes(java.util.Collection<EksVolume>)
         */
        Builder volumes(Consumer<EksVolume.Builder>... volumes);

        /**
         * <p>
         * The name of the pod for this job.
         * </p>
         * 
         * @param podName
         *        The name of the pod for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder podName(String podName);

        /**
         * <p>
         * The name of the node for this job.
         * </p>
         * 
         * @param nodeName
         *        The name of the node for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * Describes and uniquely identifies Kubernetes resources. For example, the compute environment that a pod runs
         * in or the <code>jobID</code> for a job running in the pod. For more information, see <a
         * href="https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/">Understanding
         * Kubernetes Objects</a> in the <i>Kubernetes documentation</i>.
         * </p>
         * 
         * @param metadata
         *        Describes and uniquely identifies Kubernetes resources. For example, the compute environment that a
         *        pod runs in or the <code>jobID</code> for a job running in the pod. For more information, see <a
         *        href="https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/"
         *        >Understanding Kubernetes Objects</a> in the <i>Kubernetes documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(EksMetadata metadata);

        /**
         * <p>
         * Describes and uniquely identifies Kubernetes resources. For example, the compute environment that a pod runs
         * in or the <code>jobID</code> for a job running in the pod. For more information, see <a
         * href="https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/">Understanding
         * Kubernetes Objects</a> in the <i>Kubernetes documentation</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksMetadata.Builder} avoiding the need to
         * create one manually via {@link EksMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksMetadata.Builder#build()} is called immediately and its result
         * is passed to {@link #metadata(EksMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link EksMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(EksMetadata)
         */
        default Builder metadata(Consumer<EksMetadata.Builder> metadata) {
            return metadata(EksMetadata.builder().applyMutation(metadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String serviceAccountName;

        private Boolean hostNetwork;

        private String dnsPolicy;

        private List<EksContainerDetail> containers = DefaultSdkAutoConstructList.getInstance();

        private List<EksVolume> volumes = DefaultSdkAutoConstructList.getInstance();

        private String podName;

        private String nodeName;

        private EksMetadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(EksPodPropertiesDetail model) {
            serviceAccountName(model.serviceAccountName);
            hostNetwork(model.hostNetwork);
            dnsPolicy(model.dnsPolicy);
            containers(model.containers);
            volumes(model.volumes);
            podName(model.podName);
            nodeName(model.nodeName);
            metadata(model.metadata);
        }

        public final String getServiceAccountName() {
            return serviceAccountName;
        }

        public final void setServiceAccountName(String serviceAccountName) {
            this.serviceAccountName = serviceAccountName;
        }

        @Override
        public final Builder serviceAccountName(String serviceAccountName) {
            this.serviceAccountName = serviceAccountName;
            return this;
        }

        public final Boolean getHostNetwork() {
            return hostNetwork;
        }

        public final void setHostNetwork(Boolean hostNetwork) {
            this.hostNetwork = hostNetwork;
        }

        @Override
        public final Builder hostNetwork(Boolean hostNetwork) {
            this.hostNetwork = hostNetwork;
            return this;
        }

        public final String getDnsPolicy() {
            return dnsPolicy;
        }

        public final void setDnsPolicy(String dnsPolicy) {
            this.dnsPolicy = dnsPolicy;
        }

        @Override
        public final Builder dnsPolicy(String dnsPolicy) {
            this.dnsPolicy = dnsPolicy;
            return this;
        }

        public final List<EksContainerDetail.Builder> getContainers() {
            List<EksContainerDetail.Builder> result = EksContainerDetailsCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<EksContainerDetail.BuilderImpl> containers) {
            this.containers = EksContainerDetailsCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<EksContainerDetail> containers) {
            this.containers = EksContainerDetailsCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(EksContainerDetail... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<EksContainerDetail.Builder>... containers) {
            containers(Stream.of(containers).map(c -> EksContainerDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<EksVolume.Builder> getVolumes() {
            List<EksVolume.Builder> result = EksVolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<EksVolume.BuilderImpl> volumes) {
            this.volumes = EksVolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<EksVolume> volumes) {
            this.volumes = EksVolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(EksVolume... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<EksVolume.Builder>... volumes) {
            volumes(Stream.of(volumes).map(c -> EksVolume.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPodName() {
            return podName;
        }

        public final void setPodName(String podName) {
            this.podName = podName;
        }

        @Override
        public final Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final EksMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(EksMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(EksMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public EksPodPropertiesDetail build() {
            return new EksPodPropertiesDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
