/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains metadata about a restore testing plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTestingPlanForUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<RestoreTestingPlanForUpdate.Builder, RestoreTestingPlanForUpdate> {
    private static final SdkField<RestoreTestingRecoveryPointSelection> RECOVERY_POINT_SELECTION_FIELD = SdkField
            .<RestoreTestingRecoveryPointSelection> builder(MarshallingType.SDK_POJO).memberName("RecoveryPointSelection")
            .getter(getter(RestoreTestingPlanForUpdate::recoveryPointSelection)).setter(setter(Builder::recoveryPointSelection))
            .constructor(RestoreTestingRecoveryPointSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointSelection").build())
            .build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(RestoreTestingPlanForUpdate::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_TIMEZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpressionTimezone")
            .getter(getter(RestoreTestingPlanForUpdate::scheduleExpressionTimezone))
            .setter(setter(Builder::scheduleExpressionTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpressionTimezone").build())
            .build();

    private static final SdkField<Integer> START_WINDOW_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartWindowHours").getter(getter(RestoreTestingPlanForUpdate::startWindowHours))
            .setter(setter(Builder::startWindowHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartWindowHours").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RECOVERY_POINT_SELECTION_FIELD, SCHEDULE_EXPRESSION_FIELD, SCHEDULE_EXPRESSION_TIMEZONE_FIELD,
            START_WINDOW_HOURS_FIELD));

    private static final long serialVersionUID = 1L;

    private final RestoreTestingRecoveryPointSelection recoveryPointSelection;

    private final String scheduleExpression;

    private final String scheduleExpressionTimezone;

    private final Integer startWindowHours;

    private RestoreTestingPlanForUpdate(BuilderImpl builder) {
        this.recoveryPointSelection = builder.recoveryPointSelection;
        this.scheduleExpression = builder.scheduleExpression;
        this.scheduleExpressionTimezone = builder.scheduleExpressionTimezone;
        this.startWindowHours = builder.startWindowHours;
    }

    /**
     * <p>
     * Required: <code>Algorithm</code>; <code>RecoveryPointTypes</code>; <code>IncludeVaults</code> (<i>one or
     * more</i>).
     * </p>
     * <p>
     * Optional: <i>SelectionWindowDays</i> (<i>'30' if not specified</i>); <code>ExcludeVaults</code> (defaults to
     * empty list if not listed).
     * </p>
     * 
     * @return Required: <code>Algorithm</code>; <code>RecoveryPointTypes</code>; <code>IncludeVaults</code> (<i>one or
     *         more</i>).</p>
     *         <p>
     *         Optional: <i>SelectionWindowDays</i> (<i>'30' if not specified</i>); <code>ExcludeVaults</code> (defaults
     *         to empty list if not listed).
     */
    public final RestoreTestingRecoveryPointSelection recoveryPointSelection() {
        return recoveryPointSelection;
    }

    /**
     * <p>
     * A CRON expression in specified timezone when a restore testing plan is executed.
     * </p>
     * 
     * @return A CRON expression in specified timezone when a restore testing plan is executed.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in
     * UTC. You can modify this to a specified timezone.
     * </p>
     * 
     * @return Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions
     *         are in UTC. You can modify this to a specified timezone.
     */
    public final String scheduleExpressionTimezone() {
        return scheduleExpressionTimezone;
    }

    /**
     * <p>
     * Defaults to 24 hours.
     * </p>
     * <p>
     * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
     * successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours
     * (one week).
     * </p>
     * 
     * @return Defaults to 24 hours.</p>
     *         <p>
     *         A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
     *         successfully. This value is optional. If this value is included, this parameter has a maximum value of
     *         168 hours (one week).
     */
    public final Integer startWindowHours() {
        return startWindowHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointSelection());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpressionTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(startWindowHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTestingPlanForUpdate)) {
            return false;
        }
        RestoreTestingPlanForUpdate other = (RestoreTestingPlanForUpdate) obj;
        return Objects.equals(recoveryPointSelection(), other.recoveryPointSelection())
                && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(scheduleExpressionTimezone(), other.scheduleExpressionTimezone())
                && Objects.equals(startWindowHours(), other.startWindowHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreTestingPlanForUpdate").add("RecoveryPointSelection", recoveryPointSelection())
                .add("ScheduleExpression", scheduleExpression()).add("ScheduleExpressionTimezone", scheduleExpressionTimezone())
                .add("StartWindowHours", startWindowHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecoveryPointSelection":
            return Optional.ofNullable(clazz.cast(recoveryPointSelection()));
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "ScheduleExpressionTimezone":
            return Optional.ofNullable(clazz.cast(scheduleExpressionTimezone()));
        case "StartWindowHours":
            return Optional.ofNullable(clazz.cast(startWindowHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTestingPlanForUpdate, T> g) {
        return obj -> g.apply((RestoreTestingPlanForUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestoreTestingPlanForUpdate> {
        /**
         * <p>
         * Required: <code>Algorithm</code>; <code>RecoveryPointTypes</code>; <code>IncludeVaults</code> (<i>one or
         * more</i>).
         * </p>
         * <p>
         * Optional: <i>SelectionWindowDays</i> (<i>'30' if not specified</i>); <code>ExcludeVaults</code> (defaults to
         * empty list if not listed).
         * </p>
         * 
         * @param recoveryPointSelection
         *        Required: <code>Algorithm</code>; <code>RecoveryPointTypes</code>; <code>IncludeVaults</code> (<i>one
         *        or more</i>).</p>
         *        <p>
         *        Optional: <i>SelectionWindowDays</i> (<i>'30' if not specified</i>); <code>ExcludeVaults</code>
         *        (defaults to empty list if not listed).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointSelection(RestoreTestingRecoveryPointSelection recoveryPointSelection);

        /**
         * <p>
         * Required: <code>Algorithm</code>; <code>RecoveryPointTypes</code>; <code>IncludeVaults</code> (<i>one or
         * more</i>).
         * </p>
         * <p>
         * Optional: <i>SelectionWindowDays</i> (<i>'30' if not specified</i>); <code>ExcludeVaults</code> (defaults to
         * empty list if not listed).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RestoreTestingRecoveryPointSelection.Builder} avoiding the need to create one manually via
         * {@link RestoreTestingRecoveryPointSelection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RestoreTestingRecoveryPointSelection.Builder#build()} is called
         * immediately and its result is passed to {@link #recoveryPointSelection(RestoreTestingRecoveryPointSelection)}.
         * 
         * @param recoveryPointSelection
         *        a consumer that will call methods on {@link RestoreTestingRecoveryPointSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recoveryPointSelection(RestoreTestingRecoveryPointSelection)
         */
        default Builder recoveryPointSelection(Consumer<RestoreTestingRecoveryPointSelection.Builder> recoveryPointSelection) {
            return recoveryPointSelection(RestoreTestingRecoveryPointSelection.builder().applyMutation(recoveryPointSelection)
                    .build());
        }

        /**
         * <p>
         * A CRON expression in specified timezone when a restore testing plan is executed.
         * </p>
         * 
         * @param scheduleExpression
         *        A CRON expression in specified timezone when a restore testing plan is executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are
         * in UTC. You can modify this to a specified timezone.
         * </p>
         * 
         * @param scheduleExpressionTimezone
         *        Optional. This is the timezone in which the schedule expression is set. By default,
         *        ScheduleExpressions are in UTC. You can modify this to a specified timezone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpressionTimezone(String scheduleExpressionTimezone);

        /**
         * <p>
         * Defaults to 24 hours.
         * </p>
         * <p>
         * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
         * successfully. This value is optional. If this value is included, this parameter has a maximum value of 168
         * hours (one week).
         * </p>
         * 
         * @param startWindowHours
         *        Defaults to 24 hours.</p>
         *        <p>
         *        A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
         *        successfully. This value is optional. If this value is included, this parameter has a maximum value of
         *        168 hours (one week).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startWindowHours(Integer startWindowHours);
    }

    static final class BuilderImpl implements Builder {
        private RestoreTestingRecoveryPointSelection recoveryPointSelection;

        private String scheduleExpression;

        private String scheduleExpressionTimezone;

        private Integer startWindowHours;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTestingPlanForUpdate model) {
            recoveryPointSelection(model.recoveryPointSelection);
            scheduleExpression(model.scheduleExpression);
            scheduleExpressionTimezone(model.scheduleExpressionTimezone);
            startWindowHours(model.startWindowHours);
        }

        public final RestoreTestingRecoveryPointSelection.Builder getRecoveryPointSelection() {
            return recoveryPointSelection != null ? recoveryPointSelection.toBuilder() : null;
        }

        public final void setRecoveryPointSelection(RestoreTestingRecoveryPointSelection.BuilderImpl recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection != null ? recoveryPointSelection.build() : null;
        }

        @Override
        public final Builder recoveryPointSelection(RestoreTestingRecoveryPointSelection recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection;
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getScheduleExpressionTimezone() {
            return scheduleExpressionTimezone;
        }

        public final void setScheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
        }

        @Override
        public final Builder scheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
            return this;
        }

        public final Integer getStartWindowHours() {
            return startWindowHours;
        }

        public final void setStartWindowHours(Integer startWindowHours) {
            this.startWindowHours = startWindowHours;
        }

        @Override
        public final Builder startWindowHours(Integer startWindowHours) {
            this.startWindowHours = startWindowHours;
            return this;
        }

        @Override
        public RestoreTestingPlanForUpdate build() {
            return new RestoreTestingPlanForUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
