/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains metadata about a restore testing plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTestingPlanForList implements SdkPojo, Serializable,
        ToCopyableBuilder<RestoreTestingPlanForList.Builder, RestoreTestingPlanForList> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(RestoreTestingPlanForList::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_EXECUTION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastExecutionTime").getter(getter(RestoreTestingPlanForList::lastExecutionTime))
            .setter(setter(Builder::lastExecutionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(RestoreTestingPlanForList::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanArn").getter(getter(RestoreTestingPlanForList::restoreTestingPlanArn))
            .setter(setter(Builder::restoreTestingPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanArn").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanName").getter(getter(RestoreTestingPlanForList::restoreTestingPlanName))
            .setter(setter(Builder::restoreTestingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanName").build())
            .build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(RestoreTestingPlanForList::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_TIMEZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpressionTimezone")
            .getter(getter(RestoreTestingPlanForList::scheduleExpressionTimezone))
            .setter(setter(Builder::scheduleExpressionTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpressionTimezone").build())
            .build();

    private static final SdkField<Integer> START_WINDOW_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartWindowHours").getter(getter(RestoreTestingPlanForList::startWindowHours))
            .setter(setter(Builder::startWindowHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartWindowHours").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            LAST_EXECUTION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, RESTORE_TESTING_PLAN_ARN_FIELD, RESTORE_TESTING_PLAN_NAME_FIELD,
            SCHEDULE_EXPRESSION_FIELD, SCHEDULE_EXPRESSION_TIMEZONE_FIELD, START_WINDOW_HOURS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final Instant lastExecutionTime;

    private final Instant lastUpdateTime;

    private final String restoreTestingPlanArn;

    private final String restoreTestingPlanName;

    private final String scheduleExpression;

    private final String scheduleExpressionTimezone;

    private final Integer startWindowHours;

    private RestoreTestingPlanForList(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.lastExecutionTime = builder.lastExecutionTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.restoreTestingPlanArn = builder.restoreTestingPlanArn;
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
        this.scheduleExpression = builder.scheduleExpression;
        this.scheduleExpressionTimezone = builder.scheduleExpressionTimezone;
        this.startWindowHours = builder.startWindowHours;
    }

    /**
     * <p>
     * The date and time that a restore testing plan was created, in Unix format and Coordinated Universal Time (UTC).
     * The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a restore testing plan was created, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time a restore test was run with the specified restore testing plan. A date and time, in Unix format and
     * Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For
     * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The last time a restore test was run with the specified restore testing plan. A date and time, in Unix
     *         format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to
     *         milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant lastExecutionTime() {
        return lastExecutionTime;
    }

    /**
     * <p>
     * The date and time that the restore testing plan was updated. This update is in Unix format and Coordinated
     * Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the
     * value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that the restore testing plan was updated. This update is in Unix format and
     *         Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds.
     *         For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifiesa restore testing plan.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifiesa restore testing plan.
     */
    public final String restoreTestingPlanArn() {
        return restoreTestingPlanArn;
    }

    /**
     * <p>
     * This is the restore testing plan name.
     * </p>
     * 
     * @return This is the restore testing plan name.
     */
    public final String restoreTestingPlanName() {
        return restoreTestingPlanName;
    }

    /**
     * <p>
     * A CRON expression in specified timezone when a restore testing plan is executed.
     * </p>
     * 
     * @return A CRON expression in specified timezone when a restore testing plan is executed.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in
     * UTC. You can modify this to a specified timezone.
     * </p>
     * 
     * @return Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions
     *         are in UTC. You can modify this to a specified timezone.
     */
    public final String scheduleExpressionTimezone() {
        return scheduleExpressionTimezone;
    }

    /**
     * <p>
     * Defaults to 24 hours.
     * </p>
     * <p>
     * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
     * successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours
     * (one week).
     * </p>
     * 
     * @return Defaults to 24 hours.</p>
     *         <p>
     *         A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
     *         successfully. This value is optional. If this value is included, this parameter has a maximum value of
     *         168 hours (one week).
     */
    public final Integer startWindowHours() {
        return startWindowHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutionTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpressionTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(startWindowHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTestingPlanForList)) {
            return false;
        }
        RestoreTestingPlanForList other = (RestoreTestingPlanForList) obj;
        return Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastExecutionTime(), other.lastExecutionTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(restoreTestingPlanArn(), other.restoreTestingPlanArn())
                && Objects.equals(restoreTestingPlanName(), other.restoreTestingPlanName())
                && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(scheduleExpressionTimezone(), other.scheduleExpressionTimezone())
                && Objects.equals(startWindowHours(), other.startWindowHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreTestingPlanForList").add("CreationTime", creationTime())
                .add("LastExecutionTime", lastExecutionTime()).add("LastUpdateTime", lastUpdateTime())
                .add("RestoreTestingPlanArn", restoreTestingPlanArn()).add("RestoreTestingPlanName", restoreTestingPlanName())
                .add("ScheduleExpression", scheduleExpression()).add("ScheduleExpressionTimezone", scheduleExpressionTimezone())
                .add("StartWindowHours", startWindowHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastExecutionTime":
            return Optional.ofNullable(clazz.cast(lastExecutionTime()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "RestoreTestingPlanArn":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanArn()));
        case "RestoreTestingPlanName":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanName()));
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "ScheduleExpressionTimezone":
            return Optional.ofNullable(clazz.cast(scheduleExpressionTimezone()));
        case "StartWindowHours":
            return Optional.ofNullable(clazz.cast(startWindowHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTestingPlanForList, T> g) {
        return obj -> g.apply((RestoreTestingPlanForList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestoreTestingPlanForList> {
        /**
         * <p>
         * The date and time that a restore testing plan was created, in Unix format and Coordinated Universal Time
         * (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         * 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time that a restore testing plan was created, in Unix format and Coordinated Universal
         *        Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time a restore test was run with the specified restore testing plan. A date and time, in Unix format
         * and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to
         * milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastExecutionTime
         *        The last time a restore test was run with the specified restore testing plan. A date and time, in Unix
         *        format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate
         *        to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
         *        12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastExecutionTime(Instant lastExecutionTime);

        /**
         * <p>
         * The date and time that the restore testing plan was updated. This update is in Unix format and Coordinated
         * Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the
         * value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastUpdateTime
         *        The date and time that the restore testing plan was updated. This update is in Unix format and
         *        Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to
         *        milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
         *        AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifiesa restore testing plan.
         * </p>
         * 
         * @param restoreTestingPlanArn
         *        An Amazon Resource Name (ARN) that uniquely identifiesa restore testing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanArn(String restoreTestingPlanArn);

        /**
         * <p>
         * This is the restore testing plan name.
         * </p>
         * 
         * @param restoreTestingPlanName
         *        This is the restore testing plan name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanName(String restoreTestingPlanName);

        /**
         * <p>
         * A CRON expression in specified timezone when a restore testing plan is executed.
         * </p>
         * 
         * @param scheduleExpression
         *        A CRON expression in specified timezone when a restore testing plan is executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are
         * in UTC. You can modify this to a specified timezone.
         * </p>
         * 
         * @param scheduleExpressionTimezone
         *        Optional. This is the timezone in which the schedule expression is set. By default,
         *        ScheduleExpressions are in UTC. You can modify this to a specified timezone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpressionTimezone(String scheduleExpressionTimezone);

        /**
         * <p>
         * Defaults to 24 hours.
         * </p>
         * <p>
         * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
         * successfully. This value is optional. If this value is included, this parameter has a maximum value of 168
         * hours (one week).
         * </p>
         * 
         * @param startWindowHours
         *        Defaults to 24 hours.</p>
         *        <p>
         *        A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
         *        successfully. This value is optional. If this value is included, this parameter has a maximum value of
         *        168 hours (one week).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startWindowHours(Integer startWindowHours);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private Instant lastExecutionTime;

        private Instant lastUpdateTime;

        private String restoreTestingPlanArn;

        private String restoreTestingPlanName;

        private String scheduleExpression;

        private String scheduleExpressionTimezone;

        private Integer startWindowHours;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTestingPlanForList model) {
            creationTime(model.creationTime);
            lastExecutionTime(model.lastExecutionTime);
            lastUpdateTime(model.lastUpdateTime);
            restoreTestingPlanArn(model.restoreTestingPlanArn);
            restoreTestingPlanName(model.restoreTestingPlanName);
            scheduleExpression(model.scheduleExpression);
            scheduleExpressionTimezone(model.scheduleExpressionTimezone);
            startWindowHours(model.startWindowHours);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastExecutionTime() {
            return lastExecutionTime;
        }

        public final void setLastExecutionTime(Instant lastExecutionTime) {
            this.lastExecutionTime = lastExecutionTime;
        }

        @Override
        public final Builder lastExecutionTime(Instant lastExecutionTime) {
            this.lastExecutionTime = lastExecutionTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getRestoreTestingPlanArn() {
            return restoreTestingPlanArn;
        }

        public final void setRestoreTestingPlanArn(String restoreTestingPlanArn) {
            this.restoreTestingPlanArn = restoreTestingPlanArn;
        }

        @Override
        public final Builder restoreTestingPlanArn(String restoreTestingPlanArn) {
            this.restoreTestingPlanArn = restoreTestingPlanArn;
            return this;
        }

        public final String getRestoreTestingPlanName() {
            return restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getScheduleExpressionTimezone() {
            return scheduleExpressionTimezone;
        }

        public final void setScheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
        }

        @Override
        public final Builder scheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
            return this;
        }

        public final Integer getStartWindowHours() {
            return startWindowHours;
        }

        public final void setStartWindowHours(Integer startWindowHours) {
            this.startWindowHours = startWindowHours;
        }

        @Override
        public final Builder startWindowHours(Integer startWindowHours) {
            this.startWindowHours = startWindowHours;
            return this;
        }

        @Override
        public RestoreTestingPlanForList build() {
            return new RestoreTestingPlanForList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
