/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBackupPlanTemplatesResponse extends BackupResponse implements
        ToCopyableBuilder<ListBackupPlanTemplatesResponse.Builder, ListBackupPlanTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBackupPlanTemplatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<BackupPlanTemplatesListMember>> BACKUP_PLAN_TEMPLATES_LIST_FIELD = SdkField
            .<List<BackupPlanTemplatesListMember>> builder(MarshallingType.LIST)
            .memberName("BackupPlanTemplatesList")
            .getter(getter(ListBackupPlanTemplatesResponse::backupPlanTemplatesList))
            .setter(setter(Builder::backupPlanTemplatesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanTemplatesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackupPlanTemplatesListMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackupPlanTemplatesListMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            BACKUP_PLAN_TEMPLATES_LIST_FIELD));

    private final String nextToken;

    private final List<BackupPlanTemplatesListMember> backupPlanTemplatesList;

    private ListBackupPlanTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.backupPlanTemplatesList = builder.backupPlanTemplatesList;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackupPlanTemplatesList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBackupPlanTemplatesList() {
        return backupPlanTemplatesList != null && !(backupPlanTemplatesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of template list items containing metadata about your saved templates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupPlanTemplatesList} method.
     * </p>
     * 
     * @return An array of template list items containing metadata about your saved templates.
     */
    public final List<BackupPlanTemplatesListMember> backupPlanTemplatesList() {
        return backupPlanTemplatesList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupPlanTemplatesList() ? backupPlanTemplatesList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupPlanTemplatesResponse)) {
            return false;
        }
        ListBackupPlanTemplatesResponse other = (ListBackupPlanTemplatesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasBackupPlanTemplatesList() == other.hasBackupPlanTemplatesList()
                && Objects.equals(backupPlanTemplatesList(), other.backupPlanTemplatesList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBackupPlanTemplatesResponse").add("NextToken", nextToken())
                .add("BackupPlanTemplatesList", hasBackupPlanTemplatesList() ? backupPlanTemplatesList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "BackupPlanTemplatesList":
            return Optional.ofNullable(clazz.cast(backupPlanTemplatesList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupPlanTemplatesResponse, T> g) {
        return obj -> g.apply((ListBackupPlanTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBackupPlanTemplatesResponse> {
        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of template list items containing metadata about your saved templates.
         * </p>
         * 
         * @param backupPlanTemplatesList
         *        An array of template list items containing metadata about your saved templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanTemplatesList(Collection<BackupPlanTemplatesListMember> backupPlanTemplatesList);

        /**
         * <p>
         * An array of template list items containing metadata about your saved templates.
         * </p>
         * 
         * @param backupPlanTemplatesList
         *        An array of template list items containing metadata about your saved templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanTemplatesList(BackupPlanTemplatesListMember... backupPlanTemplatesList);

        /**
         * <p>
         * An array of template list items containing metadata about your saved templates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.BackupPlanTemplatesListMember.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.backup.model.BackupPlanTemplatesListMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.BackupPlanTemplatesListMember.Builder#build()} is called
         * immediately and its result is passed to {@link #backupPlanTemplatesList(List<BackupPlanTemplatesListMember>)}.
         * 
         * @param backupPlanTemplatesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.BackupPlanTemplatesListMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupPlanTemplatesList(java.util.Collection<BackupPlanTemplatesListMember>)
         */
        Builder backupPlanTemplatesList(Consumer<BackupPlanTemplatesListMember.Builder>... backupPlanTemplatesList);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<BackupPlanTemplatesListMember> backupPlanTemplatesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupPlanTemplatesResponse model) {
            super(model);
            nextToken(model.nextToken);
            backupPlanTemplatesList(model.backupPlanTemplatesList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BackupPlanTemplatesListMember.Builder> getBackupPlanTemplatesList() {
            List<BackupPlanTemplatesListMember.Builder> result = BackupPlanTemplatesListCopier
                    .copyToBuilder(this.backupPlanTemplatesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackupPlanTemplatesList(Collection<BackupPlanTemplatesListMember.BuilderImpl> backupPlanTemplatesList) {
            this.backupPlanTemplatesList = BackupPlanTemplatesListCopier.copyFromBuilder(backupPlanTemplatesList);
        }

        @Override
        public final Builder backupPlanTemplatesList(Collection<BackupPlanTemplatesListMember> backupPlanTemplatesList) {
            this.backupPlanTemplatesList = BackupPlanTemplatesListCopier.copy(backupPlanTemplatesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanTemplatesList(BackupPlanTemplatesListMember... backupPlanTemplatesList) {
            backupPlanTemplatesList(Arrays.asList(backupPlanTemplatesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanTemplatesList(Consumer<BackupPlanTemplatesListMember.Builder>... backupPlanTemplatesList) {
            backupPlanTemplatesList(Stream.of(backupPlanTemplatesList)
                    .map(c -> BackupPlanTemplatesListMember.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBackupPlanTemplatesResponse build() {
            return new ListBackupPlanTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
