/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies whether Amazon S3 access grants are enabled for query results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryResultsS3AccessGrantsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryResultsS3AccessGrantsConfiguration.Builder, QueryResultsS3AccessGrantsConfiguration> {
    private static final SdkField<Boolean> ENABLE_S3_ACCESS_GRANTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableS3AccessGrants").getter(getter(QueryResultsS3AccessGrantsConfiguration::enableS3AccessGrants))
            .setter(setter(Builder::enableS3AccessGrants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableS3AccessGrants").build())
            .build();

    private static final SdkField<Boolean> CREATE_USER_LEVEL_PREFIX_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CreateUserLevelPrefix").getter(getter(QueryResultsS3AccessGrantsConfiguration::createUserLevelPrefix))
            .setter(setter(Builder::createUserLevelPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateUserLevelPrefix").build())
            .build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(QueryResultsS3AccessGrantsConfiguration::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_S3_ACCESS_GRANTS_FIELD,
            CREATE_USER_LEVEL_PREFIX_FIELD, AUTHENTICATION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enableS3AccessGrants;

    private final Boolean createUserLevelPrefix;

    private final String authenticationType;

    private QueryResultsS3AccessGrantsConfiguration(BuilderImpl builder) {
        this.enableS3AccessGrants = builder.enableS3AccessGrants;
        this.createUserLevelPrefix = builder.createUserLevelPrefix;
        this.authenticationType = builder.authenticationType;
    }

    /**
     * <p>
     * Specifies whether Amazon S3 access grants are enabled for query results.
     * </p>
     * 
     * @return Specifies whether Amazon S3 access grants are enabled for query results.
     */
    public final Boolean enableS3AccessGrants() {
        return enableS3AccessGrants;
    }

    /**
     * <p>
     * When enabled, appends the user ID as an Amazon S3 path prefix to the query result output location.
     * </p>
     * 
     * @return When enabled, appends the user ID as an Amazon S3 path prefix to the query result output location.
     */
    public final Boolean createUserLevelPrefix() {
        return createUserLevelPrefix;
    }

    /**
     * <p>
     * The authentication type used for Amazon S3 access grants. Currently, only <code>DIRECTORY_IDENTITY</code> is
     * supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type used for Amazon S3 access grants. Currently, only <code>DIRECTORY_IDENTITY</code>
     *         is supported.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication type used for Amazon S3 access grants. Currently, only <code>DIRECTORY_IDENTITY</code> is
     * supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type used for Amazon S3 access grants. Currently, only <code>DIRECTORY_IDENTITY</code>
     *         is supported.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableS3AccessGrants());
        hashCode = 31 * hashCode + Objects.hashCode(createUserLevelPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResultsS3AccessGrantsConfiguration)) {
            return false;
        }
        QueryResultsS3AccessGrantsConfiguration other = (QueryResultsS3AccessGrantsConfiguration) obj;
        return Objects.equals(enableS3AccessGrants(), other.enableS3AccessGrants())
                && Objects.equals(createUserLevelPrefix(), other.createUserLevelPrefix())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryResultsS3AccessGrantsConfiguration").add("EnableS3AccessGrants", enableS3AccessGrants())
                .add("CreateUserLevelPrefix", createUserLevelPrefix()).add("AuthenticationType", authenticationTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableS3AccessGrants":
            return Optional.ofNullable(clazz.cast(enableS3AccessGrants()));
        case "CreateUserLevelPrefix":
            return Optional.ofNullable(clazz.cast(createUserLevelPrefix()));
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryResultsS3AccessGrantsConfiguration, T> g) {
        return obj -> g.apply((QueryResultsS3AccessGrantsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryResultsS3AccessGrantsConfiguration> {
        /**
         * <p>
         * Specifies whether Amazon S3 access grants are enabled for query results.
         * </p>
         * 
         * @param enableS3AccessGrants
         *        Specifies whether Amazon S3 access grants are enabled for query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableS3AccessGrants(Boolean enableS3AccessGrants);

        /**
         * <p>
         * When enabled, appends the user ID as an Amazon S3 path prefix to the query result output location.
         * </p>
         * 
         * @param createUserLevelPrefix
         *        When enabled, appends the user ID as an Amazon S3 path prefix to the query result output location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createUserLevelPrefix(Boolean createUserLevelPrefix);

        /**
         * <p>
         * The authentication type used for Amazon S3 access grants. Currently, only <code>DIRECTORY_IDENTITY</code> is
         * supported.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type used for Amazon S3 access grants. Currently, only
         *        <code>DIRECTORY_IDENTITY</code> is supported.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication type used for Amazon S3 access grants. Currently, only <code>DIRECTORY_IDENTITY</code> is
         * supported.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type used for Amazon S3 access grants. Currently, only
         *        <code>DIRECTORY_IDENTITY</code> is supported.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableS3AccessGrants;

        private Boolean createUserLevelPrefix;

        private String authenticationType;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResultsS3AccessGrantsConfiguration model) {
            enableS3AccessGrants(model.enableS3AccessGrants);
            createUserLevelPrefix(model.createUserLevelPrefix);
            authenticationType(model.authenticationType);
        }

        public final Boolean getEnableS3AccessGrants() {
            return enableS3AccessGrants;
        }

        public final void setEnableS3AccessGrants(Boolean enableS3AccessGrants) {
            this.enableS3AccessGrants = enableS3AccessGrants;
        }

        @Override
        public final Builder enableS3AccessGrants(Boolean enableS3AccessGrants) {
            this.enableS3AccessGrants = enableS3AccessGrants;
            return this;
        }

        public final Boolean getCreateUserLevelPrefix() {
            return createUserLevelPrefix;
        }

        public final void setCreateUserLevelPrefix(Boolean createUserLevelPrefix) {
            this.createUserLevelPrefix = createUserLevelPrefix;
        }

        @Override
        public final Builder createUserLevelPrefix(Boolean createUserLevelPrefix) {
            this.createUserLevelPrefix = createUserLevelPrefix;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        @Override
        public QueryResultsS3AccessGrantsConfiguration build() {
            return new QueryResultsS3AccessGrantsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
