/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBrokerResponse extends MqResponse implements
        ToCopyableBuilder<DescribeBrokerResponse.Builder, DescribeBrokerResponse> {
    private static final SdkField<List<ActionRequired>> ACTIONS_REQUIRED_FIELD = SdkField
            .<List<ActionRequired>> builder(MarshallingType.LIST)
            .memberName("ActionsRequired")
            .getter(getter(DescribeBrokerResponse::actionsRequired))
            .setter(setter(Builder::actionsRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsRequired").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionRequired> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionRequired::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUTHENTICATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationStrategy").getter(getter(DescribeBrokerResponse::authenticationStrategyAsString))
            .setter(setter(Builder::authenticationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationStrategy").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(DescribeBrokerResponse::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> BROKER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrokerArn").getter(getter(DescribeBrokerResponse::brokerArn)).setter(setter(Builder::brokerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerArn").build()).build();

    private static final SdkField<String> BROKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrokerId").getter(getter(DescribeBrokerResponse::brokerId)).setter(setter(Builder::brokerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()).build();

    private static final SdkField<List<BrokerInstance>> BROKER_INSTANCES_FIELD = SdkField
            .<List<BrokerInstance>> builder(MarshallingType.LIST)
            .memberName("BrokerInstances")
            .getter(getter(DescribeBrokerResponse::brokerInstances))
            .setter(setter(Builder::brokerInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BrokerInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(BrokerInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BROKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrokerName").getter(getter(DescribeBrokerResponse::brokerName)).setter(setter(Builder::brokerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerName").build()).build();

    private static final SdkField<String> BROKER_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrokerState").getter(getter(DescribeBrokerResponse::brokerStateAsString))
            .setter(setter(Builder::brokerState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerState").build()).build();

    private static final SdkField<Configurations> CONFIGURATIONS_FIELD = SdkField
            .<Configurations> builder(MarshallingType.SDK_POJO).memberName("Configurations")
            .getter(getter(DescribeBrokerResponse::configurations)).setter(setter(Builder::configurations))
            .constructor(Configurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Created")
            .getter(getter(DescribeBrokerResponse::created))
            .setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DEPLOYMENT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentMode").getter(getter(DescribeBrokerResponse::deploymentModeAsString))
            .setter(setter(Builder::deploymentMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentMode").build()).build();

    private static final SdkField<EncryptionOptions> ENCRYPTION_OPTIONS_FIELD = SdkField
            .<EncryptionOptions> builder(MarshallingType.SDK_POJO).memberName("EncryptionOptions")
            .getter(getter(DescribeBrokerResponse::encryptionOptions)).setter(setter(Builder::encryptionOptions))
            .constructor(EncryptionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionOptions").build()).build();

    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineType").getter(getter(DescribeBrokerResponse::engineTypeAsString))
            .setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(DescribeBrokerResponse::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostInstanceType").getter(getter(DescribeBrokerResponse::hostInstanceType))
            .setter(setter(Builder::hostInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()).build();

    private static final SdkField<LdapServerMetadataOutput> LDAP_SERVER_METADATA_FIELD = SdkField
            .<LdapServerMetadataOutput> builder(MarshallingType.SDK_POJO).memberName("LdapServerMetadata")
            .getter(getter(DescribeBrokerResponse::ldapServerMetadata)).setter(setter(Builder::ldapServerMetadata))
            .constructor(LdapServerMetadataOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ldapServerMetadata").build())
            .build();

    private static final SdkField<LogsSummary> LOGS_FIELD = SdkField.<LogsSummary> builder(MarshallingType.SDK_POJO)
            .memberName("Logs").getter(getter(DescribeBrokerResponse::logs)).setter(setter(Builder::logs))
            .constructor(LogsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()).build();

    private static final SdkField<WeeklyStartTime> MAINTENANCE_WINDOW_START_TIME_FIELD = SdkField
            .<WeeklyStartTime> builder(MarshallingType.SDK_POJO)
            .memberName("MaintenanceWindowStartTime")
            .getter(getter(DescribeBrokerResponse::maintenanceWindowStartTime))
            .setter(setter(Builder::maintenanceWindowStartTime))
            .constructor(WeeklyStartTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindowStartTime").build())
            .build();

    private static final SdkField<String> PENDING_AUTHENTICATION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PendingAuthenticationStrategy")
            .getter(getter(DescribeBrokerResponse::pendingAuthenticationStrategyAsString))
            .setter(setter(Builder::pendingAuthenticationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingAuthenticationStrategy")
                    .build()).build();

    private static final SdkField<String> PENDING_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PendingEngineVersion").getter(getter(DescribeBrokerResponse::pendingEngineVersion))
            .setter(setter(Builder::pendingEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingEngineVersion").build())
            .build();

    private static final SdkField<String> PENDING_HOST_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PendingHostInstanceType").getter(getter(DescribeBrokerResponse::pendingHostInstanceType))
            .setter(setter(Builder::pendingHostInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingHostInstanceType").build())
            .build();

    private static final SdkField<LdapServerMetadataOutput> PENDING_LDAP_SERVER_METADATA_FIELD = SdkField
            .<LdapServerMetadataOutput> builder(MarshallingType.SDK_POJO).memberName("PendingLdapServerMetadata")
            .getter(getter(DescribeBrokerResponse::pendingLdapServerMetadata)).setter(setter(Builder::pendingLdapServerMetadata))
            .constructor(LdapServerMetadataOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingLdapServerMetadata").build())
            .build();

    private static final SdkField<List<String>> PENDING_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PendingSecurityGroups")
            .getter(getter(DescribeBrokerResponse::pendingSecurityGroups))
            .setter(setter(Builder::pendingSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(DescribeBrokerResponse::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(DescribeBrokerResponse::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(DescribeBrokerResponse::storageTypeAsString))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(DescribeBrokerResponse::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeBrokerResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<UserSummary>> USERS_FIELD = SdkField
            .<List<UserSummary>> builder(MarshallingType.LIST)
            .memberName("Users")
            .getter(getter(DescribeBrokerResponse::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataReplicationMetadataOutput> DATA_REPLICATION_METADATA_FIELD = SdkField
            .<DataReplicationMetadataOutput> builder(MarshallingType.SDK_POJO).memberName("DataReplicationMetadata")
            .getter(getter(DescribeBrokerResponse::dataReplicationMetadata)).setter(setter(Builder::dataReplicationMetadata))
            .constructor(DataReplicationMetadataOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationMetadata").build())
            .build();

    private static final SdkField<String> DATA_REPLICATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataReplicationMode").getter(getter(DescribeBrokerResponse::dataReplicationModeAsString))
            .setter(setter(Builder::dataReplicationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationMode").build())
            .build();

    private static final SdkField<DataReplicationMetadataOutput> PENDING_DATA_REPLICATION_METADATA_FIELD = SdkField
            .<DataReplicationMetadataOutput> builder(MarshallingType.SDK_POJO)
            .memberName("PendingDataReplicationMetadata")
            .getter(getter(DescribeBrokerResponse::pendingDataReplicationMetadata))
            .setter(setter(Builder::pendingDataReplicationMetadata))
            .constructor(DataReplicationMetadataOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingDataReplicationMetadata")
                    .build()).build();

    private static final SdkField<String> PENDING_DATA_REPLICATION_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PendingDataReplicationMode")
            .getter(getter(DescribeBrokerResponse::pendingDataReplicationModeAsString))
            .setter(setter(Builder::pendingDataReplicationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingDataReplicationMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_REQUIRED_FIELD,
            AUTHENTICATION_STRATEGY_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, BROKER_ARN_FIELD, BROKER_ID_FIELD,
            BROKER_INSTANCES_FIELD, BROKER_NAME_FIELD, BROKER_STATE_FIELD, CONFIGURATIONS_FIELD, CREATED_FIELD,
            DEPLOYMENT_MODE_FIELD, ENCRYPTION_OPTIONS_FIELD, ENGINE_TYPE_FIELD, ENGINE_VERSION_FIELD, HOST_INSTANCE_TYPE_FIELD,
            LDAP_SERVER_METADATA_FIELD, LOGS_FIELD, MAINTENANCE_WINDOW_START_TIME_FIELD, PENDING_AUTHENTICATION_STRATEGY_FIELD,
            PENDING_ENGINE_VERSION_FIELD, PENDING_HOST_INSTANCE_TYPE_FIELD, PENDING_LDAP_SERVER_METADATA_FIELD,
            PENDING_SECURITY_GROUPS_FIELD, PUBLICLY_ACCESSIBLE_FIELD, SECURITY_GROUPS_FIELD, STORAGE_TYPE_FIELD,
            SUBNET_IDS_FIELD, TAGS_FIELD, USERS_FIELD, DATA_REPLICATION_METADATA_FIELD, DATA_REPLICATION_MODE_FIELD,
            PENDING_DATA_REPLICATION_METADATA_FIELD, PENDING_DATA_REPLICATION_MODE_FIELD));

    private final List<ActionRequired> actionsRequired;

    private final String authenticationStrategy;

    private final Boolean autoMinorVersionUpgrade;

    private final String brokerArn;

    private final String brokerId;

    private final List<BrokerInstance> brokerInstances;

    private final String brokerName;

    private final String brokerState;

    private final Configurations configurations;

    private final Instant created;

    private final String deploymentMode;

    private final EncryptionOptions encryptionOptions;

    private final String engineType;

    private final String engineVersion;

    private final String hostInstanceType;

    private final LdapServerMetadataOutput ldapServerMetadata;

    private final LogsSummary logs;

    private final WeeklyStartTime maintenanceWindowStartTime;

    private final String pendingAuthenticationStrategy;

    private final String pendingEngineVersion;

    private final String pendingHostInstanceType;

    private final LdapServerMetadataOutput pendingLdapServerMetadata;

    private final List<String> pendingSecurityGroups;

    private final Boolean publiclyAccessible;

    private final List<String> securityGroups;

    private final String storageType;

    private final List<String> subnetIds;

    private final Map<String, String> tags;

    private final List<UserSummary> users;

    private final DataReplicationMetadataOutput dataReplicationMetadata;

    private final String dataReplicationMode;

    private final DataReplicationMetadataOutput pendingDataReplicationMetadata;

    private final String pendingDataReplicationMode;

    private DescribeBrokerResponse(BuilderImpl builder) {
        super(builder);
        this.actionsRequired = builder.actionsRequired;
        this.authenticationStrategy = builder.authenticationStrategy;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.brokerArn = builder.brokerArn;
        this.brokerId = builder.brokerId;
        this.brokerInstances = builder.brokerInstances;
        this.brokerName = builder.brokerName;
        this.brokerState = builder.brokerState;
        this.configurations = builder.configurations;
        this.created = builder.created;
        this.deploymentMode = builder.deploymentMode;
        this.encryptionOptions = builder.encryptionOptions;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.hostInstanceType = builder.hostInstanceType;
        this.ldapServerMetadata = builder.ldapServerMetadata;
        this.logs = builder.logs;
        this.maintenanceWindowStartTime = builder.maintenanceWindowStartTime;
        this.pendingAuthenticationStrategy = builder.pendingAuthenticationStrategy;
        this.pendingEngineVersion = builder.pendingEngineVersion;
        this.pendingHostInstanceType = builder.pendingHostInstanceType;
        this.pendingLdapServerMetadata = builder.pendingLdapServerMetadata;
        this.pendingSecurityGroups = builder.pendingSecurityGroups;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroups = builder.securityGroups;
        this.storageType = builder.storageType;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.users = builder.users;
        this.dataReplicationMetadata = builder.dataReplicationMetadata;
        this.dataReplicationMode = builder.dataReplicationMode;
        this.pendingDataReplicationMetadata = builder.pendingDataReplicationMetadata;
        this.pendingDataReplicationMode = builder.pendingDataReplicationMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionsRequired property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionsRequired() {
        return actionsRequired != null && !(actionsRequired instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Actions required for a broker.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionsRequired} method.
     * </p>
     * 
     * @return Actions required for a broker.
     */
    public final List<ActionRequired> actionsRequired() {
        return actionsRequired;
    }

    /**
     * <p>
     * The authentication strategy used to secure the broker. The default is SIMPLE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationStrategy} will return {@link AuthenticationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationStrategyAsString}.
     * </p>
     * 
     * @return The authentication strategy used to secure the broker. The default is SIMPLE.
     * @see AuthenticationStrategy
     */
    public final AuthenticationStrategy authenticationStrategy() {
        return AuthenticationStrategy.fromValue(authenticationStrategy);
    }

    /**
     * <p>
     * The authentication strategy used to secure the broker. The default is SIMPLE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationStrategy} will return {@link AuthenticationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationStrategyAsString}.
     * </p>
     * 
     * @return The authentication strategy used to secure the broker. The default is SIMPLE.
     * @see AuthenticationStrategy
     */
    public final String authenticationStrategyAsString() {
        return authenticationStrategy;
    }

    /**
     * <p>
     * Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by
     * Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual
     * broker reboot.
     * </p>
     * 
     * @return Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported
     *         by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a
     *         manual broker reboot.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The broker's Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The broker's Amazon Resource Name (ARN).
     */
    public final String brokerArn() {
        return brokerArn;
    }

    /**
     * <p>
     * The unique ID that Amazon MQ generates for the broker.
     * </p>
     * 
     * @return The unique ID that Amazon MQ generates for the broker.
     */
    public final String brokerId() {
        return brokerId;
    }

    /**
     * For responses, this returns true if the service returned a value for the BrokerInstances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBrokerInstances() {
        return brokerInstances != null && !(brokerInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of information about allocated brokers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBrokerInstances} method.
     * </p>
     * 
     * @return A list of information about allocated brokers.
     */
    public final List<BrokerInstance> brokerInstances() {
        return brokerInstances;
    }

    /**
     * <p>
     * The broker's name. This value must be unique in your Amazon Web Services account account, 1-50 characters long,
     * must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets,
     * wildcard characters, or special characters.
     * </p>
     * 
     * @return The broker's name. This value must be unique in your Amazon Web Services account account, 1-50 characters
     *         long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces,
     *         brackets, wildcard characters, or special characters.
     */
    public final String brokerName() {
        return brokerName;
    }

    /**
     * <p>
     * The broker's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brokerState} will
     * return {@link BrokerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brokerStateAsString}.
     * </p>
     * 
     * @return The broker's status.
     * @see BrokerState
     */
    public final BrokerState brokerState() {
        return BrokerState.fromValue(brokerState);
    }

    /**
     * <p>
     * The broker's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brokerState} will
     * return {@link BrokerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brokerStateAsString}.
     * </p>
     * 
     * @return The broker's status.
     * @see BrokerState
     */
    public final String brokerStateAsString() {
        return brokerState;
    }

    /**
     * <p>
     * The list of all revisions for the specified configuration.
     * </p>
     * 
     * @return The list of all revisions for the specified configuration.
     */
    public final Configurations configurations() {
        return configurations;
    }

    /**
     * <p>
     * The time when the broker was created.
     * </p>
     * 
     * @return The time when the broker was created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The broker's deployment mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentMode}
     * will return {@link DeploymentMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentModeAsString}.
     * </p>
     * 
     * @return The broker's deployment mode.
     * @see DeploymentMode
     */
    public final DeploymentMode deploymentMode() {
        return DeploymentMode.fromValue(deploymentMode);
    }

    /**
     * <p>
     * The broker's deployment mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentMode}
     * will return {@link DeploymentMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentModeAsString}.
     * </p>
     * 
     * @return The broker's deployment mode.
     * @see DeploymentMode
     */
    public final String deploymentModeAsString() {
        return deploymentMode;
    }

    /**
     * <p>
     * Encryption options for the broker.
     * </p>
     * 
     * @return Encryption options for the broker.
     */
    public final EncryptionOptions encryptionOptions() {
        return encryptionOptions;
    }

    /**
     * <p>
     * The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     * @see EngineType
     */
    public final EngineType engineType() {
        return EngineType.fromValue(engineType);
    }

    /**
     * <p>
     * The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
     * @see EngineType
     */
    public final String engineTypeAsString() {
        return engineType;
    }

    /**
     * <p>
     * The broker engine's version. For a list of supported engine versions, see <a
     * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.
     * </p>
     * 
     * @return The broker engine's version. For a list of supported engine versions, see <a
     *         href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported
     *         engines</a>.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The broker's instance type.
     * </p>
     * 
     * @return The broker's instance type.
     */
    public final String hostInstanceType() {
        return hostInstanceType;
    }

    /**
     * <p>
     * The metadata of the LDAP server used to authenticate and authorize connections to the broker.
     * </p>
     * 
     * @return The metadata of the LDAP server used to authenticate and authorize connections to the broker.
     */
    public final LdapServerMetadataOutput ldapServerMetadata() {
        return ldapServerMetadata;
    }

    /**
     * <p>
     * The list of information about logs currently enabled and pending to be deployed for the specified broker.
     * </p>
     * 
     * @return The list of information about logs currently enabled and pending to be deployed for the specified broker.
     */
    public final LogsSummary logs() {
        return logs;
    }

    /**
     * <p>
     * The parameters that determine the WeeklyStartTime.
     * </p>
     * 
     * @return The parameters that determine the WeeklyStartTime.
     */
    public final WeeklyStartTime maintenanceWindowStartTime() {
        return maintenanceWindowStartTime;
    }

    /**
     * <p>
     * The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pendingAuthenticationStrategy} will return {@link AuthenticationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pendingAuthenticationStrategyAsString}.
     * </p>
     * 
     * @return The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.
     * @see AuthenticationStrategy
     */
    public final AuthenticationStrategy pendingAuthenticationStrategy() {
        return AuthenticationStrategy.fromValue(pendingAuthenticationStrategy);
    }

    /**
     * <p>
     * The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pendingAuthenticationStrategy} will return {@link AuthenticationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pendingAuthenticationStrategyAsString}.
     * </p>
     * 
     * @return The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.
     * @see AuthenticationStrategy
     */
    public final String pendingAuthenticationStrategyAsString() {
        return pendingAuthenticationStrategy;
    }

    /**
     * <p>
     * The broker engine version to upgrade to. For a list of supported engine versions, see <a
     * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported engines</a>.
     * </p>
     * 
     * @return The broker engine version to upgrade to. For a list of supported engine versions, see <a
     *         href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported
     *         engines</a>.
     */
    public final String pendingEngineVersion() {
        return pendingEngineVersion;
    }

    /**
     * <p>
     * The broker's host instance type to upgrade to. For a list of supported instance types, see <a
     * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker
     * instance types</a>.
     * </p>
     * 
     * @return The broker's host instance type to upgrade to. For a list of supported instance types, see <a
     *         href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types"
     *         >Broker instance types</a>.
     */
    public final String pendingHostInstanceType() {
        return pendingHostInstanceType;
    }

    /**
     * <p>
     * The metadata of the LDAP server that will be used to authenticate and authorize connections to the broker after
     * it is rebooted.
     * </p>
     * 
     * @return The metadata of the LDAP server that will be used to authenticate and authorize connections to the broker
     *         after it is rebooted.
     */
    public final LdapServerMetadataOutput pendingLdapServerMetadata() {
        return pendingLdapServerMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the PendingSecurityGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPendingSecurityGroups() {
        return pendingSecurityGroups != null && !(pendingSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of pending security groups to authorize connections to brokers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPendingSecurityGroups} method.
     * </p>
     * 
     * @return The list of pending security groups to authorize connections to brokers.
     */
    public final List<String> pendingSecurityGroups() {
        return pendingSecurityGroups;
    }

    /**
     * <p>
     * Enables connections from applications outside of the VPC that hosts the broker's subnets.
     * </p>
     * 
     * @return Enables connections from applications outside of the VPC that hosts the broker's subnets.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The broker's storage type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link BrokerStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The broker's storage type.
     * @see BrokerStorageType
     */
    public final BrokerStorageType storageType() {
        return BrokerStorageType.fromValue(storageType);
    }

    /**
     * <p>
     * The broker's storage type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link BrokerStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The broker's storage type.
     * @see BrokerStorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The list of groups that define which subnets and IP ranges the broker can use from different Availability
     *         Zones.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of all tags associated with this broker.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of all tags associated with this broker.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Users property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of all broker usernames for the specified broker.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsers} method.
     * </p>
     * 
     * @return The list of all broker usernames for the specified broker.
     */
    public final List<UserSummary> users() {
        return users;
    }

    /**
     * <p>
     * The replication details of the data replication-enabled broker. Only returned if dataReplicationMode is set to
     * CRDR.
     * </p>
     * 
     * @return The replication details of the data replication-enabled broker. Only returned if dataReplicationMode is
     *         set to CRDR.
     */
    public final DataReplicationMetadataOutput dataReplicationMetadata() {
        return dataReplicationMetadata;
    }

    /**
     * <p>
     * Describes whether this broker is a part of a data replication pair.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataReplicationMode} will return {@link DataReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataReplicationModeAsString}.
     * </p>
     * 
     * @return Describes whether this broker is a part of a data replication pair.
     * @see DataReplicationMode
     */
    public final DataReplicationMode dataReplicationMode() {
        return DataReplicationMode.fromValue(dataReplicationMode);
    }

    /**
     * <p>
     * Describes whether this broker is a part of a data replication pair.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataReplicationMode} will return {@link DataReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataReplicationModeAsString}.
     * </p>
     * 
     * @return Describes whether this broker is a part of a data replication pair.
     * @see DataReplicationMode
     */
    public final String dataReplicationModeAsString() {
        return dataReplicationMode;
    }

    /**
     * <p>
     * The pending replication details of the data replication-enabled broker. Only returned if
     * pendingDataReplicationMode is set to CRDR.
     * </p>
     * 
     * @return The pending replication details of the data replication-enabled broker. Only returned if
     *         pendingDataReplicationMode is set to CRDR.
     */
    public final DataReplicationMetadataOutput pendingDataReplicationMetadata() {
        return pendingDataReplicationMetadata;
    }

    /**
     * <p>
     * Describes whether this broker will be a part of a data replication pair after reboot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pendingDataReplicationMode} will return {@link DataReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pendingDataReplicationModeAsString}.
     * </p>
     * 
     * @return Describes whether this broker will be a part of a data replication pair after reboot.
     * @see DataReplicationMode
     */
    public final DataReplicationMode pendingDataReplicationMode() {
        return DataReplicationMode.fromValue(pendingDataReplicationMode);
    }

    /**
     * <p>
     * Describes whether this broker will be a part of a data replication pair after reboot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pendingDataReplicationMode} will return {@link DataReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pendingDataReplicationModeAsString}.
     * </p>
     * 
     * @return Describes whether this broker will be a part of a data replication pair after reboot.
     * @see DataReplicationMode
     */
    public final String pendingDataReplicationModeAsString() {
        return pendingDataReplicationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActionsRequired() ? actionsRequired() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authenticationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(brokerArn());
        hashCode = 31 * hashCode + Objects.hashCode(brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(hasBrokerInstances() ? brokerInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(brokerName());
        hashCode = 31 * hashCode + Objects.hashCode(brokerStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configurations());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(ldapServerMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(logs());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(pendingAuthenticationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pendingEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(pendingHostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(pendingLdapServerMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasPendingSecurityGroups() ? pendingSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUsers() ? users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pendingDataReplicationMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(pendingDataReplicationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBrokerResponse)) {
            return false;
        }
        DescribeBrokerResponse other = (DescribeBrokerResponse) obj;
        return hasActionsRequired() == other.hasActionsRequired() && Objects.equals(actionsRequired(), other.actionsRequired())
                && Objects.equals(authenticationStrategyAsString(), other.authenticationStrategyAsString())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(brokerArn(), other.brokerArn()) && Objects.equals(brokerId(), other.brokerId())
                && hasBrokerInstances() == other.hasBrokerInstances()
                && Objects.equals(brokerInstances(), other.brokerInstances()) && Objects.equals(brokerName(), other.brokerName())
                && Objects.equals(brokerStateAsString(), other.brokerStateAsString())
                && Objects.equals(configurations(), other.configurations()) && Objects.equals(created(), other.created())
                && Objects.equals(deploymentModeAsString(), other.deploymentModeAsString())
                && Objects.equals(encryptionOptions(), other.encryptionOptions())
                && Objects.equals(engineTypeAsString(), other.engineTypeAsString())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(hostInstanceType(), other.hostInstanceType())
                && Objects.equals(ldapServerMetadata(), other.ldapServerMetadata()) && Objects.equals(logs(), other.logs())
                && Objects.equals(maintenanceWindowStartTime(), other.maintenanceWindowStartTime())
                && Objects.equals(pendingAuthenticationStrategyAsString(), other.pendingAuthenticationStrategyAsString())
                && Objects.equals(pendingEngineVersion(), other.pendingEngineVersion())
                && Objects.equals(pendingHostInstanceType(), other.pendingHostInstanceType())
                && Objects.equals(pendingLdapServerMetadata(), other.pendingLdapServerMetadata())
                && hasPendingSecurityGroups() == other.hasPendingSecurityGroups()
                && Objects.equals(pendingSecurityGroups(), other.pendingSecurityGroups())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(storageTypeAsString(), other.storageTypeAsString()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasUsers() == other.hasUsers()
                && Objects.equals(users(), other.users())
                && Objects.equals(dataReplicationMetadata(), other.dataReplicationMetadata())
                && Objects.equals(dataReplicationModeAsString(), other.dataReplicationModeAsString())
                && Objects.equals(pendingDataReplicationMetadata(), other.pendingDataReplicationMetadata())
                && Objects.equals(pendingDataReplicationModeAsString(), other.pendingDataReplicationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBrokerResponse").add("ActionsRequired", hasActionsRequired() ? actionsRequired() : null)
                .add("AuthenticationStrategy", authenticationStrategyAsString())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade()).add("BrokerArn", brokerArn())
                .add("BrokerId", brokerId()).add("BrokerInstances", hasBrokerInstances() ? brokerInstances() : null)
                .add("BrokerName", brokerName()).add("BrokerState", brokerStateAsString())
                .add("Configurations", configurations()).add("Created", created())
                .add("DeploymentMode", deploymentModeAsString()).add("EncryptionOptions", encryptionOptions())
                .add("EngineType", engineTypeAsString()).add("EngineVersion", engineVersion())
                .add("HostInstanceType", hostInstanceType()).add("LdapServerMetadata", ldapServerMetadata()).add("Logs", logs())
                .add("MaintenanceWindowStartTime", maintenanceWindowStartTime())
                .add("PendingAuthenticationStrategy", pendingAuthenticationStrategyAsString())
                .add("PendingEngineVersion", pendingEngineVersion()).add("PendingHostInstanceType", pendingHostInstanceType())
                .add("PendingLdapServerMetadata", pendingLdapServerMetadata())
                .add("PendingSecurityGroups", hasPendingSecurityGroups() ? pendingSecurityGroups() : null)
                .add("PubliclyAccessible", publiclyAccessible())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("StorageType", storageTypeAsString())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("Tags", hasTags() ? tags() : null)
                .add("Users", hasUsers() ? users() : null).add("DataReplicationMetadata", dataReplicationMetadata())
                .add("DataReplicationMode", dataReplicationModeAsString())
                .add("PendingDataReplicationMetadata", pendingDataReplicationMetadata())
                .add("PendingDataReplicationMode", pendingDataReplicationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionsRequired":
            return Optional.ofNullable(clazz.cast(actionsRequired()));
        case "AuthenticationStrategy":
            return Optional.ofNullable(clazz.cast(authenticationStrategyAsString()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "BrokerArn":
            return Optional.ofNullable(clazz.cast(brokerArn()));
        case "BrokerId":
            return Optional.ofNullable(clazz.cast(brokerId()));
        case "BrokerInstances":
            return Optional.ofNullable(clazz.cast(brokerInstances()));
        case "BrokerName":
            return Optional.ofNullable(clazz.cast(brokerName()));
        case "BrokerState":
            return Optional.ofNullable(clazz.cast(brokerStateAsString()));
        case "Configurations":
            return Optional.ofNullable(clazz.cast(configurations()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "DeploymentMode":
            return Optional.ofNullable(clazz.cast(deploymentModeAsString()));
        case "EncryptionOptions":
            return Optional.ofNullable(clazz.cast(encryptionOptions()));
        case "EngineType":
            return Optional.ofNullable(clazz.cast(engineTypeAsString()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "HostInstanceType":
            return Optional.ofNullable(clazz.cast(hostInstanceType()));
        case "LdapServerMetadata":
            return Optional.ofNullable(clazz.cast(ldapServerMetadata()));
        case "Logs":
            return Optional.ofNullable(clazz.cast(logs()));
        case "MaintenanceWindowStartTime":
            return Optional.ofNullable(clazz.cast(maintenanceWindowStartTime()));
        case "PendingAuthenticationStrategy":
            return Optional.ofNullable(clazz.cast(pendingAuthenticationStrategyAsString()));
        case "PendingEngineVersion":
            return Optional.ofNullable(clazz.cast(pendingEngineVersion()));
        case "PendingHostInstanceType":
            return Optional.ofNullable(clazz.cast(pendingHostInstanceType()));
        case "PendingLdapServerMetadata":
            return Optional.ofNullable(clazz.cast(pendingLdapServerMetadata()));
        case "PendingSecurityGroups":
            return Optional.ofNullable(clazz.cast(pendingSecurityGroups()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Users":
            return Optional.ofNullable(clazz.cast(users()));
        case "DataReplicationMetadata":
            return Optional.ofNullable(clazz.cast(dataReplicationMetadata()));
        case "DataReplicationMode":
            return Optional.ofNullable(clazz.cast(dataReplicationModeAsString()));
        case "PendingDataReplicationMetadata":
            return Optional.ofNullable(clazz.cast(pendingDataReplicationMetadata()));
        case "PendingDataReplicationMode":
            return Optional.ofNullable(clazz.cast(pendingDataReplicationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBrokerResponse, T> g) {
        return obj -> g.apply((DescribeBrokerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBrokerResponse> {
        /**
         * <p>
         * Actions required for a broker.
         * </p>
         * 
         * @param actionsRequired
         *        Actions required for a broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsRequired(Collection<ActionRequired> actionsRequired);

        /**
         * <p>
         * Actions required for a broker.
         * </p>
         * 
         * @param actionsRequired
         *        Actions required for a broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsRequired(ActionRequired... actionsRequired);

        /**
         * <p>
         * Actions required for a broker.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mq.model.ActionRequired.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mq.model.ActionRequired#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mq.model.ActionRequired.Builder#build()} is called immediately and its
         * result is passed to {@link #actionsRequired(List<ActionRequired>)}.
         * 
         * @param actionsRequired
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mq.model.ActionRequired.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionsRequired(java.util.Collection<ActionRequired>)
         */
        Builder actionsRequired(Consumer<ActionRequired.Builder>... actionsRequired);

        /**
         * <p>
         * The authentication strategy used to secure the broker. The default is SIMPLE.
         * </p>
         * 
         * @param authenticationStrategy
         *        The authentication strategy used to secure the broker. The default is SIMPLE.
         * @see AuthenticationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationStrategy
         */
        Builder authenticationStrategy(String authenticationStrategy);

        /**
         * <p>
         * The authentication strategy used to secure the broker. The default is SIMPLE.
         * </p>
         * 
         * @param authenticationStrategy
         *        The authentication strategy used to secure the broker. The default is SIMPLE.
         * @see AuthenticationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationStrategy
         */
        Builder authenticationStrategy(AuthenticationStrategy authenticationStrategy);

        /**
         * <p>
         * Enables automatic upgrades to new minor versions for brokers, as new versions are released and supported by
         * Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual
         * broker reboot.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        Enables automatic upgrades to new minor versions for brokers, as new versions are released and
         *        supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker
         *        or after a manual broker reboot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The broker's Amazon Resource Name (ARN).
         * </p>
         * 
         * @param brokerArn
         *        The broker's Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerArn(String brokerArn);

        /**
         * <p>
         * The unique ID that Amazon MQ generates for the broker.
         * </p>
         * 
         * @param brokerId
         *        The unique ID that Amazon MQ generates for the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerId(String brokerId);

        /**
         * <p>
         * A list of information about allocated brokers.
         * </p>
         * 
         * @param brokerInstances
         *        A list of information about allocated brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerInstances(Collection<BrokerInstance> brokerInstances);

        /**
         * <p>
         * A list of information about allocated brokers.
         * </p>
         * 
         * @param brokerInstances
         *        A list of information about allocated brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerInstances(BrokerInstance... brokerInstances);

        /**
         * <p>
         * A list of information about allocated brokers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mq.model.BrokerInstance.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mq.model.BrokerInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mq.model.BrokerInstance.Builder#build()} is called immediately and its
         * result is passed to {@link #brokerInstances(List<BrokerInstance>)}.
         * 
         * @param brokerInstances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mq.model.BrokerInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerInstances(java.util.Collection<BrokerInstance>)
         */
        Builder brokerInstances(Consumer<BrokerInstance.Builder>... brokerInstances);

        /**
         * <p>
         * The broker's name. This value must be unique in your Amazon Web Services account account, 1-50 characters
         * long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces,
         * brackets, wildcard characters, or special characters.
         * </p>
         * 
         * @param brokerName
         *        The broker's name. This value must be unique in your Amazon Web Services account account, 1-50
         *        characters long, must contain only letters, numbers, dashes, and underscores, and must not contain
         *        white spaces, brackets, wildcard characters, or special characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerName(String brokerName);

        /**
         * <p>
         * The broker's status.
         * </p>
         * 
         * @param brokerState
         *        The broker's status.
         * @see BrokerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerState
         */
        Builder brokerState(String brokerState);

        /**
         * <p>
         * The broker's status.
         * </p>
         * 
         * @param brokerState
         *        The broker's status.
         * @see BrokerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerState
         */
        Builder brokerState(BrokerState brokerState);

        /**
         * <p>
         * The list of all revisions for the specified configuration.
         * </p>
         * 
         * @param configurations
         *        The list of all revisions for the specified configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Configurations configurations);

        /**
         * <p>
         * The list of all revisions for the specified configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link Configurations.Builder} avoiding the need
         * to create one manually via {@link Configurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Configurations.Builder#build()} is called immediately and its
         * result is passed to {@link #configurations(Configurations)}.
         * 
         * @param configurations
         *        a consumer that will call methods on {@link Configurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurations(Configurations)
         */
        default Builder configurations(Consumer<Configurations.Builder> configurations) {
            return configurations(Configurations.builder().applyMutation(configurations).build());
        }

        /**
         * <p>
         * The time when the broker was created.
         * </p>
         * 
         * @param created
         *        The time when the broker was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The broker's deployment mode.
         * </p>
         * 
         * @param deploymentMode
         *        The broker's deployment mode.
         * @see DeploymentMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentMode
         */
        Builder deploymentMode(String deploymentMode);

        /**
         * <p>
         * The broker's deployment mode.
         * </p>
         * 
         * @param deploymentMode
         *        The broker's deployment mode.
         * @see DeploymentMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentMode
         */
        Builder deploymentMode(DeploymentMode deploymentMode);

        /**
         * <p>
         * Encryption options for the broker.
         * </p>
         * 
         * @param encryptionOptions
         *        Encryption options for the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionOptions(EncryptionOptions encryptionOptions);

        /**
         * <p>
         * Encryption options for the broker.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionOptions.Builder} avoiding the
         * need to create one manually via {@link EncryptionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionOptions(EncryptionOptions)}.
         * 
         * @param encryptionOptions
         *        a consumer that will call methods on {@link EncryptionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionOptions(EncryptionOptions)
         */
        default Builder encryptionOptions(Consumer<EncryptionOptions.Builder> encryptionOptions) {
            return encryptionOptions(EncryptionOptions.builder().applyMutation(encryptionOptions).build());
        }

        /**
         * <p>
         * The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         * </p>
         * 
         * @param engineType
         *        The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(String engineType);

        /**
         * <p>
         * The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         * </p>
         * 
         * @param engineType
         *        The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ and RABBITMQ.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(EngineType engineType);

        /**
         * <p>
         * The broker engine's version. For a list of supported engine versions, see <a
         * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported
         * engines</a>.
         * </p>
         * 
         * @param engineVersion
         *        The broker engine's version. For a list of supported engine versions, see <a
         *        href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported
         *        engines</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The broker's instance type.
         * </p>
         * 
         * @param hostInstanceType
         *        The broker's instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostInstanceType(String hostInstanceType);

        /**
         * <p>
         * The metadata of the LDAP server used to authenticate and authorize connections to the broker.
         * </p>
         * 
         * @param ldapServerMetadata
         *        The metadata of the LDAP server used to authenticate and authorize connections to the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ldapServerMetadata(LdapServerMetadataOutput ldapServerMetadata);

        /**
         * <p>
         * The metadata of the LDAP server used to authenticate and authorize connections to the broker.
         * </p>
         * This is a convenience method that creates an instance of the {@link LdapServerMetadataOutput.Builder}
         * avoiding the need to create one manually via {@link LdapServerMetadataOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LdapServerMetadataOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #ldapServerMetadata(LdapServerMetadataOutput)}.
         * 
         * @param ldapServerMetadata
         *        a consumer that will call methods on {@link LdapServerMetadataOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ldapServerMetadata(LdapServerMetadataOutput)
         */
        default Builder ldapServerMetadata(Consumer<LdapServerMetadataOutput.Builder> ldapServerMetadata) {
            return ldapServerMetadata(LdapServerMetadataOutput.builder().applyMutation(ldapServerMetadata).build());
        }

        /**
         * <p>
         * The list of information about logs currently enabled and pending to be deployed for the specified broker.
         * </p>
         * 
         * @param logs
         *        The list of information about logs currently enabled and pending to be deployed for the specified
         *        broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logs(LogsSummary logs);

        /**
         * <p>
         * The list of information about logs currently enabled and pending to be deployed for the specified broker.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogsSummary.Builder} avoiding the need to
         * create one manually via {@link LogsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogsSummary.Builder#build()} is called immediately and its result
         * is passed to {@link #logs(LogsSummary)}.
         * 
         * @param logs
         *        a consumer that will call methods on {@link LogsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logs(LogsSummary)
         */
        default Builder logs(Consumer<LogsSummary.Builder> logs) {
            return logs(LogsSummary.builder().applyMutation(logs).build());
        }

        /**
         * <p>
         * The parameters that determine the WeeklyStartTime.
         * </p>
         * 
         * @param maintenanceWindowStartTime
         *        The parameters that determine the WeeklyStartTime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindowStartTime(WeeklyStartTime maintenanceWindowStartTime);

        /**
         * <p>
         * The parameters that determine the WeeklyStartTime.
         * </p>
         * This is a convenience method that creates an instance of the {@link WeeklyStartTime.Builder} avoiding the
         * need to create one manually via {@link WeeklyStartTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WeeklyStartTime.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenanceWindowStartTime(WeeklyStartTime)}.
         * 
         * @param maintenanceWindowStartTime
         *        a consumer that will call methods on {@link WeeklyStartTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceWindowStartTime(WeeklyStartTime)
         */
        default Builder maintenanceWindowStartTime(Consumer<WeeklyStartTime.Builder> maintenanceWindowStartTime) {
            return maintenanceWindowStartTime(WeeklyStartTime.builder().applyMutation(maintenanceWindowStartTime).build());
        }

        /**
         * <p>
         * The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.
         * </p>
         * 
         * @param pendingAuthenticationStrategy
         *        The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.
         * @see AuthenticationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationStrategy
         */
        Builder pendingAuthenticationStrategy(String pendingAuthenticationStrategy);

        /**
         * <p>
         * The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.
         * </p>
         * 
         * @param pendingAuthenticationStrategy
         *        The authentication strategy that will be applied when the broker is rebooted. The default is SIMPLE.
         * @see AuthenticationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationStrategy
         */
        Builder pendingAuthenticationStrategy(AuthenticationStrategy pendingAuthenticationStrategy);

        /**
         * <p>
         * The broker engine version to upgrade to. For a list of supported engine versions, see <a
         * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported
         * engines</a>.
         * </p>
         * 
         * @param pendingEngineVersion
         *        The broker engine version to upgrade to. For a list of supported engine versions, see <a
         *        href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html">Supported
         *        engines</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingEngineVersion(String pendingEngineVersion);

        /**
         * <p>
         * The broker's host instance type to upgrade to. For a list of supported instance types, see <a
         * href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types">Broker
         * instance types</a>.
         * </p>
         * 
         * @param pendingHostInstanceType
         *        The broker's host instance type to upgrade to. For a list of supported instance types, see <a href=
         *        "https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker.html#broker-instance-types"
         *        >Broker instance types</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingHostInstanceType(String pendingHostInstanceType);

        /**
         * <p>
         * The metadata of the LDAP server that will be used to authenticate and authorize connections to the broker
         * after it is rebooted.
         * </p>
         * 
         * @param pendingLdapServerMetadata
         *        The metadata of the LDAP server that will be used to authenticate and authorize connections to the
         *        broker after it is rebooted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingLdapServerMetadata(LdapServerMetadataOutput pendingLdapServerMetadata);

        /**
         * <p>
         * The metadata of the LDAP server that will be used to authenticate and authorize connections to the broker
         * after it is rebooted.
         * </p>
         * This is a convenience method that creates an instance of the {@link LdapServerMetadataOutput.Builder}
         * avoiding the need to create one manually via {@link LdapServerMetadataOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LdapServerMetadataOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #pendingLdapServerMetadata(LdapServerMetadataOutput)}.
         * 
         * @param pendingLdapServerMetadata
         *        a consumer that will call methods on {@link LdapServerMetadataOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingLdapServerMetadata(LdapServerMetadataOutput)
         */
        default Builder pendingLdapServerMetadata(Consumer<LdapServerMetadataOutput.Builder> pendingLdapServerMetadata) {
            return pendingLdapServerMetadata(LdapServerMetadataOutput.builder().applyMutation(pendingLdapServerMetadata).build());
        }

        /**
         * <p>
         * The list of pending security groups to authorize connections to brokers.
         * </p>
         * 
         * @param pendingSecurityGroups
         *        The list of pending security groups to authorize connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingSecurityGroups(Collection<String> pendingSecurityGroups);

        /**
         * <p>
         * The list of pending security groups to authorize connections to brokers.
         * </p>
         * 
         * @param pendingSecurityGroups
         *        The list of pending security groups to authorize connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingSecurityGroups(String... pendingSecurityGroups);

        /**
         * <p>
         * Enables connections from applications outside of the VPC that hosts the broker's subnets.
         * </p>
         * 
         * @param publiclyAccessible
         *        Enables connections from applications outside of the VPC that hosts the broker's subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         * </p>
         * 
         * @param securityGroups
         *        The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         * </p>
         * 
         * @param securityGroups
         *        The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The broker's storage type.
         * </p>
         * 
         * @param storageType
         *        The broker's storage type.
         * @see BrokerStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerStorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The broker's storage type.
         * </p>
         * 
         * @param storageType
         *        The broker's storage type.
         * @see BrokerStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerStorageType
         */
        Builder storageType(BrokerStorageType storageType);

        /**
         * <p>
         * The list of groups that define which subnets and IP ranges the broker can use from different Availability
         * Zones.
         * </p>
         * 
         * @param subnetIds
         *        The list of groups that define which subnets and IP ranges the broker can use from different
         *        Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The list of groups that define which subnets and IP ranges the broker can use from different Availability
         * Zones.
         * </p>
         * 
         * @param subnetIds
         *        The list of groups that define which subnets and IP ranges the broker can use from different
         *        Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The list of all tags associated with this broker.
         * </p>
         * 
         * @param tags
         *        The list of all tags associated with this broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The list of all broker usernames for the specified broker.
         * </p>
         * 
         * @param users
         *        The list of all broker usernames for the specified broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<UserSummary> users);

        /**
         * <p>
         * The list of all broker usernames for the specified broker.
         * </p>
         * 
         * @param users
         *        The list of all broker usernames for the specified broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(UserSummary... users);

        /**
         * <p>
         * The list of all broker usernames for the specified broker.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mq.model.UserSummary.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.mq.model.UserSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mq.model.UserSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #users(List<UserSummary>)}.
         * 
         * @param users
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mq.model.UserSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(java.util.Collection<UserSummary>)
         */
        Builder users(Consumer<UserSummary.Builder>... users);

        /**
         * <p>
         * The replication details of the data replication-enabled broker. Only returned if dataReplicationMode is set
         * to CRDR.
         * </p>
         * 
         * @param dataReplicationMetadata
         *        The replication details of the data replication-enabled broker. Only returned if dataReplicationMode
         *        is set to CRDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationMetadata(DataReplicationMetadataOutput dataReplicationMetadata);

        /**
         * <p>
         * The replication details of the data replication-enabled broker. Only returned if dataReplicationMode is set
         * to CRDR.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataReplicationMetadataOutput.Builder}
         * avoiding the need to create one manually via {@link DataReplicationMetadataOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataReplicationMetadataOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #dataReplicationMetadata(DataReplicationMetadataOutput)}.
         * 
         * @param dataReplicationMetadata
         *        a consumer that will call methods on {@link DataReplicationMetadataOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataReplicationMetadata(DataReplicationMetadataOutput)
         */
        default Builder dataReplicationMetadata(Consumer<DataReplicationMetadataOutput.Builder> dataReplicationMetadata) {
            return dataReplicationMetadata(DataReplicationMetadataOutput.builder().applyMutation(dataReplicationMetadata).build());
        }

        /**
         * <p>
         * Describes whether this broker is a part of a data replication pair.
         * </p>
         * 
         * @param dataReplicationMode
         *        Describes whether this broker is a part of a data replication pair.
         * @see DataReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationMode
         */
        Builder dataReplicationMode(String dataReplicationMode);

        /**
         * <p>
         * Describes whether this broker is a part of a data replication pair.
         * </p>
         * 
         * @param dataReplicationMode
         *        Describes whether this broker is a part of a data replication pair.
         * @see DataReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationMode
         */
        Builder dataReplicationMode(DataReplicationMode dataReplicationMode);

        /**
         * <p>
         * The pending replication details of the data replication-enabled broker. Only returned if
         * pendingDataReplicationMode is set to CRDR.
         * </p>
         * 
         * @param pendingDataReplicationMetadata
         *        The pending replication details of the data replication-enabled broker. Only returned if
         *        pendingDataReplicationMode is set to CRDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingDataReplicationMetadata(DataReplicationMetadataOutput pendingDataReplicationMetadata);

        /**
         * <p>
         * The pending replication details of the data replication-enabled broker. Only returned if
         * pendingDataReplicationMode is set to CRDR.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataReplicationMetadataOutput.Builder}
         * avoiding the need to create one manually via {@link DataReplicationMetadataOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataReplicationMetadataOutput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #pendingDataReplicationMetadata(DataReplicationMetadataOutput)}.
         * 
         * @param pendingDataReplicationMetadata
         *        a consumer that will call methods on {@link DataReplicationMetadataOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingDataReplicationMetadata(DataReplicationMetadataOutput)
         */
        default Builder pendingDataReplicationMetadata(
                Consumer<DataReplicationMetadataOutput.Builder> pendingDataReplicationMetadata) {
            return pendingDataReplicationMetadata(DataReplicationMetadataOutput.builder()
                    .applyMutation(pendingDataReplicationMetadata).build());
        }

        /**
         * <p>
         * Describes whether this broker will be a part of a data replication pair after reboot.
         * </p>
         * 
         * @param pendingDataReplicationMode
         *        Describes whether this broker will be a part of a data replication pair after reboot.
         * @see DataReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationMode
         */
        Builder pendingDataReplicationMode(String pendingDataReplicationMode);

        /**
         * <p>
         * Describes whether this broker will be a part of a data replication pair after reboot.
         * </p>
         * 
         * @param pendingDataReplicationMode
         *        Describes whether this broker will be a part of a data replication pair after reboot.
         * @see DataReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationMode
         */
        Builder pendingDataReplicationMode(DataReplicationMode pendingDataReplicationMode);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private List<ActionRequired> actionsRequired = DefaultSdkAutoConstructList.getInstance();

        private String authenticationStrategy;

        private Boolean autoMinorVersionUpgrade;

        private String brokerArn;

        private String brokerId;

        private List<BrokerInstance> brokerInstances = DefaultSdkAutoConstructList.getInstance();

        private String brokerName;

        private String brokerState;

        private Configurations configurations;

        private Instant created;

        private String deploymentMode;

        private EncryptionOptions encryptionOptions;

        private String engineType;

        private String engineVersion;

        private String hostInstanceType;

        private LdapServerMetadataOutput ldapServerMetadata;

        private LogsSummary logs;

        private WeeklyStartTime maintenanceWindowStartTime;

        private String pendingAuthenticationStrategy;

        private String pendingEngineVersion;

        private String pendingHostInstanceType;

        private LdapServerMetadataOutput pendingLdapServerMetadata;

        private List<String> pendingSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private Boolean publiclyAccessible;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String storageType;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<UserSummary> users = DefaultSdkAutoConstructList.getInstance();

        private DataReplicationMetadataOutput dataReplicationMetadata;

        private String dataReplicationMode;

        private DataReplicationMetadataOutput pendingDataReplicationMetadata;

        private String pendingDataReplicationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBrokerResponse model) {
            super(model);
            actionsRequired(model.actionsRequired);
            authenticationStrategy(model.authenticationStrategy);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            brokerArn(model.brokerArn);
            brokerId(model.brokerId);
            brokerInstances(model.brokerInstances);
            brokerName(model.brokerName);
            brokerState(model.brokerState);
            configurations(model.configurations);
            created(model.created);
            deploymentMode(model.deploymentMode);
            encryptionOptions(model.encryptionOptions);
            engineType(model.engineType);
            engineVersion(model.engineVersion);
            hostInstanceType(model.hostInstanceType);
            ldapServerMetadata(model.ldapServerMetadata);
            logs(model.logs);
            maintenanceWindowStartTime(model.maintenanceWindowStartTime);
            pendingAuthenticationStrategy(model.pendingAuthenticationStrategy);
            pendingEngineVersion(model.pendingEngineVersion);
            pendingHostInstanceType(model.pendingHostInstanceType);
            pendingLdapServerMetadata(model.pendingLdapServerMetadata);
            pendingSecurityGroups(model.pendingSecurityGroups);
            publiclyAccessible(model.publiclyAccessible);
            securityGroups(model.securityGroups);
            storageType(model.storageType);
            subnetIds(model.subnetIds);
            tags(model.tags);
            users(model.users);
            dataReplicationMetadata(model.dataReplicationMetadata);
            dataReplicationMode(model.dataReplicationMode);
            pendingDataReplicationMetadata(model.pendingDataReplicationMetadata);
            pendingDataReplicationMode(model.pendingDataReplicationMode);
        }

        public final List<ActionRequired.Builder> getActionsRequired() {
            List<ActionRequired.Builder> result = ___listOfActionRequiredCopier.copyToBuilder(this.actionsRequired);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionsRequired(Collection<ActionRequired.BuilderImpl> actionsRequired) {
            this.actionsRequired = ___listOfActionRequiredCopier.copyFromBuilder(actionsRequired);
        }

        @Override
        public final Builder actionsRequired(Collection<ActionRequired> actionsRequired) {
            this.actionsRequired = ___listOfActionRequiredCopier.copy(actionsRequired);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsRequired(ActionRequired... actionsRequired) {
            actionsRequired(Arrays.asList(actionsRequired));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsRequired(Consumer<ActionRequired.Builder>... actionsRequired) {
            actionsRequired(Stream.of(actionsRequired).map(c -> ActionRequired.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAuthenticationStrategy() {
            return authenticationStrategy;
        }

        public final void setAuthenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
        }

        @Override
        public final Builder authenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
            return this;
        }

        @Override
        public final Builder authenticationStrategy(AuthenticationStrategy authenticationStrategy) {
            this.authenticationStrategy(authenticationStrategy == null ? null : authenticationStrategy.toString());
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getBrokerArn() {
            return brokerArn;
        }

        public final void setBrokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
        }

        @Override
        public final Builder brokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
            return this;
        }

        public final String getBrokerId() {
            return brokerId;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final List<BrokerInstance.Builder> getBrokerInstances() {
            List<BrokerInstance.Builder> result = ___listOfBrokerInstanceCopier.copyToBuilder(this.brokerInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBrokerInstances(Collection<BrokerInstance.BuilderImpl> brokerInstances) {
            this.brokerInstances = ___listOfBrokerInstanceCopier.copyFromBuilder(brokerInstances);
        }

        @Override
        public final Builder brokerInstances(Collection<BrokerInstance> brokerInstances) {
            this.brokerInstances = ___listOfBrokerInstanceCopier.copy(brokerInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerInstances(BrokerInstance... brokerInstances) {
            brokerInstances(Arrays.asList(brokerInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerInstances(Consumer<BrokerInstance.Builder>... brokerInstances) {
            brokerInstances(Stream.of(brokerInstances).map(c -> BrokerInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getBrokerName() {
            return brokerName;
        }

        public final void setBrokerName(String brokerName) {
            this.brokerName = brokerName;
        }

        @Override
        public final Builder brokerName(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public final String getBrokerState() {
            return brokerState;
        }

        public final void setBrokerState(String brokerState) {
            this.brokerState = brokerState;
        }

        @Override
        public final Builder brokerState(String brokerState) {
            this.brokerState = brokerState;
            return this;
        }

        @Override
        public final Builder brokerState(BrokerState brokerState) {
            this.brokerState(brokerState == null ? null : brokerState.toString());
            return this;
        }

        public final Configurations.Builder getConfigurations() {
            return configurations != null ? configurations.toBuilder() : null;
        }

        public final void setConfigurations(Configurations.BuilderImpl configurations) {
            this.configurations = configurations != null ? configurations.build() : null;
        }

        @Override
        public final Builder configurations(Configurations configurations) {
            this.configurations = configurations;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getDeploymentMode() {
            return deploymentMode;
        }

        public final void setDeploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
        }

        @Override
        public final Builder deploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        @Override
        public final Builder deploymentMode(DeploymentMode deploymentMode) {
            this.deploymentMode(deploymentMode == null ? null : deploymentMode.toString());
            return this;
        }

        public final EncryptionOptions.Builder getEncryptionOptions() {
            return encryptionOptions != null ? encryptionOptions.toBuilder() : null;
        }

        public final void setEncryptionOptions(EncryptionOptions.BuilderImpl encryptionOptions) {
            this.encryptionOptions = encryptionOptions != null ? encryptionOptions.build() : null;
        }

        @Override
        public final Builder encryptionOptions(EncryptionOptions encryptionOptions) {
            this.encryptionOptions = encryptionOptions;
            return this;
        }

        public final String getEngineType() {
            return engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getHostInstanceType() {
            return hostInstanceType;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final LdapServerMetadataOutput.Builder getLdapServerMetadata() {
            return ldapServerMetadata != null ? ldapServerMetadata.toBuilder() : null;
        }

        public final void setLdapServerMetadata(LdapServerMetadataOutput.BuilderImpl ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata != null ? ldapServerMetadata.build() : null;
        }

        @Override
        public final Builder ldapServerMetadata(LdapServerMetadataOutput ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata;
            return this;
        }

        public final LogsSummary.Builder getLogs() {
            return logs != null ? logs.toBuilder() : null;
        }

        public final void setLogs(LogsSummary.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        @Override
        public final Builder logs(LogsSummary logs) {
            this.logs = logs;
            return this;
        }

        public final WeeklyStartTime.Builder getMaintenanceWindowStartTime() {
            return maintenanceWindowStartTime != null ? maintenanceWindowStartTime.toBuilder() : null;
        }

        public final void setMaintenanceWindowStartTime(WeeklyStartTime.BuilderImpl maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime != null ? maintenanceWindowStartTime.build() : null;
        }

        @Override
        public final Builder maintenanceWindowStartTime(WeeklyStartTime maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime;
            return this;
        }

        public final String getPendingAuthenticationStrategy() {
            return pendingAuthenticationStrategy;
        }

        public final void setPendingAuthenticationStrategy(String pendingAuthenticationStrategy) {
            this.pendingAuthenticationStrategy = pendingAuthenticationStrategy;
        }

        @Override
        public final Builder pendingAuthenticationStrategy(String pendingAuthenticationStrategy) {
            this.pendingAuthenticationStrategy = pendingAuthenticationStrategy;
            return this;
        }

        @Override
        public final Builder pendingAuthenticationStrategy(AuthenticationStrategy pendingAuthenticationStrategy) {
            this.pendingAuthenticationStrategy(pendingAuthenticationStrategy == null ? null : pendingAuthenticationStrategy
                    .toString());
            return this;
        }

        public final String getPendingEngineVersion() {
            return pendingEngineVersion;
        }

        public final void setPendingEngineVersion(String pendingEngineVersion) {
            this.pendingEngineVersion = pendingEngineVersion;
        }

        @Override
        public final Builder pendingEngineVersion(String pendingEngineVersion) {
            this.pendingEngineVersion = pendingEngineVersion;
            return this;
        }

        public final String getPendingHostInstanceType() {
            return pendingHostInstanceType;
        }

        public final void setPendingHostInstanceType(String pendingHostInstanceType) {
            this.pendingHostInstanceType = pendingHostInstanceType;
        }

        @Override
        public final Builder pendingHostInstanceType(String pendingHostInstanceType) {
            this.pendingHostInstanceType = pendingHostInstanceType;
            return this;
        }

        public final LdapServerMetadataOutput.Builder getPendingLdapServerMetadata() {
            return pendingLdapServerMetadata != null ? pendingLdapServerMetadata.toBuilder() : null;
        }

        public final void setPendingLdapServerMetadata(LdapServerMetadataOutput.BuilderImpl pendingLdapServerMetadata) {
            this.pendingLdapServerMetadata = pendingLdapServerMetadata != null ? pendingLdapServerMetadata.build() : null;
        }

        @Override
        public final Builder pendingLdapServerMetadata(LdapServerMetadataOutput pendingLdapServerMetadata) {
            this.pendingLdapServerMetadata = pendingLdapServerMetadata;
            return this;
        }

        public final Collection<String> getPendingSecurityGroups() {
            if (pendingSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return pendingSecurityGroups;
        }

        public final void setPendingSecurityGroups(Collection<String> pendingSecurityGroups) {
            this.pendingSecurityGroups = ___listOf__stringCopier.copy(pendingSecurityGroups);
        }

        @Override
        public final Builder pendingSecurityGroups(Collection<String> pendingSecurityGroups) {
            this.pendingSecurityGroups = ___listOf__stringCopier.copy(pendingSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingSecurityGroups(String... pendingSecurityGroups) {
            pendingSecurityGroups(Arrays.asList(pendingSecurityGroups));
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(BrokerStorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final List<UserSummary.Builder> getUsers() {
            List<UserSummary.Builder> result = ___listOfUserSummaryCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<UserSummary.BuilderImpl> users) {
            this.users = ___listOfUserSummaryCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<UserSummary> users) {
            this.users = ___listOfUserSummaryCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserSummary... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserSummary.Builder>... users) {
            users(Stream.of(users).map(c -> UserSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataReplicationMetadataOutput.Builder getDataReplicationMetadata() {
            return dataReplicationMetadata != null ? dataReplicationMetadata.toBuilder() : null;
        }

        public final void setDataReplicationMetadata(DataReplicationMetadataOutput.BuilderImpl dataReplicationMetadata) {
            this.dataReplicationMetadata = dataReplicationMetadata != null ? dataReplicationMetadata.build() : null;
        }

        @Override
        public final Builder dataReplicationMetadata(DataReplicationMetadataOutput dataReplicationMetadata) {
            this.dataReplicationMetadata = dataReplicationMetadata;
            return this;
        }

        public final String getDataReplicationMode() {
            return dataReplicationMode;
        }

        public final void setDataReplicationMode(String dataReplicationMode) {
            this.dataReplicationMode = dataReplicationMode;
        }

        @Override
        public final Builder dataReplicationMode(String dataReplicationMode) {
            this.dataReplicationMode = dataReplicationMode;
            return this;
        }

        @Override
        public final Builder dataReplicationMode(DataReplicationMode dataReplicationMode) {
            this.dataReplicationMode(dataReplicationMode == null ? null : dataReplicationMode.toString());
            return this;
        }

        public final DataReplicationMetadataOutput.Builder getPendingDataReplicationMetadata() {
            return pendingDataReplicationMetadata != null ? pendingDataReplicationMetadata.toBuilder() : null;
        }

        public final void setPendingDataReplicationMetadata(
                DataReplicationMetadataOutput.BuilderImpl pendingDataReplicationMetadata) {
            this.pendingDataReplicationMetadata = pendingDataReplicationMetadata != null ? pendingDataReplicationMetadata.build()
                    : null;
        }

        @Override
        public final Builder pendingDataReplicationMetadata(DataReplicationMetadataOutput pendingDataReplicationMetadata) {
            this.pendingDataReplicationMetadata = pendingDataReplicationMetadata;
            return this;
        }

        public final String getPendingDataReplicationMode() {
            return pendingDataReplicationMode;
        }

        public final void setPendingDataReplicationMode(String pendingDataReplicationMode) {
            this.pendingDataReplicationMode = pendingDataReplicationMode;
        }

        @Override
        public final Builder pendingDataReplicationMode(String pendingDataReplicationMode) {
            this.pendingDataReplicationMode = pendingDataReplicationMode;
            return this;
        }

        @Override
        public final Builder pendingDataReplicationMode(DataReplicationMode pendingDataReplicationMode) {
            this.pendingDataReplicationMode(pendingDataReplicationMode == null ? null : pendingDataReplicationMode.toString());
            return this;
        }

        @Override
        public DescribeBrokerResponse build() {
            return new DescribeBrokerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
