/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mobile.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result structure used for requests to export project configuration details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportProjectResponse extends MobileResponse implements
        ToCopyableBuilder<ExportProjectResponse.Builder, ExportProjectResponse> {
    private static final SdkField<String> DOWNLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("downloadUrl").getter(getter(ExportProjectResponse::downloadUrl)).setter(setter(Builder::downloadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadUrl").build()).build();

    private static final SdkField<String> SHARE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shareUrl").getter(getter(ExportProjectResponse::shareUrl)).setter(setter(Builder::shareUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareUrl").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotId").getter(getter(ExportProjectResponse::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOWNLOAD_URL_FIELD,
            SHARE_URL_FIELD, SNAPSHOT_ID_FIELD));

    private final String downloadUrl;

    private final String shareUrl;

    private final String snapshotId;

    private ExportProjectResponse(BuilderImpl builder) {
        super(builder);
        this.downloadUrl = builder.downloadUrl;
        this.shareUrl = builder.shareUrl;
        this.snapshotId = builder.snapshotId;
    }

    /**
     * <p>
     * URL which can be used to download the exported project configuation file(s).
     * </p>
     * 
     * @return URL which can be used to download the exported project configuation file(s).
     */
    public final String downloadUrl() {
        return downloadUrl;
    }

    /**
     * <p>
     * URL which can be shared to allow other AWS users to create their own project in AWS Mobile Hub with the same
     * configuration as the specified project. This URL pertains to a snapshot in time of the project configuration that
     * is created when this API is called. If you want to share additional changes to your project configuration, then
     * you will need to create and share a new snapshot by calling this method again.
     * </p>
     * 
     * @return URL which can be shared to allow other AWS users to create their own project in AWS Mobile Hub with the
     *         same configuration as the specified project. This URL pertains to a snapshot in time of the project
     *         configuration that is created when this API is called. If you want to share additional changes to your
     *         project configuration, then you will need to create and share a new snapshot by calling this method
     *         again.
     */
    public final String shareUrl() {
        return shareUrl;
    }

    /**
     * <p>
     * Unique identifier for the exported snapshot of the project configuration. This snapshot identifier is included in
     * the share URL.
     * </p>
     * 
     * @return Unique identifier for the exported snapshot of the project configuration. This snapshot identifier is
     *         included in the share URL.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(downloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(shareUrl());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportProjectResponse)) {
            return false;
        }
        ExportProjectResponse other = (ExportProjectResponse) obj;
        return Objects.equals(downloadUrl(), other.downloadUrl()) && Objects.equals(shareUrl(), other.shareUrl())
                && Objects.equals(snapshotId(), other.snapshotId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportProjectResponse").add("DownloadUrl", downloadUrl()).add("ShareUrl", shareUrl())
                .add("SnapshotId", snapshotId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "downloadUrl":
            return Optional.ofNullable(clazz.cast(downloadUrl()));
        case "shareUrl":
            return Optional.ofNullable(clazz.cast(shareUrl()));
        case "snapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportProjectResponse, T> g) {
        return obj -> g.apply((ExportProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MobileResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExportProjectResponse> {
        /**
         * <p>
         * URL which can be used to download the exported project configuation file(s).
         * </p>
         * 
         * @param downloadUrl
         *        URL which can be used to download the exported project configuation file(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downloadUrl(String downloadUrl);

        /**
         * <p>
         * URL which can be shared to allow other AWS users to create their own project in AWS Mobile Hub with the same
         * configuration as the specified project. This URL pertains to a snapshot in time of the project configuration
         * that is created when this API is called. If you want to share additional changes to your project
         * configuration, then you will need to create and share a new snapshot by calling this method again.
         * </p>
         * 
         * @param shareUrl
         *        URL which can be shared to allow other AWS users to create their own project in AWS Mobile Hub with
         *        the same configuration as the specified project. This URL pertains to a snapshot in time of the
         *        project configuration that is created when this API is called. If you want to share additional changes
         *        to your project configuration, then you will need to create and share a new snapshot by calling this
         *        method again.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareUrl(String shareUrl);

        /**
         * <p>
         * Unique identifier for the exported snapshot of the project configuration. This snapshot identifier is
         * included in the share URL.
         * </p>
         * 
         * @param snapshotId
         *        Unique identifier for the exported snapshot of the project configuration. This snapshot identifier is
         *        included in the share URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);
    }

    static final class BuilderImpl extends MobileResponse.BuilderImpl implements Builder {
        private String downloadUrl;

        private String shareUrl;

        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportProjectResponse model) {
            super(model);
            downloadUrl(model.downloadUrl);
            shareUrl(model.shareUrl);
            snapshotId(model.snapshotId);
        }

        public final String getDownloadUrl() {
            return downloadUrl;
        }

        public final void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        @Override
        public final Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public final String getShareUrl() {
            return shareUrl;
        }

        public final void setShareUrl(String shareUrl) {
            this.shareUrl = shareUrl;
        }

        @Override
        public final Builder shareUrl(String shareUrl) {
            this.shareUrl = shareUrl;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        @Override
        public ExportProjectResponse build() {
            return new ExportProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
