/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SCTE-35 <code>time_signal</code> message can be sent with one or more <code>segmentation_descriptor</code>
 * messages. A <code>time_signal</code> message can be sent only if a single <code>segmentation_descriptor</code>
 * message is sent.
 * </p>
 * <p>
 * The <code>time_signal</code> message contains only the <code>splice_time</code> field which is constructed using a
 * given presentation timestamp. When sending a <code>time_signal</code> message, the <code>splice_command_type</code>
 * field in the <code>splice_info_section</code> message is set to 6 (0x06).
 * </p>
 * <p>
 * See the <code>time_signal()</code> table of the 2022 SCTE-35 specification for more information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSignalMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeSignalMessage.Builder, TimeSignalMessage> {
    private static final SdkField<List<SegmentationDescriptor>> SEGMENTATION_DESCRIPTORS_FIELD = SdkField
            .<List<SegmentationDescriptor>> builder(MarshallingType.LIST)
            .memberName("SegmentationDescriptors")
            .getter(getter(TimeSignalMessage::segmentationDescriptors))
            .setter(setter(Builder::segmentationDescriptors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentationDescriptors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SegmentationDescriptor> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentationDescriptor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SEGMENTATION_DESCRIPTORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SegmentationDescriptor> segmentationDescriptors;

    private TimeSignalMessage(BuilderImpl builder) {
        this.segmentationDescriptors = builder.segmentationDescriptors;
    }

    /**
     * For responses, this returns true if the service returned a value for the SegmentationDescriptors property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSegmentationDescriptors() {
        return segmentationDescriptors != null && !(segmentationDescriptors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configurations for the SCTE-35 <code>segmentation_descriptor</code> message(s) sent with the
     * <code>time_signal</code> message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentationDescriptors} method.
     * </p>
     * 
     * @return The configurations for the SCTE-35 <code>segmentation_descriptor</code> message(s) sent with the
     *         <code>time_signal</code> message.
     */
    public final List<SegmentationDescriptor> segmentationDescriptors() {
        return segmentationDescriptors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentationDescriptors() ? segmentationDescriptors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSignalMessage)) {
            return false;
        }
        TimeSignalMessage other = (TimeSignalMessage) obj;
        return hasSegmentationDescriptors() == other.hasSegmentationDescriptors()
                && Objects.equals(segmentationDescriptors(), other.segmentationDescriptors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSignalMessage")
                .add("SegmentationDescriptors", hasSegmentationDescriptors() ? segmentationDescriptors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SegmentationDescriptors":
            return Optional.ofNullable(clazz.cast(segmentationDescriptors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeSignalMessage, T> g) {
        return obj -> g.apply((TimeSignalMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSignalMessage> {
        /**
         * <p>
         * The configurations for the SCTE-35 <code>segmentation_descriptor</code> message(s) sent with the
         * <code>time_signal</code> message.
         * </p>
         * 
         * @param segmentationDescriptors
         *        The configurations for the SCTE-35 <code>segmentation_descriptor</code> message(s) sent with the
         *        <code>time_signal</code> message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationDescriptors(Collection<SegmentationDescriptor> segmentationDescriptors);

        /**
         * <p>
         * The configurations for the SCTE-35 <code>segmentation_descriptor</code> message(s) sent with the
         * <code>time_signal</code> message.
         * </p>
         * 
         * @param segmentationDescriptors
         *        The configurations for the SCTE-35 <code>segmentation_descriptor</code> message(s) sent with the
         *        <code>time_signal</code> message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationDescriptors(SegmentationDescriptor... segmentationDescriptors);

        /**
         * <p>
         * The configurations for the SCTE-35 <code>segmentation_descriptor</code> message(s) sent with the
         * <code>time_signal</code> message.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.SegmentationDescriptor.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mediatailor.model.SegmentationDescriptor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.SegmentationDescriptor.Builder#build()} is called
         * immediately and its result is passed to {@link #segmentationDescriptors(List<SegmentationDescriptor>)}.
         * 
         * @param segmentationDescriptors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.SegmentationDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentationDescriptors(java.util.Collection<SegmentationDescriptor>)
         */
        Builder segmentationDescriptors(Consumer<SegmentationDescriptor.Builder>... segmentationDescriptors);
    }

    static final class BuilderImpl implements Builder {
        private List<SegmentationDescriptor> segmentationDescriptors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSignalMessage model) {
            segmentationDescriptors(model.segmentationDescriptors);
        }

        public final List<SegmentationDescriptor.Builder> getSegmentationDescriptors() {
            List<SegmentationDescriptor.Builder> result = SegmentationDescriptorListCopier
                    .copyToBuilder(this.segmentationDescriptors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentationDescriptors(Collection<SegmentationDescriptor.BuilderImpl> segmentationDescriptors) {
            this.segmentationDescriptors = SegmentationDescriptorListCopier.copyFromBuilder(segmentationDescriptors);
        }

        @Override
        public final Builder segmentationDescriptors(Collection<SegmentationDescriptor> segmentationDescriptors) {
            this.segmentationDescriptors = SegmentationDescriptorListCopier.copy(segmentationDescriptors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentationDescriptors(SegmentationDescriptor... segmentationDescriptors) {
            segmentationDescriptors(Arrays.asList(segmentationDescriptors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentationDescriptors(Consumer<SegmentationDescriptor.Builder>... segmentationDescriptors) {
            segmentationDescriptors(Stream.of(segmentationDescriptors)
                    .map(c -> SegmentationDescriptor.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TimeSignalMessage build() {
            return new TimeSignalMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
