/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A MediaPackage VOD PackagingConfiguration resource.
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackagingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PackagingConfiguration.Builder, PackagingConfiguration> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(PackagingConfiguration::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<CmafPackage> CMAF_PACKAGE_FIELD = SdkField.<CmafPackage> builder(MarshallingType.SDK_POJO)
            .memberName("CmafPackage").getter(getter(PackagingConfiguration::cmafPackage)).setter(setter(Builder::cmafPackage))
            .constructor(CmafPackage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cmafPackage").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedAt").getter(getter(PackagingConfiguration::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<DashPackage> DASH_PACKAGE_FIELD = SdkField.<DashPackage> builder(MarshallingType.SDK_POJO)
            .memberName("DashPackage").getter(getter(PackagingConfiguration::dashPackage)).setter(setter(Builder::dashPackage))
            .constructor(DashPackage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashPackage").build()).build();

    private static final SdkField<HlsPackage> HLS_PACKAGE_FIELD = SdkField.<HlsPackage> builder(MarshallingType.SDK_POJO)
            .memberName("HlsPackage").getter(getter(PackagingConfiguration::hlsPackage)).setter(setter(Builder::hlsPackage))
            .constructor(HlsPackage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsPackage").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(PackagingConfiguration::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<MssPackage> MSS_PACKAGE_FIELD = SdkField.<MssPackage> builder(MarshallingType.SDK_POJO)
            .memberName("MssPackage").getter(getter(PackagingConfiguration::mssPackage)).setter(setter(Builder::mssPackage))
            .constructor(MssPackage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mssPackage").build()).build();

    private static final SdkField<String> PACKAGING_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackagingGroupId").getter(getter(PackagingConfiguration::packagingGroupId))
            .setter(setter(Builder::packagingGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagingGroupId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(PackagingConfiguration::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CMAF_PACKAGE_FIELD,
            CREATED_AT_FIELD, DASH_PACKAGE_FIELD, HLS_PACKAGE_FIELD, ID_FIELD, MSS_PACKAGE_FIELD, PACKAGING_GROUP_ID_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final CmafPackage cmafPackage;

    private final String createdAt;

    private final DashPackage dashPackage;

    private final HlsPackage hlsPackage;

    private final String id;

    private final MssPackage mssPackage;

    private final String packagingGroupId;

    private final Map<String, String> tags;

    private PackagingConfiguration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.cmafPackage = builder.cmafPackage;
        this.createdAt = builder.createdAt;
        this.dashPackage = builder.dashPackage;
        this.hlsPackage = builder.hlsPackage;
        this.id = builder.id;
        this.mssPackage = builder.mssPackage;
        this.packagingGroupId = builder.packagingGroupId;
        this.tags = builder.tags;
    }

    /**
     * The ARN of the PackagingConfiguration.
     * 
     * @return The ARN of the PackagingConfiguration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * Returns the value of the CmafPackage property for this object.
     * 
     * @return The value of the CmafPackage property for this object.
     */
    public final CmafPackage cmafPackage() {
        return cmafPackage;
    }

    /**
     * The time the PackagingConfiguration was created.
     * 
     * @return The time the PackagingConfiguration was created.
     */
    public final String createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the DashPackage property for this object.
     * 
     * @return The value of the DashPackage property for this object.
     */
    public final DashPackage dashPackage() {
        return dashPackage;
    }

    /**
     * Returns the value of the HlsPackage property for this object.
     * 
     * @return The value of the HlsPackage property for this object.
     */
    public final HlsPackage hlsPackage() {
        return hlsPackage;
    }

    /**
     * The ID of the PackagingConfiguration.
     * 
     * @return The ID of the PackagingConfiguration.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the MssPackage property for this object.
     * 
     * @return The value of the MssPackage property for this object.
     */
    public final MssPackage mssPackage() {
        return mssPackage;
    }

    /**
     * The ID of a PackagingGroup.
     * 
     * @return The ID of a PackagingGroup.
     */
    public final String packagingGroupId() {
        return packagingGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(cmafPackage());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(dashPackage());
        hashCode = 31 * hashCode + Objects.hashCode(hlsPackage());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(mssPackage());
        hashCode = 31 * hashCode + Objects.hashCode(packagingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackagingConfiguration)) {
            return false;
        }
        PackagingConfiguration other = (PackagingConfiguration) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(cmafPackage(), other.cmafPackage())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(dashPackage(), other.dashPackage())
                && Objects.equals(hlsPackage(), other.hlsPackage()) && Objects.equals(id(), other.id())
                && Objects.equals(mssPackage(), other.mssPackage())
                && Objects.equals(packagingGroupId(), other.packagingGroupId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackagingConfiguration").add("Arn", arn()).add("CmafPackage", cmafPackage())
                .add("CreatedAt", createdAt()).add("DashPackage", dashPackage()).add("HlsPackage", hlsPackage()).add("Id", id())
                .add("MssPackage", mssPackage()).add("PackagingGroupId", packagingGroupId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CmafPackage":
            return Optional.ofNullable(clazz.cast(cmafPackage()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DashPackage":
            return Optional.ofNullable(clazz.cast(dashPackage()));
        case "HlsPackage":
            return Optional.ofNullable(clazz.cast(hlsPackage()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "MssPackage":
            return Optional.ofNullable(clazz.cast(mssPackage()));
        case "PackagingGroupId":
            return Optional.ofNullable(clazz.cast(packagingGroupId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackagingConfiguration, T> g) {
        return obj -> g.apply((PackagingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackagingConfiguration> {
        /**
         * The ARN of the PackagingConfiguration.
         * 
         * @param arn
         *        The ARN of the PackagingConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the CmafPackage property for this object.
         *
         * @param cmafPackage
         *        The new value for the CmafPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cmafPackage(CmafPackage cmafPackage);

        /**
         * Sets the value of the CmafPackage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CmafPackage.Builder} avoiding the need to
         * create one manually via {@link CmafPackage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CmafPackage.Builder#build()} is called immediately and its result
         * is passed to {@link #cmafPackage(CmafPackage)}.
         * 
         * @param cmafPackage
         *        a consumer that will call methods on {@link CmafPackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cmafPackage(CmafPackage)
         */
        default Builder cmafPackage(Consumer<CmafPackage.Builder> cmafPackage) {
            return cmafPackage(CmafPackage.builder().applyMutation(cmafPackage).build());
        }

        /**
         * The time the PackagingConfiguration was created.
         * 
         * @param createdAt
         *        The time the PackagingConfiguration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * Sets the value of the DashPackage property for this object.
         *
         * @param dashPackage
         *        The new value for the DashPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashPackage(DashPackage dashPackage);

        /**
         * Sets the value of the DashPackage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DashPackage.Builder} avoiding the need to
         * create one manually via {@link DashPackage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashPackage.Builder#build()} is called immediately and its result
         * is passed to {@link #dashPackage(DashPackage)}.
         * 
         * @param dashPackage
         *        a consumer that will call methods on {@link DashPackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashPackage(DashPackage)
         */
        default Builder dashPackage(Consumer<DashPackage.Builder> dashPackage) {
            return dashPackage(DashPackage.builder().applyMutation(dashPackage).build());
        }

        /**
         * Sets the value of the HlsPackage property for this object.
         *
         * @param hlsPackage
         *        The new value for the HlsPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsPackage(HlsPackage hlsPackage);

        /**
         * Sets the value of the HlsPackage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link HlsPackage.Builder} avoiding the need to
         * create one manually via {@link HlsPackage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HlsPackage.Builder#build()} is called immediately and its result
         * is passed to {@link #hlsPackage(HlsPackage)}.
         * 
         * @param hlsPackage
         *        a consumer that will call methods on {@link HlsPackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsPackage(HlsPackage)
         */
        default Builder hlsPackage(Consumer<HlsPackage.Builder> hlsPackage) {
            return hlsPackage(HlsPackage.builder().applyMutation(hlsPackage).build());
        }

        /**
         * The ID of the PackagingConfiguration.
         * 
         * @param id
         *        The ID of the PackagingConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the MssPackage property for this object.
         *
         * @param mssPackage
         *        The new value for the MssPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mssPackage(MssPackage mssPackage);

        /**
         * Sets the value of the MssPackage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MssPackage.Builder} avoiding the need to
         * create one manually via {@link MssPackage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MssPackage.Builder#build()} is called immediately and its result
         * is passed to {@link #mssPackage(MssPackage)}.
         * 
         * @param mssPackage
         *        a consumer that will call methods on {@link MssPackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mssPackage(MssPackage)
         */
        default Builder mssPackage(Consumer<MssPackage.Builder> mssPackage) {
            return mssPackage(MssPackage.builder().applyMutation(mssPackage).build());
        }

        /**
         * The ID of a PackagingGroup.
         * 
         * @param packagingGroupId
         *        The ID of a PackagingGroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagingGroupId(String packagingGroupId);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private CmafPackage cmafPackage;

        private String createdAt;

        private DashPackage dashPackage;

        private HlsPackage hlsPackage;

        private String id;

        private MssPackage mssPackage;

        private String packagingGroupId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PackagingConfiguration model) {
            arn(model.arn);
            cmafPackage(model.cmafPackage);
            createdAt(model.createdAt);
            dashPackage(model.dashPackage);
            hlsPackage(model.hlsPackage);
            id(model.id);
            mssPackage(model.mssPackage);
            packagingGroupId(model.packagingGroupId);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final CmafPackage.Builder getCmafPackage() {
            return cmafPackage != null ? cmafPackage.toBuilder() : null;
        }

        public final void setCmafPackage(CmafPackage.BuilderImpl cmafPackage) {
            this.cmafPackage = cmafPackage != null ? cmafPackage.build() : null;
        }

        @Override
        public final Builder cmafPackage(CmafPackage cmafPackage) {
            this.cmafPackage = cmafPackage;
            return this;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final DashPackage.Builder getDashPackage() {
            return dashPackage != null ? dashPackage.toBuilder() : null;
        }

        public final void setDashPackage(DashPackage.BuilderImpl dashPackage) {
            this.dashPackage = dashPackage != null ? dashPackage.build() : null;
        }

        @Override
        public final Builder dashPackage(DashPackage dashPackage) {
            this.dashPackage = dashPackage;
            return this;
        }

        public final HlsPackage.Builder getHlsPackage() {
            return hlsPackage != null ? hlsPackage.toBuilder() : null;
        }

        public final void setHlsPackage(HlsPackage.BuilderImpl hlsPackage) {
            this.hlsPackage = hlsPackage != null ? hlsPackage.build() : null;
        }

        @Override
        public final Builder hlsPackage(HlsPackage hlsPackage) {
            this.hlsPackage = hlsPackage;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MssPackage.Builder getMssPackage() {
            return mssPackage != null ? mssPackage.toBuilder() : null;
        }

        public final void setMssPackage(MssPackage.BuilderImpl mssPackage) {
            this.mssPackage = mssPackage != null ? mssPackage.build() : null;
        }

        @Override
        public final Builder mssPackage(MssPackage mssPackage) {
            this.mssPackage = mssPackage;
            return this;
        }

        public final String getPackagingGroupId() {
            return packagingGroupId;
        }

        public final void setPackagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
        }

        @Override
        public final Builder packagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public PackagingConfiguration build() {
            return new PackagingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
