/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specifies a particular video stream within an input source. An input may have only a single video selector.
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoSelector implements SdkPojo, Serializable, ToCopyableBuilder<VideoSelector.Builder, VideoSelector> {
    private static final SdkField<String> COLOR_SPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColorSpace").getter(getter(VideoSelector::colorSpaceAsString)).setter(setter(Builder::colorSpace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpace").build()).build();

    private static final SdkField<VideoSelectorColorSpaceSettings> COLOR_SPACE_SETTINGS_FIELD = SdkField
            .<VideoSelectorColorSpaceSettings> builder(MarshallingType.SDK_POJO).memberName("ColorSpaceSettings")
            .getter(getter(VideoSelector::colorSpaceSettings)).setter(setter(Builder::colorSpaceSettings))
            .constructor(VideoSelectorColorSpaceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceSettings").build())
            .build();

    private static final SdkField<String> COLOR_SPACE_USAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColorSpaceUsage").getter(getter(VideoSelector::colorSpaceUsageAsString))
            .setter(setter(Builder::colorSpaceUsage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceUsage").build()).build();

    private static final SdkField<VideoSelectorSettings> SELECTOR_SETTINGS_FIELD = SdkField
            .<VideoSelectorSettings> builder(MarshallingType.SDK_POJO).memberName("SelectorSettings")
            .getter(getter(VideoSelector::selectorSettings)).setter(setter(Builder::selectorSettings))
            .constructor(VideoSelectorSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectorSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLOR_SPACE_FIELD,
            COLOR_SPACE_SETTINGS_FIELD, COLOR_SPACE_USAGE_FIELD, SELECTOR_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String colorSpace;

    private final VideoSelectorColorSpaceSettings colorSpaceSettings;

    private final String colorSpaceUsage;

    private final VideoSelectorSettings selectorSettings;

    private VideoSelector(BuilderImpl builder) {
        this.colorSpace = builder.colorSpace;
        this.colorSpaceSettings = builder.colorSpaceSettings;
        this.colorSpaceUsage = builder.colorSpaceUsage;
        this.selectorSettings = builder.selectorSettings;
    }

    /**
     * Specifies the color space of an input. This setting works in tandem with colorSpaceUsage and a video
     * description's colorSpaceSettingsChoice to determine if any conversion will be performed.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorSpace} will
     * return {@link VideoSelectorColorSpace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #colorSpaceAsString}.
     * </p>
     * 
     * @return Specifies the color space of an input. This setting works in tandem with colorSpaceUsage and a video
     *         description's colorSpaceSettingsChoice to determine if any conversion will be performed.
     * @see VideoSelectorColorSpace
     */
    public final VideoSelectorColorSpace colorSpace() {
        return VideoSelectorColorSpace.fromValue(colorSpace);
    }

    /**
     * Specifies the color space of an input. This setting works in tandem with colorSpaceUsage and a video
     * description's colorSpaceSettingsChoice to determine if any conversion will be performed.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorSpace} will
     * return {@link VideoSelectorColorSpace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #colorSpaceAsString}.
     * </p>
     * 
     * @return Specifies the color space of an input. This setting works in tandem with colorSpaceUsage and a video
     *         description's colorSpaceSettingsChoice to determine if any conversion will be performed.
     * @see VideoSelectorColorSpace
     */
    public final String colorSpaceAsString() {
        return colorSpace;
    }

    /**
     * Color space settings
     * 
     * @return Color space settings
     */
    public final VideoSelectorColorSpaceSettings colorSpaceSettings() {
        return colorSpaceSettings;
    }

    /**
     * Applies only if colorSpace is a value other than follow. This field controls how the value in the colorSpace
     * field will be used. fallback means that when the input does include color space data, that data will be used, but
     * when the input has no color space data, the value in colorSpace will be used. Choose fallback if your input is
     * sometimes missing color space data, but when it does have color space data, that data is correct. force means to
     * always use the value in colorSpace. Choose force if your input usually has no color space data or might have
     * unreliable color space data.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorSpaceUsage}
     * will return {@link VideoSelectorColorSpaceUsage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #colorSpaceUsageAsString}.
     * </p>
     * 
     * @return Applies only if colorSpace is a value other than follow. This field controls how the value in the
     *         colorSpace field will be used. fallback means that when the input does include color space data, that
     *         data will be used, but when the input has no color space data, the value in colorSpace will be used.
     *         Choose fallback if your input is sometimes missing color space data, but when it does have color space
     *         data, that data is correct. force means to always use the value in colorSpace. Choose force if your input
     *         usually has no color space data or might have unreliable color space data.
     * @see VideoSelectorColorSpaceUsage
     */
    public final VideoSelectorColorSpaceUsage colorSpaceUsage() {
        return VideoSelectorColorSpaceUsage.fromValue(colorSpaceUsage);
    }

    /**
     * Applies only if colorSpace is a value other than follow. This field controls how the value in the colorSpace
     * field will be used. fallback means that when the input does include color space data, that data will be used, but
     * when the input has no color space data, the value in colorSpace will be used. Choose fallback if your input is
     * sometimes missing color space data, but when it does have color space data, that data is correct. force means to
     * always use the value in colorSpace. Choose force if your input usually has no color space data or might have
     * unreliable color space data.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorSpaceUsage}
     * will return {@link VideoSelectorColorSpaceUsage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #colorSpaceUsageAsString}.
     * </p>
     * 
     * @return Applies only if colorSpace is a value other than follow. This field controls how the value in the
     *         colorSpace field will be used. fallback means that when the input does include color space data, that
     *         data will be used, but when the input has no color space data, the value in colorSpace will be used.
     *         Choose fallback if your input is sometimes missing color space data, but when it does have color space
     *         data, that data is correct. force means to always use the value in colorSpace. Choose force if your input
     *         usually has no color space data or might have unreliable color space data.
     * @see VideoSelectorColorSpaceUsage
     */
    public final String colorSpaceUsageAsString() {
        return colorSpaceUsage;
    }

    /**
     * The video selector settings.
     * 
     * @return The video selector settings.
     */
    public final VideoSelectorSettings selectorSettings() {
        return selectorSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(colorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(colorSpaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(colorSpaceUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(selectorSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSelector)) {
            return false;
        }
        VideoSelector other = (VideoSelector) obj;
        return Objects.equals(colorSpaceAsString(), other.colorSpaceAsString())
                && Objects.equals(colorSpaceSettings(), other.colorSpaceSettings())
                && Objects.equals(colorSpaceUsageAsString(), other.colorSpaceUsageAsString())
                && Objects.equals(selectorSettings(), other.selectorSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoSelector").add("ColorSpace", colorSpaceAsString())
                .add("ColorSpaceSettings", colorSpaceSettings()).add("ColorSpaceUsage", colorSpaceUsageAsString())
                .add("SelectorSettings", selectorSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColorSpace":
            return Optional.ofNullable(clazz.cast(colorSpaceAsString()));
        case "ColorSpaceSettings":
            return Optional.ofNullable(clazz.cast(colorSpaceSettings()));
        case "ColorSpaceUsage":
            return Optional.ofNullable(clazz.cast(colorSpaceUsageAsString()));
        case "SelectorSettings":
            return Optional.ofNullable(clazz.cast(selectorSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoSelector, T> g) {
        return obj -> g.apply((VideoSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoSelector> {
        /**
         * Specifies the color space of an input. This setting works in tandem with colorSpaceUsage and a video
         * description's colorSpaceSettingsChoice to determine if any conversion will be performed.
         * 
         * @param colorSpace
         *        Specifies the color space of an input. This setting works in tandem with colorSpaceUsage and a video
         *        description's colorSpaceSettingsChoice to determine if any conversion will be performed.
         * @see VideoSelectorColorSpace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoSelectorColorSpace
         */
        Builder colorSpace(String colorSpace);

        /**
         * Specifies the color space of an input. This setting works in tandem with colorSpaceUsage and a video
         * description's colorSpaceSettingsChoice to determine if any conversion will be performed.
         * 
         * @param colorSpace
         *        Specifies the color space of an input. This setting works in tandem with colorSpaceUsage and a video
         *        description's colorSpaceSettingsChoice to determine if any conversion will be performed.
         * @see VideoSelectorColorSpace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoSelectorColorSpace
         */
        Builder colorSpace(VideoSelectorColorSpace colorSpace);

        /**
         * Color space settings
         * 
         * @param colorSpaceSettings
         *        Color space settings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorSpaceSettings(VideoSelectorColorSpaceSettings colorSpaceSettings);

        /**
         * Color space settings This is a convenience method that creates an instance of the
         * {@link VideoSelectorColorSpaceSettings.Builder} avoiding the need to create one manually via
         * {@link VideoSelectorColorSpaceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoSelectorColorSpaceSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #colorSpaceSettings(VideoSelectorColorSpaceSettings)}.
         * 
         * @param colorSpaceSettings
         *        a consumer that will call methods on {@link VideoSelectorColorSpaceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorSpaceSettings(VideoSelectorColorSpaceSettings)
         */
        default Builder colorSpaceSettings(Consumer<VideoSelectorColorSpaceSettings.Builder> colorSpaceSettings) {
            return colorSpaceSettings(VideoSelectorColorSpaceSettings.builder().applyMutation(colorSpaceSettings).build());
        }

        /**
         * Applies only if colorSpace is a value other than follow. This field controls how the value in the colorSpace
         * field will be used. fallback means that when the input does include color space data, that data will be used,
         * but when the input has no color space data, the value in colorSpace will be used. Choose fallback if your
         * input is sometimes missing color space data, but when it does have color space data, that data is correct.
         * force means to always use the value in colorSpace. Choose force if your input usually has no color space data
         * or might have unreliable color space data.
         * 
         * @param colorSpaceUsage
         *        Applies only if colorSpace is a value other than follow. This field controls how the value in the
         *        colorSpace field will be used. fallback means that when the input does include color space data, that
         *        data will be used, but when the input has no color space data, the value in colorSpace will be used.
         *        Choose fallback if your input is sometimes missing color space data, but when it does have color space
         *        data, that data is correct. force means to always use the value in colorSpace. Choose force if your
         *        input usually has no color space data or might have unreliable color space data.
         * @see VideoSelectorColorSpaceUsage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoSelectorColorSpaceUsage
         */
        Builder colorSpaceUsage(String colorSpaceUsage);

        /**
         * Applies only if colorSpace is a value other than follow. This field controls how the value in the colorSpace
         * field will be used. fallback means that when the input does include color space data, that data will be used,
         * but when the input has no color space data, the value in colorSpace will be used. Choose fallback if your
         * input is sometimes missing color space data, but when it does have color space data, that data is correct.
         * force means to always use the value in colorSpace. Choose force if your input usually has no color space data
         * or might have unreliable color space data.
         * 
         * @param colorSpaceUsage
         *        Applies only if colorSpace is a value other than follow. This field controls how the value in the
         *        colorSpace field will be used. fallback means that when the input does include color space data, that
         *        data will be used, but when the input has no color space data, the value in colorSpace will be used.
         *        Choose fallback if your input is sometimes missing color space data, but when it does have color space
         *        data, that data is correct. force means to always use the value in colorSpace. Choose force if your
         *        input usually has no color space data or might have unreliable color space data.
         * @see VideoSelectorColorSpaceUsage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoSelectorColorSpaceUsage
         */
        Builder colorSpaceUsage(VideoSelectorColorSpaceUsage colorSpaceUsage);

        /**
         * The video selector settings.
         * 
         * @param selectorSettings
         *        The video selector settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectorSettings(VideoSelectorSettings selectorSettings);

        /**
         * The video selector settings. This is a convenience method that creates an instance of the
         * {@link VideoSelectorSettings.Builder} avoiding the need to create one manually via
         * {@link VideoSelectorSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoSelectorSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #selectorSettings(VideoSelectorSettings)}.
         * 
         * @param selectorSettings
         *        a consumer that will call methods on {@link VideoSelectorSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectorSettings(VideoSelectorSettings)
         */
        default Builder selectorSettings(Consumer<VideoSelectorSettings.Builder> selectorSettings) {
            return selectorSettings(VideoSelectorSettings.builder().applyMutation(selectorSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String colorSpace;

        private VideoSelectorColorSpaceSettings colorSpaceSettings;

        private String colorSpaceUsage;

        private VideoSelectorSettings selectorSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSelector model) {
            colorSpace(model.colorSpace);
            colorSpaceSettings(model.colorSpaceSettings);
            colorSpaceUsage(model.colorSpaceUsage);
            selectorSettings(model.selectorSettings);
        }

        public final String getColorSpace() {
            return colorSpace;
        }

        public final void setColorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
        }

        @Override
        public final Builder colorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
            return this;
        }

        @Override
        public final Builder colorSpace(VideoSelectorColorSpace colorSpace) {
            this.colorSpace(colorSpace == null ? null : colorSpace.toString());
            return this;
        }

        public final VideoSelectorColorSpaceSettings.Builder getColorSpaceSettings() {
            return colorSpaceSettings != null ? colorSpaceSettings.toBuilder() : null;
        }

        public final void setColorSpaceSettings(VideoSelectorColorSpaceSettings.BuilderImpl colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings != null ? colorSpaceSettings.build() : null;
        }

        @Override
        public final Builder colorSpaceSettings(VideoSelectorColorSpaceSettings colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings;
            return this;
        }

        public final String getColorSpaceUsage() {
            return colorSpaceUsage;
        }

        public final void setColorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
        }

        @Override
        public final Builder colorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
            return this;
        }

        @Override
        public final Builder colorSpaceUsage(VideoSelectorColorSpaceUsage colorSpaceUsage) {
            this.colorSpaceUsage(colorSpaceUsage == null ? null : colorSpaceUsage.toString());
            return this;
        }

        public final VideoSelectorSettings.Builder getSelectorSettings() {
            return selectorSettings != null ? selectorSettings.toBuilder() : null;
        }

        public final void setSelectorSettings(VideoSelectorSettings.BuilderImpl selectorSettings) {
            this.selectorSettings = selectorSettings != null ? selectorSettings.build() : null;
        }

        @Override
        public final Builder selectorSettings(VideoSelectorSettings selectorSettings) {
            this.selectorSettings = selectorSettings;
            return this;
        }

        @Override
        public VideoSelector build() {
            return new VideoSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
