/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Archive S3 Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchiveS3Settings implements SdkPojo, Serializable,
        ToCopyableBuilder<ArchiveS3Settings.Builder, ArchiveS3Settings> {
    private static final SdkField<String> CANNED_ACL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CannedAcl").getter(getter(ArchiveS3Settings::cannedAclAsString)).setter(setter(Builder::cannedAcl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cannedAcl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANNED_ACL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cannedAcl;

    private ArchiveS3Settings(BuilderImpl builder) {
        this.cannedAcl = builder.cannedAcl;
    }

    /**
     * Specify the canned ACL to apply to each S3 request. Defaults to none.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cannedAcl} will
     * return {@link S3CannedAcl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cannedAclAsString}.
     * </p>
     * 
     * @return Specify the canned ACL to apply to each S3 request. Defaults to none.
     * @see S3CannedAcl
     */
    public final S3CannedAcl cannedAcl() {
        return S3CannedAcl.fromValue(cannedAcl);
    }

    /**
     * Specify the canned ACL to apply to each S3 request. Defaults to none.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cannedAcl} will
     * return {@link S3CannedAcl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cannedAclAsString}.
     * </p>
     * 
     * @return Specify the canned ACL to apply to each S3 request. Defaults to none.
     * @see S3CannedAcl
     */
    public final String cannedAclAsString() {
        return cannedAcl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cannedAclAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveS3Settings)) {
            return false;
        }
        ArchiveS3Settings other = (ArchiveS3Settings) obj;
        return Objects.equals(cannedAclAsString(), other.cannedAclAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArchiveS3Settings").add("CannedAcl", cannedAclAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CannedAcl":
            return Optional.ofNullable(clazz.cast(cannedAclAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArchiveS3Settings, T> g) {
        return obj -> g.apply((ArchiveS3Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchiveS3Settings> {
        /**
         * Specify the canned ACL to apply to each S3 request. Defaults to none.
         * 
         * @param cannedAcl
         *        Specify the canned ACL to apply to each S3 request. Defaults to none.
         * @see S3CannedAcl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3CannedAcl
         */
        Builder cannedAcl(String cannedAcl);

        /**
         * Specify the canned ACL to apply to each S3 request. Defaults to none.
         * 
         * @param cannedAcl
         *        Specify the canned ACL to apply to each S3 request. Defaults to none.
         * @see S3CannedAcl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3CannedAcl
         */
        Builder cannedAcl(S3CannedAcl cannedAcl);
    }

    static final class BuilderImpl implements Builder {
        private String cannedAcl;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveS3Settings model) {
            cannedAcl(model.cannedAcl);
        }

        public final String getCannedAcl() {
            return cannedAcl;
        }

        public final void setCannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
        }

        @Override
        public final Builder cannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
            return this;
        }

        @Override
        public final Builder cannedAcl(S3CannedAcl cannedAcl) {
            this.cannedAcl(cannedAcl == null ? null : cannedAcl.toString());
            return this;
        }

        @Override
        public ArchiveS3Settings build() {
            return new ArchiveS3Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
