/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Type of video codec
 */
@Generated("software.amazon.awssdk:codegen")
public enum VideoCodec {
    AV1("AV1"),

    AVC_INTRA("AVC_INTRA"),

    FRAME_CAPTURE("FRAME_CAPTURE"),

    H_264("H_264"),

    H_265("H_265"),

    MPEG2("MPEG2"),

    PASSTHROUGH("PASSTHROUGH"),

    PRORES("PRORES"),

    VC3("VC3"),

    VP8("VP8"),

    VP9("VP9"),

    XAVC("XAVC"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VideoCodec> VALUE_MAP = EnumUtils.uniqueIndex(VideoCodec.class, VideoCodec::toString);

    private final String value;

    private VideoCodec(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return VideoCodec corresponding to the value
     */
    public static VideoCodec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link VideoCodec}s
     */
    public static Set<VideoCodec> knownValues() {
        Set<VideoCodec> knownValues = EnumSet.allOf(VideoCodec.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
