/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Set Framerate to make sure that the captions and the video are synchronized in the output. Specify a frame rate that
 * matches the frame rate of the associated video. If the video frame rate is 29.97, choose 29.97 dropframe only if the
 * video has video_insertion=true and drop_frame_timecode=true; otherwise, choose 29.97 non-dropframe.
 */
@Generated("software.amazon.awssdk:codegen")
public enum SccDestinationFramerate {
    FRAMERATE_23_97("FRAMERATE_23_97"),

    FRAMERATE_24("FRAMERATE_24"),

    FRAMERATE_25("FRAMERATE_25"),

    FRAMERATE_29_97_DROPFRAME("FRAMERATE_29_97_DROPFRAME"),

    FRAMERATE_29_97_NON_DROPFRAME("FRAMERATE_29_97_NON_DROPFRAME"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SccDestinationFramerate> VALUE_MAP = EnumUtils.uniqueIndex(SccDestinationFramerate.class,
            SccDestinationFramerate::toString);

    private final String value;

    private SccDestinationFramerate(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return SccDestinationFramerate corresponding to the value
     */
    public static SccDestinationFramerate fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link SccDestinationFramerate}s
     */
    public static Set<SccDestinationFramerate> knownValues() {
        Set<SccDestinationFramerate> knownValues = EnumSet.allOf(SccDestinationFramerate.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
