/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * For motion overlays that don't have a built-in frame rate, specify the frame rate of the overlay in frames per
 * second, as a fraction. For example, specify 24 fps as 24/1. The overlay frame rate doesn't need to match the frame
 * rate of the underlying video.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MotionImageInsertionFramerate implements SdkPojo, Serializable,
        ToCopyableBuilder<MotionImageInsertionFramerate.Builder, MotionImageInsertionFramerate> {
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(MotionImageInsertionFramerate::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(MotionImageInsertionFramerate::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMERATE_DENOMINATOR_FIELD,
            FRAMERATE_NUMERATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private MotionImageInsertionFramerate(BuilderImpl builder) {
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
    }

    /**
     * The bottom of the fraction that expresses your overlay frame rate. For example, if your frame rate is 24 fps, set
     * this value to 1.
     * 
     * @return The bottom of the fraction that expresses your overlay frame rate. For example, if your frame rate is 24
     *         fps, set this value to 1.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * The top of the fraction that expresses your overlay frame rate. For example, if your frame rate is 24 fps, set
     * this value to 24.
     * 
     * @return The top of the fraction that expresses your overlay frame rate. For example, if your frame rate is 24
     *         fps, set this value to 24.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MotionImageInsertionFramerate)) {
            return false;
        }
        MotionImageInsertionFramerate other = (MotionImageInsertionFramerate) obj;
        return Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MotionImageInsertionFramerate").add("FramerateDenominator", framerateDenominator())
                .add("FramerateNumerator", framerateNumerator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MotionImageInsertionFramerate, T> g) {
        return obj -> g.apply((MotionImageInsertionFramerate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MotionImageInsertionFramerate> {
        /**
         * The bottom of the fraction that expresses your overlay frame rate. For example, if your frame rate is 24 fps,
         * set this value to 1.
         * 
         * @param framerateDenominator
         *        The bottom of the fraction that expresses your overlay frame rate. For example, if your frame rate is
         *        24 fps, set this value to 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * The top of the fraction that expresses your overlay frame rate. For example, if your frame rate is 24 fps,
         * set this value to 24.
         * 
         * @param framerateNumerator
         *        The top of the fraction that expresses your overlay frame rate. For example, if your frame rate is 24
         *        fps, set this value to 24.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);
    }

    static final class BuilderImpl implements Builder {
        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private BuilderImpl() {
        }

        private BuilderImpl(MotionImageInsertionFramerate model) {
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        @Override
        public MotionImageInsertionFramerate build() {
            return new MotionImageInsertionFramerate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
