/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify how MediaConvert maps brightness and colors from your HDR input to your SDR output. The mode that you select
 * represents a creative choice, with different tradeoffs in the details and tones of your output. To maintain details
 * in bright or saturated areas of your output: Choose Preserve details. For some sources, your SDR output may look less
 * bright and less saturated when compared to your HDR source. MediaConvert automatically applies this mode for HLG
 * sources, regardless of your choice. For a bright and saturated output: Choose Vibrant. We recommend that you choose
 * this mode when any of your source content is HDR10, and for the best results when it is mastered for 1000 nits. You
 * may notice loss of details in bright or saturated areas of your output. HDR to SDR tone mapping has no effect when
 * your input is SDR.
 */
@Generated("software.amazon.awssdk:codegen")
public enum HDRToSDRToneMapper {
    PRESERVE_DETAILS("PRESERVE_DETAILS"),

    VIBRANT("VIBRANT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HDRToSDRToneMapper> VALUE_MAP = EnumUtils.uniqueIndex(HDRToSDRToneMapper.class,
            HDRToSDRToneMapper::toString);

    private final String value;

    private HDRToSDRToneMapper(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return HDRToSDRToneMapper corresponding to the value
     */
    public static HDRToSDRToneMapper fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link HDRToSDRToneMapper}s
     */
    public static Set<HDRToSDRToneMapper> knownValues() {
        Set<HDRToSDRToneMapper> knownValues = EnumSet.allOf(HDRToSDRToneMapper.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
