/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in each
 * video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video AdaptationSet:
 * Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any Representation that does not share a
 * common timeline. To write a video AdaptationSet for each different output framerate, and a common SegmentTimeline in
 * each AdaptationSet: Choose Distinct.
 */
@Generated("software.amazon.awssdk:codegen")
public enum DashManifestStyle {
    BASIC("BASIC"),

    COMPACT("COMPACT"),

    DISTINCT("DISTINCT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DashManifestStyle> VALUE_MAP = EnumUtils.uniqueIndex(DashManifestStyle.class,
            DashManifestStyle::toString);

    private final String value;

    private DashManifestStyle(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DashManifestStyle corresponding to the value
     */
    public static DashManifestStyle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DashManifestStyle}s
     */
    public static Set<DashManifestStyle> knownValues() {
        Set<DashManifestStyle> knownValues = EnumSet.allOf(DashManifestStyle.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
