/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
 */
@Generated("software.amazon.awssdk:codegen")
public final class CmafImageBasedTrickPlaySettings implements SdkPojo, Serializable,
        ToCopyableBuilder<CmafImageBasedTrickPlaySettings.Builder, CmafImageBasedTrickPlaySettings> {
    private static final SdkField<String> INTERVAL_CADENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntervalCadence").getter(getter(CmafImageBasedTrickPlaySettings::intervalCadenceAsString))
            .setter(setter(Builder::intervalCadence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intervalCadence").build()).build();

    private static final SdkField<Integer> THUMBNAIL_HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThumbnailHeight").getter(getter(CmafImageBasedTrickPlaySettings::thumbnailHeight))
            .setter(setter(Builder::thumbnailHeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailHeight").build()).build();

    private static final SdkField<Double> THUMBNAIL_INTERVAL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ThumbnailInterval").getter(getter(CmafImageBasedTrickPlaySettings::thumbnailInterval))
            .setter(setter(Builder::thumbnailInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailInterval").build()).build();

    private static final SdkField<Integer> THUMBNAIL_WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThumbnailWidth").getter(getter(CmafImageBasedTrickPlaySettings::thumbnailWidth))
            .setter(setter(Builder::thumbnailWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailWidth").build()).build();

    private static final SdkField<Integer> TILE_HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TileHeight").getter(getter(CmafImageBasedTrickPlaySettings::tileHeight))
            .setter(setter(Builder::tileHeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tileHeight").build()).build();

    private static final SdkField<Integer> TILE_WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TileWidth").getter(getter(CmafImageBasedTrickPlaySettings::tileWidth))
            .setter(setter(Builder::tileWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tileWidth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_CADENCE_FIELD,
            THUMBNAIL_HEIGHT_FIELD, THUMBNAIL_INTERVAL_FIELD, THUMBNAIL_WIDTH_FIELD, TILE_HEIGHT_FIELD, TILE_WIDTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String intervalCadence;

    private final Integer thumbnailHeight;

    private final Double thumbnailInterval;

    private final Integer thumbnailWidth;

    private final Integer tileHeight;

    private final Integer tileWidth;

    private CmafImageBasedTrickPlaySettings(BuilderImpl builder) {
        this.intervalCadence = builder.intervalCadence;
        this.thumbnailHeight = builder.thumbnailHeight;
        this.thumbnailInterval = builder.thumbnailInterval;
        this.thumbnailWidth = builder.thumbnailWidth;
        this.tileHeight = builder.tileHeight;
        this.tileWidth = builder.tileWidth;
    }

    /**
     * The cadence MediaConvert follows for generating thumbnails. If set to FOLLOW_IFRAME, MediaConvert generates
     * thumbnails for each IDR frame in the output (matching the GOP cadence). If set to FOLLOW_CUSTOM, MediaConvert
     * generates thumbnails according to the interval you specify in thumbnailInterval.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intervalCadence}
     * will return {@link CmafIntervalCadence#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #intervalCadenceAsString}.
     * </p>
     * 
     * @return The cadence MediaConvert follows for generating thumbnails. If set to FOLLOW_IFRAME, MediaConvert
     *         generates thumbnails for each IDR frame in the output (matching the GOP cadence). If set to
     *         FOLLOW_CUSTOM, MediaConvert generates thumbnails according to the interval you specify in
     *         thumbnailInterval.
     * @see CmafIntervalCadence
     */
    public final CmafIntervalCadence intervalCadence() {
        return CmafIntervalCadence.fromValue(intervalCadence);
    }

    /**
     * The cadence MediaConvert follows for generating thumbnails. If set to FOLLOW_IFRAME, MediaConvert generates
     * thumbnails for each IDR frame in the output (matching the GOP cadence). If set to FOLLOW_CUSTOM, MediaConvert
     * generates thumbnails according to the interval you specify in thumbnailInterval.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intervalCadence}
     * will return {@link CmafIntervalCadence#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #intervalCadenceAsString}.
     * </p>
     * 
     * @return The cadence MediaConvert follows for generating thumbnails. If set to FOLLOW_IFRAME, MediaConvert
     *         generates thumbnails for each IDR frame in the output (matching the GOP cadence). If set to
     *         FOLLOW_CUSTOM, MediaConvert generates thumbnails according to the interval you specify in
     *         thumbnailInterval.
     * @see CmafIntervalCadence
     */
    public final String intervalCadenceAsString() {
        return intervalCadence;
    }

    /**
     * Height of each thumbnail within each tile image, in pixels. Leave blank to maintain aspect ratio with thumbnail
     * width. If following the aspect ratio would lead to a total tile height greater than 4096, then the job will be
     * rejected. Must be divisible by 2.
     * 
     * @return Height of each thumbnail within each tile image, in pixels. Leave blank to maintain aspect ratio with
     *         thumbnail width. If following the aspect ratio would lead to a total tile height greater than 4096, then
     *         the job will be rejected. Must be divisible by 2.
     */
    public final Integer thumbnailHeight() {
        return thumbnailHeight;
    }

    /**
     * Enter the interval, in seconds, that MediaConvert uses to generate thumbnails. If the interval you enter doesn't
     * align with the output frame rate, MediaConvert automatically rounds the interval to align with the output frame
     * rate. For example, if the output frame rate is 29.97 frames per second and you enter 5, MediaConvert uses a 150
     * frame interval to generate thumbnails.
     * 
     * @return Enter the interval, in seconds, that MediaConvert uses to generate thumbnails. If the interval you enter
     *         doesn't align with the output frame rate, MediaConvert automatically rounds the interval to align with
     *         the output frame rate. For example, if the output frame rate is 29.97 frames per second and you enter 5,
     *         MediaConvert uses a 150 frame interval to generate thumbnails.
     */
    public final Double thumbnailInterval() {
        return thumbnailInterval;
    }

    /**
     * Width of each thumbnail within each tile image, in pixels. Default is 312. Must be divisible by 8.
     * 
     * @return Width of each thumbnail within each tile image, in pixels. Default is 312. Must be divisible by 8.
     */
    public final Integer thumbnailWidth() {
        return thumbnailWidth;
    }

    /**
     * Number of thumbnails in each column of a tile image. Set a value between 2 and 2048. Must be divisible by 2.
     * 
     * @return Number of thumbnails in each column of a tile image. Set a value between 2 and 2048. Must be divisible by
     *         2.
     */
    public final Integer tileHeight() {
        return tileHeight;
    }

    /**
     * Number of thumbnails in each row of a tile image. Set a value between 1 and 512.
     * 
     * @return Number of thumbnails in each row of a tile image. Set a value between 1 and 512.
     */
    public final Integer tileWidth() {
        return tileWidth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intervalCadenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailHeight());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailInterval());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailWidth());
        hashCode = 31 * hashCode + Objects.hashCode(tileHeight());
        hashCode = 31 * hashCode + Objects.hashCode(tileWidth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafImageBasedTrickPlaySettings)) {
            return false;
        }
        CmafImageBasedTrickPlaySettings other = (CmafImageBasedTrickPlaySettings) obj;
        return Objects.equals(intervalCadenceAsString(), other.intervalCadenceAsString())
                && Objects.equals(thumbnailHeight(), other.thumbnailHeight())
                && Objects.equals(thumbnailInterval(), other.thumbnailInterval())
                && Objects.equals(thumbnailWidth(), other.thumbnailWidth()) && Objects.equals(tileHeight(), other.tileHeight())
                && Objects.equals(tileWidth(), other.tileWidth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CmafImageBasedTrickPlaySettings").add("IntervalCadence", intervalCadenceAsString())
                .add("ThumbnailHeight", thumbnailHeight()).add("ThumbnailInterval", thumbnailInterval())
                .add("ThumbnailWidth", thumbnailWidth()).add("TileHeight", tileHeight()).add("TileWidth", tileWidth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntervalCadence":
            return Optional.ofNullable(clazz.cast(intervalCadenceAsString()));
        case "ThumbnailHeight":
            return Optional.ofNullable(clazz.cast(thumbnailHeight()));
        case "ThumbnailInterval":
            return Optional.ofNullable(clazz.cast(thumbnailInterval()));
        case "ThumbnailWidth":
            return Optional.ofNullable(clazz.cast(thumbnailWidth()));
        case "TileHeight":
            return Optional.ofNullable(clazz.cast(tileHeight()));
        case "TileWidth":
            return Optional.ofNullable(clazz.cast(tileWidth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmafImageBasedTrickPlaySettings, T> g) {
        return obj -> g.apply((CmafImageBasedTrickPlaySettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CmafImageBasedTrickPlaySettings> {
        /**
         * The cadence MediaConvert follows for generating thumbnails. If set to FOLLOW_IFRAME, MediaConvert generates
         * thumbnails for each IDR frame in the output (matching the GOP cadence). If set to FOLLOW_CUSTOM, MediaConvert
         * generates thumbnails according to the interval you specify in thumbnailInterval.
         * 
         * @param intervalCadence
         *        The cadence MediaConvert follows for generating thumbnails. If set to FOLLOW_IFRAME, MediaConvert
         *        generates thumbnails for each IDR frame in the output (matching the GOP cadence). If set to
         *        FOLLOW_CUSTOM, MediaConvert generates thumbnails according to the interval you specify in
         *        thumbnailInterval.
         * @see CmafIntervalCadence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafIntervalCadence
         */
        Builder intervalCadence(String intervalCadence);

        /**
         * The cadence MediaConvert follows for generating thumbnails. If set to FOLLOW_IFRAME, MediaConvert generates
         * thumbnails for each IDR frame in the output (matching the GOP cadence). If set to FOLLOW_CUSTOM, MediaConvert
         * generates thumbnails according to the interval you specify in thumbnailInterval.
         * 
         * @param intervalCadence
         *        The cadence MediaConvert follows for generating thumbnails. If set to FOLLOW_IFRAME, MediaConvert
         *        generates thumbnails for each IDR frame in the output (matching the GOP cadence). If set to
         *        FOLLOW_CUSTOM, MediaConvert generates thumbnails according to the interval you specify in
         *        thumbnailInterval.
         * @see CmafIntervalCadence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafIntervalCadence
         */
        Builder intervalCadence(CmafIntervalCadence intervalCadence);

        /**
         * Height of each thumbnail within each tile image, in pixels. Leave blank to maintain aspect ratio with
         * thumbnail width. If following the aspect ratio would lead to a total tile height greater than 4096, then the
         * job will be rejected. Must be divisible by 2.
         * 
         * @param thumbnailHeight
         *        Height of each thumbnail within each tile image, in pixels. Leave blank to maintain aspect ratio with
         *        thumbnail width. If following the aspect ratio would lead to a total tile height greater than 4096,
         *        then the job will be rejected. Must be divisible by 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailHeight(Integer thumbnailHeight);

        /**
         * Enter the interval, in seconds, that MediaConvert uses to generate thumbnails. If the interval you enter
         * doesn't align with the output frame rate, MediaConvert automatically rounds the interval to align with the
         * output frame rate. For example, if the output frame rate is 29.97 frames per second and you enter 5,
         * MediaConvert uses a 150 frame interval to generate thumbnails.
         * 
         * @param thumbnailInterval
         *        Enter the interval, in seconds, that MediaConvert uses to generate thumbnails. If the interval you
         *        enter doesn't align with the output frame rate, MediaConvert automatically rounds the interval to
         *        align with the output frame rate. For example, if the output frame rate is 29.97 frames per second and
         *        you enter 5, MediaConvert uses a 150 frame interval to generate thumbnails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailInterval(Double thumbnailInterval);

        /**
         * Width of each thumbnail within each tile image, in pixels. Default is 312. Must be divisible by 8.
         * 
         * @param thumbnailWidth
         *        Width of each thumbnail within each tile image, in pixels. Default is 312. Must be divisible by 8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailWidth(Integer thumbnailWidth);

        /**
         * Number of thumbnails in each column of a tile image. Set a value between 2 and 2048. Must be divisible by 2.
         * 
         * @param tileHeight
         *        Number of thumbnails in each column of a tile image. Set a value between 2 and 2048. Must be divisible
         *        by 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tileHeight(Integer tileHeight);

        /**
         * Number of thumbnails in each row of a tile image. Set a value between 1 and 512.
         * 
         * @param tileWidth
         *        Number of thumbnails in each row of a tile image. Set a value between 1 and 512.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tileWidth(Integer tileWidth);
    }

    static final class BuilderImpl implements Builder {
        private String intervalCadence;

        private Integer thumbnailHeight;

        private Double thumbnailInterval;

        private Integer thumbnailWidth;

        private Integer tileHeight;

        private Integer tileWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafImageBasedTrickPlaySettings model) {
            intervalCadence(model.intervalCadence);
            thumbnailHeight(model.thumbnailHeight);
            thumbnailInterval(model.thumbnailInterval);
            thumbnailWidth(model.thumbnailWidth);
            tileHeight(model.tileHeight);
            tileWidth(model.tileWidth);
        }

        public final String getIntervalCadence() {
            return intervalCadence;
        }

        public final void setIntervalCadence(String intervalCadence) {
            this.intervalCadence = intervalCadence;
        }

        @Override
        public final Builder intervalCadence(String intervalCadence) {
            this.intervalCadence = intervalCadence;
            return this;
        }

        @Override
        public final Builder intervalCadence(CmafIntervalCadence intervalCadence) {
            this.intervalCadence(intervalCadence == null ? null : intervalCadence.toString());
            return this;
        }

        public final Integer getThumbnailHeight() {
            return thumbnailHeight;
        }

        public final void setThumbnailHeight(Integer thumbnailHeight) {
            this.thumbnailHeight = thumbnailHeight;
        }

        @Override
        public final Builder thumbnailHeight(Integer thumbnailHeight) {
            this.thumbnailHeight = thumbnailHeight;
            return this;
        }

        public final Double getThumbnailInterval() {
            return thumbnailInterval;
        }

        public final void setThumbnailInterval(Double thumbnailInterval) {
            this.thumbnailInterval = thumbnailInterval;
        }

        @Override
        public final Builder thumbnailInterval(Double thumbnailInterval) {
            this.thumbnailInterval = thumbnailInterval;
            return this;
        }

        public final Integer getThumbnailWidth() {
            return thumbnailWidth;
        }

        public final void setThumbnailWidth(Integer thumbnailWidth) {
            this.thumbnailWidth = thumbnailWidth;
        }

        @Override
        public final Builder thumbnailWidth(Integer thumbnailWidth) {
            this.thumbnailWidth = thumbnailWidth;
            return this;
        }

        public final Integer getTileHeight() {
            return tileHeight;
        }

        public final void setTileHeight(Integer tileHeight) {
            this.tileHeight = tileHeight;
        }

        @Override
        public final Builder tileHeight(Integer tileHeight) {
            this.tileHeight = tileHeight;
            return this;
        }

        public final Integer getTileWidth() {
            return tileWidth;
        }

        public final void setTileWidth(Integer tileWidth) {
            this.tileWidth = tileWidth;
        }

        @Override
        public final Builder tileWidth(Integer tileWidth) {
            this.tileWidth = tileWidth;
            return this;
        }

        @Override
        public CmafImageBasedTrickPlaySettings build() {
            return new CmafImageBasedTrickPlaySettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
