/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The source configuration for cloud flows receiving a stream from a bridge.
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatewayBridgeSource implements SdkPojo, Serializable,
        ToCopyableBuilder<GatewayBridgeSource.Builder, GatewayBridgeSource> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BridgeArn").getter(getter(GatewayBridgeSource::bridgeArn)).setter(setter(Builder::bridgeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeArn").build()).build();

    private static final SdkField<VpcInterfaceAttachment> VPC_INTERFACE_ATTACHMENT_FIELD = SdkField
            .<VpcInterfaceAttachment> builder(MarshallingType.SDK_POJO).memberName("VpcInterfaceAttachment")
            .getter(getter(GatewayBridgeSource::vpcInterfaceAttachment)).setter(setter(Builder::vpcInterfaceAttachment))
            .constructor(VpcInterfaceAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceAttachment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD,
            VPC_INTERFACE_ATTACHMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bridgeArn;

    private final VpcInterfaceAttachment vpcInterfaceAttachment;

    private GatewayBridgeSource(BuilderImpl builder) {
        this.bridgeArn = builder.bridgeArn;
        this.vpcInterfaceAttachment = builder.vpcInterfaceAttachment;
    }

    /**
     * The ARN of the bridge feeding this flow.
     * 
     * @return The ARN of the bridge feeding this flow.
     */
    public final String bridgeArn() {
        return bridgeArn;
    }

    /**
     * The name of the VPC interface attachment to use for this bridge source.
     * 
     * @return The name of the VPC interface attachment to use for this bridge source.
     */
    public final VpcInterfaceAttachment vpcInterfaceAttachment() {
        return vpcInterfaceAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcInterfaceAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayBridgeSource)) {
            return false;
        }
        GatewayBridgeSource other = (GatewayBridgeSource) obj;
        return Objects.equals(bridgeArn(), other.bridgeArn())
                && Objects.equals(vpcInterfaceAttachment(), other.vpcInterfaceAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GatewayBridgeSource").add("BridgeArn", bridgeArn())
                .add("VpcInterfaceAttachment", vpcInterfaceAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BridgeArn":
            return Optional.ofNullable(clazz.cast(bridgeArn()));
        case "VpcInterfaceAttachment":
            return Optional.ofNullable(clazz.cast(vpcInterfaceAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatewayBridgeSource, T> g) {
        return obj -> g.apply((GatewayBridgeSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatewayBridgeSource> {
        /**
         * The ARN of the bridge feeding this flow.
         * 
         * @param bridgeArn
         *        The ARN of the bridge feeding this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bridgeArn(String bridgeArn);

        /**
         * The name of the VPC interface attachment to use for this bridge source.
         * 
         * @param vpcInterfaceAttachment
         *        The name of the VPC interface attachment to use for this bridge source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaceAttachment(VpcInterfaceAttachment vpcInterfaceAttachment);

        /**
         * The name of the VPC interface attachment to use for this bridge source. This is a convenience method that
         * creates an instance of the {@link VpcInterfaceAttachment.Builder} avoiding the need to create one manually
         * via {@link VpcInterfaceAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcInterfaceAttachment.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcInterfaceAttachment(VpcInterfaceAttachment)}.
         * 
         * @param vpcInterfaceAttachment
         *        a consumer that will call methods on {@link VpcInterfaceAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcInterfaceAttachment(VpcInterfaceAttachment)
         */
        default Builder vpcInterfaceAttachment(Consumer<VpcInterfaceAttachment.Builder> vpcInterfaceAttachment) {
            return vpcInterfaceAttachment(VpcInterfaceAttachment.builder().applyMutation(vpcInterfaceAttachment).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String bridgeArn;

        private VpcInterfaceAttachment vpcInterfaceAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayBridgeSource model) {
            bridgeArn(model.bridgeArn);
            vpcInterfaceAttachment(model.vpcInterfaceAttachment);
        }

        public final String getBridgeArn() {
            return bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final VpcInterfaceAttachment.Builder getVpcInterfaceAttachment() {
            return vpcInterfaceAttachment != null ? vpcInterfaceAttachment.toBuilder() : null;
        }

        public final void setVpcInterfaceAttachment(VpcInterfaceAttachment.BuilderImpl vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment != null ? vpcInterfaceAttachment.build() : null;
        }

        @Override
        public final Builder vpcInterfaceAttachment(VpcInterfaceAttachment vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment;
            return this;
        }

        @Override
        public GatewayBridgeSource build() {
            return new GatewayBridgeSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
