/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Add a network source to an existing bridge.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddBridgeNetworkSourceRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<AddBridgeNetworkSourceRequest.Builder, AddBridgeNetworkSourceRequest> {
    private static final SdkField<String> MULTICAST_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MulticastIp").getter(getter(AddBridgeNetworkSourceRequest::multicastIp))
            .setter(setter(Builder::multicastIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multicastIp").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AddBridgeNetworkSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> NETWORK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkName").getter(getter(AddBridgeNetworkSourceRequest::networkName))
            .setter(setter(Builder::networkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(AddBridgeNetworkSourceRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(AddBridgeNetworkSourceRequest::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTICAST_IP_FIELD,
            NAME_FIELD, NETWORK_NAME_FIELD, PORT_FIELD, PROTOCOL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String multicastIp;

    private final String name;

    private final String networkName;

    private final Integer port;

    private final String protocol;

    private AddBridgeNetworkSourceRequest(BuilderImpl builder) {
        this.multicastIp = builder.multicastIp;
        this.name = builder.name;
        this.networkName = builder.networkName;
        this.port = builder.port;
        this.protocol = builder.protocol;
    }

    /**
     * The network source multicast IP.
     * 
     * @return The network source multicast IP.
     */
    public final String multicastIp() {
        return multicastIp;
    }

    /**
     * The name of the network source. This name is used to reference the source and must be unique among sources in
     * this bridge.
     * 
     * @return The name of the network source. This name is used to reference the source and must be unique among
     *         sources in this bridge.
     */
    public final String name() {
        return name;
    }

    /**
     * The network source's gateway network name.
     * 
     * @return The network source's gateway network name.
     */
    public final String networkName() {
        return networkName;
    }

    /**
     * The network source port.
     * 
     * @return The network source port.
     */
    public final Integer port() {
        return port;
    }

    /**
     * The network source protocol.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The network source protocol.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * The network source protocol.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The network source protocol.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(multicastIp());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddBridgeNetworkSourceRequest)) {
            return false;
        }
        AddBridgeNetworkSourceRequest other = (AddBridgeNetworkSourceRequest) obj;
        return Objects.equals(multicastIp(), other.multicastIp()) && Objects.equals(name(), other.name())
                && Objects.equals(networkName(), other.networkName()) && Objects.equals(port(), other.port())
                && Objects.equals(protocolAsString(), other.protocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddBridgeNetworkSourceRequest").add("MulticastIp", multicastIp()).add("Name", name())
                .add("NetworkName", networkName()).add("Port", port()).add("Protocol", protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MulticastIp":
            return Optional.ofNullable(clazz.cast(multicastIp()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkName":
            return Optional.ofNullable(clazz.cast(networkName()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddBridgeNetworkSourceRequest, T> g) {
        return obj -> g.apply((AddBridgeNetworkSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddBridgeNetworkSourceRequest> {
        /**
         * The network source multicast IP.
         * 
         * @param multicastIp
         *        The network source multicast IP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastIp(String multicastIp);

        /**
         * The name of the network source. This name is used to reference the source and must be unique among sources in
         * this bridge.
         * 
         * @param name
         *        The name of the network source. This name is used to reference the source and must be unique among
         *        sources in this bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The network source's gateway network name.
         * 
         * @param networkName
         *        The network source's gateway network name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkName(String networkName);

        /**
         * The network source port.
         * 
         * @param port
         *        The network source port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * The network source protocol.
         * 
         * @param protocol
         *        The network source protocol.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * The network source protocol.
         * 
         * @param protocol
         *        The network source protocol.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);
    }

    static final class BuilderImpl implements Builder {
        private String multicastIp;

        private String name;

        private String networkName;

        private Integer port;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(AddBridgeNetworkSourceRequest model) {
            multicastIp(model.multicastIp);
            name(model.name);
            networkName(model.networkName);
            port(model.port);
            protocol(model.protocol);
        }

        public final String getMulticastIp() {
            return multicastIp;
        }

        public final void setMulticastIp(String multicastIp) {
            this.multicastIp = multicastIp;
        }

        @Override
        public final Builder multicastIp(String multicastIp) {
            this.multicastIp = multicastIp;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkName() {
            return networkName;
        }

        public final void setNetworkName(String networkName) {
            this.networkName = networkName;
        }

        @Override
        public final Builder networkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        @Override
        public AddBridgeNetworkSourceRequest build() {
            return new AddBridgeNetworkSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
