/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacemetering.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>UsageRecordResult</code> indicates the status of a given <code>UsageRecord</code> processed by
 * <code>BatchMeterUsage</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageRecordResult implements SdkPojo, Serializable,
        ToCopyableBuilder<UsageRecordResult.Builder, UsageRecordResult> {
    private static final SdkField<UsageRecord> USAGE_RECORD_FIELD = SdkField.<UsageRecord> builder(MarshallingType.SDK_POJO)
            .memberName("UsageRecord").getter(getter(UsageRecordResult::usageRecord)).setter(setter(Builder::usageRecord))
            .constructor(UsageRecord::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageRecord").build()).build();

    private static final SdkField<String> METERING_RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeteringRecordId").getter(getter(UsageRecordResult::meteringRecordId))
            .setter(setter(Builder::meteringRecordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteringRecordId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UsageRecordResult::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_RECORD_FIELD,
            METERING_RECORD_ID_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final UsageRecord usageRecord;

    private final String meteringRecordId;

    private final String status;

    private UsageRecordResult(BuilderImpl builder) {
        this.usageRecord = builder.usageRecord;
        this.meteringRecordId = builder.meteringRecordId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The <code>UsageRecord</code> that was part of the <code>BatchMeterUsage</code> request.
     * </p>
     * 
     * @return The <code>UsageRecord</code> that was part of the <code>BatchMeterUsage</code> request.
     */
    public final UsageRecord usageRecord() {
        return usageRecord;
    }

    /**
     * <p>
     * The <code>MeteringRecordId</code> is a unique identifier for this metering event.
     * </p>
     * 
     * @return The <code>MeteringRecordId</code> is a unique identifier for this metering event.
     */
    public final String meteringRecordId() {
        return meteringRecordId;
    }

    /**
     * <p>
     * The <code>UsageRecordResult</code> <code>Status</code> indicates the status of an individual
     * <code>UsageRecord</code> processed by <code>BatchMeterUsage</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Success</i>- The <code>UsageRecord</code> was accepted and honored by <code>BatchMeterUsage</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>CustomerNotSubscribed</i>- The <code>CustomerIdentifier</code> specified is not able to use your product. The
     * <code>UsageRecord</code> was not honored. There are three causes for this result:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The customer identifier is invalid.
     * </p>
     * </li>
     * <li>
     * <p>
     * The customer identifier provided in the metering record does not have an active agreement or subscription with
     * this product. Future <code>UsageRecords</code> for this customer will fail until the customer subscribes to your
     * product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The customer's AWS account was suspended.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <i>DuplicateRecord</i>- Indicates that the <code>UsageRecord</code> was invalid and not honored. A previously
     * metered <code>UsageRecord</code> had the same customer, dimension, and time, but a different quantity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UsageRecordResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The <code>UsageRecordResult</code> <code>Status</code> indicates the status of an individual
     *         <code>UsageRecord</code> processed by <code>BatchMeterUsage</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Success</i>- The <code>UsageRecord</code> was accepted and honored by <code>BatchMeterUsage</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>CustomerNotSubscribed</i>- The <code>CustomerIdentifier</code> specified is not able to use your
     *         product. The <code>UsageRecord</code> was not honored. There are three causes for this result:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The customer identifier is invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The customer identifier provided in the metering record does not have an active agreement or subscription
     *         with this product. Future <code>UsageRecords</code> for this customer will fail until the customer
     *         subscribes to your product.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The customer's AWS account was suspended.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <i>DuplicateRecord</i>- Indicates that the <code>UsageRecord</code> was invalid and not honored. A
     *         previously metered <code>UsageRecord</code> had the same customer, dimension, and time, but a different
     *         quantity.
     *         </p>
     *         </li>
     * @see UsageRecordResultStatus
     */
    public final UsageRecordResultStatus status() {
        return UsageRecordResultStatus.fromValue(status);
    }

    /**
     * <p>
     * The <code>UsageRecordResult</code> <code>Status</code> indicates the status of an individual
     * <code>UsageRecord</code> processed by <code>BatchMeterUsage</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Success</i>- The <code>UsageRecord</code> was accepted and honored by <code>BatchMeterUsage</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>CustomerNotSubscribed</i>- The <code>CustomerIdentifier</code> specified is not able to use your product. The
     * <code>UsageRecord</code> was not honored. There are three causes for this result:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The customer identifier is invalid.
     * </p>
     * </li>
     * <li>
     * <p>
     * The customer identifier provided in the metering record does not have an active agreement or subscription with
     * this product. Future <code>UsageRecords</code> for this customer will fail until the customer subscribes to your
     * product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The customer's AWS account was suspended.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <i>DuplicateRecord</i>- Indicates that the <code>UsageRecord</code> was invalid and not honored. A previously
     * metered <code>UsageRecord</code> had the same customer, dimension, and time, but a different quantity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UsageRecordResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The <code>UsageRecordResult</code> <code>Status</code> indicates the status of an individual
     *         <code>UsageRecord</code> processed by <code>BatchMeterUsage</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Success</i>- The <code>UsageRecord</code> was accepted and honored by <code>BatchMeterUsage</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>CustomerNotSubscribed</i>- The <code>CustomerIdentifier</code> specified is not able to use your
     *         product. The <code>UsageRecord</code> was not honored. There are three causes for this result:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The customer identifier is invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The customer identifier provided in the metering record does not have an active agreement or subscription
     *         with this product. Future <code>UsageRecords</code> for this customer will fail until the customer
     *         subscribes to your product.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The customer's AWS account was suspended.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <i>DuplicateRecord</i>- Indicates that the <code>UsageRecord</code> was invalid and not honored. A
     *         previously metered <code>UsageRecord</code> had the same customer, dimension, and time, but a different
     *         quantity.
     *         </p>
     *         </li>
     * @see UsageRecordResultStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usageRecord());
        hashCode = 31 * hashCode + Objects.hashCode(meteringRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageRecordResult)) {
            return false;
        }
        UsageRecordResult other = (UsageRecordResult) obj;
        return Objects.equals(usageRecord(), other.usageRecord()) && Objects.equals(meteringRecordId(), other.meteringRecordId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageRecordResult").add("UsageRecord", usageRecord())
                .add("MeteringRecordId", meteringRecordId()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UsageRecord":
            return Optional.ofNullable(clazz.cast(usageRecord()));
        case "MeteringRecordId":
            return Optional.ofNullable(clazz.cast(meteringRecordId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageRecordResult, T> g) {
        return obj -> g.apply((UsageRecordResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageRecordResult> {
        /**
         * <p>
         * The <code>UsageRecord</code> that was part of the <code>BatchMeterUsage</code> request.
         * </p>
         * 
         * @param usageRecord
         *        The <code>UsageRecord</code> that was part of the <code>BatchMeterUsage</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRecord(UsageRecord usageRecord);

        /**
         * <p>
         * The <code>UsageRecord</code> that was part of the <code>BatchMeterUsage</code> request.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsageRecord.Builder} avoiding the need to
         * create one manually via {@link UsageRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsageRecord.Builder#build()} is called immediately and its result
         * is passed to {@link #usageRecord(UsageRecord)}.
         * 
         * @param usageRecord
         *        a consumer that will call methods on {@link UsageRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageRecord(UsageRecord)
         */
        default Builder usageRecord(Consumer<UsageRecord.Builder> usageRecord) {
            return usageRecord(UsageRecord.builder().applyMutation(usageRecord).build());
        }

        /**
         * <p>
         * The <code>MeteringRecordId</code> is a unique identifier for this metering event.
         * </p>
         * 
         * @param meteringRecordId
         *        The <code>MeteringRecordId</code> is a unique identifier for this metering event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meteringRecordId(String meteringRecordId);

        /**
         * <p>
         * The <code>UsageRecordResult</code> <code>Status</code> indicates the status of an individual
         * <code>UsageRecord</code> processed by <code>BatchMeterUsage</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Success</i>- The <code>UsageRecord</code> was accepted and honored by <code>BatchMeterUsage</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>CustomerNotSubscribed</i>- The <code>CustomerIdentifier</code> specified is not able to use your product.
         * The <code>UsageRecord</code> was not honored. There are three causes for this result:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The customer identifier is invalid.
         * </p>
         * </li>
         * <li>
         * <p>
         * The customer identifier provided in the metering record does not have an active agreement or subscription
         * with this product. Future <code>UsageRecords</code> for this customer will fail until the customer subscribes
         * to your product.
         * </p>
         * </li>
         * <li>
         * <p>
         * The customer's AWS account was suspended.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <i>DuplicateRecord</i>- Indicates that the <code>UsageRecord</code> was invalid and not honored. A previously
         * metered <code>UsageRecord</code> had the same customer, dimension, and time, but a different quantity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The <code>UsageRecordResult</code> <code>Status</code> indicates the status of an individual
         *        <code>UsageRecord</code> processed by <code>BatchMeterUsage</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Success</i>- The <code>UsageRecord</code> was accepted and honored by <code>BatchMeterUsage</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>CustomerNotSubscribed</i>- The <code>CustomerIdentifier</code> specified is not able to use your
         *        product. The <code>UsageRecord</code> was not honored. There are three causes for this result:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The customer identifier is invalid.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The customer identifier provided in the metering record does not have an active agreement or
         *        subscription with this product. Future <code>UsageRecords</code> for this customer will fail until the
         *        customer subscribes to your product.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The customer's AWS account was suspended.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <i>DuplicateRecord</i>- Indicates that the <code>UsageRecord</code> was invalid and not honored. A
         *        previously metered <code>UsageRecord</code> had the same customer, dimension, and time, but a
         *        different quantity.
         *        </p>
         *        </li>
         * @see UsageRecordResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageRecordResultStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The <code>UsageRecordResult</code> <code>Status</code> indicates the status of an individual
         * <code>UsageRecord</code> processed by <code>BatchMeterUsage</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Success</i>- The <code>UsageRecord</code> was accepted and honored by <code>BatchMeterUsage</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>CustomerNotSubscribed</i>- The <code>CustomerIdentifier</code> specified is not able to use your product.
         * The <code>UsageRecord</code> was not honored. There are three causes for this result:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The customer identifier is invalid.
         * </p>
         * </li>
         * <li>
         * <p>
         * The customer identifier provided in the metering record does not have an active agreement or subscription
         * with this product. Future <code>UsageRecords</code> for this customer will fail until the customer subscribes
         * to your product.
         * </p>
         * </li>
         * <li>
         * <p>
         * The customer's AWS account was suspended.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <i>DuplicateRecord</i>- Indicates that the <code>UsageRecord</code> was invalid and not honored. A previously
         * metered <code>UsageRecord</code> had the same customer, dimension, and time, but a different quantity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The <code>UsageRecordResult</code> <code>Status</code> indicates the status of an individual
         *        <code>UsageRecord</code> processed by <code>BatchMeterUsage</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Success</i>- The <code>UsageRecord</code> was accepted and honored by <code>BatchMeterUsage</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>CustomerNotSubscribed</i>- The <code>CustomerIdentifier</code> specified is not able to use your
         *        product. The <code>UsageRecord</code> was not honored. There are three causes for this result:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The customer identifier is invalid.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The customer identifier provided in the metering record does not have an active agreement or
         *        subscription with this product. Future <code>UsageRecords</code> for this customer will fail until the
         *        customer subscribes to your product.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The customer's AWS account was suspended.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <i>DuplicateRecord</i>- Indicates that the <code>UsageRecord</code> was invalid and not honored. A
         *        previously metered <code>UsageRecord</code> had the same customer, dimension, and time, but a
         *        different quantity.
         *        </p>
         *        </li>
         * @see UsageRecordResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageRecordResultStatus
         */
        Builder status(UsageRecordResultStatus status);
    }

    static final class BuilderImpl implements Builder {
        private UsageRecord usageRecord;

        private String meteringRecordId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageRecordResult model) {
            usageRecord(model.usageRecord);
            meteringRecordId(model.meteringRecordId);
            status(model.status);
        }

        public final UsageRecord.Builder getUsageRecord() {
            return usageRecord != null ? usageRecord.toBuilder() : null;
        }

        public final void setUsageRecord(UsageRecord.BuilderImpl usageRecord) {
            this.usageRecord = usageRecord != null ? usageRecord.build() : null;
        }

        @Override
        public final Builder usageRecord(UsageRecord usageRecord) {
            this.usageRecord = usageRecord;
            return this;
        }

        public final String getMeteringRecordId() {
            return meteringRecordId;
        }

        public final void setMeteringRecordId(String meteringRecordId) {
            this.meteringRecordId = meteringRecordId;
        }

        @Override
        public final Builder meteringRecordId(String meteringRecordId) {
            this.meteringRecordId = meteringRecordId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UsageRecordResultStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public UsageRecordResult build() {
            return new UsageRecordResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
