/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * A list of the variables to use in searching or filtering <code>Evaluation</code>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>CreatedAt</code> - Sets the search criteria to <code>Evaluation</code> creation date.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Status</code> - Sets the search criteria to <code>Evaluation</code> status.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Name</code> - Sets the search criteria to the contents of <code>Evaluation</code> <b> </b> <code>Name</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>IAMUser</code> - Sets the search criteria to the user account that invoked an evaluation.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>MLModelId</code> - Sets the search criteria to the <code>Predictor</code> that was evaluated.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in evaluation.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DataUri</code> - Sets the search criteria to the data file(s) used in evaluation. The URL can identify either a
 * file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum EvaluationFilterVariable {
    CREATED_AT("CreatedAt"),

    LAST_UPDATED_AT("LastUpdatedAt"),

    STATUS("Status"),

    NAME("Name"),

    IAM_USER("IAMUser"),

    ML_MODEL_ID("MLModelId"),

    DATA_SOURCE_ID("DataSourceId"),

    DATA_URI("DataURI"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EvaluationFilterVariable> VALUE_MAP = EnumUtils.uniqueIndex(EvaluationFilterVariable.class,
            EvaluationFilterVariable::toString);

    private final String value;

    private EvaluationFilterVariable(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return EvaluationFilterVariable corresponding to the value
     */
    public static EvaluationFilterVariable fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link EvaluationFilterVariable}s
     */
    public static Set<EvaluationFilterVariable> knownValues() {
        Set<EvaluationFilterVariable> knownValues = EnumSet.allOf(EvaluationFilterVariable.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
