/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInstanceMetadataOptionsRequest extends LightsailRequest implements
        ToCopyableBuilder<UpdateInstanceMetadataOptionsRequest.Builder, UpdateInstanceMetadataOptionsRequest> {
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceName").getter(getter(UpdateInstanceMetadataOptionsRequest::instanceName))
            .setter(setter(Builder::instanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()).build();

    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpTokens").getter(getter(UpdateInstanceMetadataOptionsRequest::httpTokensAsString))
            .setter(setter(Builder::httpTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpTokens").build()).build();

    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpEndpoint").getter(getter(UpdateInstanceMetadataOptionsRequest::httpEndpointAsString))
            .setter(setter(Builder::httpEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpEndpoint").build()).build();

    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("httpPutResponseHopLimit")
            .getter(getter(UpdateInstanceMetadataOptionsRequest::httpPutResponseHopLimit))
            .setter(setter(Builder::httpPutResponseHopLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpPutResponseHopLimit").build())
            .build();

    private static final SdkField<String> HTTP_PROTOCOL_IPV6_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpProtocolIpv6").getter(getter(UpdateInstanceMetadataOptionsRequest::httpProtocolIpv6AsString))
            .setter(setter(Builder::httpProtocolIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpProtocolIpv6").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAME_FIELD,
            HTTP_TOKENS_FIELD, HTTP_ENDPOINT_FIELD, HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, HTTP_PROTOCOL_IPV6_FIELD));

    private final String instanceName;

    private final String httpTokens;

    private final String httpEndpoint;

    private final Integer httpPutResponseHopLimit;

    private final String httpProtocolIpv6;

    private UpdateInstanceMetadataOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceName = builder.instanceName;
        this.httpTokens = builder.httpTokens;
        this.httpEndpoint = builder.httpEndpoint;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.httpProtocolIpv6 = builder.httpProtocolIpv6;
    }

    /**
     * <p>
     * The name of the instance for which to update metadata parameters.
     * </p>
     * 
     * @return The name of the instance for which to update metadata parameters.
     */
    public final String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The state of token usage for your instance metadata requests. If the parameter is not specified in the request,
     * the default state is <code>optional</code>.
     * </p>
     * <p>
     * If the state is <code>optional</code>, you can choose whether to retrieve instance metadata with a signed token
     * header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role
     * credentials are returned. If you retrieve the IAM role credentials by using a valid signed token, the version 2.0
     * role credentials are returned.
     * </p>
     * <p>
     * If the state is <code>required</code>, you must send a signed token header with all instance metadata retrieval
     * requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials. The
     * version 1.0 credentials are not available.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpTokens} will
     * return {@link HttpTokens#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpTokensAsString}.
     * </p>
     * 
     * @return The state of token usage for your instance metadata requests. If the parameter is not specified in the
     *         request, the default state is <code>optional</code>.</p>
     *         <p>
     *         If the state is <code>optional</code>, you can choose whether to retrieve instance metadata with a signed
     *         token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0
     *         role credentials are returned. If you retrieve the IAM role credentials by using a valid signed token,
     *         the version 2.0 role credentials are returned.
     *         </p>
     *         <p>
     *         If the state is <code>required</code>, you must send a signed token header with all instance metadata
     *         retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0
     *         credentials. The version 1.0 credentials are not available.
     * @see HttpTokens
     */
    public final HttpTokens httpTokens() {
        return HttpTokens.fromValue(httpTokens);
    }

    /**
     * <p>
     * The state of token usage for your instance metadata requests. If the parameter is not specified in the request,
     * the default state is <code>optional</code>.
     * </p>
     * <p>
     * If the state is <code>optional</code>, you can choose whether to retrieve instance metadata with a signed token
     * header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role
     * credentials are returned. If you retrieve the IAM role credentials by using a valid signed token, the version 2.0
     * role credentials are returned.
     * </p>
     * <p>
     * If the state is <code>required</code>, you must send a signed token header with all instance metadata retrieval
     * requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials. The
     * version 1.0 credentials are not available.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpTokens} will
     * return {@link HttpTokens#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpTokensAsString}.
     * </p>
     * 
     * @return The state of token usage for your instance metadata requests. If the parameter is not specified in the
     *         request, the default state is <code>optional</code>.</p>
     *         <p>
     *         If the state is <code>optional</code>, you can choose whether to retrieve instance metadata with a signed
     *         token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0
     *         role credentials are returned. If you retrieve the IAM role credentials by using a valid signed token,
     *         the version 2.0 role credentials are returned.
     *         </p>
     *         <p>
     *         If the state is <code>required</code>, you must send a signed token header with all instance metadata
     *         retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0
     *         credentials. The version 1.0 credentials are not available.
     * @see HttpTokens
     */
    public final String httpTokensAsString() {
        return httpTokens;
    }

    /**
     * <p>
     * Enables or disables the HTTP metadata endpoint on your instances. If this parameter is not specified, the
     * existing state is maintained.
     * </p>
     * <p>
     * If you specify a value of <code>disabled</code>, you cannot access your instance metadata.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpEndpoint} will
     * return {@link HttpEndpoint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpEndpointAsString}.
     * </p>
     * 
     * @return Enables or disables the HTTP metadata endpoint on your instances. If this parameter is not specified, the
     *         existing state is maintained.</p>
     *         <p>
     *         If you specify a value of <code>disabled</code>, you cannot access your instance metadata.
     * @see HttpEndpoint
     */
    public final HttpEndpoint httpEndpoint() {
        return HttpEndpoint.fromValue(httpEndpoint);
    }

    /**
     * <p>
     * Enables or disables the HTTP metadata endpoint on your instances. If this parameter is not specified, the
     * existing state is maintained.
     * </p>
     * <p>
     * If you specify a value of <code>disabled</code>, you cannot access your instance metadata.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpEndpoint} will
     * return {@link HttpEndpoint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpEndpointAsString}.
     * </p>
     * 
     * @return Enables or disables the HTTP metadata endpoint on your instances. If this parameter is not specified, the
     *         existing state is maintained.</p>
     *         <p>
     *         If you specify a value of <code>disabled</code>, you cannot access your instance metadata.
     * @see HttpEndpoint
     */
    public final String httpEndpointAsString() {
        return httpEndpoint;
    }

    /**
     * <p>
     * The desired HTTP PUT response hop limit for instance metadata requests. A larger number means that the instance
     * metadata requests can travel farther. If no parameter is specified, the existing state is maintained.
     * </p>
     * 
     * @return The desired HTTP PUT response hop limit for instance metadata requests. A larger number means that the
     *         instance metadata requests can travel farther. If no parameter is specified, the existing state is
     *         maintained.
     */
    public final Integer httpPutResponseHopLimit() {
        return httpPutResponseHopLimit;
    }

    /**
     * <p>
     * Enables or disables the IPv6 endpoint for the instance metadata service. This setting applies only when the HTTP
     * metadata endpoint is enabled.
     * </p>
     * <note>
     * <p>
     * This parameter is available only for instances in the Europe (Stockholm) Amazon Web Services Region (
     * <code>eu-north-1</code>).
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpProtocolIpv6}
     * will return {@link HttpProtocolIpv6#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #httpProtocolIpv6AsString}.
     * </p>
     * 
     * @return Enables or disables the IPv6 endpoint for the instance metadata service. This setting applies only when
     *         the HTTP metadata endpoint is enabled.</p> <note>
     *         <p>
     *         This parameter is available only for instances in the Europe (Stockholm) Amazon Web Services Region (
     *         <code>eu-north-1</code>).
     *         </p>
     * @see HttpProtocolIpv6
     */
    public final HttpProtocolIpv6 httpProtocolIpv6() {
        return HttpProtocolIpv6.fromValue(httpProtocolIpv6);
    }

    /**
     * <p>
     * Enables or disables the IPv6 endpoint for the instance metadata service. This setting applies only when the HTTP
     * metadata endpoint is enabled.
     * </p>
     * <note>
     * <p>
     * This parameter is available only for instances in the Europe (Stockholm) Amazon Web Services Region (
     * <code>eu-north-1</code>).
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpProtocolIpv6}
     * will return {@link HttpProtocolIpv6#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #httpProtocolIpv6AsString}.
     * </p>
     * 
     * @return Enables or disables the IPv6 endpoint for the instance metadata service. This setting applies only when
     *         the HTTP metadata endpoint is enabled.</p> <note>
     *         <p>
     *         This parameter is available only for instances in the Europe (Stockholm) Amazon Web Services Region (
     *         <code>eu-north-1</code>).
     *         </p>
     * @see HttpProtocolIpv6
     */
    public final String httpProtocolIpv6AsString() {
        return httpProtocolIpv6;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(httpTokensAsString());
        hashCode = 31 * hashCode + Objects.hashCode(httpEndpointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(httpProtocolIpv6AsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceMetadataOptionsRequest)) {
            return false;
        }
        UpdateInstanceMetadataOptionsRequest other = (UpdateInstanceMetadataOptionsRequest) obj;
        return Objects.equals(instanceName(), other.instanceName())
                && Objects.equals(httpTokensAsString(), other.httpTokensAsString())
                && Objects.equals(httpEndpointAsString(), other.httpEndpointAsString())
                && Objects.equals(httpPutResponseHopLimit(), other.httpPutResponseHopLimit())
                && Objects.equals(httpProtocolIpv6AsString(), other.httpProtocolIpv6AsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInstanceMetadataOptionsRequest").add("InstanceName", instanceName())
                .add("HttpTokens", httpTokensAsString()).add("HttpEndpoint", httpEndpointAsString())
                .add("HttpPutResponseHopLimit", httpPutResponseHopLimit()).add("HttpProtocolIpv6", httpProtocolIpv6AsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceName":
            return Optional.ofNullable(clazz.cast(instanceName()));
        case "httpTokens":
            return Optional.ofNullable(clazz.cast(httpTokensAsString()));
        case "httpEndpoint":
            return Optional.ofNullable(clazz.cast(httpEndpointAsString()));
        case "httpPutResponseHopLimit":
            return Optional.ofNullable(clazz.cast(httpPutResponseHopLimit()));
        case "httpProtocolIpv6":
            return Optional.ofNullable(clazz.cast(httpProtocolIpv6AsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInstanceMetadataOptionsRequest, T> g) {
        return obj -> g.apply((UpdateInstanceMetadataOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateInstanceMetadataOptionsRequest> {
        /**
         * <p>
         * The name of the instance for which to update metadata parameters.
         * </p>
         * 
         * @param instanceName
         *        The name of the instance for which to update metadata parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The state of token usage for your instance metadata requests. If the parameter is not specified in the
         * request, the default state is <code>optional</code>.
         * </p>
         * <p>
         * If the state is <code>optional</code>, you can choose whether to retrieve instance metadata with a signed
         * token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role
         * credentials are returned. If you retrieve the IAM role credentials by using a valid signed token, the version
         * 2.0 role credentials are returned.
         * </p>
         * <p>
         * If the state is <code>required</code>, you must send a signed token header with all instance metadata
         * retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0
         * credentials. The version 1.0 credentials are not available.
         * </p>
         * 
         * @param httpTokens
         *        The state of token usage for your instance metadata requests. If the parameter is not specified in the
         *        request, the default state is <code>optional</code>.</p>
         *        <p>
         *        If the state is <code>optional</code>, you can choose whether to retrieve instance metadata with a
         *        signed token header on your request. If you retrieve the IAM role credentials without a token, the
         *        version 1.0 role credentials are returned. If you retrieve the IAM role credentials by using a valid
         *        signed token, the version 2.0 role credentials are returned.
         *        </p>
         *        <p>
         *        If the state is <code>required</code>, you must send a signed token header with all instance metadata
         *        retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0
         *        credentials. The version 1.0 credentials are not available.
         * @see HttpTokens
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpTokens
         */
        Builder httpTokens(String httpTokens);

        /**
         * <p>
         * The state of token usage for your instance metadata requests. If the parameter is not specified in the
         * request, the default state is <code>optional</code>.
         * </p>
         * <p>
         * If the state is <code>optional</code>, you can choose whether to retrieve instance metadata with a signed
         * token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role
         * credentials are returned. If you retrieve the IAM role credentials by using a valid signed token, the version
         * 2.0 role credentials are returned.
         * </p>
         * <p>
         * If the state is <code>required</code>, you must send a signed token header with all instance metadata
         * retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0
         * credentials. The version 1.0 credentials are not available.
         * </p>
         * 
         * @param httpTokens
         *        The state of token usage for your instance metadata requests. If the parameter is not specified in the
         *        request, the default state is <code>optional</code>.</p>
         *        <p>
         *        If the state is <code>optional</code>, you can choose whether to retrieve instance metadata with a
         *        signed token header on your request. If you retrieve the IAM role credentials without a token, the
         *        version 1.0 role credentials are returned. If you retrieve the IAM role credentials by using a valid
         *        signed token, the version 2.0 role credentials are returned.
         *        </p>
         *        <p>
         *        If the state is <code>required</code>, you must send a signed token header with all instance metadata
         *        retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0
         *        credentials. The version 1.0 credentials are not available.
         * @see HttpTokens
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpTokens
         */
        Builder httpTokens(HttpTokens httpTokens);

        /**
         * <p>
         * Enables or disables the HTTP metadata endpoint on your instances. If this parameter is not specified, the
         * existing state is maintained.
         * </p>
         * <p>
         * If you specify a value of <code>disabled</code>, you cannot access your instance metadata.
         * </p>
         * 
         * @param httpEndpoint
         *        Enables or disables the HTTP metadata endpoint on your instances. If this parameter is not specified,
         *        the existing state is maintained.</p>
         *        <p>
         *        If you specify a value of <code>disabled</code>, you cannot access your instance metadata.
         * @see HttpEndpoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpEndpoint
         */
        Builder httpEndpoint(String httpEndpoint);

        /**
         * <p>
         * Enables or disables the HTTP metadata endpoint on your instances. If this parameter is not specified, the
         * existing state is maintained.
         * </p>
         * <p>
         * If you specify a value of <code>disabled</code>, you cannot access your instance metadata.
         * </p>
         * 
         * @param httpEndpoint
         *        Enables or disables the HTTP metadata endpoint on your instances. If this parameter is not specified,
         *        the existing state is maintained.</p>
         *        <p>
         *        If you specify a value of <code>disabled</code>, you cannot access your instance metadata.
         * @see HttpEndpoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpEndpoint
         */
        Builder httpEndpoint(HttpEndpoint httpEndpoint);

        /**
         * <p>
         * The desired HTTP PUT response hop limit for instance metadata requests. A larger number means that the
         * instance metadata requests can travel farther. If no parameter is specified, the existing state is
         * maintained.
         * </p>
         * 
         * @param httpPutResponseHopLimit
         *        The desired HTTP PUT response hop limit for instance metadata requests. A larger number means that the
         *        instance metadata requests can travel farther. If no parameter is specified, the existing state is
         *        maintained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit);

        /**
         * <p>
         * Enables or disables the IPv6 endpoint for the instance metadata service. This setting applies only when the
         * HTTP metadata endpoint is enabled.
         * </p>
         * <note>
         * <p>
         * This parameter is available only for instances in the Europe (Stockholm) Amazon Web Services Region (
         * <code>eu-north-1</code>).
         * </p>
         * </note>
         * 
         * @param httpProtocolIpv6
         *        Enables or disables the IPv6 endpoint for the instance metadata service. This setting applies only
         *        when the HTTP metadata endpoint is enabled.</p> <note>
         *        <p>
         *        This parameter is available only for instances in the Europe (Stockholm) Amazon Web Services Region (
         *        <code>eu-north-1</code>).
         *        </p>
         * @see HttpProtocolIpv6
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpProtocolIpv6
         */
        Builder httpProtocolIpv6(String httpProtocolIpv6);

        /**
         * <p>
         * Enables or disables the IPv6 endpoint for the instance metadata service. This setting applies only when the
         * HTTP metadata endpoint is enabled.
         * </p>
         * <note>
         * <p>
         * This parameter is available only for instances in the Europe (Stockholm) Amazon Web Services Region (
         * <code>eu-north-1</code>).
         * </p>
         * </note>
         * 
         * @param httpProtocolIpv6
         *        Enables or disables the IPv6 endpoint for the instance metadata service. This setting applies only
         *        when the HTTP metadata endpoint is enabled.</p> <note>
         *        <p>
         *        This parameter is available only for instances in the Europe (Stockholm) Amazon Web Services Region (
         *        <code>eu-north-1</code>).
         *        </p>
         * @see HttpProtocolIpv6
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpProtocolIpv6
         */
        Builder httpProtocolIpv6(HttpProtocolIpv6 httpProtocolIpv6);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String instanceName;

        private String httpTokens;

        private String httpEndpoint;

        private Integer httpPutResponseHopLimit;

        private String httpProtocolIpv6;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstanceMetadataOptionsRequest model) {
            super(model);
            instanceName(model.instanceName);
            httpTokens(model.httpTokens);
            httpEndpoint(model.httpEndpoint);
            httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            httpProtocolIpv6(model.httpProtocolIpv6);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getHttpTokens() {
            return httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        @Override
        public final Builder httpTokens(HttpTokens httpTokens) {
            this.httpTokens(httpTokens == null ? null : httpTokens.toString());
            return this;
        }

        public final String getHttpEndpoint() {
            return httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        @Override
        public final Builder httpEndpoint(HttpEndpoint httpEndpoint) {
            this.httpEndpoint(httpEndpoint == null ? null : httpEndpoint.toString());
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getHttpProtocolIpv6() {
            return httpProtocolIpv6;
        }

        public final void setHttpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
        }

        @Override
        public final Builder httpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
            return this;
        }

        @Override
        public final Builder httpProtocolIpv6(HttpProtocolIpv6 httpProtocolIpv6) {
            this.httpProtocolIpv6(httpProtocolIpv6 == null ? null : httpProtocolIpv6.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInstanceMetadataOptionsRequest build() {
            return new UpdateInstanceMetadataOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
