/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetIpAddressTypeRequest extends LightsailRequest implements
        ToCopyableBuilder<SetIpAddressTypeRequest.Builder, SetIpAddressTypeRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(SetIpAddressTypeRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(SetIpAddressTypeRequest::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddressType").getter(getter(SetIpAddressTypeRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            RESOURCE_NAME_FIELD, IP_ADDRESS_TYPE_FIELD));

    private final String resourceType;

    private final String resourceName;

    private final String ipAddressType;

    private SetIpAddressTypeRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceName = builder.resourceName;
        this.ipAddressType = builder.ipAddressType;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * The possible values are <code>Distribution</code>, <code>Instance</code>, and <code>LoadBalancer</code>.
     * </p>
     * <note>
     * <p>
     * Distribution-related APIs are available only in the N. Virginia (<code>us-east-1</code>) Amazon Web Services
     * Region. Set your Amazon Web Services Region configuration to <code>us-east-1</code> to create, view, or edit
     * distributions.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type.</p>
     *         <p>
     *         The possible values are <code>Distribution</code>, <code>Instance</code>, and <code>LoadBalancer</code>.
     *         </p>
     *         <note>
     *         <p>
     *         Distribution-related APIs are available only in the N. Virginia (<code>us-east-1</code>) Amazon Web
     *         Services Region. Set your Amazon Web Services Region configuration to <code>us-east-1</code> to create,
     *         view, or edit distributions.
     *         </p>
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * The possible values are <code>Distribution</code>, <code>Instance</code>, and <code>LoadBalancer</code>.
     * </p>
     * <note>
     * <p>
     * Distribution-related APIs are available only in the N. Virginia (<code>us-east-1</code>) Amazon Web Services
     * Region. Set your Amazon Web Services Region configuration to <code>us-east-1</code> to create, view, or edit
     * distributions.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type.</p>
     *         <p>
     *         The possible values are <code>Distribution</code>, <code>Instance</code>, and <code>LoadBalancer</code>.
     *         </p>
     *         <note>
     *         <p>
     *         Distribution-related APIs are available only in the N. Virginia (<code>us-east-1</code>) Amazon Web
     *         Services Region. Set your Amazon Web Services Region configuration to <code>us-east-1</code> to create,
     *         view, or edit distributions.
     *         </p>
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The name of the resource for which to set the IP address type.
     * </p>
     * 
     * @return The name of the resource for which to set the IP address type.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The IP address type to set for the specified resource.
     * </p>
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type to set for the specified resource.</p>
     *         <p>
     *         The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type to set for the specified resource.
     * </p>
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type to set for the specified resource.</p>
     *         <p>
     *         The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIpAddressTypeRequest)) {
            return false;
        }
        SetIpAddressTypeRequest other = (SetIpAddressTypeRequest) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetIpAddressTypeRequest").add("ResourceType", resourceTypeAsString())
                .add("ResourceName", resourceName()).add("IpAddressType", ipAddressTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "ipAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetIpAddressTypeRequest, T> g) {
        return obj -> g.apply((SetIpAddressTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetIpAddressTypeRequest> {
        /**
         * <p>
         * The resource type.
         * </p>
         * <p>
         * The possible values are <code>Distribution</code>, <code>Instance</code>, and <code>LoadBalancer</code>.
         * </p>
         * <note>
         * <p>
         * Distribution-related APIs are available only in the N. Virginia (<code>us-east-1</code>) Amazon Web Services
         * Region. Set your Amazon Web Services Region configuration to <code>us-east-1</code> to create, view, or edit
         * distributions.
         * </p>
         * </note>
         * 
         * @param resourceType
         *        The resource type.</p>
         *        <p>
         *        The possible values are <code>Distribution</code>, <code>Instance</code>, and
         *        <code>LoadBalancer</code>.
         *        </p>
         *        <note>
         *        <p>
         *        Distribution-related APIs are available only in the N. Virginia (<code>us-east-1</code>) Amazon Web
         *        Services Region. Set your Amazon Web Services Region configuration to <code>us-east-1</code> to
         *        create, view, or edit distributions.
         *        </p>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type.
         * </p>
         * <p>
         * The possible values are <code>Distribution</code>, <code>Instance</code>, and <code>LoadBalancer</code>.
         * </p>
         * <note>
         * <p>
         * Distribution-related APIs are available only in the N. Virginia (<code>us-east-1</code>) Amazon Web Services
         * Region. Set your Amazon Web Services Region configuration to <code>us-east-1</code> to create, view, or edit
         * distributions.
         * </p>
         * </note>
         * 
         * @param resourceType
         *        The resource type.</p>
         *        <p>
         *        The possible values are <code>Distribution</code>, <code>Instance</code>, and
         *        <code>LoadBalancer</code>.
         *        </p>
         *        <note>
         *        <p>
         *        Distribution-related APIs are available only in the N. Virginia (<code>us-east-1</code>) Amazon Web
         *        Services Region. Set your Amazon Web Services Region configuration to <code>us-east-1</code> to
         *        create, view, or edit distributions.
         *        </p>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The name of the resource for which to set the IP address type.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource for which to set the IP address type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The IP address type to set for the specified resource.
         * </p>
         * <p>
         * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type to set for the specified resource.</p>
         *        <p>
         *        The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type to set for the specified resource.
         * </p>
         * <p>
         * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type to set for the specified resource.</p>
         *        <p>
         *        The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String resourceType;

        private String resourceName;

        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIpAddressTypeRequest model) {
            super(model);
            resourceType(model.resourceType);
            resourceName(model.resourceName);
            ipAddressType(model.ipAddressType);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetIpAddressTypeRequest build() {
            return new SetIpAddressTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
