/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetBucketsResponse.Builder, GetBucketsResponse> {
    private static final SdkField<List<Bucket>> BUCKETS_FIELD = SdkField
            .<List<Bucket>> builder(MarshallingType.LIST)
            .memberName("buckets")
            .getter(getter(GetBucketsResponse::buckets))
            .setter(setter(Builder::buckets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buckets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Bucket> builder(MarshallingType.SDK_POJO)
                                            .constructor(Bucket::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(GetBucketsResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final SdkField<AccountLevelBpaSync> ACCOUNT_LEVEL_BPA_SYNC_FIELD = SdkField
            .<AccountLevelBpaSync> builder(MarshallingType.SDK_POJO).memberName("accountLevelBpaSync")
            .getter(getter(GetBucketsResponse::accountLevelBpaSync)).setter(setter(Builder::accountLevelBpaSync))
            .constructor(AccountLevelBpaSync::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountLevelBpaSync").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKETS_FIELD,
            NEXT_PAGE_TOKEN_FIELD, ACCOUNT_LEVEL_BPA_SYNC_FIELD));

    private final List<Bucket> buckets;

    private final String nextPageToken;

    private final AccountLevelBpaSync accountLevelBpaSync;

    private GetBucketsResponse(BuilderImpl builder) {
        super(builder);
        this.buckets = builder.buckets;
        this.nextPageToken = builder.nextPageToken;
        this.accountLevelBpaSync = builder.accountLevelBpaSync;
    }

    /**
     * For responses, this returns true if the service returned a value for the Buckets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBuckets() {
        return buckets != null && !(buckets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe buckets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuckets} method.
     * </p>
     * 
     * @return An array of objects that describe buckets.
     */
    public final List<Bucket> buckets() {
        return buckets;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetBuckets</code> request and specify the next page token
     * using the <code>pageToken</code> parameter.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         A next page token is not returned if there are no more results to display.
     *         </p>
     *         <p>
     *         To get the next page of results, perform another <code>GetBuckets</code> request and specify the next
     *         page token using the <code>pageToken</code> parameter.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * An object that describes the synchronization status of the Amazon S3 account-level block public access feature
     * for your Lightsail buckets.
     * </p>
     * <p>
     * For more information about this feature and how it affects Lightsail buckets, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-block-public-access-for-buckets"
     * >Block public access for buckets in Amazon Lightsail</a>.
     * </p>
     * 
     * @return An object that describes the synchronization status of the Amazon S3 account-level block public access
     *         feature for your Lightsail buckets.</p>
     *         <p>
     *         For more information about this feature and how it affects Lightsail buckets, see <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-block-public-access-for-buckets"
     *         >Block public access for buckets in Amazon Lightsail</a>.
     */
    public final AccountLevelBpaSync accountLevelBpaSync() {
        return accountLevelBpaSync;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBuckets() ? buckets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(accountLevelBpaSync());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketsResponse)) {
            return false;
        }
        GetBucketsResponse other = (GetBucketsResponse) obj;
        return hasBuckets() == other.hasBuckets() && Objects.equals(buckets(), other.buckets())
                && Objects.equals(nextPageToken(), other.nextPageToken())
                && Objects.equals(accountLevelBpaSync(), other.accountLevelBpaSync());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBucketsResponse").add("Buckets", hasBuckets() ? buckets() : null)
                .add("NextPageToken", nextPageToken()).add("AccountLevelBpaSync", accountLevelBpaSync()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "buckets":
            return Optional.ofNullable(clazz.cast(buckets()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "accountLevelBpaSync":
            return Optional.ofNullable(clazz.cast(accountLevelBpaSync()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketsResponse, T> g) {
        return obj -> g.apply((GetBucketsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBucketsResponse> {
        /**
         * <p>
         * An array of objects that describe buckets.
         * </p>
         * 
         * @param buckets
         *        An array of objects that describe buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buckets(Collection<Bucket> buckets);

        /**
         * <p>
         * An array of objects that describe buckets.
         * </p>
         * 
         * @param buckets
         *        An array of objects that describe buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buckets(Bucket... buckets);

        /**
         * <p>
         * An array of objects that describe buckets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.Bucket.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lightsail.model.Bucket#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.Bucket.Builder#build()} is called immediately and its
         * result is passed to {@link #buckets(List<Bucket>)}.
         * 
         * @param buckets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.Bucket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buckets(java.util.Collection<Bucket>)
         */
        Builder buckets(Consumer<Bucket.Builder>... buckets);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * A next page token is not returned if there are no more results to display.
         * </p>
         * <p>
         * To get the next page of results, perform another <code>GetBuckets</code> request and specify the next page
         * token using the <code>pageToken</code> parameter.
         * </p>
         * 
         * @param nextPageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        A next page token is not returned if there are no more results to display.
         *        </p>
         *        <p>
         *        To get the next page of results, perform another <code>GetBuckets</code> request and specify the next
         *        page token using the <code>pageToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * An object that describes the synchronization status of the Amazon S3 account-level block public access
         * feature for your Lightsail buckets.
         * </p>
         * <p>
         * For more information about this feature and how it affects Lightsail buckets, see <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-block-public-access-for-buckets"
         * >Block public access for buckets in Amazon Lightsail</a>.
         * </p>
         * 
         * @param accountLevelBpaSync
         *        An object that describes the synchronization status of the Amazon S3 account-level block public access
         *        feature for your Lightsail buckets.</p>
         *        <p>
         *        For more information about this feature and how it affects Lightsail buckets, see <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-block-public-access-for-buckets"
         *        >Block public access for buckets in Amazon Lightsail</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountLevelBpaSync(AccountLevelBpaSync accountLevelBpaSync);

        /**
         * <p>
         * An object that describes the synchronization status of the Amazon S3 account-level block public access
         * feature for your Lightsail buckets.
         * </p>
         * <p>
         * For more information about this feature and how it affects Lightsail buckets, see <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-block-public-access-for-buckets"
         * >Block public access for buckets in Amazon Lightsail</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountLevelBpaSync.Builder} avoiding the
         * need to create one manually via {@link AccountLevelBpaSync#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountLevelBpaSync.Builder#build()} is called immediately and
         * its result is passed to {@link #accountLevelBpaSync(AccountLevelBpaSync)}.
         * 
         * @param accountLevelBpaSync
         *        a consumer that will call methods on {@link AccountLevelBpaSync.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountLevelBpaSync(AccountLevelBpaSync)
         */
        default Builder accountLevelBpaSync(Consumer<AccountLevelBpaSync.Builder> accountLevelBpaSync) {
            return accountLevelBpaSync(AccountLevelBpaSync.builder().applyMutation(accountLevelBpaSync).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<Bucket> buckets = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private AccountLevelBpaSync accountLevelBpaSync;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketsResponse model) {
            super(model);
            buckets(model.buckets);
            nextPageToken(model.nextPageToken);
            accountLevelBpaSync(model.accountLevelBpaSync);
        }

        public final List<Bucket.Builder> getBuckets() {
            List<Bucket.Builder> result = BucketListCopier.copyToBuilder(this.buckets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuckets(Collection<Bucket.BuilderImpl> buckets) {
            this.buckets = BucketListCopier.copyFromBuilder(buckets);
        }

        @Override
        public final Builder buckets(Collection<Bucket> buckets) {
            this.buckets = BucketListCopier.copy(buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Bucket... buckets) {
            buckets(Arrays.asList(buckets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Consumer<Bucket.Builder>... buckets) {
            buckets(Stream.of(buckets).map(c -> Bucket.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final AccountLevelBpaSync.Builder getAccountLevelBpaSync() {
            return accountLevelBpaSync != null ? accountLevelBpaSync.toBuilder() : null;
        }

        public final void setAccountLevelBpaSync(AccountLevelBpaSync.BuilderImpl accountLevelBpaSync) {
            this.accountLevelBpaSync = accountLevelBpaSync != null ? accountLevelBpaSync.build() : null;
        }

        @Override
        public final Builder accountLevelBpaSync(AccountLevelBpaSync accountLevelBpaSync) {
            this.accountLevelBpaSync = accountLevelBpaSync;
            return this;
        }

        @Override
        public GetBucketsResponse build() {
            return new GetBucketsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
