/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A default value for a slot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotDefaultValue implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotDefaultValue.Builder, SlotDefaultValue> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultValue").getter(getter(SlotDefaultValue::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultValue;

    private SlotDefaultValue(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
    }

    /**
     * <p>
     * The default value for the slot. You can specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>#context-name.slot-name</code> - The slot value "slot-name" in the context "context-name."
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>{attribute}</code> - The slot value of the session attribute "attribute."
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>'value'</code> - The discrete value "value."
     * </p>
     * </li>
     * </ul>
     * 
     * @return The default value for the slot. You can specify one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>#context-name.slot-name</code> - The slot value "slot-name" in the context "context-name."
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>{attribute}</code> - The slot value of the session attribute "attribute."
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>'value'</code> - The discrete value "value."
     *         </p>
     *         </li>
     */
    public final String defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotDefaultValue)) {
            return false;
        }
        SlotDefaultValue other = (SlotDefaultValue) obj;
        return Objects.equals(defaultValue(), other.defaultValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotDefaultValue").add("DefaultValue", defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotDefaultValue, T> g) {
        return obj -> g.apply((SlotDefaultValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotDefaultValue> {
        /**
         * <p>
         * The default value for the slot. You can specify one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>#context-name.slot-name</code> - The slot value "slot-name" in the context "context-name."
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>{attribute}</code> - The slot value of the session attribute "attribute."
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>'value'</code> - The discrete value "value."
         * </p>
         * </li>
         * </ul>
         * 
         * @param defaultValue
         *        The default value for the slot. You can specify one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>#context-name.slot-name</code> - The slot value "slot-name" in the context "context-name."
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>{attribute}</code> - The slot value of the session attribute "attribute."
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>'value'</code> - The discrete value "value."
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);
    }

    static final class BuilderImpl implements Builder {
        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotDefaultValue model) {
            defaultValue(model.defaultValue);
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public SlotDefaultValue build() {
            return new SlotDefaultValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
